/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002T8h%\u0016\u001cwN^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t!A_6\n\u00055Q!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0003)\u0012a\u0005:fa2L7-\u0019'bORKW.Z'bq6\u001bX#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\t1{gn\u001a\u0005\u0007;\u0001\u0001\u000b\u0011\u0002\f\u0002)I,\u0007\u000f\\5dC2\u000bw\rV5nK6\u000b\u00070T:!\u0011\u001dy\u0002A1A\u0005\u0002U\tQC]3qY&\u001c\u0017\rT1h\u001b\u0006DX*Z:tC\u001e,7\u000f\u0003\u0004\"\u0001\u0001\u0006IAF\u0001\u0017e\u0016\u0004H.[2b\u0019\u0006<W*\u0019=NKN\u001c\u0018mZ3tA!91\u0005\u0001b\u0001\n\u0003!\u0013!\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj]\u000b\u0002KA\u0011qCJ\u0005\u0003Oa\u00111!\u00138u\u0011\u0019I\u0003\u0001)A\u0005K\u00051\"/\u001a9mS\u000e\fg)\u001a;dQ^\u000b\u0017\u000e^'bq6\u001b\b\u0005C\u0004,\u0001\t\u0007I\u0011\u0001\u0013\u0002)I,\u0007\u000f\\5dC\u001a+Go\u00195NS:\u0014\u0015\u0010^3t\u0011\u0019i\u0003\u0001)A\u0005K\u0005)\"/\u001a9mS\u000e\fg)\u001a;dQ6KgNQ=uKN\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t\u0011\u0007\u0005\u00023o5\t1G\u0003\u00025k\u0005!Q\u000f^5m\u0015\u00051\u0014\u0001\u00026bm\u0006L!\u0001O\u001a\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004;\u0001\u0001\u0006I!M\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002Bq\u0001\u0010\u0001A\u0002\u0013\u0005Q(A\u0004d_:4\u0017nZ:\u0016\u0003y\u00022a\u0010\"E\u001b\u0005\u0001%BA!\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0007\u0002\u00131aU3r!\t\u0011R)\u0003\u0002G\u0005\tY1*\u00194lC\u000e{gNZ5h\u0011\u001dA\u0005\u00011A\u0005\u0002%\u000b1bY8oM&<7o\u0018\u0013fcR\u0011!*\u0014\t\u0003/-K!\u0001\u0014\r\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u001e\u000b\t\u00111\u0001?\u0003\rAH%\r\u0005\u0007!\u0002\u0001\u000b\u0015\u0002 \u0002\u0011\r|gNZ5hg\u0002BqA\u0015\u0001C\u0002\u0013\u00051+A\u0003u_BL7-F\u0001U!\t)\u0006,D\u0001W\u0015\t9V'\u0001\u0003mC:<\u0017BA-W\u0005\u0019\u0019FO]5oO\"11\f\u0001Q\u0001\nQ\u000ba\u0001^8qS\u000e\u0004\u0003bB/\u0001\u0005\u0004%\t\u0001J\u0001\fa\u0006\u0014H/\u001b;j_:LE\r\u0003\u0004`\u0001\u0001\u0006I!J\u0001\ra\u0006\u0014H/\u001b;j_:LE\r\t\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\u0019\t\u0003I2l\u0011!\u001a\u0006\u0003M\u001e\faaY8n[>t'BA\u0003i\u0015\tI'.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0006\u0019qN]4\n\u00055,'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007_\u0002\u0001\u000b\u0011B2\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002Bq!\u001d\u0001A\u0002\u0013\u0005!/A\u0004tKJ4XM]\u0019\u0016\u0003M\u0004\"A\u0005;\n\u0005U\u0014!aC&bM.\f7+\u001a:wKJDqa\u001e\u0001A\u0002\u0013\u0005\u00010A\u0006tKJ4XM]\u0019`I\u0015\fHC\u0001&z\u0011\u001dqe/!AA\u0002MDaa\u001f\u0001!B\u0013\u0019\u0018\u0001C:feZ,'/\r\u0011\t\u000fu\u0004\u0001\u0019!C\u0001e\u000691/\u001a:wKJ\u0014\u0004\u0002C@\u0001\u0001\u0004%\t!!\u0001\u0002\u0017M,'O^3se}#S-\u001d\u000b\u0004\u0015\u0006\r\u0001b\u0002(\u007f\u0003\u0003\u0005\ra\u001d\u0005\b\u0003\u000f\u0001\u0001\u0015)\u0003t\u0003!\u0019XM\u001d<feJ\u0002\u0003bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\rG>tg-[4Qe>\u00048/M\u000b\u0002\t\"9\u0011\u0011\u0003\u0001\u0005\u0002\u00055\u0011\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0004\u0002CA\u000b\u0001\t\u0007I\u0011A*\u0002\u000f5,7o]1hK\"9\u0011\u0011\u0004\u0001!\u0002\u0013!\u0016\u0001C7fgN\fw-\u001a\u0011\t\u0013\u0005u\u0001\u00011A\u0005\u0002\u0005}\u0011\u0001\u00039s_\u0012,8-\u001a:\u0016\u0005\u0005\u0005\u0002\u0003CA\u0012\u0003W\ty#!\u000e\u000e\u0005\u0005\u0015\"\u0002BA\u000f\u0003OQ1!!\u000bh\u0003\u001d\u0019G.[3oiNLA!!\f\u0002&\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u00042!VA\u0019\u0013\r\t\u0019D\u0016\u0002\b\u0013:$XmZ3s!\u0011\t9$!\u0010\u000f\u0007]\tI$C\u0002\u0002<a\ta\u0001\u0015:fI\u00164\u0017bA-\u0002@)\u0019\u00111\b\r\t\u0013\u0005\r\u0003\u00011A\u0005\u0002\u0005\u0015\u0013\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHc\u0001&\u0002H!Ia*!\u0011\u0002\u0002\u0003\u0007\u0011\u0011\u0005\u0005\t\u0003\u0017\u0002\u0001\u0015)\u0003\u0002\"\u0005I\u0001O]8ek\u000e,'\u000f\t\u0005\b\u0003\u001f\u0002A\u0011AA)\u0003\u001dAwOR5mKF*\"!a\u0015\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\u0003\u0003-\u0019\u0007.Z2la>Lg\u000e^:\n\t\u0005u\u0013q\u000b\u0002\u0015\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002R\u00059\u0001n\u001e$jY\u0016\u0014\u0004\"CA3\u0001\u0001\u0007I\u0011AA4\u0003\u001d\u0019XM\u001d<feN,\"!!\u001b\u0011\u0007}\u00125\u000fC\u0005\u0002n\u0001\u0001\r\u0011\"\u0001\u0002p\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\rQ\u0015\u0011\u000f\u0005\n\u001d\u0006-\u0014\u0011!a\u0001\u0003SB\u0001\"!\u001e\u0001A\u0003&\u0011\u0011N\u0001\tg\u0016\u0014h/\u001a:tA!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0014AD;qI\u0006$X\r\u0015:pIV\u001cWM\u001d\u000b\u0002\u0015\"9\u0011q\u0010\u0001\u0005B\u0005m\u0014!B:fiV\u0003\b\u0006BA?\u0003\u0007\u0003B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013S\u0017!\u00026v]&$\u0018\u0002BAG\u0003\u000f\u0013aAQ3g_J,\u0007bBAI\u0001\u0011\u0005\u00131P\u0001\ti\u0016\f'\u000fR8x]\"\"\u0011qRAK!\u0011\t))a&\n\t\u0005e\u0015q\u0011\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003;\u0003A\u0011AA>\u0003)\"Xm\u001d;I/\u000eCWmY6q_&tGOT8GC&dWO]3t'&tw\r\\3M_\u001e\u001cVmZ7f]RDC!a'\u0002\"B!\u0011QQAR\u0013\u0011\t)+a\"\u0003\tQ+7\u000f\u001e\u0005\b\u0003S\u0003A\u0011AA>\u00031\"Xm\u001d;I/\u000eCWmY6q_&tGoV5uQ\u001a\u000b\u0017\u000e\\;sKN\u001c\u0016N\\4mK2{wmU3h[\u0016tG\u000f\u000b\u0003\u0002(\u0006\u0005\u0006bBAX\u0001\u0011\u0005\u00111P\u0001.i\u0016\u001cH\u000fS,DQ\u0016\u001c7\u000e]8j]RtuNR1jYV\u0014Xm]'vYRL\u0007\u000f\\3M_\u001e\u001cVmZ7f]R\u001c\b\u0006BAW\u0003CCq!!.\u0001\t\u0003\tY(A\u0018uKN$\bjV\"iK\u000e\\\u0007o\\5oi^KG\u000f\u001b$bS2,(/Z:Nk2$\u0018\u000e\u001d7f\u0019><7+Z4nK:$8\u000f\u000b\u0003\u00024\u0006\u0005\u0006bBA^\u0001\u0011%\u0011QX\u0001\rg\u0016tG-T3tg\u0006<Wm\u001d\u000b\u0004\u0015\u0006}\u0006bBAa\u0003s\u0003\r!J\u0001\u0002]\u0002")
public class LogRecoveryTest
extends ZooKeeperTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps = new Properties();
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private KafkaServer server1;
    private KafkaServer server2;
    private final String message;
    private KafkaProducer<Integer, String> producer;
    private Seq<KafkaServer> servers;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public KafkaProducer<Integer, String> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<Integer, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpointFile hwFile1() {
        return new OffsetCheckpointFile(new File((String)this.configProps1().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public OffsetCheckpointFile hwFile2() {
        return new OffsetCheckpointFile(new File((String)this.configProps2().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        if (this.producer() != null) {
            this.producer().close();
        }
        String x$8 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        IntegerSerializer x$9 = new IntegerSerializer();
        StringSerializer x$10 = new StringSerializer();
        int x$11 = TestUtils$.MODULE$.createProducer$default$2();
        long x$12 = TestUtils$.MODULE$.createProducer$default$3();
        long x$13 = TestUtils$.MODULE$.createProducer$default$4();
        int x$14 = TestUtils$.MODULE$.createProducer$default$5();
        int x$15 = TestUtils$.MODULE$.createProducer$default$6();
        int x$16 = TestUtils$.MODULE$.createProducer$default$7();
        int x$17 = TestUtils$.MODULE$.createProducer$default$8();
        String x$18 = TestUtils$.MODULE$.createProducer$default$9();
        int x$19 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$20 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$21 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$22 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$23 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$8, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$9, x$10, x$23));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.configProps1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.configProps2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((Seq<KafkaServer>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{this.server1(), this.server2()})));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.updateProducer();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, numMessages){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long numMessages$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server2().replicaManager().localLogOrException(this.$outer.topicPartition()).highWatermark() == this.numMessages$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numMessages$1 = numMessages$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$2) {
                x$2.replicaManager().checkpointHighWatermarks();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)numMessages, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresSingleLogSegment() {
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(1);
        Thread.sleep(1000L);
        LongRef hw = LongRef.create((long)1L);
        this.server1().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        KafkaZkClient x$24 = this.zkClient();
        String x$25 = this.topic();
        int x$26 = this.partitionId();
        Some x$27 = new Some((Object)BoxesRunTime.boxToInteger((int)leader2));
        long x$28 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$29 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$24, x$25, x$26, x$28, (Option<Object>)x$27, x$29);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)leader2);
        this.server1().startup();
        this.updateProducer();
        leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader must remain on broker 1, in case of ZooKeeper session expiration it can move to broker 0", (leader2 == 0 || leader2 == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Partition)this.$outer.server2().replicaManager().nonOfflinePartition(this.$outer.topicPartition()).get()).inSyncReplicaIds().size() == 2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Server 1 is not able to join the ISR after restart";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$30 = this.zkClient();
        String x$31 = this.topic();
        int x$32 = this.partitionId();
        Some x$33 = new Some((Object)BoxesRunTime.boxToInteger((int)leader2));
        long x$34 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$35 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$30, x$31, x$32, x$34, (Option<Object>)x$33, x$35);
        Assert.assertTrue((String)"Leader must remain on broker 0, in case of ZooKeeper session expiration it can move to broker 1", (leader2 == 0 || leader2 == 1 ? 1 : 0) != 0);
        this.sendMessages(1);
        ++hw.elem;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server2().replicaManager().localLogOrException(this.$outer.topicPartition()).highWatermark() == this.hw$1.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$1 = hw$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$3) {
                x$3.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    @Test
    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final long hw$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server2().replicaManager().localLogOrException(this.$outer.topicPartition()).highWatermark() == this.hw$2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$2 = hw$2;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$4) {
                x$4.shutdown();
            }
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Assert.assertEquals((long)hw, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        int leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.sendMessages(2);
        LongRef hw = LongRef.create((long)2L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server2().replicaManager().localLogOrException(this.$outer.topicPartition()).highWatermark() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.server1().shutdown();
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$36 = this.zkClient();
        String x$37 = this.topic();
        int x$38 = this.partitionId();
        Some x$39 = new Some((Object)BoxesRunTime.boxToInteger((int)leader2));
        long x$40 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$41 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$36, x$37, x$38, x$40, (Option<Object>)x$39, x$41);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)leader2);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.server1().startup();
        this.updateProducer();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        this.sendMessages(2);
        hw.elem += 2L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server1().replicaManager().localLog(this.$outer.topicPartition()).nonEmpty();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to create replica in follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, hw){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;
            private final LongRef hw$3;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server1().replicaManager().localLogOrException(this.$outer.topicPartition()).highWatermark() == this.hw$3.elem;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hw$3 = hw$3;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Failed to update high watermark for follower after timeout";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$5) {
                x$5.shutdown();
            }
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        })));
    }

    private void sendMessages(int n) {
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogRecoveryTest $outer;

            public final Future<RecordMetadata> apply(int x$6) {
                return this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)this.$outer.message()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$7) {
                return x$7.get();
            }
        });
    }

    public LogRecoveryTest() {
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMinBytes())).toString());
        this.configs = null;
        this.topic = "new-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.server1 = null;
        this.server2 = null;
        this.message = "hello";
        this.producer = null;
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

