/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.log.LogManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.NotRunning$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001\u001d\u0011!cU3sm\u0016\u00148\u000b[;uI><h\u000eV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0003u.L!!\u0004\u0006\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\u0001\u0007I\u0011A\u000b\u0002\r\r|gNZ5h+\u00051\u0002C\u0001\n\u0018\u0013\tA\"AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007b\u0002\u000e\u0001\u0001\u0004%\taG\u0001\u000bG>tg-[4`I\u0015\fHC\u0001\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0011)f.\u001b;\t\u000f\rJ\u0012\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\r\u0015\u0002\u0001\u0015)\u0003\u0017\u0003\u001d\u0019wN\u001c4jO\u0002Bqa\n\u0001C\u0002\u0013\u0005\u0001&\u0001\u0003i_N$X#A\u0015\u0011\u0005)zS\"A\u0016\u000b\u00051j\u0013\u0001\u00027b]\u001eT\u0011AL\u0001\u0005U\u00064\u0018-\u0003\u00021W\t11\u000b\u001e:j]\u001eDaA\r\u0001!\u0002\u0013I\u0013!\u00025pgR\u0004\u0003b\u0002\u001b\u0001\u0005\u0004%\t\u0001K\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0007m\u0001\u0001\u000b\u0011B\u0015\u0002\rQ|\u0007/[2!\u0011\u001dA\u0004A1A\u0005\u0002e\nQa]3oiF*\u0012A\u000f\t\u0004w\u0001KS\"\u0001\u001f\u000b\u0005ur\u0014!C5n[V$\u0018M\u00197f\u0015\tyd$\u0001\u0006d_2dWm\u0019;j_:L!!\u0011\u001f\u0003\t1K7\u000f\u001e\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u001e\u0002\rM,g\u000e^\u0019!\u0011\u001d)\u0005A1A\u0005\u0002e\nQa]3oiJBaa\u0012\u0001!\u0002\u0013Q\u0014AB:f]R\u0014\u0004\u0005C\u0003J\u0001\u0011\u0005#*A\u0003tKR,\u0006\u000fF\u0001\u001dQ\tAE\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)!.\u001e8ji*\t\u0011+A\u0002pe\u001eL!a\u0015(\u0003\r\t+gm\u001c:f\u0011\u0015)\u0006\u0001\"\u0001K\u0003E!Xm\u001d;DY\u0016\fgn\u00155vi\u0012|wO\u001c\u0015\u0003)^\u0003\"!\u0014-\n\u0005es%\u0001\u0002+fgRDQa\u0017\u0001\u0005\u0002)\u000bq\u0005^3ti\u000ecW-\u00198TQV$Hm\\<o/&$\b\u000eR3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fI\"\u0012!l\u0016\u0005\u0006=\u0002!\tAS\u0001$i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^t\u0017I\u001a;fe\u001a\u000b\u0017\u000e\\3e'R\f'\u000f^;qQ\tiv\u000bC\u0003b\u0001\u0011\u0005!*A\u001auKN$8\t\\3b]NCW\u000f\u001e3po:\fe\r^3s\r\u0006LG.\u001a3Ti\u0006\u0014H/\u001e9Ek\u0016$vnQ8seV\u0004H\u000fT8hg\"\u0012\u0001m\u0016\u0005\u0006I\u0002!I!Z\u0001&m\u0016\u0014\u0018NZ=DY\u0016\fgn\u00155vi\u0012|wO\\!gi\u0016\u0014h)Y5mK\u0012\u001cF/\u0019:ukB,\"A\u001a:\u0015\u0007\u001d\fI\u0001\u0006\u0002\u001dQ\")\u0011n\u0019a\u0002U\u0006\tR\r_2faRLwN\\\"mCN\u001cH+Y4\u0011\u0007-t\u0007/D\u0001m\u0015\tig$A\u0004sK\u001adWm\u0019;\n\u0005=d'\u0001C\"mCN\u001cH+Y4\u0011\u0005E\u0014H\u0002\u0001\u0003\u0006g\u000e\u0014\r\u0001\u001e\u0002\u0002\u000bF\u0011Q\u000f\u001f\t\u0003;YL!a\u001e\u0010\u0003\u000f9{G\u000f[5oOB\u0019\u00110a\u0001\u000f\u0005i|hBA>\u007f\u001b\u0005a(BA?\u0007\u0003\u0019a$o\\8u}%\tq$C\u0002\u0002\u0002y\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0006\u0005\u001d!!C#yG\u0016\u0004H/[8o\u0015\r\t\tA\b\u0005\u0006)\r\u0004\rA\u0006\u0005\t\u0003\u001b\u0001\u0001\u0015\"\u0003\u0002\u0010\u00051\u0012n\u001d(p]\u0012\u000bW-\\8o\u0017\u000647.\u0019+ie\u0016\fG\r\u0006\u0003\u0002\u0012\u0005]\u0001cA\u000f\u0002\u0014%\u0019\u0011Q\u0003\u0010\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u0011DA\u0006\u0001\u0004\tY\"A\u0001u!\rQ\u0013QD\u0005\u0004\u0003?Y#A\u0002+ie\u0016\fG\r\u0003\u0004\u0002$\u0001!\tAS\u0001\u001dm\u0016\u0014\u0018NZ=O_:$\u0015-Z7p]RC'/Z1egN#\u0018\r^;t\u0011\u0019\t9\u0003\u0001C\u0001\u0015\u00069B/Z:u\u0007>t7/Z2vi&4Xm\u00155vi\u0012|wO\u001c\u0015\u0004\u0003K9\u0006BBA\u0017\u0001\u0011\u0005!*\u0001\u0011uKN$8i\u001c8ue>dG.\u001a:TQV$Hm\\<o\tV\u0014\u0018N\\4TK:$\u0007fAA\u0016/\u0002")
public class ServerShutdownTest
extends ZooKeeperTestHarness {
    private KafkaConfig config = null;
    private final String host;
    private final String topic;
    private final List<String> sent1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
    private final List<String> sent2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"more", "messages"}));

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @Test
    public void testCleanShutdown() {
        KafkaConfig x$34 = this.config();
        Option x$35 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$36 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$37 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$34, x$36, x$35, x$37);
        server.startup();
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1(server));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), TestUtils$.MODULE$.createTopic$default$6());
        ((List)this.sent1().map((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerShutdownTest $outer;
            private final ObjectRef producer$1;

            public final Future<RecordMetadata> apply(String value) {
                return ((KafkaProducer)this.producer$1.elem).send(new ProducerRecord(this.$outer.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)value));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$1) {
                return x$1.get();
            }
        });
        server.shutdown();
        this.config().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String logDir) {
                File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
                Assert.assertTrue((boolean)OffsetCheckpointFile2.exists());
                Assert.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
            }
        });
        ((KafkaProducer)producer.elem).close();
        server = new KafkaServer(this.config(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), this.topic(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        producer.elem = this.createProducer$1(server);
        KafkaConsumer consumer = this.createConsumer$1(server);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConsumerRecord<Integer, String> x$2) {
                return (String)x$2.value();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        ((List)this.sent2().map((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerShutdownTest $outer;
            private final ObjectRef producer$1;

            public final Future<RecordMetadata> apply(String value) {
                return ((KafkaProducer)this.producer$1.elem).send(new ProducerRecord(this.$outer.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)value));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RecordMetadata apply(Future<RecordMetadata> x$3) {
                return x$3.get();
            }
        });
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ConsumerRecord<Integer, String> x$4) {
                return (String)x$4.value();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
        server.shutdown();
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Test
    public void testCleanShutdownWithDeleteTopicEnabled() {
        KafkaConfig newConfig;
        Properties newProps = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        newProps.setProperty("delete.topic.enable", "true");
        KafkaConfig x$38 = newConfig = KafkaConfig$.MODULE$.fromProps(newProps);
        Option x$39 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$40 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$41 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$38, x$40, x$39, x$41);
        server.startup();
        server.shutdown();
        server.awaitShutdown();
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @Test
    public void testCleanShutdownAfterFailedStartup() {
        Properties newProps = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        newProps.setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
        newProps.setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.fromProps(newProps);
        this.verifyCleanShutdownAfterFailedStartup(newConfig, ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
    }

    @Test
    public void testCleanShutdownAfterFailedStartupDueToCorruptLogs() {
        KafkaServer server = new KafkaServer(this.config(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 1, (Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), TestUtils$.MODULE$.createTopic$default$6());
        server.shutdown();
        server.awaitShutdown();
        this.config().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerShutdownTest $outer;

            public final void apply(String dirName) {
                File partitionDir = new File(dirName, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic()})));
                Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(File f) {
                        TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.verifyCleanShutdownAfterFailedStartup(this.config(), ClassTag$.MODULE$.apply(KafkaStorageException.class));
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(KafkaConfig config, ClassTag<E> exceptionClassTag) {
        KafkaConfig x$42 = config;
        Option x$43 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$44 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        Seq x$45 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$42, x$44, x$43, x$45);
        try {
            try {
                server.startup();
                Assert.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception exception) {
                Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected exception ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception})), (boolean)exceptionClassTag.runtimeClass().isInstance(exception));
                Assert.assertEquals((long)NotRunning$.MODULE$.state(), (long)server.brokerState().currentState());
            }
        }
        finally {
            if (server.brokerState().currentState() != NotRunning$.MODULE$.state()) {
                server.shutdown();
            }
            server.awaitShutdown();
        }
        CoreUtils$.MODULE$.delete(server.config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    public boolean kafka$server$ServerShutdownTest$$isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assert.assertEquals((long)0L, (long)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Thread apply(Object x$5) {
                return (Thread)x$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Thread.class)))).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ServerShutdownTest $outer;

            public final boolean apply(Thread t) {
                return this.$outer.kafka$server$ServerShutdownTest$$isNonDaemonKafkaThread(t);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    @Test
    public void testConsecutiveShutdown() {
        KafkaServer server = new KafkaServer(this.config(), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        server.startup();
        server.shutdown();
        server.awaitShutdown();
        server.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerShutdownDuringSend() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(this, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokerAndEpochs((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 1, 0L, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)brokerAndEpochs.keys().map((Function1)new Serializable(this, listenerName){
                public static final long serialVersionUID = 0L;
                private final ListenerName listenerName$1;

                public final Node apply(Broker x$6) {
                    return x$6.node(this.listenerName$1);
                }
                {
                    this.listenerName$1 = listenerName$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSet()).asJava(), false);
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            int x$46 = 1;
            LeaderAndIsrRequest.Builder x$47 = requestBuilder;
            Function1 x$48 = qual$1.sendRequest$default$3();
            qual$1.sendRequest(x$46, (AbstractControlRequest.Builder)x$47, x$48);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            Future<?> shutdownFuture = executor.submit(new Runnable(this, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            });
            shutdownFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            void var4_4;
            void var5_5;
            void var7_7;
            void var6_6;
            if ((ServerSocket)var6_6.elem != null) {
                ((ServerSocket)var6_6.elem).close();
            }
            if ((ControllerChannelManager)var7_7.elem != null) {
                ((ControllerChannelManager)var7_7.elem).shutdown();
            }
            var5_5.shutdownNow();
            var4_4.close();
            throw throwable;
        }
        if ((ServerSocket)serverSocket.elem != null) {
            ((ServerSocket)serverSocket.elem).close();
        }
        if ((ControllerChannelManager)controllerChannelManager.elem != null) {
            ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
        }
        executor.shutdownNow();
        metrics.close();
    }

    private final KafkaProducer createProducer$1(KafkaServer server) {
        String x$7 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        IntegerSerializer x$8 = new IntegerSerializer();
        StringSerializer x$9 = new StringSerializer();
        int x$10 = TestUtils$.MODULE$.createProducer$default$2();
        long x$11 = TestUtils$.MODULE$.createProducer$default$3();
        long x$12 = TestUtils$.MODULE$.createProducer$default$4();
        int x$13 = TestUtils$.MODULE$.createProducer$default$5();
        int x$14 = TestUtils$.MODULE$.createProducer$default$6();
        int x$15 = TestUtils$.MODULE$.createProducer$default$7();
        int x$16 = TestUtils$.MODULE$.createProducer$default$8();
        String x$17 = TestUtils$.MODULE$.createProducer$default$9();
        int x$18 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$19 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$20 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$21 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$22 = TestUtils$.MODULE$.createProducer$default$16();
        return TestUtils$.MODULE$.createProducer(x$7, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$8, x$9, x$22);
    }

    private final KafkaConsumer createConsumer$1(KafkaServer server) {
        String x$23 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        SecurityProtocol x$24 = SecurityProtocol.PLAINTEXT;
        IntegerDeserializer x$25 = new IntegerDeserializer();
        StringDeserializer x$26 = new StringDeserializer();
        String x$27 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$28 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$29 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$30 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$31 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$32 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$33 = TestUtils$.MODULE$.createConsumer$default$9();
        return TestUtils$.MODULE$.createConsumer(x$23, x$27, x$28, x$29, x$30, x$31, x$24, x$32, x$33, x$25, x$26);
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }
}

