/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.QuotaType;
import kafka.server.ThrottledChannel;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0001\u0003\u0001\u001d\u0011a\u0004\u00165s_R$H.\u001a3DQ\u0006tg.\u001a7FqBL'/\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0004\u0015\u0001\t\u0007I\u0011B\u000b\u0002\tQLW.Z\u000b\u0002-A\u0011q#I\u0007\u00021)\u0011\u0011DG\u0001\u0006kRLGn\u001d\u0006\u00037q\taaY8n[>t'BA\u0003\u001e\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\n\u0005\tB\"\u0001C'pG.$\u0016.\\3\t\r\u0011\u0002\u0001\u0015!\u0003\u0017\u0003\u0015!\u0018.\\3!\u0011\u001d1\u0003\u00011A\u0005\n\u001d\naD\\;n\u0007\u0006dGNY1dWN4uN]*uCJ$H\u000b\u001b:piRd\u0017N\\4\u0016\u0003!\u0002\"!C\u0015\n\u0005)R!aA%oi\"9A\u0006\u0001a\u0001\n\u0013i\u0013A\t8v[\u000e\u000bG\u000e\u001c2bG.\u001chi\u001c:Ti\u0006\u0014H\u000f\u00165s_R$H.\u001b8h?\u0012*\u0017\u000f\u0006\u0002/cA\u0011\u0011bL\u0005\u0003a)\u0011A!\u00168ji\"9!gKA\u0001\u0002\u0004A\u0013a\u0001=%c!1A\u0007\u0001Q!\n!\nqD\\;n\u0007\u0006dGNY1dWN4uN]*uCJ$H\u000b\u001b:piRd\u0017N\\4!\u0011\u001d1\u0004\u00011A\u0005\n\u001d\nAD\\;n\u0007\u0006dGNY1dWN4uN]#oIRC'o\u001c;uY&tw\rC\u00049\u0001\u0001\u0007I\u0011B\u001d\u0002A9,XnQ1mY\n\f7m[:G_J,e\u000e\u001a+ie>$H\u000f\\5oO~#S-\u001d\u000b\u0003]iBqAM\u001c\u0002\u0002\u0003\u0007\u0001\u0006\u0003\u0004=\u0001\u0001\u0006K\u0001K\u0001\u001e]Vl7)\u00197mE\u0006\u001c7n\u001d$pe\u0016sG\r\u00165s_R$H.\u001b8hA!9a\b\u0001b\u0001\n\u0013y\u0014aB7fiJL7m]\u000b\u0002\u0001B\u0011\u0011iQ\u0007\u0002\u0005*\u0011aHG\u0005\u0003\t\n\u0013q!T3ue&\u001c7\u000f\u0003\u0004G\u0001\u0001\u0006I\u0001Q\u0001\t[\u0016$(/[2tA!9\u0001\n\u0001b\u0001\n\u0013I\u0015a\u0002:fcV,7\u000f^\u000b\u0002\u0015B\u00111*\u0015\b\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0012\tqA\\3uo>\u00148.\u0003\u0002Q\u001b\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017B\u0001*T\u0005\u001d\u0011V-];fgRT!\u0001U'\t\rU\u0003\u0001\u0015!\u0003K\u0003!\u0011X-];fgR\u0004\u0003\"B,\u0001\t\u0013A\u0016\u0001\u00042vS2$'+Z9vKN$XCA-`)\rQ6\u000e\u001e\t\u0005\u0013mk&*\u0003\u0002]\u0015\t1A+\u001e9mKJ\u0002\"AX0\r\u0001\u0011)\u0001M\u0016b\u0001C\n\tA+\u0005\u0002cKB\u0011\u0011bY\u0005\u0003I*\u0011qAT8uQ&tw\r\u0005\u0002gS6\tqM\u0003\u0002i5\u0005A!/Z9vKN$8/\u0003\u0002kO\ny\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0003m-\u0002\u0007Q.A\u0004ck&dG-\u001a:\u0011\u00079\fXL\u0004\u0002g_&\u0011\u0001oZ\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&\u0011!o\u001d\u0002\b\u0005VLG\u000eZ3s\u0015\t\u0001x\rC\u0004v-B\u0005\t\u0019\u0001<\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\u0005]LX\"\u0001=\u000b\u00059S\u0012B\u0001>y\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u0015a\b\u0001\"\u0001~\u0003!\u0019\u0017\r\u001c7cC\u000e\\GC\u0001\u0018\u007f\u0011\u0019y8\u00101\u0001\u0002\u0002\u0005A!/Z:q_:\u001cX\r\u0005\u0003\u0002\u0004\u0005MabAA\u0003\u001f:!\u0011qAA\t\u001d\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007\r\u00051AH]8pizJ\u0011!B\u0005\u0003\u001d\u0012I1!!\u0006T\u0005!\u0011Vm\u001d9p]N,\u0007bBA\r\u0001\u0011\u0005\u00111D\u0001\rE\u00164wN]3NKRDw\u000e\u001a\u000b\u0002]!\"\u0011qCA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013?\u0005)!.\u001e8ji&!\u0011\u0011FA\u0012\u0005\u0019\u0011UMZ8sK\"9\u0011Q\u0006\u0001\u0005\u0002\u0005m\u0011!\n;fgR\u001c\u0015\r\u001c7cC\u000e\\\u0017J\u001c<pG\u0006$\u0018n\u001c8BMR,'/\u0012=qSJ\fG/[8oQ\u0011\tY#!\r\u0011\t\u0005\u0005\u00121G\u0005\u0005\u0003k\t\u0019C\u0001\u0003UKN$\bbBA\u001d\u0001\u0011\u0005\u00111D\u0001\u001ai\u0016\u001cH\u000f\u00165s_R$H.\u001a3DQ\u0006tg.\u001a7EK2\f\u0017\u0010\u000b\u0003\u00028\u0005E\u0002\"CA \u0001E\u0005I\u0011BA!\u0003Y\u0011W/\u001b7e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012T\u0003BA\"\u00033*\"!!\u0012+\u0007Y\f9e\u000b\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013!C;oG\",7m[3e\u0015\r\t\u0019FC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA,\u0003\u001b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019\u0001\u0017Q\bb\u0001C\u0002")
public class ThrottledChannelExpirationTest {
    private final MockTime kafka$server$ThrottledChannelExpirationTest$$time = new MockTime();
    private int numCallbacksForStartThrottling = 0;
    private int kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling = 0;
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.kafka$server$ThrottledChannelExpirationTest$$time());
    private final RequestChannel.Request request = (RequestChannel.Request)this.buildRequest((AbstractRequest.Builder)FetchRequest.Builder.forConsumer((int)0, (int)1000, new HashMap()), this.buildRequest$default$2())._2();

    public MockTime kafka$server$ThrottledChannelExpirationTest$$time() {
        return this.kafka$server$ThrottledChannelExpirationTest$$time;
    }

    private int numCallbacksForStartThrottling() {
        return this.numCallbacksForStartThrottling;
    }

    private void numCallbacksForStartThrottling_$eq(int x$1) {
        this.numCallbacksForStartThrottling = x$1;
    }

    public int kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling() {
        return this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling;
    }

    private void kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling_$eq(int x$1) {
        this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling = x$1;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private RequestChannel.Request request() {
        return this.request;
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, requestChannelMetrics));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    public void callback(RequestChannel.Response response) {
        RequestChannel.Response response2;
        block4: {
            block3: {
                block2: {
                    response2 = response;
                    if (!(response2 instanceof RequestChannel.StartThrottlingResponse)) break block2;
                    this.numCallbacksForStartThrottling_$eq(this.numCallbacksForStartThrottling() + 1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(response2 instanceof RequestChannel.EndThrottlingResponse)) break block4;
                this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling_$eq(this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling() + 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)response2);
    }

    @Before
    public void beforeMethod() {
        this.numCallbacksForStartThrottling_$eq(0);
        this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling_$eq(0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCallbackInvocationAfterExpiration() {
        ClientQuotaManager clientMetrics = new ClientQuotaManager(new ClientQuotaManagerConfig(ClientQuotaManagerConfig$.MODULE$.apply$default$1(), ClientQuotaManagerConfig$.MODULE$.apply$default$2(), ClientQuotaManagerConfig$.MODULE$.apply$default$3(), ClientQuotaManagerConfig$.MODULE$.apply$default$4()), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.kafka$server$ThrottledChannelExpirationTest$$time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
        DelayQueue<ThrottledChannel> delayQueue = new DelayQueue<ThrottledChannel>();
        ClientQuotaManager.ThrottledChannelReaper reaper = new ClientQuotaManager.ThrottledChannelReaper(clientMetrics, delayQueue, "");
        try {
            ThrottledChannel channel1 = new ThrottledChannel(this.request(), (Time)this.kafka$server$ThrottledChannelExpirationTest$$time(), 10, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ThrottledChannelExpirationTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ThrottledChannel channel2 = new ThrottledChannel(this.request(), (Time)this.kafka$server$ThrottledChannelExpirationTest$$time(), 30, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ThrottledChannelExpirationTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ThrottledChannel channel3 = new ThrottledChannel(this.request(), (Time)this.kafka$server$ThrottledChannelExpirationTest$$time(), 30, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ThrottledChannelExpirationTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ThrottledChannel channel4 = new ThrottledChannel(this.request(), (Time)this.kafka$server$ThrottledChannelExpirationTest$$time(), 20, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ThrottledChannelExpirationTest $outer;

                public final void apply(RequestChannel.Response response) {
                    this.$outer.callback(response);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            delayQueue.add(channel1);
            delayQueue.add(channel2);
            delayQueue.add(channel3);
            delayQueue.add(channel4);
            Assert.assertEquals((long)4L, (long)this.numCallbacksForStartThrottling());
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foreach$mVc$sp((Function1)new Serializable(this, reaper){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ThrottledChannelExpirationTest $outer;
                private final ClientQuotaManager.ThrottledChannelReaper reaper$1;

                public final void apply(int itr) {
                    this.apply$mcVI$sp(itr);
                }

                public void apply$mcVI$sp(int itr) {
                    this.$outer.kafka$server$ThrottledChannelExpirationTest$$time().sleep(10L);
                    this.reaper$1.doWork();
                    Assert.assertEquals((long)itr, (long)this.$outer.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.reaper$1 = reaper$1;
                }
            });
            reaper.doWork();
            Assert.assertEquals((long)4L, (long)this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling());
            Assert.assertEquals((long)0L, (long)delayQueue.size());
            reaper.doWork();
            Assert.assertEquals((long)4L, (long)this.kafka$server$ThrottledChannelExpirationTest$$numCallbacksForEndThrottling());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.shutdown();
            throw throwable;
        }
        clientMetrics.shutdown();
    }

    @Test
    public void testThrottledChannelDelay() {
        ThrottledChannel t1 = new ThrottledChannel(this.request(), (Time)this.kafka$server$ThrottledChannelExpirationTest$$time(), 10, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ThrottledChannelExpirationTest $outer;

            public final void apply(RequestChannel.Response response) {
                this.$outer.callback(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ThrottledChannel t2 = new ThrottledChannel(this.request(), (Time)this.kafka$server$ThrottledChannelExpirationTest$$time(), 20, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ThrottledChannelExpirationTest $outer;

            public final void apply(RequestChannel.Response response) {
                this.$outer.callback(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ThrottledChannel t3 = new ThrottledChannel(this.request(), (Time)this.kafka$server$ThrottledChannelExpirationTest$$time(), 20, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ThrottledChannelExpirationTest $outer;

            public final void apply(RequestChannel.Response response) {
                this.$outer.callback(response);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Assert.assertEquals((long)10L, (long)t1.throttleTimeMs());
        Assert.assertEquals((long)20L, (long)t2.throttleTimeMs());
        Assert.assertEquals((long)20L, (long)t3.throttleTimeMs());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, t1, t2, t3){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ThrottledChannelExpirationTest $outer;
            private final ThrottledChannel t1$1;
            private final ThrottledChannel t2$1;
            private final ThrottledChannel t3$1;

            public final void apply(int itr) {
                this.apply$mcVI$sp(itr);
            }

            public void apply$mcVI$sp(int itr) {
                Assert.assertEquals((long)(10 - 10 * itr), (long)this.t1$1.getDelay(TimeUnit.MILLISECONDS));
                Assert.assertEquals((long)(20 - 10 * itr), (long)this.t2$1.getDelay(TimeUnit.MILLISECONDS));
                Assert.assertEquals((long)(20 - 10 * itr), (long)this.t3$1.getDelay(TimeUnit.MILLISECONDS));
                this.$outer.kafka$server$ThrottledChannelExpirationTest$$time().sleep(10L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.t1$1 = t1$1;
                this.t2$1 = t2$1;
                this.t3$1 = t3$1;
            }
        });
    }
}

