/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u000f\tyB+[3s)>\u0004\u0018nY'b]\u0006<WM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011aC5oi\u0016<'/\u0019;j_:L!!\u0004\u0006\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgNDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001\u0017!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0003vi&d'\"A\u000e\u0002\t)\fg/Y\u0005\u0003;a\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019y\u0002\u0001)A\u0005-\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\bC\u0001\u0011\r\u0011\"\u0001#\u0003\u0019awn\u001a#jeV\t1\u0005\u0005\u0002%O5\tQE\u0003\u0002'5\u0005\u0011\u0011n\\\u0005\u0003Q\u0015\u0012AAR5mK\"1!\u0006\u0001Q\u0001\n\r\nq\u0001\\8h\t&\u0014\b\u0005C\u0003-\u0001\u0011\u0005S&A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005q\u0003cA\u00185m5\t\u0001G\u0003\u00022e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u0019\u0003\u0007M+\u0017\u000f\u0005\u0002\u0013o%\u0011\u0001H\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003;\u0001\u0011\u00051(\u0001\u000buKN$H+[3s)>\u0004\u0018nY'b]\u0006<WM\u001d\u000b\u0002yA\u0011QHP\u0007\u0002e%\u0011qH\r\u0002\u0005+:LG\u000f\u000b\u0002:\u0003B\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\r\u0006\u0019qN]4\n\u0005!\u001b%\u0001\u0002+fgRDQA\u0013\u0001\u0005\u0002-\u000bqc\u0019:fCR,\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0007>tg-[4\u0015\u00031\u0003BaF'P-&\u0011a\n\u0007\u0002\u0004\u001b\u0006\u0004\bC\u0001)T\u001d\ti\u0014+\u0003\u0002Se\u00051\u0001K]3eK\u001aL!\u0001V+\u0003\rM#(/\u001b8h\u0015\t\u0011&\u0007\u0005\u0002X56\t\u0001L\u0003\u0002Z5\u0005!A.\u00198h\u0013\tY\u0006L\u0001\u0004PE*,7\r\u001e\u0005\u0006;\u0002!IaO\u0001\u001cCN\u001cXM\u001d;US\u0016\u00148\u000b^1uKR{\u0007/[2D_:4\u0017nZ:")
public class TierTopicManagerIntegrationTest
extends KafkaServerTestHarness {
    private final Properties overridingProps = new Properties();
    private final File logDir;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public File logDir() {
        return this.logDir;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTopicManagerIntegrationTest $outer;

            public final KafkaConfig apply(Properties x$1) {
                return KafkaConfig$.MODULE$.fromProps(x$1, this.$outer.overridingProps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testTierTopicManager() {
        TierTopicManager tierTopicManager = (TierTopicManager)((KafkaServer)this.servers().last()).tierTopicManagerOpt().get();
        LogManager logManager = ((KafkaServer)this.servers().last()).logManager();
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("cleanup.policy", "delete");
        while (true) {
            if (tierTopicManager.isReady()) {
                this.assertTierStateTopicConfigs();
                String topic1 = "foo";
                TestUtils$.MODULE$.createTopic(this.zkClient(), topic1, 2, 1, (Seq<KafkaServer>)this.servers(), properties);
                TopicPartition topicPartition = new TopicPartition(topic1, 0);
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, logManager, topicPartition){
                    public static final long serialVersionUID = 0L;
                    private final LogManager logManager$1;
                    private final TopicPartition topicPartition$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        Option partitionState = this.logManager$1.getLog(this.topicPartition$1, this.logManager$1.getLog$default$2()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TierPartitionState apply(AbstractLog x$2) {
                                return x$2.tierPartitionState();
                            }
                        });
                        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
                    }
                    {
                        this.logManager$1 = logManager$1;
                        this.topicPartition$1 = topicPartition$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Did not become leader for TierPartitionState.";
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
                TierPartitionState tierPartitionState1 = ((AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get()).tierPartitionState();
                TopicIdPartition topicIdPartition1 = (TopicIdPartition)tierPartitionState1.topicIdPartition().get();
                CompletableFuture<TierPartitionState.AppendResult> result1 = TierTestUtils$.MODULE$.uploadWithMetadata(tierTopicManager, topicIdPartition1, 0, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 100, false, true, false);
                Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result1.get());
                tierPartitionState1.flush();
                Assert.assertEquals((long)1000L, (long)tierPartitionState1.committedEndOffset());
                CompletableFuture<TierPartitionState.AppendResult> result2 = TierTestUtils$.MODULE$.uploadWithMetadata(tierTopicManager, topicIdPartition1, 0, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 200, false, true, false);
                Assert.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)result2.get());
                tierPartitionState1.flush();
                Assert.assertEquals((long)1000L, (long)tierPartitionState1.committedEndOffset());
                Assert.assertEquals((long)1L, (long)tierPartitionState1.numSegments());
                String topic2 = "topic2";
                TopicPartition topicPartition2 = new TopicPartition(topic2, 0);
                TestUtils$.MODULE$.createTopic(this.zkClient(), topicPartition2.topic(), 1, 1, (Seq<KafkaServer>)this.servers(), properties);
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, logManager, topicPartition2){
                    public static final long serialVersionUID = 0L;
                    private final LogManager logManager$1;
                    private final TopicPartition topicPartition2$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        Option partitionState = this.logManager$1.getLog(this.topicPartition2$1, this.logManager$1.getLog$default$2()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final TierPartitionState apply(AbstractLog x$3) {
                                return x$3.tierPartitionState();
                            }
                        });
                        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
                    }
                    {
                        this.logManager$1 = logManager$1;
                        this.topicPartition2$1 = topicPartition2$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Did not become leader for TierPartitionState topic2.";
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
                TierPartitionState tierPartitionState2 = ((AbstractLog)logManager.getLog(topicPartition2, logManager.getLog$default$2()).get()).tierPartitionState();
                Assert.assertTrue((boolean)tierPartitionState2.topicIdPartition().isPresent());
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierPartitionState1, tierPartitionState2){
                    public static final long serialVersionUID = 0L;
                    private final TierPartitionState tierPartitionState1$1;
                    private final TierPartitionState tierPartitionState2$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean apply$mcZ$sp() {
                        TierPartitionStatus tierPartitionStatus = this.tierPartitionState1$1.status();
                        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
                        if (tierPartitionStatus == null) {
                            if (tierPartitionStatus2 != null) {
                                return false;
                            }
                        } else if (!tierPartitionStatus.equals(tierPartitionStatus2)) return false;
                        TierPartitionStatus tierPartitionStatus3 = this.tierPartitionState2$1.status();
                        TierPartitionStatus tierPartitionStatus4 = TierPartitionStatus.ONLINE;
                        if (tierPartitionStatus3 == null) {
                            if (tierPartitionStatus4 == null) return true;
                            return false;
                        } else {
                            if (!tierPartitionStatus3.equals(tierPartitionStatus4)) return false;
                            return true;
                        }
                    }
                    {
                        this.tierPartitionState1$1 = tierPartitionState1$1;
                        this.tierPartitionState2$1 = tierPartitionState2$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "tierTopicManager consumers catchingUp timed out";
                    }
                }, 500L, TestUtils$.MODULE$.waitUntilTrue$default$4());
                TierPartitionState originalState = ((AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get()).tierPartitionState();
                Assert.assertEquals((long)1L, (long)originalState.numSegments());
                return;
            }
            Thread.sleep(5L);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> createAdminClientConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void assertTierStateTopicConfigs() {
        AdminClient client = AdminClient.create(this.createAdminClientConfig());
        ObjectRef result = ObjectRef.create(null);
        try {
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, client, result){
                public static final long serialVersionUID = 0L;
                private final AdminClient client$1;
                private final ObjectRef result$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    ExecutionException executionException2;
                    block2: {
                        boolean bl;
                        try {
                            ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, "_confluent-tier-state");
                            this.result$1.elem = (Config)((KafkaFuture)this.client$1.describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
                            bl = true;
                        }
                        catch (ExecutionException executionException2) {
                            if (!(executionException2.getCause() instanceof UnknownTopicOrPartitionException)) break block2;
                            bl = false;
                        }
                        return bl;
                    }
                    throw executionException2.getCause();
                }
                {
                    this.client$1 = client$1;
                    this.result$1 = result$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "timed waiting to find tier state topic";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        client.close();
        Assert.assertEquals((Object)"-1", (Object)((ConfigEntry)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)result.elem).entries()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ConfigEntry x$4) {
                String string = x$4.name();
                String string2 = "retention.bytes";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).get()).value());
        Assert.assertEquals((Object)"-1", (Object)((ConfigEntry)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)result.elem).entries()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ConfigEntry x$5) {
                String string = x$5.name();
                String string2 = "retention.ms";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).get()).value());
        Assert.assertEquals((Object)"delete", (Object)((ConfigEntry)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)result.elem).entries()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ConfigEntry x$6) {
                String string = x$6.name();
                String string2 = "cleanup.policy";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).get()).value());
    }

    public TierTopicManagerIntegrationTest() {
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogCleanupPolicyProp(), "compact");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1000000");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1000000");
        this.logDir = TestUtils$.MODULE$.tempDir();
    }
}

