/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001%\u0011\u0001\u0004T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",G+Z:u\u0015\t\u0019A!A\u0003fa>\u001c\u0007N\u0003\u0002\u0006\r\u000511/\u001a:wKJT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013\u0005q#\u0001\u0002uaV\t\u0001\u0004\u0005\u0002\u001aC5\t!D\u0003\u0002\u001c9\u000511m\\7n_:T!aB\u000f\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0005\u0003Ei\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004%\u0001\u0001\u0006I\u0001G\u0001\u0004iB\u0004\u0003b\u0002\u0014\u0001\u0001\u0004%IaJ\u0001\rY><WI\u001c3PM\u001a\u001cX\r^\u000b\u0002QA\u00111\"K\u0005\u0003U1\u0011A\u0001T8oO\"9A\u0006\u0001a\u0001\n\u0013i\u0013\u0001\u00057pO\u0016sGm\u00144gg\u0016$x\fJ3r)\tq\u0013\u0007\u0005\u0002\f_%\u0011\u0001\u0007\u0004\u0002\u0005+:LG\u000fC\u00043W\u0005\u0005\t\u0019\u0001\u0015\u0002\u0007a$\u0013\u0007\u0003\u00045\u0001\u0001\u0006K\u0001K\u0001\u000eY><WI\u001c3PM\u001a\u001cX\r\u001e\u0011\t\u000fY\u0002!\u0019!C\u0005o\u0005Q1\r[3dWB|\u0017N\u001c;\u0016\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0003\u0002\u0017\rDWmY6q_&tGo]\u0005\u0003{i\u0012Q\u0003T3bI\u0016\u0014X\t]8dQ\u000eCWmY6q_&tG\u000f\u0003\u0004@\u0001\u0001\u0006I\u0001O\u0001\fG\",7m\u001b9pS:$\b\u0005C\u0004B\u0001\t\u0007I\u0011\u0002\"\u0002\u000b\r\f7\r[3\u0016\u0003\r\u0003\"\u0001\u0006#\n\u0005\u0015\u0013!\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW\r\u0003\u0004H\u0001\u0001\u0006IaQ\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\t\u000b%\u0003A\u0011\u0001&\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\f\u0015\u0003\u00112\u0003\"!\u0014)\u000e\u00039S!aT\u0010\u0002\u000b),h.\u001b;\n\u0005Es%!B!gi\u0016\u0014\b\"B*\u0001\t\u0003Q\u0015!J:i_VdG-\u00113e\u000bB|7\r[!oI6+7o]1hK>3gm]3u)>\u001c\u0015m\u00195fQ\t\u0011V\u000b\u0005\u0002N-&\u0011qK\u0014\u0002\u0005)\u0016\u001cH\u000fC\u0003Z\u0001\u0011\u0005!*\u0001\u0018tQ>,H\u000e\u001a*fiV\u0014h\u000eT8h\u000b:$wJ\u001a4tKRLe\rT1uKN$X\t]8dQJ+\u0017/^3ti\u0016$\u0007F\u0001-V\u0011\u0015a\u0006\u0001\"\u0001K\u0003Q\u001a\bn\\;mIJ+G/\u001e:o+:$WMZ5oK\u0012|eMZ:fi&3WK\u001c3fM&tW\rZ#q_\u000eD'+Z9vKN$X\r\u001a\u0015\u00037VCQa\u0018\u0001\u0005\u0002)\u000b!i\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK2{w-\u00128e\u001f\u001a47/\u001a;G_J\fE*Z1eKJ,\u0005o\\2i\u001f:\u001cW-\u0013;ICN\u0014U-\u001a8BgNLwM\\3eQ\tqV\u000bC\u0003c\u0001\u0011\u0005!*\u0001\u0019tQ>,H\u000eZ#oM>\u00148-Z'p]>$xN\\5dC2d\u00170\u00138de\u0016\f7/\u001b8h'R\f'\u000f^(gMN,Go\u001d\u0015\u0003CVCQ!\u001a\u0001\u0005\u0002)\u000bAh\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK>3gm]3u\r>\u0014\u0018\tT3bI\u0016\u0014X\t]8dQ>s7-Z%u\u0011\u0006\u001c()Z3o\u0003N\u001c\u0018n\u001a8fI\"\u0012A-\u0016\u0005\u0006Q\u0002!\tAS\u0001)g\"|W\u000f\u001c3SKR,(O\\+ogV\u0004\bo\u001c:uK\u0012LeMT8Fa>\u001c\u0007NU3d_J$W\r\u001a\u0015\u0003OVCQa\u001b\u0001\u0005\u0002)\u000b!i\u001d5pk2$'+\u001a;ve:,fn];qa>\u0014H/\u001a3JM:{W\t]8dQJ+7m\u001c:eK\u0012\fe\u000eZ+oI\u00164\u0017N\\3e\u000bB|7\r\u001b*fcV,7\u000f^3eQ\tQW\u000bC\u0003o\u0001\u0011\u0005!*\u0001\u001dtQ>,H\u000e\u001a*fiV\u0014hNR5sgR,\u0005o\\2i\u0013\u001a\u0014V-];fgR,G-\u00129pG\"dUm]:UQ\u0006tg)\u001b:ti\u0016\u0003xn\u00195)\u00055,\u0006\"B9\u0001\t\u0003Q\u0015!N:i_VdG\r\u0016:v]\u000e\fG/Z%g\u001b\u0006$8\r[5oO\u0016\u0003xn\u00195CkR,\u0015M\u001d7jKJ\u001cF/\u0019:uS:<wJ\u001a4tKRD#\u0001]+\t\u000bQ\u0004A\u0011\u0001&\u0002\u0011NDw.\u001e7e\u000f\u0016$h)\u001b:ti>3gm]3u\u001f\u001a\u001cVOY:fcV,g\u000e^#q_\u000eDw\u000b[3o\u001f\u001a47/\u001a;SKF,Xm\u001d;fI\u001a{'\u000f\u0015:fm&|Wo]#q_\u000eD\u0007FA:V\u0011\u00159\b\u0001\"\u0001K\u0003\u0015\u001b\bn\\;mIJ+G/\u001e:o\u001d\u0016DH/\u0011<bS2\f'\r\\3Fa>\u001c\u0007.\u00134UQ\u0016\u0014X-S:O_\u0016C\u0018m\u0019;Fa>\u001c\u0007NR8s)\",wJ\\3SKF,Xm\u001d;fI\"\u0012a/\u0016\u0005\u0006u\u0002!\tAS\u00013g\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\u0016\u0003xn\u00195B]\u0012\u001cF/\u0019:u\u001f\u001a47/\u001a;JM&#H)\u001b3O_R\u001c\u0005.\u00198hK\"\u0012\u00110\u0016\u0005\u0006{\u0002!\tAS\u0001Fg\"|W\u000f\u001c3SKR,(O\\%om\u0006d\u0017\u000eZ(gMN,G/\u00134Fa>\u001c\u0007.S:SKF,Xm\u001d;fI^C\u0017n\u00195Jg:{GoQ;se\u0016tG\u000f\\=Ue\u0006\u001c7.\u001a3)\u0005q,\u0006BBA\u0001\u0001\u0011\u0005!*A\u0015tQ>,H\u000eZ*vaB|'\u000f^#q_\u000eD7\u000f\u00165bi\u0012{gj\u001c;Ti\u0006\u0014HO\u0012:p[j+'o\u001c\u0015\u0003\u007fVCa!a\u0002\u0001\t\u0003Q\u0015aI:i_VdG\rU3sg&\u001cH/\u00129pG\"\u001c()\u001a;xK\u0016t\u0017J\\:uC:\u001cWm\u001d\u0015\u0004\u0003\u000b)\u0006BBA\u0007\u0001\u0011\u0005!*\u0001\u0016tQ>,H\u000eZ#oM>\u00148-Z'p]>$xN\\5dC2d\u00170\u00138de\u0016\f7/\u001b8h\u000bB|7\r[:)\u0007\u0005-Q\u000b\u0003\u0004\u0002\u0014\u0001!\tAS\u0001*g\"|W\u000f\u001c3F]\u001a|'oY3PM\u001a\u001cX\r^:J]\u000e\u0014X-Y:f\u001b>tw\u000e^8oS\u000e\fG\u000e\\=)\u0007\u0005EQ\u000b\u0003\u0004\u0002\u001a\u0001!\tAS\u00015g\"|W\u000f\u001c3J]\u000e\u0014X-Y:f\u0003:$GK]1dW\u0016\u0003xn\u00195t\u0003NdU-\u00193feN\u001c\u0005.\u00198hK6\u000bg.\u001f+j[\u0016\u001c\bfAA\f+\"1\u0011q\u0004\u0001\u0005\u0002)\u000b!h\u001d5pk2$\u0017J\\2sK\u0006\u001cX-\u00118e)J\f7m[#q_\u000eD7/Q:G_2dwn^3s%\u0016\u001cW-\u001b<fg6\u000bg._'fgN\fw-Z:)\u0007\u0005uQ\u000b\u0003\u0004\u0002&\u0001!\tAS\u0001:g\"|W\u000f\u001c3Ee>\u0004XI\u001c;sS\u0016\u001cxJ\\#q_\u000eD'i\\;oI\u0006\u0014\u0018p\u00165f]J+Wn\u001c<j]\u001ed\u0015\r^3ti\u0016sGO]5fg\"\u001a\u00111E+\t\r\u0005-\u0002\u0001\"\u0001K\u0003M\u001a\bn\\;mIB\u0013Xm]3sm\u0016\u0014Vm]3u\u001f\u001a47/\u001a;P]\u000ecW-\u0019:FCJd\u0017.Z:u\u0013\u001a|e.Z#ySN$8\u000fK\u0002\u0002*UCa!!\r\u0001\t\u0003Q\u0015!O:i_VdG-\u00169eCR,7+\u0019<fI>3gm]3u/\",gn\u00144gg\u0016$Hk\\\"mK\u0006\u0014Hk\\%t\u0005\u0016$x/Z3o\u000bB|7\r[:)\u0007\u0005=R\u000b\u0003\u0004\u00028\u0001!\tAS\u0001&g\"|W\u000f\u001c3O_R\u001cE.Z1s\u0003:LH\u000f[5oO&3wJ\u001a4tKR$v.R1sYfD3!!\u000eV\u0011\u0019\ti\u0004\u0001C\u0001\u0015\u0006Y3\u000f[8vY\u0012tu\u000e^\"mK\u0006\u0014\u0018I\\=uQ&tw-\u00134PM\u001a\u001cX\r\u001e+p\r&\u00148\u000f^(gMN,G\u000fK\u0002\u0002<UCa!a\u0011\u0001\t\u0003Q\u0015!K:i_VdGMU3uC&tG*\u0019;fgR,\u0005o\\2i\u001f:\u001cE.Z1s\u00032dW)\u0019:mS\u0016\u001cH\u000fK\u0002\u0002BUCa!!\u0013\u0001\t\u0003Q\u0015aN:i_VdG-\u00169eCR,wJ\u001a4tKR\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1sS\u0016\u001cxJ\\\"mK\u0006\u0014X)\u0019:mS\u0016\u001cH\u000fK\u0002\u0002HUCa!a\u0014\u0001\t\u0003Q\u0015\u0001O:i_VdG-\u00169eCR,wJ\u001a4tKR\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1sS\u0016\u001cxJ\\\"mK\u0006\u0014X)\u0019:mS\u0016\u001cHO\r\u0015\u0004\u0003\u001b*\u0006BBA+\u0001\u0011\u0005!*A\u001etQ>,H\u000e\u001a*fi\u0006Lg\u000eT1uKN$X\t]8dQ>s7\t\\3be\u0006cG.R1sY&,7\u000f^!oIV\u0003H-\u0019;f\u0013R\u001cxJ\u001a4tKRD3!a\u0015V\u0011\u0019\tY\u0006\u0001C\u0001\u0015\u000694\u000f[8vY\u0012$%o\u001c9F]R\u0014\u0018.Z:CKR<X-\u001a8Fa>\u001c\u0007NQ8v]\u0012\f'/_,iK:\u0014V-\\8wS:<g*Z<fgRD3!!\u0017V\u0011\u0019\t\t\u0007\u0001C\u0001\u0015\u0006)2\u000f[8vY\u0012\u001cE.Z1s\u00032dWI\u001c;sS\u0016\u001c\bfAA0+\"1\u0011q\r\u0001\u0005\u0002)\u000bqf\u001d5pk2$gj\u001c;SKN,G/\u00129pG\"D\u0015n\u001d;pefDU-\u00193JMVsG-\u001a4j]\u0016$\u0007+Y:tK\u0012D3!!\u001aV\u0011\u0019\ti\u0007\u0001C\u0001\u0015\u0006y3\u000f[8vY\u0012tu\u000e\u001e*fg\u0016$X\t]8dQ\"K7\u000f^8ssR\u000b\u0017\u000e\\%g+:$WMZ5oK\u0012\u0004\u0016m]:fI\"\u001a\u00111N+\t\r\u0005M\u0004\u0001\"\u0001K\u0003\t\u001a\bn\\;mI\u001a+Go\u00195MCR,7\u000f^#q_\u000eDwJZ#naRL8)Y2iK\"\u001a\u0011\u0011O+\t\r\u0005e\u0004\u0001\"\u0001K\u0003\u0001\u001a\bn\\;mI\u001a+Go\u00195F]\u0012|eMZ:fi>3W)\u001c9us\u000e\u000b7\r[3)\u0007\u0005]T\u000b\u0003\u0004\u0002\u0000\u0001!\tAS\u0001 g\"|W\u000f\u001c3DY\u0016\f'/R1sY&,7\u000f^(o\u000b6\u0004H/_\"bG\",\u0007fAA?+\"1\u0011Q\u0011\u0001\u0005\u0002)\u000bQd\u001d5pk2$7\t\\3be2\u000bG/Z:u\u001f:,U\u000e\u001d;z\u0007\u0006\u001c\u0007.\u001a\u0015\u0004\u0003\u0007+\u0006")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private long kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset = 0L;
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(this){
        private Seq<EpochEntry> epochs;
        private final File file;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public File file() {
            return this.file;
        }

        public void write(Seq<EpochEntry> epochs) {
            this.epochs_$eq(epochs);
        }

        public Seq<EpochEntry> read() {
            return this.epochs();
        }
        {
            this.epochs = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.file = TestUtils$.MODULE$.tempFile();
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ LeaderEpochFileCacheTest $outer;

        public final long apply() {
            return this.apply$mcJ$sp();
        }

        public long apply$mcJ$sp() {
            return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset();
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }, this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    public long kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset() {
        return this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset;
    }

    private void kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(long x$1) {
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset = x$1;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.checkpoint().file());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(11L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new EpochEntry(2, 10L), (Object)this.cache().epochEntries().apply(0));
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(14L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.cache().endOffsetFor(-1);
        Assert.assertEquals((String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.", (Object)expectedEpochEndOffset, (Object)epochAndOffsetFor);
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(9L);
        this.cache().assign(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset());
        this.cache().assign(2, 10L);
        Assert.assertEquals((long)this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset(), (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assert.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(73L);
        Tuple2 offsetFor = this.cache().endOffsetFor(-1);
        Assert.assertEquals((String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.", (Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)offsetFor);
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.cache().endOffsetFor(4);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(4, 11), (Object)epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(5));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(6));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(17L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 15), (Object)this.cache().endOffsetFor(2));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 13), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(3));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assert.assertEquals((long)1L, (long)this.cache().epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(100L);
        this.cache().assign(2, 100L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(3));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(7L);
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((long)1L, (long)this.cache().epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (LeaderEpochCheckpoint)checkpoint);
        cache.assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LeaderEpochFileCacheTest $outer;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (LeaderEpochCheckpoint)checkpoint2);
        Assert.assertEquals((long)1L, (long)cache2.epochEntries().size());
        Assert.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache2.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(6L);
        this.cache().assign(2, 6L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(7L);
        this.cache().assign(1, 7L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(8L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 8), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new EpochEntry(1, 7L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assert.assertEquals((Object)new EpochEntry(3, 5L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 0), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(5L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(2, 5L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(10L);
        Assert.assertEquals((Object)new Tuple2.mcII.sp(2, 10), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(1L);
        this.cache().assign(0, 1L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(2L);
        this.cache().assign(0, 2L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(3L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(0, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(0));
        this.cache().assign(1, 3L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(4L);
        this.cache().assign(1, 4L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(5L);
        this.cache().assign(1, 5L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(6L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(1, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(1));
        this.cache().assign(2, 6L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(7L);
        this.cache().assign(2, 7L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(8L);
        this.cache().assign(2, 8L);
        this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset_$eq(9L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(2, this.kafka$server$epoch$LeaderEpochFileCacheTest$$logEndOffset()), (Object)this.cache().endOffsetFor(2));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(0, 3), (Object)this.cache().endOffsetFor(0));
        Assert.assertEquals((Object)new Tuple2.mcII.sp(1, 6), (Object)this.cache().endOffsetFor(1));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(1L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Object)this.cache().latestEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assert.assertEquals((long)0L, (long)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assert.assertEquals((long)3L, (long)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assert.assertEquals((long)3L, (long)this.cache().epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assert.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(7));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }
}

