/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u000f\t)B+[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u0011!\u0018.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\u00111\u0002B\u0001\u0004CBL\u0017BA\u0007\u000b\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\nU\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001\u0017!\t9r$D\u0001\u0019\u0015\tI\"$\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bmQ!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO&\u0011\u0001\u0005\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\u0011\u0003\u0001)A\u0005-\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004%\u0001\t\u0007I\u0011K\u0013\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t\u0019\u0011J\u001c;\t\r5\u0002\u0001\u0015!\u0003'\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0011\u0015y\u0003\u0001\"\u00111\u0003\u0015\u0019X\r^+q)\u0005\t\u0004CA\u00143\u0013\t\u0019\u0004F\u0001\u0003V]&$\bF\u0001\u00186!\t1\u0014(D\u00018\u0015\tAT$A\u0003kk:LG/\u0003\u0002;o\t1!)\u001a4pe\u0016DQ\u0001\u0010\u0001\u0005\u0002A\n\u0001\u0007^3ti\u0016s\u0017M\u00197f\u0007>l\u0007/Y2uS>t\u0017I\u001a;fe\u0016s\u0017M\u00197f)&,'/\u0011;Ce>\\WM\u001d'fm\u0016d\u0007FA\u001e?!\t1t(\u0003\u0002Ao\t!A+Z:u\u0011\u0015\u0011\u0005\u0001\"\u00011\u0003=\"Xm\u001d;F]\u0006\u0014G.Z\"p[B\f7\r^5p]\u00063G/\u001a:F]\u0006\u0014G.\u001a+jKJ\fE\u000fV8qS\u000edUM^3mQ\t\te\bC\u0003F\u0001\u0011\u0005\u0001'\u0001\u001buKN$8I]3bi\u0016\u001cu.\u001c9bGR,G\rV8qS\u000e\fe\r^3s\u000b:\f'\r\\3US\u0016\u0014\u0018\t\u001e\"s_.,'\u000fT3wK2D#\u0001\u0012 \t\u000b!\u0003A\u0011B%\u0002!\u0015t\u0017M\u00197f\u0007>l\u0007/Y2uS>tG#\u0001&\u0011\u0005-\u0003V\"\u0001'\u000b\u00055s\u0015!B1e[&t'BA(\u001b\u0003\u001d\u0019G.[3oiNL!!\u0015'\u0003%\u0005cG/\u001a:D_:4\u0017nZ:SKN,H\u000e\u001e\u0005\u0006'\u0002!I\u0001V\u0001\u000eCN\u001cXM\u001d;J]Z\fG.\u001b3\u0015\u0005E*\u0006\"\u0002,S\u0001\u0004Q\u0015A\u0002:fgVdG\u000f")
public class TierConfigurationTest
extends IntegrationTestHarness {
    private final TopicPartition kafka$tier$TierConfigurationTest$$topicPartition;
    private final int brokerCount;

    public TopicPartition kafka$tier$TierConfigurationTest$$topicPartition() {
        return this.kafka$tier$TierConfigurationTest$$topicPartition;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @Before
    public void setUp() {
    }

    @Test
    public void testEnableCompactionAfterEnableTierAtBrokerLevel() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        super.setUp();
        this.createTopic(this.kafka$tier$TierConfigurationTest$$topicPartition().topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        this.assertInvalid(this.enableCompaction());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierConfigurationTest $outer;

            public final void apply(KafkaServer server) {
                LogManager qual$1 = server.logManager();
                TopicPartition x$1 = this.$outer.kafka$tier$TierConfigurationTest$$topicPartition();
                boolean x$2 = qual$1.getLog$default$2();
                Assert.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$1, x$2).get()).tierPartitionState().isTieringEnabled());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testEnableCompactionAfterEnableTierAtTopicLevel() {
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        String x$3 = this.kafka$tier$TierConfigurationTest$$topicPartition().topic();
        Properties x$4 = topicConfig;
        int x$5 = this.createTopic$default$2();
        int x$6 = this.createTopic$default$3();
        this.createTopic(x$3, x$5, x$6, x$4);
        this.assertInvalid(this.enableCompaction());
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierConfigurationTest $outer;

            public final void apply(KafkaServer server) {
                LogManager qual$2 = server.logManager();
                TopicPartition x$7 = this.$outer.kafka$tier$TierConfigurationTest$$topicPartition();
                boolean x$8 = qual$2.getLog$default$2();
                Assert.assertTrue((boolean)((AbstractLog)qual$2.getLog(x$7, x$8).get()).tierPartitionState().isTieringEnabled());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testCreateCompactedTopicAfterEnableTierAtBrokerLevel() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        String x$9 = this.kafka$tier$TierConfigurationTest$$topicPartition().topic();
        Properties x$10 = topicConfig;
        int x$11 = this.createTopic$default$2();
        int x$12 = this.createTopic$default$3();
        this.createTopic(x$9, x$11, x$12, x$10);
        this.enableCompaction().all().get();
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierConfigurationTest $outer;

            public final void apply(KafkaServer server) {
                LogManager qual$3 = server.logManager();
                TopicPartition x$13 = this.$outer.kafka$tier$TierConfigurationTest$$topicPartition();
                boolean x$14 = qual$3.getLog$default$2();
                Assert.assertFalse((boolean)((AbstractLog)qual$3.getLog(x$13, x$14).get()).tierPartitionState().isTieringEnabled());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private AlterConfigsResult enableCompaction() {
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.kafka$tier$TierConfigurationTest$$topicPartition().topic()), Collections.singletonList(alterConfigOp));
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        return adminClient.incrementalAlterConfigs(configs);
    }

    private void assertInvalid(AlterConfigsResult result) {
        ExecutionException exception = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final AlterConfigsResult result$1;

            public final Void apply() {
                return (Void)this.result$1.all().get();
            }
            {
                this.result$1 = result$1;
            }
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TierConfigurationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        Assert.assertEquals(InvalidConfigurationException.class, exception.getCause().getClass());
    }

    public TierConfigurationTest() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.kafka$tier$TierConfigurationTest$$topicPartition = new TopicPartition("foo", 0);
        this.brokerCount = 1;
    }
}

