/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.TierTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0004V5fe\u0016\u0003xn\u00195Ti\u0006$XMU3qY&\u001c\u0017\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tA\u0001^5fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\bCA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%\taG\u0001\u0006i>\u0004\u0018nY\u000b\u00029A\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005Y\u0006twMC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"AB*ue&tw\r\u0003\u0004&\u0001\u0001\u0006I\u0001H\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u000f\u001d\u0002!\u0019!C\u0001Q\u0005\u0019Qn]4\u0016\u0003%\u00022AK\u00170\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#!B!se\u0006L\bC\u0001\u00161\u0013\t\t4F\u0001\u0003CsR,\u0007BB\u001a\u0001A\u0003%\u0011&\u0001\u0003ng\u001e\u0004\u0003bB\u001b\u0001\u0005\u0004%\t\u0001K\u0001\n[N<')[4hKJDaa\u000e\u0001!\u0002\u0013I\u0013AC7tO\nKwmZ3sA!9\u0011\b\u0001a\u0001\n\u0003Q\u0014a\u00022s_.,'o]\u000b\u0002wA\u0019AhP!\u000e\u0003uR!AP\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002A{\t\u00191+Z9\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0011AB:feZ,'/\u0003\u0002G\u0007\nY1*\u00194lCN+'O^3s\u0011\u001dA\u0005\u00011A\u0005\u0002%\u000b1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u0011!*\u0014\t\u0003U-K!\u0001T\u0016\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\u001e\u000b\t\u00111\u0001<\u0003\rAH%\r\u0005\u0007!\u0002\u0001\u000b\u0015B\u001e\u0002\u0011\t\u0014xn[3sg\u0002BqA\u0015\u0001A\u0002\u0013\u00051+\u0001\u0005qe>$WoY3s+\u0005!\u0006\u0003B+_S%j\u0011A\u0016\u0006\u0003%^S!\u0001W-\u0002\u000f\rd\u0017.\u001a8ug*\u0011QA\u0017\u0006\u00037r\u000ba!\u00199bG\",'\"A/\u0002\u0007=\u0014x-\u0003\u0002`-\ni1*\u00194lCB\u0013x\u000eZ;dKJDq!\u0019\u0001A\u0002\u0013\u0005!-\u0001\u0007qe>$WoY3s?\u0012*\u0017\u000f\u0006\u0002KG\"9a\nYA\u0001\u0002\u0004!\u0006BB3\u0001A\u0003&A+A\u0005qe>$WoY3sA!9q\r\u0001b\u0001\n\u0003A\u0017AB3ySR,G-F\u0001j!\tQ\u0017/D\u0001l\u0015\taW.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003]>\f!bY8oGV\u0014(/\u001a8u\u0015\t\u0001\b%\u0001\u0003vi&d\u0017B\u0001:l\u00055\tEo\\7jG\n{w\u000e\\3b]\"1A\u000f\u0001Q\u0001\n%\fq!\u001a=ji\u0016$\u0007\u0005C\u0003w\u0001\u0011\u0005s/A\u0003tKR,\u0006\u000fF\u0001KQ\t)\u0018\u0010\u0005\u0002{{6\t1P\u0003\u0002}9\u0006)!.\u001e8ji&\u0011ap\u001f\u0002\u0007\u0005\u00164wN]3\t\r\u0005\u0005\u0001\u0001\"\u0011x\u0003!!X-\u0019:E_^t\u0007fA@\u0002\u0006A\u0019!0a\u0002\n\u0007\u0005%1PA\u0003BMR,'\u000f\u0003\u0004\u0002\u000e\u0001!\ta^\u0001\"i\u0016\u001cH\u000fV5feN#\u0018\r^3SKN$xN]3U_J+\u0007\u000f\\5dCRLwN\u001c\u0015\u0005\u0003\u0017\t\t\u0002E\u0002{\u0003'I1!!\u0006|\u0005\u0011!Vm\u001d;\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c\u00051q-\u001a;M_\u001e$b!!\b\u0002*\u00055\u0002\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rB!A\u0002m_\u001eLA!a\n\u0002\"\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u001d\tY#a\u0006A\u0002\u0005\u000baA\u0019:pW\u0016\u0014\b\u0002CA\u0018\u0003/\u0001\r!!\r\u0002\u0013A\f'\u000f^5uS>t\u0007c\u0001\u0016\u00024%\u0019\u0011QG\u0016\u0003\u0007%sG\u000fC\u0004\u0002:\u0001!I!a\u000f\u0002\tM$x\u000e\u001d\u000b\u0004\u0015\u0006u\u0002B\u0002#\u00028\u0001\u0007\u0011\tC\u0004\u0002B\u0001!I!a\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0007)\u000b)\u0005\u0003\u0004E\u0003\u007f\u0001\r!\u0011\u0005\b\u0003\u0013\u0002A\u0011BA&\u0003\u0019\u0011w.\u001e8dKR\u0019!*!\u0014\t\r\u0011\u000b9\u00051\u0001B\u0011\u001d\t\t\u0006\u0001C\u0005\u0003'\n!\"\u001a9pG\"\u001c\u0015m\u00195f)\u0011\t)&!\u0019\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017D\u0003\u0015)\u0007o\\2i\u0013\u0011\ty&!\u0017\u0003)1+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195f\u0011\u001d\tY#a\u0014A\u0002\u0005Cq!!\u001a\u0001\t\u0013\t9'\u0001\u0007mCR,7\u000f\u001e*fG>\u0014H\r\u0006\u0005\u0002j\u0005e\u0014QPAA!\u0011\tY'!\u001e\u000e\u0005\u00055$\u0002BA8\u0003c\naA]3d_J$'bAA:3\u000611m\\7n_:LA!a\u001e\u0002n\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011\u001d\tY(a\u0019A\u0002\u0005\u000ba\u0001\\3bI\u0016\u0014\bBCA@\u0003G\u0002\n\u00111\u0001\u00022\u00051qN\u001a4tKRD!\"a\f\u0002dA\u0005\t\u0019AA\u0019\u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000b\u0001\"Y<bSRL5K\u0015\u000b\u0006\u0015\u0006%\u0015Q\u0013\u0005\t\u0003\u0017\u000b\u0019\t1\u0001\u0002\u000e\u0006\u0011A\u000f\u001d\t\u0005\u0003\u001f\u000b\t*\u0004\u0002\u0002r%!\u00111SA9\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"a&\u0002\u0004\u0002\u0007\u0011\u0011G\u0001\f]Vl'+\u001a9mS\u000e\f7\u000f\u0003\u0004\u0002\u001c\u0002!IaU\u0001\u000fGJ,\u0017\r^3Qe>$WoY3s\u0011\u001d\tY\b\u0001C\u0005\u0003?#\u0012!\u0011\u0005\b\u0003G\u0003A\u0011BAP\u0003!1w\u000e\u001c7po\u0016\u0014\bbBAT\u0001\u0011%\u0011\u0011V\u0001\rGJ,\u0017\r^3Ce>\\WM\u001d\u000b\u0006\u0003\u0006-\u0016q\u0016\u0005\t\u0003[\u000b)\u000b1\u0001\u00022\u0005\u0011\u0011\u000e\u001a\u0005\u000b\u0003c\u000b)\u000b%AA\u0002\u0005M\u0016aG3oC\ndW-\u00168dY\u0016\fg\u000eT3bI\u0016\u0014X\t\\3di&|g\u000eE\u0002+\u0003kK1!a.,\u0005\u001d\u0011un\u001c7fC:D\u0011\"a/\u0001#\u0003%I!!0\u0002-\r\u0014X-\u0019;f\u0005J|7.\u001a:%I\u00164\u0017-\u001e7uII*\"!a0+\t\u0005M\u0016\u0011Y\u0016\u0003\u0003\u0007\u0004B!!2\u0002P6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-A\u0005v]\u000eDWmY6fI*\u0019\u0011QZ\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0006\u001d'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011Q\u001b\u0001\u0012\u0002\u0013%\u0011q[\u0001\u0017Y\u0006$Xm\u001d;SK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001c\u0016\u0005\u0003c\t\t\rC\u0005\u0002^\u0002\t\n\u0011\"\u0003\u0002X\u00061B.\u0019;fgR\u0014VmY8sI\u0012\"WMZ1vYR$3\u0007")
public class TierEpochStateReplicationTest
extends ZooKeeperTestHarness {
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final byte[] msgBigger = new byte[10000];
    private Seq<KafkaServer> brokers = null;
    private KafkaProducer<byte[], byte[]> producer = null;
    private final AtomicBoolean exited = new AtomicBoolean(false);

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public byte[] msgBigger() {
        return this.msgBigger;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @Before
    public void setUp() {
        Exit.setExitProcedure((Exit.Procedure)new Exit.Procedure(this){
            private final /* synthetic */ TierEpochStateReplicationTest $outer;

            public void execute(int statusCode, String message) {
                this.$outer.exited().set(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
        Assert.assertFalse((boolean)this.exited().get());
    }

    @Test
    public void testTierStateRestoreToReplication() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierEpochStateReplicationTest $outer;

            public final KafkaServer apply(int x$1) {
                return this.$outer.kafka$tier$TierEpochStateReplicationTest$$createBroker(x$1, this.$outer.kafka$tier$TierEpochStateReplicationTest$$createBroker$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("segment.bytes", "10000");
        properties.put("retention.bytes", "-1");
        this.brokers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer b) {
                TierTestUtils$.MODULE$.awaitTierTopicPartition(b, Predef$.MODULE$.int2Integer(0));
            }
        });
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers(), properties);
        this.producer_$eq(this.createProducer());
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.kafka$tier$TierEpochStateReplicationTest$$leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.kafka$tier$TierEpochStateReplicationTest$$leader()).epochEntries());
        this.bounce(this.kafka$tier$TierEpochStateReplicationTest$$leader());
        this.awaitISR(tp, 2);
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.kafka$tier$TierEpochStateReplicationTest$$leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.follower()).epochEntries());
        KafkaServer followerToShutdown = this.follower();
        this.stop(followerToShutdown);
        this.awaitISR(tp, 1);
        LogManager qual$1 = this.kafka$tier$TierEpochStateReplicationTest$$leader().replicaManager().logManager();
        TopicPartition x$4 = tp;
        boolean x$5 = qual$1.getLog$default$2();
        long logEndPriorToProduce = ((AbstractLog)qual$1.getLog(x$4, x$5).get()).localLogEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 999).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierEpochStateReplicationTest $outer;

            public final RecordMetadata apply(int i) {
                return (RecordMetadata)this.$outer.producer().send(new ProducerRecord(this.$outer.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.$outer.msg())).get();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, logEndPriorToProduce){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierEpochStateReplicationTest $outer;
            private final TopicPartition tp$1;
            private final long logEndPriorToProduce$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                LogManager qual$2 = this.$outer.kafka$tier$TierEpochStateReplicationTest$$leader().replicaManager().logManager();
                TopicPartition x$6 = this.tp$1;
                boolean x$7 = qual$2.getLog$default$2();
                Option leaderLog = qual$2.getLog(x$6, x$7);
                ((AbstractLog)leaderLog.get()).deleteOldSegments();
                return ((AbstractLog)leaderLog.get()).localLogStartOffset() > this.logEndPriorToProduce$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$1 = tp$1;
                this.logEndPriorToProduce$1 = logEndPriorToProduce$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timed out waiting for segment tiering and deletion";
            }
        }, 60000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)1001L, (long)this.latestRecord(this.kafka$tier$TierEpochStateReplicationTest$$leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).nextOffset());
        Assert.assertEquals((long)2L, (long)this.latestRecord(this.kafka$tier$TierEpochStateReplicationTest$$leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.kafka$tier$TierEpochStateReplicationTest$$leader()).epochEntries());
        this.start(followerToShutdown);
        this.awaitISR(tp, 2);
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.kafka$tier$TierEpochStateReplicationTest$$leader()).epochEntries());
        Assert.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.follower()).epochEntries());
    }

    private AbstractLog getLog(KafkaServer broker, int partition) {
        LogManager qual$3 = broker.logManager();
        TopicPartition x$8 = new TopicPartition(this.topic(), partition);
        boolean x$9 = qual$3.getLog$default$2();
        return (AbstractLog)qual$3.getLog(x$8, x$9).orNull(Predef$.MODULE$.$conforms());
    }

    private void stop(KafkaServer server) {
        server.shutdown();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private void start(KafkaServer server) {
        server.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private void bounce(KafkaServer server) {
        server.shutdown();
        server.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private LeaderEpochFileCache epochCache(KafkaServer broker) {
        AbstractLog log2 = this.getLog(broker, 0);
        return (LeaderEpochFileCache)log2.leaderEpochCache().get();
    }

    private RecordBatch latestRecord(KafkaServer leader2, int offset, int partition) {
        LogSegment segment = this.getLog(leader2, partition).activeSegment();
        Records records2 = segment.read(0L, Integer.MAX_VALUE, segment.read$default$3(), segment.read$default$4()).records();
        return (RecordBatch)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.batches()).asScala()).toSeq().last();
    }

    private int latestRecord$default$2() {
        return -1;
    }

    private int latestRecord$default$3() {
        return 0;
    }

    private void awaitISR(TopicPartition tp, int numReplicas) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, numReplicas){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierEpochStateReplicationTest $outer;
            private final TopicPartition tp$2;
            private final int numReplicas$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Partition)this.$outer.kafka$tier$TierEpochStateReplicationTest$$leader().replicaManager().nonOfflinePartition(this.tp$2).get()).inSyncReplicaIds().size() == this.numReplicas$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tp$2 = tp$2;
                this.numReplicas$1 = numReplicas$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for replicas to join ISR";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private KafkaProducer<byte[], byte[]> createProducer() {
        return TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16());
    }

    public KafkaServer kafka$tier$TierEpochStateReplicationTest$$leader() {
        Assert.assertEquals((long)2L, (long)this.brokers().size());
        int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((SeqLike)this.brokers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaServer x$2) {
                return x$2.config().brokerId() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).apply(0);
    }

    private KafkaServer follower() {
        Assert.assertEquals((long)2L, (long)this.brokers().size());
        int leader2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((SeqLike)this.brokers().filter((Function1)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$1;

            public final boolean apply(KafkaServer x$3) {
                return x$3.config().brokerId() != this.leader$1;
            }
            {
                this.leader$1 = leader$1;
            }
        })).apply(0);
    }

    public KafkaServer kafka$tier$TierEpochStateReplicationTest$$createBroker(int id, boolean enableUncleanLeaderElection) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)enableUncleanLeaderElection)).toString());
        config.setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        config.setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        config.setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        config.setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        config.setProperty(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
    }

    public boolean kafka$tier$TierEpochStateReplicationTest$$createBroker$default$2() {
        return false;
    }

    public TierEpochStateReplicationTest() {
        this.topic = "topic1";
    }
}

