/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TierIntegrationFetchTest$;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0004V5fe&sG/Z4sCRLwN\u001c$fi\u000eDG+Z:u\u0015\t\u0019A!\u0001\u0003uS\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t1!\u00199j\u0013\ti!B\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011ES#A\u0006ce>\\WM]\"pk:$X#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG\u000fC\u0003\u001e\u0001\u0011%a$A\u0007d_:4\u0017nZ;sK6{7m\u001b\u000b\u0002?A\u0011q\u0003I\u0005\u0003Ca\u0011A!\u00168ji\"91\u0005\u0001b\u0001\n\u0013!\u0013!\u0002;pa&\u001cW#A\u0013\u0011\u0005\u0019ZS\"A\u0014\u000b\u0005!J\u0013\u0001\u00027b]\u001eT\u0011AK\u0001\u0005U\u00064\u0018-\u0003\u0002-O\t11\u000b\u001e:j]\u001eDaA\f\u0001!\u0002\u0013)\u0013A\u0002;pa&\u001c\u0007\u0005C\u00041\u0001\t\u0007I\u0011B\u000b\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0003\u00043\u0001\u0001\u0006IAF\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u00035\u0001\u0011%Q'A\bu_BL7\rU1si&$\u0018n\u001c8t+\u00051\u0004cA\u001c@\u0005:\u0011\u0001(\u0010\b\u0003sqj\u0011A\u000f\u0006\u0003w\u0019\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005yB\u0012a\u00029bG.\fw-Z\u0005\u0003\u0001\u0006\u00131aU3r\u0015\tq\u0004\u0004\u0005\u0002D\u00176\tAI\u0003\u0002F\r\u000611m\\7n_:T!!B$\u000b\u0005!K\u0015AB1qC\u000eDWMC\u0001K\u0003\ry'oZ\u0005\u0003\u0019\u0012\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004O\u0001\t\u0007I\u0011A(\u0002\r\u0015D\u0018\u000e^3e+\u0005\u0001\u0006CA)Y\u001b\u0005\u0011&BA*U\u0003\u0019\tGo\\7jG*\u0011QKV\u0001\u000bG>t7-\u001e:sK:$(BA,*\u0003\u0011)H/\u001b7\n\u0005e\u0013&!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004\\\u0001\u0001\u0006I\u0001U\u0001\bKbLG/\u001a3!\u0011\u0015i\u0006\u0001\"\u0011\u001f\u0003\u0015\u0019X\r^+qQ\tav\f\u0005\u0002aG6\t\u0011M\u0003\u0002c\u0013\u0006)!.\u001e8ji&\u0011A-\u0019\u0002\u0007\u0005\u00164wN]3\t\u000b\u0019\u0004A\u0011\t\u0010\u0002\u0011Q,\u0017M\u001d#po:D#!\u001a5\u0011\u0005\u0001L\u0017B\u00016b\u0005\u0015\te\r^3s\u0011\u0015a\u0007\u0001\"\u0001\u001f\u0003]!Xm\u001d;Be\u000eD\u0017N^3B]\u0012$\u0016.\u001a:GKR\u001c\u0007\u000e\u000b\u0002l]B\u0011\u0001m\\\u0005\u0003a\u0006\u0014A\u0001V3ti\")!\u000f\u0001C\u0001=\u0005\u0001C/Z:u\u0003J\u001c\u0007.\u001b<f\u0003:$\u0007K]3gKJ\u0014X\r\u001a+jKJ4U\r^2iQ\t\th\u000eC\u0003v\u0001\u0011%a/\u0001\bqe>$WoY3SK\u000e|'\u000fZ:\u0015\u0007}9\u0018\u0010C\u0003yi\u0002\u0007a#\u0001\u0005o\u0005\u0006$8\r[3t\u0011\u0015QH\u000f1\u0001\u0017\u0003=\u0011XmY8sIN\u0004VM\u001d\"bi\u000eD\u0007\"\u0002?\u0001\t\u0013i\u0018AG4fi2+\u0017\rZ3s\r>\u0014Hk\u001c9jGB\u000b'\u000f^5uS>tG\u0003\u0002\f\u007f\u0003\u0003AQa`>A\u0002\t\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002\u0004m\u0004\r!!\u0002\u0002)A\f'\u000f^5uS>tGk\u001c'fC\u0012,'/T1q!\u0019\t9!!\u0004\u0017-9\u0019q#!\u0003\n\u0007\u0005-\u0001$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\t\tBA\u0002NCBT1!a\u0003\u0019\u0011\u001d\t)\u0002\u0001C\u0005\u0003/\tqc^1jiVsG/\u001b7TK\u001elWM\u001c;t)&,'/\u001a3\u0015\u000b}\tI\"!\b\t\u000f\u0005m\u00111\u0003a\u0001-\u0005qQ.\u001b8Ok6\u001cVmZ7f]R\u001c\b\u0002CA\u0002\u0003'\u0001\r!!\u0002\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\u0005\t2/[7vY\u0006$XMU3uK:$\u0018n\u001c8\u0015\u0007}\t)\u0003\u0003\u0005\u0002\u0004\u0005}\u0001\u0019AA\u0003\u0011\u001d\tI\u0003\u0001C\u0005\u0003W\t1dY8ogVlW-\u00118e-\u0006d\u0017\u000eZ1uKRKWM\u001d$fi\u000eDGcB\u0010\u0002.\u0005=\u0012\u0011\u0007\u0005\t\u0003\u0007\t9\u00031\u0001\u0002\u0006!1\u00010a\nA\u0002YAaA_A\u0014\u0001\u00041\u0002bBA\u001b\u0001\u0011%\u0011qG\u0001&CN\u001cXM\u001d;US6,7\u000f^1na\u001a{'o\u00144gg\u0016$Hj\\8lkB\u001cuN\u001d:fGR$\u0012bHA\u001d\u0003w\t\t&a\u0017\t\r}\f\u0019\u00041\u0001C\u0011!\ti$a\rA\u0002\u0005}\u0012\u0001C2p]N,X.\u001a:\u0011\u0011\u0005\u0005\u0013\u0011JA'\u0003\u001bj!!a\u0011\u000b\t\u0005u\u0012Q\t\u0006\u0004\u0003\u000f2\u0015aB2mS\u0016tGo]\u0005\u0005\u0003\u0017\n\u0019EA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0005\u0003\u000f\ty%C\u0002-\u0003#A\u0001\"a\u0015\u00024\u0001\u0007\u0011QK\u0001\ni&lWm\u001d;b[B\u00042aFA,\u0013\r\tI\u0006\u0007\u0002\u0005\u0019>tw\r\u0003\u0005\u0002^\u0005M\u0002\u0019AA+\u00039)\u0007\u0010]3di\u0016$wJ\u001a4tKRDq!!\u0019\u0001\t\u0013\t\u0019'A\u0013bgN,'\u000f\u001e+j[\u0016\u001cH/Y7q\r>\u0014xJ\u001a4tKRdun\\6va6K7o]5oOR9q$!\u001a\u0002h\u0005%\u0004BB@\u0002`\u0001\u0007!\t\u0003\u0005\u0002>\u0005}\u0003\u0019AA \u0011!\t\u0019&a\u0018A\u0002\u0005U\u0003")
public class TierIntegrationFetchTest
extends IntegrationTestHarness {
    private final String kafka$tier$TierIntegrationFetchTest$$topic;
    private final int partitions;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    public String kafka$tier$TierIntegrationFetchTest$$topic() {
        return this.kafka$tier$TierIntegrationFetchTest$$topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private Seq<TopicPartition> topicPartitions() {
        return (Seq)package$.MODULE$.Range().apply(0, this.partitions()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationFetchTest $outer;

            public final TopicPartition apply(int p) {
                return new TopicPartition(this.$outer.kafka$tier$TierIntegrationFetchTest$$topic(), p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @Before
    public void setUp() {
        Exit.setExitProcedure((Exit.Procedure)new Exit.Procedure(this){
            private final /* synthetic */ TierIntegrationFetchTest $outer;

            public void execute(int statusCode, String message) {
                this.$outer.exited().set(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        super.setUp();
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        Assert.assertFalse((boolean)this.exited().get());
    }

    @Test
    public void testArchiveAndTierFetch() {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        Map<Object, Object> partitionToLeaderMap = this.createTopic(this.kafka$tier$TierIntegrationFetchTest$$topic(), this.partitions(), 1, props);
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
    }

    @Test
    public void testArchiveAndPreferredTierFetch() {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("confluent.tier.local.hotset.bytes", "-1");
        props.put("confluent.prefer.tier.fetch.ms", "0");
        Map<Object, Object> partitionToLeaderMap = this.createTopic(this.kafka$tier$TierIntegrationFetchTest$$topic(), this.partitions(), 1, props);
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
    }

    /*
     * WARNING - void declaration
     */
    private void produceRecords(int nBatches, int recordsPerBatch) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nBatches).foreach((Function1)new Serializable(this, recordsPerBatch, producer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TierIntegrationFetchTest $outer;
                public final int recordsPerBatch$1;
                public final KafkaProducer producer$1;

                public final IndexedSeq<RecordMetadata> apply(int b) {
                    long timestamp = System.currentTimeMillis();
                    IndexedSeq producerRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.recordsPerBatch$1).map((Function1)new Serializable(this, timestamp, b){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$produceRecords$1 $outer;
                        private final long timestamp$1;
                        private final int b$1;

                        public final ProducerRecord<byte[], byte[]> apply(int i) {
                            int m = this.$outer.recordsPerBatch$1 * this.b$1 + i;
                            return new ProducerRecord(this.$outer.kafka$tier$TierIntegrationFetchTest$$anonfun$$$outer().kafka$tier$TierIntegrationFetchTest$$topic(), null, Predef$.MODULE$.long2Long(this.timestamp$1), (Object)"foo".getBytes(StandardCharsets.UTF_8), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m)})).getBytes(StandardCharsets.UTF_8));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.timestamp$1 = timestamp$1;
                            this.b$1 = b$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return (IndexedSeq)((TraversableLike)producerRecords.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$produceRecords$1 $outer;

                        public final Future<RecordMetadata> apply(ProducerRecord<byte[], byte[]> x$1) {
                            return this.$outer.producer$1.send(x$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final RecordMetadata apply(Future<RecordMetadata> x$1) {
                            return x$1.get(10L, TimeUnit.SECONDS);
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                }

                public /* synthetic */ TierIntegrationFetchTest kafka$tier$TierIntegrationFetchTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.recordsPerBatch$1 = recordsPerBatch$1;
                    this.producer$1 = producer$1;
                }
            });
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        producer.close();
    }

    public int kafka$tier$TierIntegrationFetchTest$$getLeaderForTopicPartition(TopicPartition topicPartition, Map<Object, Object> partitionToLeaderMap) {
        return BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private void waitUntilSegmentsTiered(int minNumSegments, Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1)new Serializable(this, minNumSegments, partitionToLeaderMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationFetchTest $outer;
            public final int minNumSegments$1;
            private final Map partitionToLeaderMap$1;

            public final void apply(TopicPartition tp) {
                int leaderId = this.$outer.kafka$tier$TierIntegrationFetchTest$$getLeaderForTopicPartition(tp, (Map<Object, Object>)this.partitionToLeaderMap$1);
                Option<KafkaServer> server = this.$outer.serverForId(leaderId);
                LogManager qual$1 = ((KafkaServer)server.get()).logManager();
                TopicPartition x$3 = tp;
                boolean x$4 = qual$1.getLog$default$2();
                TierPartitionState tierPartitionState2 = ((AbstractLog)qual$1.getLog(x$3, x$4).get()).tierPartitionState();
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierPartitionState2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitUntilSegmentsTiered$1 $outer;
                    private final TierPartitionState tierPartitionState$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.tierPartitionState$1.numSegments() > this.$outer.minNumSegments$1 && this.tierPartitionState$1.endOffset() == this.tierPartitionState$1.committedEndOffset();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tierPartitionState$1 = tierPartitionState$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitUntilSegmentsTiered$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timeout waiting for at least ", " to be archived and materialized"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.minNumSegments$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, 60000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.minNumSegments$1 = minNumSegments$1;
                this.partitionToLeaderMap$1 = partitionToLeaderMap$1;
            }
        });
    }

    private void simulateRetention(Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1)new Serializable(this, partitionToLeaderMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationFetchTest $outer;
            private final Map partitionToLeaderMap$2;

            public final void apply(TopicPartition tp) {
                boolean x$6;
                TopicPartition x$5;
                int leaderId = this.$outer.kafka$tier$TierIntegrationFetchTest$$getLeaderForTopicPartition(tp, (Map<Object, Object>)this.partitionToLeaderMap$2);
                Option<KafkaServer> server = this.$outer.serverForId(leaderId);
                LogManager qual$2 = ((KafkaServer)server.get()).replicaManager().logManager();
                int numDeleted = ((AbstractLog)qual$2.getLog(x$5 = tp, x$6 = qual$2.getLog$default$2()).get()).deleteOldSegments();
                Assert.assertTrue((String)"tiered segments should have been deleted", (numDeleted > 0 ? 1 : 0) != 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionToLeaderMap$2 = partitionToLeaderMap$2;
            }
        });
    }

    private void consumeAndValidateTierFetch(Map<Object, Object> partitionToLeaderMap, int nBatches, int recordsPerBatch) {
        TopicPartition topicPartition = (TopicPartition)this.topicPartitions().head();
        KafkaConsumer consumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.List<TopicPartition> partitions = Collections.singletonList(topicPartition);
        consumer.assign(partitions);
        consumer.seekToBeginning(partitions);
        ArrayList valuesRead = new ArrayList();
        ArrayList timestampsOffsets = new ArrayList();
        while (valuesRead.size() != nBatches * recordsPerBatch) {
            ConsumerRecords records2 = consumer.poll(Duration.ofMillis(1000L));
            records2.forEach((Consumer)new Consumer<ConsumerRecord<String, String>>(this, valuesRead, timestampsOffsets){
                private final ArrayList valuesRead$1;
                private final ArrayList timestampsOffsets$1;

                public void accept(ConsumerRecord<String, String> r) {
                    this.valuesRead$1.add(BoxesRunTime.boxToInteger((int)Integer.parseInt((String)r.value())));
                    this.timestampsOffsets$1.add(new Tuple2.mcJJ.sp(r.timestamp(), r.offset()));
                }
                {
                    this.valuesRead$1 = valuesRead$1;
                    this.timestampsOffsets$1 = timestampsOffsets$1;
                }
            });
        }
        ArrayList expectedValues = new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Range().apply(0, nBatches * recordsPerBatch)).asJava());
        Assert.assertEquals(expectedValues, valuesRead);
        ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(timestampsOffsets).asScala()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, topicPartition, consumer, timestampsOffsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationFetchTest $outer;
            private final TopicPartition topicPartition$1;
            private final KafkaConsumer consumer$1;
            private final ArrayList timestampsOffsets$1;

            public final void apply(Tuple2<Object, Object> x$2) {
                Tuple2<Object, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    long timestamp = tuple2._1$mcJ$sp();
                    long expectedOffset = ((Tuple2)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)this.timestampsOffsets$1).asScala()).find((Function1)new Serializable(this, timestamp){
                        public static final long serialVersionUID = 0L;
                        private final long timestamp$2;

                        public final boolean apply(Tuple2<Object, Object> x0$1) {
                            Tuple2<Object, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                long recordTimestamp = tuple2._1$mcJ$sp();
                                boolean bl = recordTimestamp >= this.timestamp$2;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.timestamp$2 = timestamp$2;
                        }
                    }).get())._2$mcJ$sp();
                    this.$outer.kafka$tier$TierIntegrationFetchTest$$assertTimestampForOffsetLookupCorrect(this.topicPartition$1, (KafkaConsumer<String, String>)this.consumer$1, timestamp, expectedOffset);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.consumer$1 = consumer$1;
                this.timestampsOffsets$1 = timestampsOffsets$1;
            }
        });
        this.kafka$tier$TierIntegrationFetchTest$$assertTimestampForOffsetLookupCorrect(topicPartition, consumer, 0L, 0L);
        this.assertTimestampForOffsetLookupMissing(topicPartition, consumer, Long.MAX_VALUE);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        List list = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks.archive:type=TierArchiver,name=BytesPerSec"), (String[])((Object[])new String[]{"MeanRate"})).asList()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Attribute attr) {
                return BoxesRunTime.unboxToDouble((Object)attr.getValue());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
            double meanArchiveRate;
            double d;
            double meanArchiveRate2 = d = (meanArchiveRate = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(0)));
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tier archiver mean rate shows no data uploaded to tiered storage: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)meanArchiveRate2)})), (meanArchiveRate2 > (double)100 ? 1 : 0) != 0);
            int partitionsInErrorCount = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInError"), (String[])((Object[])new String[]{"Value"})).asList()).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Attribute attr) {
                    return BoxesRunTime.unboxToInt((Object)attr.getValue());
                }
            }, Buffer$.MODULE$.canBuildFrom())).head());
            Assert.assertEquals((String)"tier archiver shows no partitions in error state", (long)0L, (long)partitionsInErrorCount);
            return;
        }
        throw new MatchError((Object)list);
    }

    public void kafka$tier$TierIntegrationFetchTest$$assertTimestampForOffsetLookupCorrect(TopicPartition topicPartition, KafkaConsumer<String, String> consumer, long timestamp, long expectedOffset) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assert.assertEquals((String)"timestamp should match offset read", (long)((OffsetAndTimestamp)consumer.offsetsForTimes(timestampsToSearch).get(topicPartition)).offset(), (long)expectedOffset);
    }

    private void assertTimestampForOffsetLookupMissing(TopicPartition topicPartition, KafkaConsumer<String, String> consumer, long timestamp) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assert.assertEquals((String)"offset should not be returned", null, consumer.offsetsForTimes(timestampsToSearch).get(topicPartition));
    }

    public TierIntegrationFetchTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), ((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)).toString());
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.configureMock();
        this.kafka$tier$TierIntegrationFetchTest$$topic = "test_topic";
        this.partitions = 1;
        this.exited = new AtomicBoolean(false);
    }
}

