/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierIntegrationTest$;
import kafka.tier.TierIntegrationTest$$anonfun$kafka$tier$TierIntegrationTest$;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tasks.TierTasks;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ZooKeeperTestHarness$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r\rd\u0001B\u0001\u0003\u0001\u001d\u00111\u0003V5fe&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\tQLWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0003\u0016\u0003!iwnY6US6,W#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u0005!iunY6US6,\u0007BB\u000f\u0001A\u0003%a#A\u0005n_\u000e\\G+[7fA!9q\u0004\u0001b\u0001\n\u0003\u0001\u0013a\u00027pO\u0012K'o]\u000b\u0002CA\u0019!eJ\u0015\u000e\u0003\rR!\u0001J\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u0005!!.\u0019<b\u0013\tA3EA\u0005BeJ\f\u0017\u0010T5tiB\u0011!&L\u0007\u0002W)\u0011A&J\u0001\u0005Y\u0006tw-\u0003\u0002/W\t11\u000b\u001e:j]\u001eDa\u0001\r\u0001!\u0002\u0013\t\u0013\u0001\u00037pO\u0012K'o\u001d\u0011\t\u000fI\u0002!\u0019!C\u0001g\u00051B/[3s)>\u0004\u0018nY'b]\u0006<WM]\"p]\u001aLw-F\u00015!\t)\u0004(D\u00017\u0015\t9$!A\u0003u_BL7-\u0003\u0002:m\t1B+[3s)>\u0004\u0018nY'b]\u0006<WM]\"p]\u001aLw\r\u0003\u0004<\u0001\u0001\u0006I\u0001N\u0001\u0018i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cuN\u001c4jO\u0002B\u0011\"\u0010\u0001A\u0002\u0003\u0007I\u0011\u0001 \u0002#QLWM\u001d+pa&\u001c7i\u001c8tk6,'/F\u0001@!\t)\u0004)\u0003\u0002Bm\t\tB+[3s)>\u0004\u0018nY\"p]N,X.\u001a:\t\u0013\r\u0003\u0001\u0019!a\u0001\n\u0003!\u0015!\u0006;jKJ$v\u000e]5d\u0007>t7/^7fe~#S-\u001d\u000b\u0003\u000b\"\u0003\"!\u0003$\n\u0005\u001dS!\u0001B+oSRDq!\u0013\"\u0002\u0002\u0003\u0007q(A\u0002yIEBaa\u0013\u0001!B\u0013y\u0014A\u0005;jKJ$v\u000e]5d\u0007>t7/^7fe\u0002B\u0011\"\u0014\u0001A\u0002\u0003\u0007I\u0011\u0001(\u0002#QLWM\u001d'pO\u000e{W\u000e]8oK:$8/F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011F!A\u0002m_\u001eL!\u0001V)\u0003#QKWM\u001d'pO\u000e{W\u000e]8oK:$8\u000fC\u0005W\u0001\u0001\u0007\t\u0019!C\u0001/\u0006)B/[3s\u0019><7i\\7q_:,g\u000e^:`I\u0015\fHCA#Y\u0011\u001dIU+!AA\u0002=CaA\u0017\u0001!B\u0013y\u0015A\u0005;jKJdunZ\"p[B|g.\u001a8ug\u0002B\u0011\u0002\u0018\u0001A\u0002\u0003\u0007I\u0011A/\u0002\u000fQ,W\u000e\u001d#jeV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002bK\u0005\u0011\u0011n\\\u0005\u0003G\u0002\u0014AAR5mK\"IQ\r\u0001a\u0001\u0002\u0004%\tAZ\u0001\fi\u0016l\u0007\u000fR5s?\u0012*\u0017\u000f\u0006\u0002FO\"9\u0011\nZA\u0001\u0002\u0004q\u0006BB5\u0001A\u0003&a,\u0001\u0005uK6\u0004H)\u001b:!\u0011%Y\u0007\u00011AA\u0002\u0013\u0005A.A\u0005uS\u0016\u0014H+Y:lgV\tQ\u000e\u0005\u0002oc6\tqN\u0003\u0002q\u0005\u0005)A/Y:lg&\u0011!o\u001c\u0002\n)&,'\u000fV1tWND\u0011\u0002\u001e\u0001A\u0002\u0003\u0007I\u0011A;\u0002\u001bQLWM\u001d+bg.\u001cx\fJ3r)\t)e\u000fC\u0004Jg\u0006\u0005\t\u0019A7\t\ra\u0004\u0001\u0015)\u0003n\u0003)!\u0018.\u001a:UCN\\7\u000f\t\u0005\nu\u0002\u0001\r\u00111A\u0005\u0002m\faB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001}!\ri\u0018\u0011A\u0007\u0002}*\u0011q\u0010B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0007\u0005\raP\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u0017\u0005\u001d\u0001\u00011AA\u0002\u0013\u0005\u0011\u0011B\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000fF\u0002F\u0003\u0017A\u0001\"SA\u0003\u0003\u0003\u0005\r\u0001 \u0005\b\u0003\u001f\u0001\u0001\u0015)\u0003}\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003bCA\n\u0001\u0001\u0007\t\u0019!C\u0001\u0003+\tq\u0002^5fe>\u0013'.Z2u'R|'/Z\u000b\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;\u0011\u0011!B:u_J,\u0017\u0002BA\u0011\u00037\u00111$T8dW&sW*Z7pef$\u0016.\u001a:PE*,7\r^*u_J,\u0007bCA\u0013\u0001\u0001\u0007\t\u0019!C\u0001\u0003O\t1\u0003^5fe>\u0013'.Z2u'R|'/Z0%KF$2!RA\u0015\u0011%I\u00151EA\u0001\u0002\u0004\t9\u0002\u0003\u0005\u0002.\u0001\u0001\u000b\u0015BA\f\u0003A!\u0018.\u001a:PE*,7\r^*u_J,\u0007\u0005C\u0005\u00022\u0001\u0001\r\u0011\"\u0001\u00024\u0005\u0001C/[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s+\t\t)\u0004E\u0002\u0013\u0003oI1!!\u000f\u0003\u0005\u0001\"\u0016.\u001a:EK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001cun\u001c:eS:\fGo\u001c:\t\u0013\u0005u\u0002\u00011A\u0005\u0002\u0005}\u0012\u0001\n;jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J|F%Z9\u0015\u0007\u0015\u000b\t\u0005C\u0005J\u0003w\t\t\u00111\u0001\u00026!A\u0011Q\t\u0001!B\u0013\t)$A\u0011uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014\b\u0005C\u0006\u0002J\u0001\u0001\r\u00111A\u0005\u0002\u0005-\u0013\u0001\u00027pON,\"!!\u0014\u0011\r\u0005=\u0013qLA3\u001d\u0011\t\t&a\u0017\u000f\t\u0005M\u0013\u0011L\u0007\u0003\u0003+R1!a\u0016\u0007\u0003\u0019a$o\\8u}%\t1\"C\u0002\u0002^)\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002b\u0005\r$aA*fc*\u0019\u0011Q\f\u0006\u0011\u0007A\u000b9'C\u0002\u0002jE\u0013\u0011\"T3sO\u0016$Gj\\4\t\u0017\u00055\u0004\u00011AA\u0002\u0013\u0005\u0011qN\u0001\tY><7o\u0018\u0013fcR\u0019Q)!\u001d\t\u0013%\u000bY'!AA\u0002\u00055\u0003\u0002CA;\u0001\u0001\u0006K!!\u0014\u0002\u000b1|wm\u001d\u0011\t\u0017\u0005e\u0004\u00011AA\u0002\u0013\u0005\u00111P\u0001\u0011i&,'\u000fV8qS\u000el\u0015M\\1hKJ,\"!! \u0011\u0007U\ny(C\u0002\u0002\u0002Z\u0012\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\t\u0017\u0005\u0015\u0005\u00011AA\u0002\u0013\u0005\u0011qQ\u0001\u0015i&,'\u000fV8qS\u000el\u0015M\\1hKJ|F%Z9\u0015\u0007\u0015\u000bI\tC\u0005J\u0003\u0007\u000b\t\u00111\u0001\u0002~!A\u0011Q\u0012\u0001!B\u0013\ti(A\tuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u0002B1\"!%\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0014\u0006\u00012m\u001c8tk6,'oU;qa2LWM]\u000b\u0003\u0003+\u0003\u0002\"a&\u0002\u001e\u0006\u0005\u0016\u0011U\u0007\u0003\u00033S1!a'\u0003\u0003\u0019\u0019G.[3oi&!\u0011qTAM\u0005QiunY6D_:\u001cX/\\3s'V\u0004\b\u000f\\5feB)\u0011\"a)\u0002(&\u0019\u0011Q\u0015\u0006\u0003\u000b\u0005\u0013(/Y=\u0011\u0007%\tI+C\u0002\u0002,*\u0011AAQ=uK\"Y\u0011q\u0016\u0001A\u0002\u0003\u0007I\u0011AAY\u0003Q\u0019wN\\:v[\u0016\u00148+\u001e9qY&,'o\u0018\u0013fcR\u0019Q)a-\t\u0013%\u000bi+!AA\u0002\u0005U\u0005\u0002CA\\\u0001\u0001\u0006K!!&\u0002#\r|gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0005C\u0005\u0002<\u0002\u0011\r\u0011\"\u0001\u0002>\u0006iQ.\u0019=XC&$H+[7f\u001bN,\"!a0\u0011\u0007%\t\t-C\u0002\u0002D*\u00111!\u00138u\u0011!\t9\r\u0001Q\u0001\n\u0005}\u0016AD7bq^\u000b\u0017\u000e\u001e+j[\u0016l5\u000f\t\u0005\n\u0003\u0017\u0004!\u0019!C\u0001\u0003\u001b\f!\u0003^5feJ+\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011q\u001a\t\u0004%\u0005E\u0017bAAj\u0005\t\u0011B+[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!\t9\u000e\u0001Q\u0001\n\u0005=\u0017a\u0005;jKJ\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003\"CAn\u0001\t\u0007I\u0011AAo\u0003-i')Z1o'\u0016\u0014h/\u001a:\u0016\u0005\u0005}\u0007\u0003BAq\u0003Wl!!a9\u000b\t\u0005\u0015\u0018q]\u0001\u000b[\u0006t\u0017mZ3nK:$(BAAu\u0003\u0015Q\u0017M^1y\u0013\u0011\ti/a9\u0003\u00175\u0013U-\u00198TKJ4XM\u001d\u0005\t\u0003c\u0004\u0001\u0015!\u0003\u0002`\u0006aQNQ3b]N+'O^3sA!9\u0011Q\u001f\u0001\u0005\u0002\u0005]\u0018!B:fiV\u0004H#B#\u0002z\n\r\u0001BCA~\u0003g\u0004\n\u00111\u0001\u0002~\u00069a.^7M_\u001e\u001c\bc\u0001\u0016\u0002\u0000&\u0019!\u0011A\u0016\u0003\u000f%sG/Z4fe\"Q!QAAz!\u0003\u0005\r!!@\u0002%9,X.\u0011:dQ&4XM\u001d+ie\u0016\fGm\u001d\u0005\b\u0005\u0013\u0001A\u0011\u0001B\u0006\u0003\u0019\u0011WMZ8sKR\tQ\t\u000b\u0003\u0003\b\t=\u0001\u0003\u0002B\t\u00057i!Aa\u0005\u000b\t\tU!qC\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u00053\t1a\u001c:h\u0013\u0011\u0011iBa\u0005\u0003\r\t+gm\u001c:f\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005\u0017\t\u0001\u0002^3be\u0012|wO\u001c\u0015\u0005\u0005?\u0011)\u0003\u0005\u0003\u0003\u0012\t\u001d\u0012\u0002\u0002B\u0015\u0005'\u0011Q!\u00114uKJDqA!\f\u0001\t\u0003\u0011Y!A\u000buKN$\u0018I]2iSZ,'/S7nS\u001e\u0014\u0018\r^3)\t\t-\"\u0011\u0007\t\u0005\u0005#\u0011\u0019$\u0003\u0003\u00036\tM!\u0001\u0002+fgRDqA!\u000f\u0001\t\u0003\u0011Y!\u0001\u0011uKN$\u0018I]2iSZ,'/\u00169m_\u0006$\u0017I\u001c3NCR,'/[1mSj,\u0007\u0006\u0002B\u001c\u0005cAqAa\u0010\u0001\t\u0003\u0011Y!A!uKN$\u0018I]2iSZ,'/\u00169m_\u0006$\u0017I\u001c3NCR,'/[1mSj,w\u000b[3o/JLG/\u001a%baB,gn]!gi\u0016\u0014()Z2p[\u0016dU-\u00193fe\"\"!Q\bB\u0019\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u0017\ta\u0006^3ti\u0006\u00138\r[5wKJ,\u0006\u000f\\8bI^KG\u000f\u001b'j[&$X\rZ+qY>\fGmQ8oGV\u0014(/\u001a8ds\"\"!1\tB\u0019\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u0017\tA\u0003^3ti\u0006\u00138\r[5wKJ$v\u000e^1m\u0019\u0006<\u0007\u0006\u0002B%\u0005cAqA!\u0015\u0001\t\u0013\u0011\u0019&\u0001\nxC&$hi\u001c:J[6LwM]1uS>tG#D#\u0003V\t]#1\fB/\u0005?\u0012\t\u0007\u0003\u0005\u0002J\t=\u0003\u0019AA'\u0011!\u0011IFa\u0014A\u0002\u0005}\u0016a\u00037fC\u0012,'/\u00129pG\"Daa\u001bB(\u0001\u0004i\u0007\u0002CA=\u0005\u001f\u0002\r!! \t\u0011\u0005E%q\na\u0001\u0003+C!Ba\u0019\u0003PA\u0005\t\u0019\u0001B3\u00031\u0011WmY8nK2+\u0017\rZ3s!\rI!qM\u0005\u0004\u0005SR!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005[\u0002A\u0011\u0002B8\u0003y\t'o\u00195jm\u0016\fe\u000eZ'bi\u0016\u0014\u0018.\u00197ju\u0016,f\u000e^5m)J,X\rF\u0005F\u0005c\u0012YHa#\u0003\u000e\"A!1\u000fB6\u0001\u0004\u0011)(\u0001\u0003qe\u0016$\u0007#B\u0005\u0003x\t\u0015\u0014b\u0001B=\u0015\tIa)\u001e8di&|g\u000e\r\u0005\t\u0005{\u0012Y\u00071\u0001\u0003\u0000\u0005\u0019Qn]4\u0011\t\t\u0005%q\u0011\b\u0004\u0013\t\r\u0015b\u0001BC\u0015\u00051\u0001K]3eK\u001aL1A\fBE\u0015\r\u0011)I\u0003\u0005\t\u0003s\u0012Y\u00071\u0001\u0002~!A\u0011\u0011\u0013B6\u0001\u0004\t)\nC\u0004\u0003\u0012\u0002!IAa%\u0002YY\fG.\u001b3bi\u0016\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cuN\u001c;bS:,G-\u00138PE*,7\r^*u_J,GcB#\u0003\u0016\n]%\u0011\u0014\u0005\t\u0003s\u0012y\t1\u0001\u0002~!A\u00111\u0003BH\u0001\u0004\t9\u0002\u0003\u0005\u0002J\t=\u0005\u0019\u0001BN!\u0019\tyE!(\u0003\"&!!qTA2\u0005!IE/\u001a:bE2,\u0007c\u0001)\u0003$&\u0019!QU)\u0003\u0017\u0005\u00137\u000f\u001e:bGRdun\u001a\u0005\b\u0005S\u0003A\u0011\u0002B\u0006\u0003M\u0019X\r^;q)&,'oQ8na>tWM\u001c;t\u0011\u001d\u0011i\u000b\u0001C\u0005\u0005_\u000b!b\u0019:fCR,Gj\\4t))\u0011\tLa.\u0003<\n\u0015'q\u0019\t\u0007\u0003\u001f\u0012\u0019,!\u001a\n\t\tU\u00161\r\u0002\u000b\u0013:$W\r_3e'\u0016\f\b\u0002\u0003B]\u0005W\u0003\r!a0\u0002\u00039D\u0001B!0\u0003,\u0002\u0007!qX\u0001\nY><7i\u001c8gS\u001e\u00042\u0001\u0015Ba\u0013\r\u0011\u0019-\u0015\u0002\n\u0019><7i\u001c8gS\u001eDa\u0001\u0018BV\u0001\u0004q\u0006BB'\u0003,\u0002\u0007q\nC\u0004\u0003L\u0002!IA!4\u0002%5|7m\u001b*fa2L7-Y'b]\u0006<WM\u001d\u000b\u0004y\n=\u0007\u0002CA%\u0005\u0013\u0004\rAa'\t\u000f\tM\u0007\u0001\"\u0003\u0003V\u0006\u0011rO]5uKJ+7m\u001c:e\u0005\u0006$8\r[3t)-)%q\u001bBm\u00057\u0014)O!;\t\u000fI\u0013\t\u000e1\u0001\u0003\"\"A!\u0011\fBi\u0001\u0004\ty\f\u0003\u0005\u0003^\nE\u0007\u0019\u0001Bp\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\t\u0004\u0013\t\u0005\u0018b\u0001Br\u0015\t!Aj\u001c8h\u0011!\u00119O!5A\u0002\u0005}\u0016a\u00022bi\u000eDWm\u001d\u0005\t\u0005W\u0014\t\u000e1\u0001\u0002@\u0006y!/Z2pe\u0012\u001c\b+\u001a:CCR\u001c\u0007\u000eC\u0004\u0003p\u0002!IA!=\u0002\u001b\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3t))\u0011\u0019p!\u0003\u0004\u0016\r]1\u0011\u0004\t\u0005\u0005k\u001c)!\u0004\u0002\u0003x*!!\u0011 B~\u0003\u0019\u0011XmY8sI*!!Q B\u0000\u0003\u0019\u0019w.\\7p]*\u0019Qa!\u0001\u000b\t\r\r!qC\u0001\u0007CB\f7\r[3\n\t\r\u001d!q\u001f\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0011\r-!Q\u001ea\u0001\u0007\u001b\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0004\u0010\rEQB\u0001B~\u0013\u0011\u0019\u0019Ba?\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"A!\u0011\fBw\u0001\u0004\ty\f\u0003\u0005\u0003^\n5\b\u0019\u0001Bp\u0011!\u0019YB!<A\u0002\u0005}\u0016A\u00038v[J+7m\u001c:eg\"91q\u0004\u0001\u0005\n\r\u0005\u0012aC7fiJL7MV1mk\u0016$BAa8\u0004$!A1QEB\u000f\u0001\u0004\u0011y(\u0001\u0003oC6,\u0007bBB\u0015\u0001\u0011%11F\u0001\u0013i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0004.\re\u0002\u0003BB\u0018\u0007ki!a!\r\u000b\u0007\rM\"!A\u0003ti\u0006$X-\u0003\u0003\u00048\rE\"A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016D\u0001ba\u000f\u0004(\u0001\u00071QB\u0001\na\u0006\u0014H/\u001b;j_:D\u0011ba\u0010\u0001#\u0003%\ta!\u0011\u0002\u001fM,G/\u001e9%I\u00164\u0017-\u001e7uIE*\"aa\u0011+\t\u0005u8QI\u0016\u0003\u0007\u000f\u0002Ba!\u0013\u0004T5\u001111\n\u0006\u0005\u0007\u001b\u001ay%A\u0005v]\u000eDWmY6fI*\u00191\u0011\u000b\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004V\r-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I1\u0011\f\u0001\u0012\u0002\u0013\u00051\u0011I\u0001\u0010g\u0016$X\u000f\u001d\u0013eK\u001a\fW\u000f\u001c;%e!I1Q\f\u0001\u0012\u0002\u0013%1qL\u0001\u001do\u0006LGOR8s\u00136l\u0017n\u001a:bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019\tG\u000b\u0003\u0003f\r\u0015\u0003")
public class TierIntegrationTest {
    private final MockTime kafka$tier$TierIntegrationTest$$mockTime = new MockTime();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(TestUtils$.MODULE$.tempDir().getAbsolutePath()));
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig((Supplier)new Supplier<Map<String, Object>>(this){

        public Map<String, Object> get() {
            return Collections.singletonMap("bootstrap.servers", "bootstrap");
        }
    }, null, 1, 1, 33, "cluster99", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private TierTopicConsumer tierTopicConsumer;
    private TierLogComponents tierLogComponents;
    private File tempDir;
    private TierTasks tierTasks;
    private ReplicaManager replicaManager;
    private MockInMemoryTierObjectStore tierObjectStore;
    private TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator = (TierDeletedPartitionsCoordinator)Mockito.mock(TierDeletedPartitionsCoordinator.class);
    private Seq<MergedLog> logs;
    private TierTopicManager tierTopicManager;
    private MockConsumerSupplier<byte[], byte[]> consumerSupplier;
    private final int maxWaitTimeMs;
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    public MockTime kafka$tier$TierIntegrationTest$$mockTime() {
        return this.kafka$tier$TierIntegrationTest$$mockTime;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public void tierTopicConsumer_$eq(TierTopicConsumer x$1) {
        this.tierTopicConsumer = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public void tierLogComponents_$eq(TierLogComponents x$1) {
        this.tierLogComponents = x$1;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public TierTasks tierTasks() {
        return this.tierTasks;
    }

    public void tierTasks_$eq(TierTasks x$1) {
        this.tierTasks = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(MockInMemoryTierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator() {
        return this.tierDeletedPartitionsCoordinator;
    }

    public void tierDeletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.tierDeletedPartitionsCoordinator = x$1;
    }

    public Seq<MergedLog> logs() {
        return this.logs;
    }

    public void logs_$eq(Seq<MergedLog> x$1) {
        this.logs = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    public void consumerSupplier_$eq(MockConsumerSupplier<byte[], byte[]> x$1) {
        this.consumerSupplier = x$1;
    }

    public int maxWaitTimeMs() {
        return this.maxWaitTimeMs;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public MBeanServer mBeanServer() {
        return this.mBeanServer;
    }

    public void setup(Integer numLogs, Integer numArchiverThreads) {
        this.tierObjectStore_$eq(new MockInMemoryTierObjectStore(new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1))));
        this.setupTierComponents();
        int x$16 = 150;
        int x$17 = 1;
        int x$18 = 65536;
        boolean x$19 = true;
        long x$20 = LogTest$.MODULE$.createLogConfig$default$1();
        long x$21 = LogTest$.MODULE$.createLogConfig$default$3();
        long x$22 = LogTest$.MODULE$.createLogConfig$default$4();
        long x$23 = LogTest$.MODULE$.createLogConfig$default$5();
        String x$24 = LogTest$.MODULE$.createLogConfig$default$6();
        int x$25 = LogTest$.MODULE$.createLogConfig$default$9();
        String x$26 = LogTest$.MODULE$.createLogConfig$default$10();
        long x$27 = LogTest$.MODULE$.createLogConfig$default$11();
        long x$28 = LogTest$.MODULE$.createLogConfig$default$13();
        long x$29 = LogTest$.MODULE$.createLogConfig$default$14();
        int x$30 = LogTest$.MODULE$.createLogConfig$default$15();
        long x$31 = LogTest$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTest$.MODULE$.createLogConfig(x$20, x$16, x$21, x$22, x$23, x$24, x$18, x$17, x$25, x$26, x$27, x$19, x$28, x$29, x$30, x$31);
        File tempDir = TestUtils$.MODULE$.tempDir();
        IndexedSeq<MergedLog> logs = this.createLogs(Predef$.MODULE$.Integer2int(numLogs), logConfig, tempDir, this.tierLogComponents());
        ReplicaManager replicaManager = this.mockReplicaManager((Iterable<AbstractLog>)logs);
        int x$32 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        int x$33 = 20;
        int x$34 = 20;
        long x$35 = TierTasksConfig$.MODULE$.apply$default$2();
        int x$36 = TierTasksConfig$.MODULE$.apply$default$3();
        TierTasks tierTasks = new TierTasks(new TierTasksConfig(x$32, x$35, x$36, x$33, x$34), replicaManager, this.tierReplicaManager(), this.tierDeletedPartitionsCoordinator(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.tierObjectStore(), (Time)this.kafka$tier$TierIntegrationTest$$mockTime());
        this.tierTasks_$eq(tierTasks);
        this.replicaManager_$eq(replicaManager);
        this.logs_$eq((Seq<MergedLog>)logs);
        this.tempDir_$eq(tempDir);
    }

    public Integer setup$default$1() {
        return Predef$.MODULE$.int2Integer(2);
    }

    public Integer setup$default$2() {
        return Predef$.MODULE$.int2Integer(10);
    }

    @Before
    public void before() {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@Before");
    }

    @After
    public void teardown() {
        this.tierTasks().shutdown();
        this.tierTopicManager().shutdown();
        this.tierTopicConsumer().shutdown();
        ReplicaManager qual$1 = this.replicaManager();
        boolean x$37 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$37);
        this.tierObjectStore().close();
        this.logs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MergedLog x$1) {
                x$1.close();
            }
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.logDirs()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String path) {
                Utils.delete((File)new File(path));
            }
        });
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@After");
    }

    @Test
    public void testArchiverImmigrate() {
        this.setup(this.setup$default$1(), this.setup$default$2());
        this.tierTasks().start();
        this.waitForImmigration(this.logs(), 1, this.tierTasks(), this.tierTopicManager(), this.consumerSupplier(), this.waitForImmigration$default$6());
        this.tierReplicaManager().becomeFollower(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.tierTasks().archiverTaskQueue().withAllTasks((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(scala.collection.immutable.Set<ArchiveTask> x$2) {
                        return x$2.size() == 1;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Archiver should process pending emigrations";
            }
        }, 2000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.tierReplicaManager().becomeLeader(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()), 2);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.$outer.consumerSupplier().moveRecordsFromProducer();
                this.$outer.tierTopicConsumer().doWork();
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.tierTasks().archiverTaskQueue().withAllTasks((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(scala.collection.immutable.Set<ArchiveTask> tasks) {
                        return tasks.forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(ArchiveTask task) {
                                return task.state() instanceof BeforeUpload || task.state() instanceof AfterUpload;
                            }
                        });
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Archiver should process pending immigrations";
            }
        }, 2000L, TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testArchiverUploadAndMaterialize() {
        this.setup(Predef$.MODULE$.int2Integer(10), this.setup$default$2());
        this.tierTasks().start();
        int numBatches = 6;
        int leaderEpoch = 1;
        this.logs().foreach((Function1)new Serializable(this, numBatches, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            private final int numBatches$1;
            private final int leaderEpoch$2;

            public final void apply(MergedLog log2) {
                this.$outer.kafka$tier$TierIntegrationTest$$writeRecordBatches((AbstractLog)log2, this.leaderEpoch$2, 0L, this.numBatches$1, 4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numBatches$1 = numBatches$1;
                this.leaderEpoch$2 = leaderEpoch$2;
            }
        });
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.tierTopicManager(), this.consumerSupplier(), this.waitForImmigration$default$6());
        this.logs().foreach((Function1)new Serializable(this, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch$2;

            public final void apply(MergedLog log2) {
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic manager should materialize entry for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log2.topicPartition()})), (long)log2.tierPartitionState().tierEpoch(), (long)this.leaderEpoch$2);
            }
            {
                this.leaderEpoch$2 = leaderEpoch$2;
            }
        });
        this.validatePartitionStateContainedInObjectStore(this.tierTopicManager(), this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.archiveAndMaterializeUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.logs().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MergedLog log2) {
                        TierPartitionState tierPartitionState2 = log2.tierPartitionState();
                        tierPartitionState2.flush();
                        return tierPartitionState2.numSegments() >= 1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Should materialize segments", this.tierTopicManager(), this.consumerSupplier());
        this.logs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MergedLog log2) {
                Assert.assertEquals((String)"batch 1: segment should be materialized with correct offset relationship", (long)0L, (long)((TierObjectMetadata)log2.tierPartitionState().metadata(0L).get()).baseOffset());
                Assert.assertTrue((String)"batch 1: segment should be materialized with correct end offset", (log2.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0);
            }
        });
        this.validatePartitionStateContainedInObjectStore(this.tierTopicManager(), this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.archiveAndMaterializeUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.logs().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MergedLog log2) {
                        TierPartitionState tierPartitionState2 = log2.tierPartitionState();
                        tierPartitionState2.flush();
                        return tierPartitionState2.numSegments() >= 2 && tierPartitionState2.committedEndOffset() == tierPartitionState2.endOffset();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Should materialize segments", this.tierTopicManager(), this.consumerSupplier());
        this.validatePartitionStateContainedInObjectStore(this.tierTopicManager(), this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MergedLog log2) {
                TierPartitionState tierPartitionState2 = log2.tierPartitionState();
                Assert.assertEquals((String)"batch 2: segment should be materialized with correct offset relationship", (long)4L, (long)((TierObjectMetadata)tierPartitionState2.metadata(6L).get()).baseOffset());
                Assert.assertTrue((String)"batch 2: segment should be materialized with correct end offset", (tierPartitionState2.committedEndOffset() >= 7L ? 1 : 0) != 0);
            }
        });
        this.validatePartitionStateContainedInObjectStore(this.tierTopicManager(), this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.archiveAndMaterializeUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.logs().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MergedLog log2) {
                        TierPartitionState tierPartitionState2 = log2.tierPartitionState();
                        tierPartitionState2.flush();
                        return tierPartitionState2.numSegments() >= 3 && tierPartitionState2.committedEndOffset() == tierPartitionState2.endOffset();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Should materialize segments", this.tierTopicManager(), this.consumerSupplier());
        this.logs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MergedLog log2) {
                Assert.assertEquals((String)"batch 3: segment should be materialized with correct offset relationship", (long)8L, (long)((TierObjectMetadata)log2.tierPartitionState().metadata(10L).get()).baseOffset());
                Assert.assertTrue((String)"batch 3: segment should be materialized with correct end offset", (log2.tierPartitionState().committedEndOffset() >= 11L ? 1 : 0) != 0);
            }
        });
        this.validatePartitionStateContainedInObjectStore(this.tierTopicManager(), this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    @Test
    public void testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader() {
        this.setup(Predef$.MODULE$.int2Integer(10), this.setup$default$2());
        this.tierTasks().start();
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.tierTopicManager(), this.consumerSupplier(), this.waitForImmigration$default$6());
        this.validatePartitionStateContainedInObjectStore(this.tierTopicManager(), this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1)new Serializable(this, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            private final int leaderEpoch$4;

            public final void apply(MergedLog log2) {
                this.$outer.kafka$tier$TierIntegrationTest$$writeRecordBatches((AbstractLog)log2, this.leaderEpoch$4, 0L, 6, 4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderEpoch$4 = leaderEpoch$4;
            }
        });
        this.archiveAndMaterializeUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.logs().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MergedLog log2) {
                        TierPartitionState tierPartitionState2 = log2.tierPartitionState();
                        tierPartitionState2.flush();
                        return tierPartitionState2.numSegments() > 0 && tierPartitionState2.committedEndOffset() == tierPartitionState2.endOffset();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, "Should materialize segments", this.tierTopicManager(), this.consumerSupplier());
        this.logs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MergedLog log2) {
                Assert.assertEquals((String)"Segment should be materialized with correct offset relationship", (long)0L, (long)((TierObjectMetadata)log2.tierPartitionState().metadata(0L).get()).baseOffset());
                Assert.assertTrue((String)"Segment should be materialized with correct end offset", (log2.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0);
            }
        });
        this.validatePartitionStateContainedInObjectStore(this.tierTopicManager(), this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    @Test
    public void testArchiverUploadWithLimitedUploadConcurrency() {
        int maxConcurrentUploads = 2;
        int nLogs = 3;
        this.setup(Predef$.MODULE$.int2Integer(nLogs), Predef$.MODULE$.int2Integer(maxConcurrentUploads));
        this.tierTasks().start();
        int batches = 3;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.tierTopicManager(), this.consumerSupplier(), this.waitForImmigration$default$6());
        this.logs().foreach((Function1)new Serializable(this, batches, recordsPerBatch, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            private final int batches$1;
            private final int recordsPerBatch$2;
            private final int leaderEpoch$5;

            public final void apply(MergedLog log2) {
                this.$outer.kafka$tier$TierIntegrationTest$$writeRecordBatches((AbstractLog)log2, this.leaderEpoch$5, 0L, this.batches$1, this.recordsPerBatch$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batches$1 = batches$1;
                this.recordsPerBatch$2 = recordsPerBatch$2;
                this.leaderEpoch$5 = leaderEpoch$5;
            }
        });
        this.archiveAndMaterializeUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.logs().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MergedLog x$3) {
                        return x$3.tierableLogSegments().isEmpty();
                    }
                }) && this.$outer.logs().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MergedLog x$4) {
                        return x$4.tieredLogSegments().toIterator().nonEmpty();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected all logs to eventually become tiered"})).s((Seq)Nil$.MODULE$), this.tierTopicManager(), this.consumerSupplier());
    }

    @Test
    public void testArchiverTotalLag() {
        int numLogs = 5;
        int batches = 6;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.setup(Predef$.MODULE$.int2Integer(numLogs), this.setup$default$2());
        this.tierTasks().start();
        Assert.assertEquals((long)0L, (long)this.totalLag$1());
        this.logs().foreach((Function1)new Serializable(this, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            private final int leaderEpoch$6;

            public final void apply(MergedLog log2) {
                TopicIdPartition topicIdPartition = new TopicIdPartition(log2.topicPartition().topic(), UUID.randomUUID(), log2.topicPartition().partition());
                log2.assignTopicId(topicIdPartition.topicId());
                this.$outer.tierReplicaManager().becomeLeader(log2.tierPartitionState(), this.leaderEpoch$6);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.leaderEpoch$6 = leaderEpoch$6;
            }
        });
        Assert.assertEquals((long)0L, (long)this.totalLag$1());
        this.logs().foreach((Function1)new Serializable(this, batches, recordsPerBatch, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            private final int batches$2;
            private final int recordsPerBatch$3;
            private final int leaderEpoch$6;

            public final void apply(MergedLog log2) {
                this.$outer.kafka$tier$TierIntegrationTest$$writeRecordBatches((AbstractLog)log2, this.leaderEpoch$6, 0L, this.batches$2, this.recordsPerBatch$3);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batches$2 = batches$2;
                this.recordsPerBatch$3 = recordsPerBatch$3;
                this.leaderEpoch$6 = leaderEpoch$6;
            }
        });
        this.kafka$tier$TierIntegrationTest$$mockTime().sleep(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1);
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.logs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(MergedLog x$7) {
                return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$7.tierableLogSegments().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(LogSegment x$8) {
                        return x$8.size();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.tierTopicManager(), this.consumerSupplier(), false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), batches).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;

            public final void apply(int archivedBatches) {
                this.apply$mcVI$sp(archivedBatches);
            }

            public void apply$mcVI$sp(int archivedBatches) {
                this.$outer.kafka$tier$TierIntegrationTest$$awaitMaterializeBatchAndAssertLag$1(archivedBatches);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void waitForImmigration(Seq<MergedLog> logs, int leaderEpoch, TierTasks tierTasks, TierTopicManager tierTopicManager, MockConsumerSupplier<byte[], byte[]> consumerSupplier, boolean becomeLeader) {
        if (becomeLeader) {
            logs.foreach((Function1)new Serializable(this, leaderEpoch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TierIntegrationTest $outer;
                private final int leaderEpoch$1;

                public final void apply(MergedLog log2) {
                    TopicIdPartition topicIdPartition = new TopicIdPartition(log2.topicPartition().topic(), UUID.randomUUID(), log2.topicPartition().partition());
                    log2.assignTopicId(topicIdPartition.topicId());
                    this.$outer.tierReplicaManager().becomeLeader(log2.tierPartitionState(), this.leaderEpoch$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.leaderEpoch$1 = leaderEpoch$1;
                }
            });
        }
        this.archiveAndMaterializeUntilTrue((Function0<Object>)new Serializable(this, logs){
            public static final long serialVersionUID = 0L;
            private final Seq logs$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.logs$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(MergedLog x$9) {
                        TierPartitionStatus tierPartitionStatus = x$9.tierPartitionState().status();
                        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
                        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
                    }
                });
            }
            {
                this.logs$2 = logs$2;
            }
        }, "Expect leadership to materialize", tierTopicManager, consumerSupplier);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, logs, tierTasks, consumerSupplier){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            public final Seq logs$2;
            private final TierTasks tierTasks$1;
            private final MockConsumerSupplier consumerSupplier$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumerSupplier$1.moveRecordsFromProducer();
                this.$outer.tierTopicConsumer().doWork();
                return BoxesRunTime.unboxToBoolean((Object)this.tierTasks$1.archiverTaskQueue().withAllTasks((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitForImmigration$2 $outer;

                    public final boolean apply(scala.collection.immutable.Set<ArchiveTask> tasks) {
                        return tasks.size() == this.$outer.logs$2.size() && !tasks.forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(ArchiveTask x$10) {
                                return x$10.state() instanceof BeforeLeader;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logs$2 = logs$2;
                this.tierTasks$1 = tierTasks$1;
                this.consumerSupplier$1 = consumerSupplier$1;
            }
        }, (Function0<String>)new Serializable(this, tierTasks){
            public static final long serialVersionUID = 0L;
            private final TierTasks tierTasks$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expect zero BeforeLeader in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tierTasks$1.archiverTaskQueue()}));
            }
            {
                this.tierTasks$1 = tierTasks$1;
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private boolean waitForImmigration$default$6() {
        return true;
    }

    private void archiveAndMaterializeUntilTrue(Function0<Object> pred, String msg, TierTopicManager tierTopicManager, MockConsumerSupplier<byte[], byte[]> consumerSupplier) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, pred, consumerSupplier){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            private final Function0 pred$1;
            private final MockConsumerSupplier consumerSupplier$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.consumerSupplier$2.moveRecordsFromProducer();
                this.$outer.tierTopicConsumer().doWork();
                return this.pred$1.apply$mcZ$sp();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pred$1 = pred$1;
                this.consumerSupplier$2 = consumerSupplier$2;
            }
        }, (Function0<String>)new Serializable(this, msg){
            public static final long serialVersionUID = 0L;
            private final String msg$1;

            public final String apply() {
                return this.msg$1;
            }
            {
                this.msg$1 = msg$1;
            }
        }, this.maxWaitTimeMs(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void validatePartitionStateContainedInObjectStore(TierTopicManager tierTopicManager, MockInMemoryTierObjectStore tierObjectStore, Iterable<AbstractLog> logs) {
        logs.foreach((Function1)new Serializable(this, tierObjectStore){
            public static final long serialVersionUID = 0L;
            public final MockInMemoryTierObjectStore tierObjectStore$1;

            public final void apply(AbstractLog log2) {
                TierPartitionState tierPartitionState2 = log2.tierPartitionState();
                NavigableSet tierSegmentOffsets = tierPartitionState2.segmentOffsets();
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter((Set)tierSegmentOffsets).asScala()).foreach((Function1)new Serializable(this, tierPartitionState2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$validatePartitionStateContainedInObjectStore$1 $outer;
                    private final TierPartitionState tierPartitionState$1;

                    public final void apply(Long offset) {
                        TierObjectMetadata tierObjectMetadata = (TierObjectMetadata)this.tierPartitionState$1.metadata(Predef$.MODULE$.Long2long(offset)).get();
                        Assert.assertNotNull((Object)this.$outer.tierObjectStore$1.getObject(new TierObjectStore.ObjectMetadata(tierObjectMetadata), TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1000)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tierPartitionState$1 = tierPartitionState$1;
                    }
                });
            }
            {
                this.tierObjectStore$1 = tierObjectStore$1;
            }
        });
    }

    private void setupTierComponents() {
        MockProducerSupplier producerSupplier = new MockProducerSupplier();
        this.consumerSupplier_$eq(new MockConsumerSupplier<byte[], byte[]>("primary", TierTopicManager.partitions((String)TierTopic.topicName((String)this.tierTopicManagerConfig().tierNamespace), (int)this.tierTopicManagerConfig().configuredNumPartitions), producerSupplier.producer()));
        Supplier<AdminZkClient> adminZkClientSupplier = new Supplier<AdminZkClient>(this){

            public AdminZkClient get() {
                return (AdminZkClient)Mockito.mock(AdminZkClient.class);
            }
        };
        this.tierTopicConsumer_$eq(new TierTopicConsumer(this.tierTopicManagerConfig(), this.consumerSupplier(), this.consumerSupplier(), new TierTopicManagerCommitter(this.tierTopicManagerConfig(), (LogDirFailureChannel)EasyMock.mock(LogDirFailureChannel.class))));
        this.tierTopicManager_$eq(new TierTopicManager(this.tierTopicManagerConfig(), this.tierTopicConsumer(), producerSupplier, (Supplier)adminZkClientSupplier));
        this.tierLogComponents_$eq(new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), new TierPartitionStateFactory(true)));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.$outer.tierTopicManager().tryBecomeReady(false);
                return this.$outer.tierTopicManager().isReady();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for TierTopicManager to be ready";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private IndexedSeq<MergedLog> createLogs(int n, LogConfig logConfig, File tempDir, TierLogComponents tierLogComponents) {
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(n);
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1)new Serializable(this, logConfig, tempDir, tierLogComponents, logDirFailureChannel){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            private final LogConfig logConfig$1;
            private final File tempDir$1;
            private final TierLogComponents tierLogComponents$1;
            private final LogDirFailureChannel logDirFailureChannel$1;

            public final MergedLog apply(int i) {
                File logDir = this.tempDir$1.toPath().resolve(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tierlogtest-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))).toFile();
                logDir.mkdir();
                return MergedLog$.MODULE$.apply(logDir, this.logConfig$1, 0L, 0L, (Scheduler)this.$outer.kafka$tier$TierIntegrationTest$$mockTime().scheduler(), new BrokerTopicStats(), (Time)this.$outer.kafka$tier$TierIntegrationTest$$mockTime(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), this.logDirFailureChannel$1, this.tierLogComponents$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logConfig$1 = logConfig$1;
                this.tempDir$1 = tempDir$1;
                this.tierLogComponents$1 = tierLogComponents$1;
                this.logDirFailureChannel$1 = logDirFailureChannel$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private ReplicaManager mockReplicaManager(Iterable<AbstractLog> logs) {
        void var2_2;
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog((TopicPartition)ArgumentMatchers.any(TopicPartition.class))).thenAnswer((Answer)new Answer<Option<AbstractLog>>(this, logs){
            private final Iterable logs$1;

            public Option<AbstractLog> answer(InvocationOnMock invocation) {
                TopicPartition target = (TopicPartition)invocation.getArgument(0);
                return this.logs$1.find((Function1)new Serializable(this, target){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition target$1;

                    public final boolean apply(AbstractLog log2) {
                        TopicPartition topicPartition = log2.topicPartition();
                        TopicPartition topicPartition2 = this.target$1;
                        return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
                    }
                    {
                        this.target$1 = target$1;
                    }
                });
            }
            {
                this.logs$1 = logs$1;
            }
        });
        Iterable partitions = (Iterable)logs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Partition apply(AbstractLog log2) {
                void var2_2;
                Partition partition = (Partition)Mockito.mock(Partition.class);
                Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log2));
                return var2_2;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer((Answer)new Answer<Iterator<Partition>>(this, partitions){
            private final Iterable partitions$1;

            public Iterator<Partition> answer(InvocationOnMock invocation) {
                return this.partitions$1.toIterator();
            }
            {
                this.partitions$1 = partitions$1;
            }
        });
        return var2_2;
    }

    public void kafka$tier$TierIntegrationTest$$writeRecordBatches(AbstractLog log2, int leaderEpoch, long baseOffset, int batches, int recordsPerBatch) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batches).foreach((Function1)new Serializable(this, log2, leaderEpoch, baseOffset, recordsPerBatch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            private final AbstractLog log$1;
            private final int leaderEpoch$3;
            private final long baseOffset$1;
            private final int recordsPerBatch$1;

            public final LogAppendInfo apply(int idx) {
                MemoryRecords records2 = this.$outer.kafka$tier$TierIntegrationTest$$createRecords(this.log$1.topicPartition(), this.leaderEpoch$3, this.baseOffset$1 + (long)(idx * this.recordsPerBatch$1), this.recordsPerBatch$1);
                return this.log$1.appendAsFollower(records2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$1 = log$1;
                this.leaderEpoch$3 = leaderEpoch$3;
                this.baseOffset$1 = baseOffset$1;
                this.recordsPerBatch$1 = recordsPerBatch$1;
            }
        });
        log2.flush();
        log2.updateHighWatermark((long)(batches * recordsPerBatch));
    }

    public MemoryRecords kafka$tier$TierIntegrationTest$$createRecords(TopicPartition topicPartition, int leaderEpoch, long baseOffset, int numRecords) {
        scala.collection.immutable.IndexedSeq recList;
        scala.collection.immutable.IndexedSeq x$38 = recList = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final SimpleRecord apply(int x$11) {
                return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        long x$39 = baseOffset;
        byte x$40 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$41 = TestUtils$.MODULE$.records$default$3();
        long x$42 = TestUtils$.MODULE$.records$default$4();
        short x$43 = TestUtils$.MODULE$.records$default$5();
        int x$44 = TestUtils$.MODULE$.records$default$6();
        int x$45 = TestUtils$.MODULE$.records$default$8();
        MemoryRecords records2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$38, x$40, x$41, x$42, x$43, x$44, x$39, x$45);
        ByteBuffer filtered = ByteBuffer.allocate(100 * numRecords);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.batches()).asScala()).foreach((Function1)new Serializable(this, leaderEpoch){
            public static final long serialVersionUID = 0L;
            private final int leaderEpoch$7;

            public final void apply(MutableRecordBatch x$12) {
                x$12.setPartitionLeaderEpoch(this.leaderEpoch$7);
            }
            {
                this.leaderEpoch$7 = leaderEpoch$7;
            }
        });
        records2.filterTo(topicPartition, new MemoryRecords.RecordFilter(this){

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                return MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY;
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return MemoryRecords.readableRecords((ByteBuffer)filtered);
    }

    private long metricValue(String name) {
        return BoxesRunTime.unboxToLong((Object)((Gauge)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(MetricName x$13) {
                String string = x$13.getName();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = name$1;
            }
        }).values().head()).value());
    }

    private TierPartitionState tierPartitionState(TopicPartition partition) {
        return (TierPartitionState)this.logs().find((Function1)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition partition$1;

            public final boolean apply(MergedLog x$14) {
                TopicPartition topicPartition = x$14.topicPartition();
                TopicPartition topicPartition2 = this.partition$1;
                return !(topicPartition != null ? !topicPartition.equals(topicPartition2) : topicPartition2 != null);
            }
            {
                this.partition$1 = partition$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TierPartitionState apply(MergedLog x$15) {
                return x$15.tierPartitionState();
            }
        }).get();
    }

    private final long totalLag$1() {
        return this.metricValue("TotalLag");
    }

    public final void kafka$tier$TierIntegrationTest$$awaitMaterializeBatchAndAssertLag$1(int archivedBatches) {
        this.archiveAndMaterializeUntilTrue((Function0<Object>)new Serializable(this, archivedBatches){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierIntegrationTest $outer;
            public final int archivedBatches$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.logs().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$kafka$tier$TierIntegrationTest$$awaitMaterializeBatchAndAssertLag$1$1 $outer;

                    public final boolean apply(MergedLog log2) {
                        TierPartitionState tierPartitionState2 = log2.tierPartitionState();
                        tierPartitionState2.flush();
                        return tierPartitionState2.numSegments() >= this.$outer.archivedBatches$1 && tierPartitionState2.committedEndOffset() == tierPartitionState2.endOffset();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.archivedBatches$1 = archivedBatches$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should materialize segments for batch ", " or greater"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)archivedBatches)})), this.tierTopicManager(), this.consumerSupplier());
        this.kafka$tier$TierIntegrationTest$$mockTime().sleep(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1);
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.logs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(MergedLog x$5) {
                return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$5.tierableLogSegments().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(LogSegment x$6) {
                        return x$6.size();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
    }

    public TierIntegrationTest() {
        this.maxWaitTimeMs = 20000;
    }
}

