/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TierProducerStateReplicationTest$;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.IntegrationTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u0001\u001d\u0011\u0001\u0005V5feB\u0013x\u000eZ;dKJ\u001cF/\u0019;f%\u0016\u0004H.[2bi&|g\u000eV3ti*\u00111\u0001B\u0001\u0005i&,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\tYA!A\u0002ba&L!!\u0004\u0006\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001C\u0002\u0013%1$\u0001\u0007tK\u001elWM\u001c;CsR,7/F\u0001\u001d!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\rIe\u000e\u001e\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u001bM,w-\\3oi\nKH/Z:!\u0011\u001d)\u0003A1A\u0005\n\u0019\n\u0011\u0002^8qS\u000et\u0015-\\3\u0016\u0003\u001d\u0002\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\t1\fgn\u001a\u0006\u0002Y\u0005!!.\u0019<b\u0013\tq\u0013F\u0001\u0004TiJLgn\u001a\u0005\u0007a\u0001\u0001\u000b\u0011B\u0014\u0002\u0015Q|\u0007/[2OC6,\u0007\u0005C\u00043\u0001\t\u0007I\u0011B\u000e\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000f\u0003\u00045\u0001\u0001\u0006I\u0001H\u0001\u0013e\u0016\u0004H.[2bi&|gNR1di>\u0014\b\u0005C\u00057\u0001\u0001\u0007\t\u0019!C\u0005o\u0005yqN\\3tQ>$\bK]8ek\u000e,'/F\u00019!\u0011I4)R#\u000e\u0003iR!a\u000f\u001f\u0002\u0011A\u0014x\u000eZ;dKJT!!\u0010 \u0002\u000f\rd\u0017.\u001a8ug*\u0011Qa\u0010\u0006\u0003\u0001\u0006\u000ba!\u00199bG\",'\"\u0001\"\u0002\u0007=\u0014x-\u0003\u0002Eu\ti1*\u00194lCB\u0013x\u000eZ;dKJ\u00042!\b$I\u0013\t9eDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001e\u0013&\u0011!J\b\u0002\u0005\u0005f$X\rC\u0005M\u0001\u0001\u0007\t\u0019!C\u0005\u001b\u0006\u0019rN\\3tQ>$\bK]8ek\u000e,'o\u0018\u0013fcR\u0011a*\u0015\t\u0003;=K!\u0001\u0015\u0010\u0003\tUs\u0017\u000e\u001e\u0005\b%.\u000b\t\u00111\u00019\u0003\rAH%\r\u0005\u0007)\u0002\u0001\u000b\u0015\u0002\u001d\u0002!=tWm\u001d5piB\u0013x\u000eZ;dKJ\u0004\u0003\"C\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u00038\u0011%9\u0006\u00011AA\u0002\u0013%\u0001,\u0001\u0007qe>$WoY3s?\u0012*\u0017\u000f\u0006\u0002O3\"9!KVA\u0001\u0002\u0004A\u0004BB.\u0001A\u0003&\u0001(A\u0005qe>$WoY3sA!IQ\f\u0001a\u0001\u0002\u0004%IAX\u0001\tG>t7/^7feV\tq\f\u0005\u0003aE\u0016+U\"A1\u000b\u0005uc\u0014BA2b\u00055Y\u0015MZ6b\u0007>t7/^7fe\"IQ\r\u0001a\u0001\u0002\u0004%IAZ\u0001\rG>t7/^7fe~#S-\u001d\u000b\u0003\u001d\u001eDqA\u00153\u0002\u0002\u0003\u0007q\f\u0003\u0004j\u0001\u0001\u0006KaX\u0001\nG>t7/^7fe\u0002BQa\u001b\u0001\u0005Rm\t1B\u0019:pW\u0016\u00148i\\;oi\")Q\u000e\u0001C!]\u0006iQn\u001c3jMf\u001cuN\u001c4jON$\"AT8\t\u000bAd\u0007\u0019A9\u0002\u000bA\u0014x\u000e]:\u0011\u0007ITXP\u0004\u0002tq:\u0011Ao^\u0007\u0002k*\u0011aOB\u0001\u0007yI|w\u000e\u001e \n\u0003}I!!\u001f\u0010\u0002\u000fA\f7m[1hK&\u00111\u0010 \u0002\u0004'\u0016\f(BA=\u001f!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011A\u0016\u0002\tU$\u0018\u000e\\\u0005\u0004\u0003\u000by(A\u0003)s_B,'\u000f^5fg\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0011!B:fiV\u0003H#\u0001()\t\u0005\u001d\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011QC!\u0002\u000b),h.\u001b;\n\t\u0005e\u00111\u0003\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005u\u0001\u0001\"\u0011\u0002\f\u0005AA/Z1s\t><h\u000e\u000b\u0003\u0002\u001c\u0005\u0005\u0002\u0003BA\t\u0003GIA!!\n\u0002\u0014\t)\u0011I\u001a;fe\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0012\u0001\u00049s_\u0012,8-\u001a\"zi\u0016\u001cHCBA\u0017\u0003g\t9\u0004E\u0002:\u0003_I1!!\r;\u00059\u0011VmY8sI6+G/\u00193bi\u0006Dq!!\u000e\u0002(\u0001\u0007\u0001(\u0001\u0003qe>$\u0007bBA\u001d\u0003O\u0001\r\u0001H\u0001\t]Vl')\u001f;fg\"9\u0011Q\b\u0001\u0005\n\u0005}\u0012A\u00027fC\u0012,'\u000f\u0006\u0003\u0002B\u00055\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001dC!\u0001\u0004tKJ4XM]\u0005\u0005\u0003\u0017\n)EA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\b\u0002CA(\u0003w\u0001\r!!\u0015\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u00111KA-\u001b\t\t)FC\u0002\u0002Xy\naaY8n[>t\u0017\u0002BA.\u0003+\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0002`\u0001!I!!\u0019\u0002\u0011\u0005<\u0018-\u001b;J'J#RATA2\u0003KB\u0001\"a\u0014\u0002^\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003O\ni\u00061\u0001\u001d\u0003!)\u0007\u0010]3di\u0016$\u0007bBA6\u0001\u0011\u0005\u00111B\u0001.i\u0016\u001cH\u000f\u0015:pIV\u001cWM]*uCR,'+Z:u_J\fG/[8o\rJ|W\u000eV5fe\u0016$7\u000b^8sC\u001e,\u0007\u0006BA5\u0003_\u0002B!!\u0005\u0002r%!\u00111OA\n\u0005\u0011!Vm\u001d;)\u000f\u0001\t9(a\"\u0002\nB!\u0011\u0011PAB\u001b\t\tYH\u0003\u0003\u0002~\u0005}\u0014AC2bi\u0016<wN]5fg*!\u0011\u0011QA\n\u00031)\u0007\u0010]3sS6,g\u000e^1m\u0013\u0011\t))a\u001f\u0003\u0011\r\u000bG/Z4pef\fQA^1mk\u0016d#!a#$\u0005\u00055\u0005\u0003BAH\u0003+k!!!%\u000b\u0007\u0005Me(\u0001\u0003uKN$\u0018\u0002BAL\u0003#\u0013q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e")
public class TierProducerStateReplicationTest
extends IntegrationTestHarness {
    private final int kafka$tier$TierProducerStateReplicationTest$$segmentBytes;
    private final String topicName;
    private final int replicationFactor = this.brokerCount();
    private KafkaProducer<byte[], byte[]> oneshotProducer;
    private KafkaProducer<byte[], byte[]> kafka$tier$TierProducerStateReplicationTest$$producer;
    private KafkaConsumer<byte[], byte[]> consumer;

    public int kafka$tier$TierProducerStateReplicationTest$$segmentBytes() {
        return this.kafka$tier$TierProducerStateReplicationTest$$segmentBytes;
    }

    private String topicName() {
        return this.topicName;
    }

    private int replicationFactor() {
        return this.replicationFactor;
    }

    private KafkaProducer<byte[], byte[]> oneshotProducer() {
        return this.oneshotProducer;
    }

    private void oneshotProducer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.oneshotProducer = x$1;
    }

    public KafkaProducer<byte[], byte[]> kafka$tier$TierProducerStateReplicationTest$$producer() {
        return this.kafka$tier$TierProducerStateReplicationTest$$producer;
    }

    private void kafka$tier$TierProducerStateReplicationTest$$producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.kafka$tier$TierProducerStateReplicationTest$$producer = x$1;
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierProducerStateReplicationTest $outer;

            public final Object apply(Properties p) {
                p.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
                p.put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
                p.put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
                p.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
                p.put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
                p.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
                p.put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)(this.$outer.kafka$tier$TierProducerStateReplicationTest$$segmentBytes() * 2))).toString());
                p.put(KafkaConfig$.MODULE$.LogSegmentBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$tier$TierProducerStateReplicationTest$$segmentBytes())).toString());
                return p.put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "500");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties topicProps = new Properties();
        topicProps.put("confluent.tier.enable", "true");
        topicProps.put("retention.bytes", "-1");
        topicProps.put("min.insync.replicas", "2");
        String x$8 = this.topicName();
        int x$9 = this.replicationFactor();
        int x$10 = this.createTopic$default$2();
        Properties x$11 = this.createTopic$default$4();
        this.createTopic(x$8, x$10, x$9, x$11);
        Properties producerProps = new Properties();
        producerProps.put("enable.idempotence", "true");
        this.oneshotProducer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProps));
        this.kafka$tier$TierProducerStateReplicationTest$$producer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProps));
        this.consumer_$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.kafka$tier$TierProducerStateReplicationTest$$producer().flush();
        this.kafka$tier$TierProducerStateReplicationTest$$producer().close();
        this.oneshotProducer().flush();
        this.oneshotProducer().close();
        this.consumer().close();
    }

    public RecordMetadata kafka$tier$TierProducerStateReplicationTest$$produceBytes(KafkaProducer<byte[], byte[]> prod, int numBytes) {
        byte[] bytes = TestUtils$.MODULE$.randomBytes(numBytes);
        return (RecordMetadata)prod.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), null, (Object)bytes)).get();
    }

    public KafkaServer kafka$tier$TierProducerStateReplicationTest$$leader(TopicPartition topicPartition) {
        int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(topicPartition).get());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1)new Serializable(this, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            public final boolean apply(KafkaServer x$1) {
                return x$1.config().brokerId() == this.leaderId$1;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        })).head();
    }

    private void awaitISR(TopicPartition topicPartition, int expected) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, expected){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierProducerStateReplicationTest $outer;
            private final TopicPartition topicPartition$1;
            private final int expected$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Partition)this.$outer.kafka$tier$TierProducerStateReplicationTest$$leader(this.topicPartition$1).replicaManager().nonOfflinePartition(this.topicPartition$1).get()).inSyncReplicaIds().size() == this.expected$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
                this.expected$1 = expected$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "timed out waiting for replicas to join the ISR";
            }
        }, 120000L, 1000L);
    }

    @Test
    public void testProducerStateRestorationFromTieredStorage() {
        TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierProducerStateReplicationTest $outer;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.servers().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(KafkaServer x$2) {
                        return ((TierTopicManager)x$2.tierTopicManagerOpt().get()).isReady();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Wait until the tier topic manager is ready for all brokers";
            }
        }, 30000L, 1000L);
        int killedBroker = this.killRandomBroker();
        this.awaitISR(topicPartition, this.replicationFactor() - 1);
        this.kafka$tier$TierProducerStateReplicationTest$$produceBytes(this.oneshotProducer(), 512);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierProducerStateReplicationTest $outer;

            public final RecordMetadata apply(int _) {
                return this.$outer.kafka$tier$TierProducerStateReplicationTest$$produceBytes(this.$outer.kafka$tier$TierProducerStateReplicationTest$$producer(), 512);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Tuple2 tuple2 = this.servers().partition((Function1)new Serializable(this, killedBroker){
            public static final long serialVersionUID = 0L;
            private final int killedBroker$1;

            public final boolean apply(KafkaServer x$3) {
                return x$3.config().brokerId() == this.killedBroker$1;
            }
            {
                this.killedBroker$1 = killedBroker$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Buffer deadServers = (Buffer)tuple2._1();
            Buffer livingServers = (Buffer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)deadServers, (Object)livingServers);
            Buffer deadServers2 = (Buffer)tuple23._1();
            Buffer livingServers2 = (Buffer)tuple23._2();
            KafkaServer deadServer = (KafkaServer)deadServers2.head();
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition, livingServers2){
                public static final long serialVersionUID = 0L;
                public final TopicPartition topicPartition$2;
                private final Buffer livingServers$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.livingServers$1.forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testProducerStateRestorationFromTieredStorage$2 $outer;

                        public final boolean apply(KafkaServer broker) {
                            boolean x$13;
                            TopicPartition x$12;
                            LogManager qual$1 = broker.replicaManager().logManager();
                            Option log2 = qual$1.getLog(x$12 = this.$outer.topicPartition$2, x$13 = qual$1.getLog$default$2());
                            return ((AbstractLog)log2.get()).localLogStartOffset() > 0L;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                    this.livingServers$1 = livingServers$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "expected to tier some segments and advance the local log start offset";
                }
            }, 300000L, 1000L);
            Assert.assertTrue((String)"expected the shutdown server to have no active producers", (boolean)((AbstractLog)deadServer.replicaManager().getLog(topicPartition).get()).producerStateManager().activeProducers().isEmpty());
            Assert.assertTrue((String)"expected the active brokers to both have materialized some producer state", (boolean)livingServers2.forall((Function1)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final boolean apply(KafkaServer x$5) {
                    return ((AbstractLog)x$5.replicaManager().getLog(this.topicPartition$2).get()).producerStateManager().activeProducers().nonEmpty();
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            }));
            this.restartDeadBrokers();
            this.awaitISR(topicPartition, this.replicationFactor());
            Assert.assertEquals((long)this.servers().size(), (long)this.replicationFactor());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TierProducerStateReplicationTest $outer;
                public final TopicPartition topicPartition$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    Buffer endOffsets = (Buffer)this.$outer.servers().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testProducerStateRestorationFromTieredStorage$3 $outer;

                        public final long apply(KafkaServer x$6) {
                            return ((AbstractLog)x$6.replicaManager().getLog(this.$outer.topicPartition$2).get()).localLogEndOffset();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Buffer$.MODULE$.canBuildFrom());
                    return endOffsets.forall((Function1)new Serializable(this, endOffsets){
                        public static final long serialVersionUID = 0L;
                        private final Buffer endOffsets$1;

                        public final boolean apply(long x$7) {
                            return this.apply$mcZJ$sp(x$7);
                        }

                        public boolean apply$mcZJ$sp(long x$7) {
                            return x$7 == BoxesRunTime.unboxToLong((Object)this.endOffsets$1.head());
                        }
                        {
                            this.endOffsets$1 = endOffsets$1;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicPartition$2 = topicPartition$2;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "expected all brokers to have matching end offsets";
                }
            }, 300000L, 1000L);
            Buffer activeProducersAcrossBrokers = (Buffer)this.servers().map((Function1)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final Set<Object> apply(KafkaServer broker) {
                    return ((AbstractLog)broker.replicaManager().getLog(this.topicPartition$2).get()).producerStateManager().activeProducers().keys().toSet();
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            }, Buffer$.MODULE$.canBuildFrom());
            activeProducersAcrossBrokers.foreach((Function1)new Serializable(this, activeProducersAcrossBrokers){
                public static final long serialVersionUID = 0L;
                private final Buffer activeProducersAcrossBrokers$1;

                public final void apply(Set<Object> s) {
                    Assert.assertEquals((String)"expected the set of active producers for all brokers to be the same", (Object)this.activeProducersAcrossBrokers$1.head(), s);
                }
                {
                    this.activeProducersAcrossBrokers$1 = activeProducersAcrossBrokers$1;
                }
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public TierProducerStateReplicationTest() {
        this.kafka$tier$TierProducerStateReplicationTest$$segmentBytes = 1024;
        this.topicName = "topic";
    }
}

