/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.Optional;
import java.util.UUID;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u000f\t1B+[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!A/[3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\nU\t\u0001\u0002\\5ti\u0016tWM]\u000b\u0002-A\u0011q#\t\b\u00031}q!!\u0007\u0010\u000f\u0005iiR\"A\u000e\u000b\u0005q1\u0011A\u0002\u001fs_>$h(C\u0001\u0006\u0013\t\u0019A!\u0003\u0002!\u0005\u0005\u0011B+[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0013\t\u00113E\u0001\bDQ\u0006tw-\u001a'jgR,g.\u001a:\u000b\u0005\u0001\u0012\u0001BB\u0013\u0001A\u0003%a#A\u0005mSN$XM\\3sA!9q\u0005\u0001b\u0001\n\u0013A\u0013!\u0007;jKJ,e.\u00192mK\u0012\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016,\u0012!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0003Y\t\tQa\u001d;bi\u0016L!AL\u0016\u0003-\u0019KG.\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016Da\u0001\r\u0001!\u0002\u0013I\u0013A\u0007;jKJ,e.\u00192mK\u0012\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%I\u0001K\u0001\u001bi&,'\u000fR5tC\ndW\r\u001a)beRLG/[8o'R\fG/\u001a\u0005\u0007i\u0001\u0001\u000b\u0011B\u0015\u00027QLWM\u001d#jg\u0006\u0014G.\u001a3QCJ$\u0018\u000e^5p]N#\u0018\r^3!\u0011\u001d1\u0004A1A\u0005\n]\n!\u0003^5feJ+\u0007\u000f\\5dC6\u000bg.Y4feV\t\u0001\b\u0005\u0002\u0013s%\u0011!H\u0001\u0002\u0013)&,'OU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0004=\u0001\u0001\u0006I\u0001O\u0001\u0014i&,'OU3qY&\u001c\u0017-T1oC\u001e,'\u000f\t\u0005\u0006}\u0001!\taP\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002\u0001B\u0011\u0011\"Q\u0005\u0003\u0005*\u0011A!\u00168ji\"\u0012Q\b\u0012\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000bQA[;oSRT\u0011!S\u0001\u0004_J<\u0017BA&G\u0005\u0019\u0011UMZ8sK\")Q\n\u0001C\u0001\u007f\u0005YB/Z:u\u0005\u0016\u001cw.\\3MK\u0006$WM\u001d)s_B\fw-\u0019;j_:D#\u0001T(\u0011\u0005\u0015\u0003\u0016BA)G\u0005\u0011!Vm\u001d;\t\u000bM\u0003A\u0011A \u0002;Q,7\u000f\u001e\"fG>lWMR8mY><XM\u001d)s_B\fw-\u0019;j_:D#AU(\t\u000bY\u0003A\u0011A \u0002+Q,7\u000f\u001e#fY\u0016$X\r\u0015:pa\u0006<\u0017\r^5p]\"\u0012Qk\u0014")
public class TierReplicaManagerTest {
    private final TierReplicaManager.ChangeListener listener = (TierReplicaManager.ChangeListener)Mockito.mock(TierReplicaManager.ChangeListener.class);
    private final FileTierPartitionState tierEnabledPartitionState = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
    private final FileTierPartitionState tierDisabledPartitionState = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();

    private TierReplicaManager.ChangeListener listener() {
        return this.listener;
    }

    private FileTierPartitionState tierEnabledPartitionState() {
        return this.tierEnabledPartitionState;
    }

    private FileTierPartitionState tierDisabledPartitionState() {
        return this.tierDisabledPartitionState;
    }

    private TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    @Before
    public void setup() {
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierEnabledPartitionState().isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.tierEnabledPartitionState().topicIdPartition()).thenReturn(Optional.of(new TopicIdPartition("foo", UUID.randomUUID(), 0)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierDisabledPartitionState().isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.tierDisabledPartitionState().topicIdPartition()).thenReturn(Optional.of(new TopicIdPartition("bar", UUID.randomUUID(), 0)));
        this.tierReplicaManager().addListener(this.listener());
    }

    @Test
    public void testBecomeLeaderPropagation() {
        this.tierReplicaManager().becomeLeader((TierPartitionState)this.tierEnabledPartitionState(), 10);
        this.tierReplicaManager().becomeLeader((TierPartitionState)this.tierDisabledPartitionState(), 10);
        ((TierReplicaManager.ChangeListener)Mockito.verify((Object)this.listener(), (VerificationMode)Mockito.times((int)1))).onBecomeLeader((TopicIdPartition)this.tierEnabledPartitionState().topicIdPartition().get(), 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener()});
    }

    @Test
    public void testBecomeFollowerPropagation() {
        this.tierReplicaManager().becomeFollower((TierPartitionState)this.tierEnabledPartitionState());
        this.tierReplicaManager().becomeFollower((TierPartitionState)this.tierDisabledPartitionState());
        ((TierReplicaManager.ChangeListener)Mockito.verify((Object)this.listener(), (VerificationMode)Mockito.times((int)1))).onBecomeFollower((TopicIdPartition)this.tierEnabledPartitionState().topicIdPartition().get());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener()});
    }

    @Test
    public void testDeletePropagation() {
        this.tierReplicaManager().delete((TopicIdPartition)this.tierEnabledPartitionState().topicIdPartition().get());
        this.tierReplicaManager().delete((TopicIdPartition)this.tierDisabledPartitionState().topicIdPartition().get());
        ((TierReplicaManager.ChangeListener)Mockito.verify((Object)this.listener(), (VerificationMode)Mockito.times((int)1))).onDelete((TopicIdPartition)this.tierEnabledPartitionState().topicIdPartition().get());
        ((TierReplicaManager.ChangeListener)Mockito.verify((Object)this.listener(), (VerificationMode)Mockito.times((int)1))).onDelete((TopicIdPartition)this.tierDisabledPartitionState().topicIdPartition().get());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener()});
    }
}

