/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.NavigableSet;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TierRetentionIntegrationTest$;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001\u001d\u0011A\u0004V5feJ+G/\u001a8uS>t\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005!A/[3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u000e\u0015\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000fC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012!\u0002;pa&\u001cW#\u0001\f\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u00027b]\u001eT\u0011aG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001e1\t11\u000b\u001e:j]\u001eDaa\b\u0001!\u0002\u00131\u0012A\u0002;pa&\u001c\u0007\u0005C\u0004\"\u0001\t\u0007I\u0011\u0002\u0012\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#aA%oi\"1!\u0006\u0001Q\u0001\n\r\naB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004-\u0001\t\u0007I\u0011\u0002\u0012\u0002\u00179,XNU3qY&\u001c\u0017m\u001d\u0005\u0007]\u0001\u0001\u000b\u0011B\u0012\u0002\u00199,XNU3qY&\u001c\u0017m\u001d\u0011\t\u000bA\u0002A\u0011\u000b\u0012\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e\u001e\u0005\be\u0001\u0011\r\u0011\"\u00014\u0003\u0019)\u00070\u001b;fIV\tA\u0007\u0005\u00026y5\taG\u0003\u00028q\u00051\u0011\r^8nS\u000eT!!\u000f\u001e\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002<5\u0005!Q\u000f^5m\u0013\tidGA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007\u007f\u0001\u0001\u000b\u0011\u0002\u001b\u0002\u000f\u0015D\u0018\u000e^3eA!)\u0011\t\u0001C!\u0005\u0006)1/\u001a;VaR\t1\t\u0005\u0002%\t&\u0011Q)\n\u0002\u0005+:LG\u000f\u000b\u0002A\u000fB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0019\u0006\u0019qN]4\n\u00059K%A\u0002\"fM>\u0014X\rC\u0003Q\u0001\u0011\u0005#)\u0001\u0005uK\u0006\u0014Hi\\<oQ\ty%\u000b\u0005\u0002I'&\u0011A+\u0013\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0006-\u0002!\tAQ\u0001\u0013i\u0016\u001cHOQ1tS\u000e\u0014V\r^3oi&|g\u000e\u000b\u0002V1B\u0011\u0001*W\u0005\u00035&\u0013A\u0001V3ti\")A\f\u0001C\u0005;\u0006Qr/Y5u+:$\u0018\u000e\\#rk\u0006dwJ\\!mY\n\u0013xn[3sgR\u00191I\u00187\t\u000b}[\u0006\u0019\u00011\u0002\u0013\r|W\u000e];uK\u001as\u0007\u0003\u0002\u0013bG&L!AY\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u00013h\u001b\u0005)'B\u00014\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011\u0001.\u001a\u0002\f\u0017\u000647.Y*feZ,'\u000f\u0005\u0002\u0018U&\u00111\u000e\u0007\u0002\u0007\u001f\nTWm\u0019;\t\u000b5\\\u0006\u0019\u00018\u0002\u00075\u001cx\r\u0005\u0002pe:\u0011A\u0005]\u0005\u0003c\u0016\na\u0001\u0015:fI\u00164\u0017BA\u000ft\u0015\t\tX\u0005C\u0003v\u0001\u0011%a/\u0001\u0005bo\u0006LG/S*S)\u0019\u0019u/!\u0002\u0002\b!)\u0001\u0010\u001ea\u0001s\u0006\u0011A\u000f\u001d\t\u0004u\u0006\u0005Q\"A>\u000b\u0005ql\u0018AB2p[6|gN\u0003\u0002\u0006}*\u0011qpS\u0001\u0007CB\f7\r[3\n\u0007\u0005\r1P\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000b1\"\b\u0019A\u0012\t\r\u0005%A\u000f1\u0001d\u0003\u0019aW-\u00193fe\u0002")
public class TierRetentionIntegrationTest
extends IntegrationTestHarness {
    private final String topic;
    private final int numPartitions;
    private final int numReplicas;
    private final AtomicBoolean exited;

    private String topic() {
        return this.topic;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private int numReplicas() {
        return this.numReplicas;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @Before
    public void setUp() {
        Exit.setExitProcedure((Exit.Procedure)new Exit.Procedure(this){
            private final /* synthetic */ TierRetentionIntegrationTest $outer;

            public void execute(int statusCode, String message) {
                this.$outer.exited().set(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        super.setUp();
        this.createTopic(this.topic(), this.numPartitions(), this.numReplicas(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        Assert.assertFalse((boolean)this.exited().get());
    }

    @Test
    public void testBasicRetention() {
        int bytesSent;
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).s((Seq)Nil$.MODULE$).getBytes());
        int recordSize = Predef$.MODULE$.byteArrayOps((byte[])record.key()).size() + Predef$.MODULE$.byteArrayOps((byte[])record.value()).size();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        PartitionInfo partitionInfo2 = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PartitionInfo x$1) {
                return x$1.partition() == 0;
            }
        }).get();
        int leaderBrokerId = partitionInfo2.leader().id();
        int[] followers = (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionInfo2.replicas()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$2) {
                return x$2.id();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).filter((Function1)new Serializable(this, leaderBrokerId){
            public static final long serialVersionUID = 0L;
            private final int leaderBrokerId$1;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return x$3 != this.leaderBrokerId$1;
            }
            {
                this.leaderBrokerId$1 = leaderBrokerId$1;
            }
        });
        KafkaServer leader2 = (KafkaServer)this.servers().find((Function1)new Serializable(this, leaderBrokerId){
            public static final long serialVersionUID = 0L;
            private final int leaderBrokerId$1;

            public final boolean apply(KafkaServer x$4) {
                return x$4.config().brokerId() == this.leaderBrokerId$1;
            }
            {
                this.leaderBrokerId$1 = leaderBrokerId$1;
            }
        }).get();
        for (bytesSent = 0; bytesSent < 1100; bytesSent += recordSize) {
            producer.send(record).get();
        }
        LogManager qual$1 = leader2.logManager();
        TopicPartition x$5 = topicPartition;
        boolean x$6 = qual$1.getLog$default$2();
        AbstractLog log2 = (AbstractLog)qual$1.getLog(x$5, x$6).get();
        TierPartitionState tierPartitionState2 = log2.tierPartitionState();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierPartitionState2){
            public static final long serialVersionUID = 0L;
            private final TierPartitionState tierPartitionState$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.tierPartitionState$1.totalSize() > 0L;
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for segments to be tiered";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierPartitionState2){
            public static final long serialVersionUID = 0L;
            private final TierPartitionState tierPartitionState$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.tierPartitionState$1.committedEndOffset() > 0L;
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for tier partition state to be flushed";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((tierPartitionState2.segmentOffsets().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)log2.logStartOffset());
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)0L), tierPartitionState2.segmentOffsets().first());
        this.awaitISR(topicPartition, this.numReplicas(), leader2);
        this.killBroker(followers[0]);
        while (bytesSent < 20000) {
            producer.send(record).get();
            bytesSent += recordSize;
        }
        this.servers().foreach((Function1)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierRetentionIntegrationTest $outer;
            private final TopicPartition topicPartition$1;

            public final void apply(KafkaServer server) {
                boolean isAlive = this.$outer.alive()[this.$outer.servers().indexOf((Object)server)];
                if (isAlive) {
                    LogManager qual$2 = server.logManager();
                    TopicPartition x$7 = this.topicPartition$1;
                    boolean x$8 = qual$2.getLog$default$2();
                    AbstractLog log2 = (AbstractLog)qual$2.getLog(x$7, x$8).get();
                    TierPartitionState tierPartitionState2 = log2.tierPartitionState();
                    TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, log2){
                        public static final long serialVersionUID = 0L;
                        private final AbstractLog log$1;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return this.log$1.logStartOffset() > 0L;
                        }
                        {
                            this.log$1 = log$1;
                        }
                    }, (Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Timed out waiting for retention to kick in";
                        }
                    }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
                    TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierPartitionState2){
                        public static final long serialVersionUID = 0L;
                        private final TierPartitionState tierPartitionState$2;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return this.tierPartitionState$2.segmentOffsets().size() > 0;
                        }
                        {
                            this.tierPartitionState$2 = tierPartitionState$2;
                        }
                    }, (Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Timed out waiting for more segments to be tiered";
                        }
                    }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
                    Assert.assertTrue((Predef$.MODULE$.Long2long((Long)tierPartitionState2.segmentOffsets().first()) > 0L ? 1 : 0) != 0);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
            }
        });
        this.killBroker(followers[1]);
        while (bytesSent < 40000) {
            producer.send(record).get();
            bytesSent += recordSize;
        }
        this.restartDeadBrokers();
        this.awaitISR(topicPartition, this.numReplicas(), leader2);
        this.waitUntilEqualOnAllBrokers((Function1<KafkaServer, Object>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final String apply(KafkaServer server) {
                LogManager qual$3 = server.logManager();
                TopicPartition x$9 = this.topicPartition$1;
                boolean x$10 = qual$3.getLog$default$2();
                return ((Object)BoxesRunTime.boxToLong((long)((AbstractLog)qual$3.getLog(x$9, x$10).get()).logStartOffset())).toString();
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        }, "Timed out waiting for logStartOffset sync");
        this.waitUntilEqualOnAllBrokers((Function1<KafkaServer, Object>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final String apply(KafkaServer server) {
                LogManager qual$4 = server.logManager();
                TopicPartition x$11 = this.topicPartition$1;
                boolean x$12 = qual$4.getLog$default$2();
                return ((Object)BoxesRunTime.boxToLong((long)((AbstractLog)qual$4.getLog(x$11, x$12).get()).logEndOffset())).toString();
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        }, "Timed out waiting for logEndOffset sync");
        this.waitUntilEqualOnAllBrokers((Function1<KafkaServer, Object>)new Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final NavigableSet<Long> apply(KafkaServer server) {
                LogManager qual$5 = server.logManager();
                TopicPartition x$13 = this.topicPartition$1;
                boolean x$14 = qual$5.getLog$default$2();
                TierPartitionState tierPartitionState2 = ((AbstractLog)qual$5.getLog(x$13, x$14).get()).tierPartitionState();
                return tierPartitionState2.segmentOffsets();
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        }, "Timed out waiting for tier partition state sync");
    }

    private void waitUntilEqualOnAllBrokers(Function1<KafkaServer, Object> computeFn, String msg) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, computeFn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierRetentionIntegrationTest $outer;
            public final Function1 computeFn$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((TraversableOnce)this.$outer.servers().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$waitUntilEqualOnAllBrokers$1 $outer;

                    public final Object apply(KafkaServer server) {
                        return this.$outer.computeFn$1.apply((Object)server);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toSet().size() == 1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.computeFn$1 = computeFn$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private void awaitISR(TopicPartition tp, int numReplicas, KafkaServer leader2) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tp, numReplicas, leader2){
            public static final long serialVersionUID = 0L;
            private final TopicPartition tp$1;
            private final int numReplicas$1;
            private final KafkaServer leader$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return ((Partition)this.leader$1.replicaManager().nonOfflinePartition(this.tp$1).get()).inSyncReplicaIds().size() == this.numReplicas$1;
            }
            {
                this.tp$1 = tp$1;
                this.numReplicas$1 = numReplicas$1;
                this.leader$1 = leader$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for replicas to join ISR";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public TierRetentionIntegrationTest() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "10000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "1000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.topic = "foo";
        this.numPartitions = 1;
        this.numReplicas = 3;
        this.exited = new AtomicBoolean(false);
    }
}

