/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u000f\t\u0001C+[3s)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8J]R,wM]1uS>tG+Z:u\u0015\t\u0019A!\u0001\u0003uS\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0003\u0017\u0011\t1!\u00199j\u0013\ti!B\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015y\u0001\u0001\"\u0001\u0011\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0003\u0005\u0002\u0013\u00015\t!\u0001C\u0003\u0015\u0001\u0011ES#A\u0006ce>\\WM]\"pk:$X#\u0001\f\u0011\u0005]QR\"\u0001\r\u000b\u0003e\tQa]2bY\u0006L!a\u0007\r\u0003\u0007%sG\u000fC\u0004\u001e\u0001\t\u0007I\u0011\u0002\u0010\u0002\u000bQ|\u0007/[2\u0016\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\t1\fgn\u001a\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0004TiJLgn\u001a\u0005\u0007Q\u0001\u0001\u000b\u0011B\u0010\u0002\rQ|\u0007/[2!\u0011\u001dQ\u0003A1A\u0005\nU\tQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bB\u0002\u0017\u0001A\u0003%a#\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u000f9\u0002!\u0019!C\u0005+\u0005Ya.^7SKBd\u0017nY1t\u0011\u0019\u0001\u0004\u0001)A\u0005-\u0005aa.^7SKBd\u0017nY1tA!9!\u0007\u0001b\u0001\n\u0013\u0019\u0014AB3ySR,G-F\u00015!\t)D(D\u00017\u0015\t9\u0004(\u0001\u0004bi>l\u0017n\u0019\u0006\u0003si\n!bY8oGV\u0014(/\u001a8u\u0015\tY4%\u0001\u0003vi&d\u0017BA\u001f7\u00055\tEo\\7jG\n{w\u000e\\3b]\"1q\b\u0001Q\u0001\nQ\nq!\u001a=ji\u0016$\u0007\u0005C\u0003B\u0001\u0011\u0005#)A\u0003tKR,\u0006\u000fF\u0001D!\t9B)\u0003\u0002F1\t!QK\\5uQ\t\u0001u\t\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006)!.\u001e8ji*\tA*A\u0002pe\u001eL!AT%\u0003\r\t+gm\u001c:f\u0011\u0015\u0001\u0006\u0001\"\u0011C\u0003!!X-\u0019:E_^t\u0007FA(S!\tA5+\u0003\u0002U\u0013\n)\u0011I\u001a;fe\")a\u000b\u0001C\u0001\u0005\u0006\tB/Z:u)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0005UC\u0006C\u0001%Z\u0013\tQ\u0016J\u0001\u0003UKN$\b")
public class TierTopicDeletionIntegrationTest
extends IntegrationTestHarness {
    private final String kafka$tier$TierTopicDeletionIntegrationTest$$topic;
    private final int numPartitions;
    private final int numReplicas;
    private final AtomicBoolean kafka$tier$TierTopicDeletionIntegrationTest$$exited = new AtomicBoolean(false);

    @Override
    public int brokerCount() {
        return 3;
    }

    public String kafka$tier$TierTopicDeletionIntegrationTest$$topic() {
        return this.kafka$tier$TierTopicDeletionIntegrationTest$$topic;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private int numReplicas() {
        return this.numReplicas;
    }

    public AtomicBoolean kafka$tier$TierTopicDeletionIntegrationTest$$exited() {
        return this.kafka$tier$TierTopicDeletionIntegrationTest$$exited;
    }

    @Override
    @Before
    public void setUp() {
        Exit.setExitProcedure((Exit.Procedure)new Exit.Procedure(this){
            private final /* synthetic */ TierTopicDeletionIntegrationTest $outer;

            public void execute(int statusCode, String message) {
                this.$outer.kafka$tier$TierTopicDeletionIntegrationTest$$exited().set(true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        super.setUp();
        this.createTopic(this.kafka$tier$TierTopicDeletionIntegrationTest$$topic(), this.numPartitions(), this.numReplicas(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        Assert.assertFalse((boolean)this.kafka$tier$TierTopicDeletionIntegrationTest$$exited().get());
    }

    @Test
    public void testTopicDeletion() {
        IndexedSeq records2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTopicDeletionIntegrationTest $outer;

            public final ProducerRecord<byte[], byte[]> apply(int i) {
                return new ProducerRecord(this.$outer.kafka$tier$TierTopicDeletionIntegrationTest$$topic(), Predef$.MODULE$.int2Integer(i), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key"})).s((Seq)Nil$.MODULE$).getBytes(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})).s((Seq)Nil$.MODULE$).getBytes());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        int recordSize = Predef$.MODULE$.byteArrayOps((byte[])((ProducerRecord)records2.head()).key()).size() + Predef$.MODULE$.byteArrayOps((byte[])((ProducerRecord)records2.head()).value()).size();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        for (int bytesSent = 0; bytesSent < 200; bytesSent += recordSize) {
            records2.foreach((Function1)new Serializable(this, producer){
                public static final long serialVersionUID = 0L;
                private final KafkaProducer producer$1;

                public final RecordMetadata apply(ProducerRecord<byte[], byte[]> record) {
                    return (RecordMetadata)this.producer$1.send(record).get();
                }
                {
                    this.producer$1 = producer$1;
                }
            });
        }
        MockInMemoryTierObjectStore mockObjectStore = (MockInMemoryTierObjectStore)((KafkaServer)this.servers().head()).tierObjectStoreOpt().get();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTopicDeletionIntegrationTest $outer;
            private final KafkaProducer producer$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TopicPartition topicPartition = new TopicPartition(this.$outer.kafka$tier$TierTopicDeletionIntegrationTest$$topic(), i);
                PartitionInfo partitionInfo2 = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.producer$1.partitionsFor(this.$outer.kafka$tier$TierTopicDeletionIntegrationTest$$topic())).asScala()).find((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final boolean apply(PartitionInfo x$1) {
                        return x$1.partition() == this.i$1;
                    }
                    {
                        this.i$1 = i$1;
                    }
                }).get();
                int leaderBrokerId = partitionInfo2.leader().id();
                KafkaServer leader2 = (KafkaServer)this.$outer.servers().find((Function1)new Serializable(this, leaderBrokerId){
                    public static final long serialVersionUID = 0L;
                    private final int leaderBrokerId$1;

                    public final boolean apply(KafkaServer x$2) {
                        return x$2.config().brokerId() == this.leaderBrokerId$1;
                    }
                    {
                        this.leaderBrokerId$1 = leaderBrokerId$1;
                    }
                }).get();
                LogManager qual$1 = leader2.logManager();
                TopicPartition x$3 = topicPartition;
                boolean x$4 = qual$1.getLog$default$2();
                AbstractLog log2 = (AbstractLog)qual$1.getLog(x$3, x$4).get();
                TierPartitionState tierPartitionState2 = log2.tierPartitionState();
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierPartitionState2){
                    public static final long serialVersionUID = 0L;
                    private final TierPartitionState tierPartitionState$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.tierPartitionState$1.totalSize() > 0L;
                    }
                    {
                        this.tierPartitionState$1 = tierPartitionState$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Timed out waiting for segments to be tiered";
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
                TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierPartitionState2){
                    public static final long serialVersionUID = 0L;
                    private final TierPartitionState tierPartitionState$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return this.tierPartitionState$1.committedEndOffset() > 0L;
                    }
                    {
                        this.tierPartitionState$1 = tierPartitionState$1;
                    }
                }, (Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Timed out waiting for tier partition state to be flushed";
                    }
                }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
            }
        });
        Assert.assertTrue((mockObjectStore.getStored().size() >= this.numPartitions() ? 1 : 0) != 0);
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        adminClient.deleteTopics(Collections.singleton(this.kafka$tier$TierTopicDeletionIntegrationTest$$topic())).all().get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, mockObjectStore){
            public static final long serialVersionUID = 0L;
            private final MockInMemoryTierObjectStore mockObjectStore$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.mockObjectStore$1.getStored().size() == 0;
            }
            {
                this.mockObjectStore$1 = mockObjectStore$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting for all objects to be deleted";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    public TierTopicDeletionIntegrationTest() {
        this.kafka$tier$TierTopicDeletionIntegrationTest$$topic = "foo";
        this.numPartitions = 4;
        this.numReplicas = 2;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "10000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "1000");
        Predef$.MODULE$.locally(this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10"));
    }
}

