/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import kafka.tier.client.TierTopicClient;
import kafka.tier.client.TierTopicConsumerSupplier;
import kafka.tier.client.TierTopicProducerSupplier;
import kafka.tier.topic.TierTopicManagerConfig;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u0013\t\u0019B+[3s)>\u0004\u0018nY\"mS\u0016tG\u000fV3ti*\u00111\u0001B\u0001\u0007G2LWM\u001c;\u000b\u0005\u00151\u0011\u0001\u0002;jKJT\u0011aB\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006#\u0001!\tAE\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\tAqA\u0006\u0001C\u0002\u0013%q#A\u0005dYV\u001cH/\u001a:JIV\t\u0001\u0004\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005!A.\u00198h\u0015\u0005i\u0012\u0001\u00026bm\u0006L!a\b\u000e\u0003\rM#(/\u001b8h\u0011\u0019\t\u0003\u0001)A\u00051\u0005Q1\r\\;ti\u0016\u0014\u0018\n\u001a\u0011\t\u000f\r\u0002!\u0019!C\u0005I\u0005A!M]8lKJLE-F\u0001&!\tYa%\u0003\u0002(\u0019\t\u0019\u0011J\u001c;\t\r%\u0002\u0001\u0015!\u0003&\u0003%\u0011'o\\6fe&#\u0007\u0005C\u0004,\u0001\t\u0007I\u0011\u0002\u0013\u0002\u0015%t7\u000f^1oG\u0016LE\r\u0003\u0004.\u0001\u0001\u0006I!J\u0001\fS:\u001cH/\u00198dK&#\u0007\u0005C\u00030\u0001\u0011\u0005\u0001'\u0001\u000buKN$8i\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u000b\u0002cA\u00111BM\u0005\u0003g1\u0011A!\u00168ji\"\u0012a&\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nQA[;oSRT\u0011AO\u0001\u0004_J<\u0017B\u0001\u001f8\u0005\u0011!Vm\u001d;\t\u000by\u0002A\u0011\u0001\u0019\u0002)Q,7\u000f\u001e)s_\u0012,8-\u001a:DY&,g\u000e^%eQ\tiT\u0007C\u0003B\u0001\u0011\u0005\u0001'A\u0012uKN$X*\u001a;sS\u000e\u001c(+\u001a9peR,'oQ8oM&<gj\u001c;Qe\u0016\u001cXM\u001c;)\u0005\u0001+\u0004")
public class TierTopicClientTest {
    private final String clusterId;
    private final int brokerId;
    private final int instanceId;

    private String clusterId() {
        return this.clusterId;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private int instanceId() {
        return this.instanceId;
    }

    @Test
    public void testConsumerClientId() {
        String clientIdSuffix = "suffix";
        String clientId = TierTopicConsumerSupplier.clientId((String)this.clusterId(), (int)this.brokerId(), (int)this.instanceId(), (String)clientIdSuffix);
        Assert.assertTrue((boolean)TierTopicClient.isTierTopicClient((String)clientId));
    }

    @Test
    public void testProducerClientId() {
        String clientId = TierTopicProducerSupplier.clientId((String)this.clusterId(), (int)this.brokerId(), (long)this.instanceId());
        Assert.assertTrue((boolean)TierTopicClient.isTierTopicClient((String)clientId));
    }

    @Test
    public void testMetricsReporterConfigNotPresent() {
        Supplier<Map<String, Object>> configsSupplier = new Supplier<Map<String, Object>>(this){

            /*
             * WARNING - void declaration
             */
            public Map<String, Object> get() {
                void var1_1;
                HashMap<String, String> configs = new HashMap<String, String>();
                configs.put("bootstrap.servers", "bootstrap");
                configs.put("metric.reporters", "reporter");
                return var1_1;
            }
        };
        TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig((Supplier)configsSupplier, "tierNamespace", (short)2, (short)1, 0, "clusterId", Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.int2Integer(200), Predef$.MODULE$.int2Integer(300), Collections.singletonList("logDir"));
        Properties producerConfigs = TierTopicProducerSupplier.properties((TierTopicManagerConfig)tierTopicManagerConfig, (String)"clientId");
        Assert.assertEquals((Object)"bootstrap", (Object)producerConfigs.getProperty("bootstrap.servers"));
        Assert.assertNull((Object)producerConfigs.getProperty("metric.reporters"));
        Properties consumerConfigs = TierTopicConsumerSupplier.properties((TierTopicManagerConfig)tierTopicManagerConfig, (String)"clientId");
        Assert.assertEquals((Object)"bootstrap", (Object)consumerConfigs.getProperty("bootstrap.servers"));
        Assert.assertNull((Object)consumerConfigs.getProperty("metric.reporters"));
    }

    public TierTopicClientTest() {
        this.clusterId = "cluster-id";
        this.brokerId = 3;
        this.instanceId = 10;
    }
}

