/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.util.OptionalInt;
import java.util.UUID;
import kafka.tier.fetcher.offsetcache.FetchOffsetCache;
import kafka.tier.fetcher.offsetcache.FetchOffsetMetadata;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class FetchOffsetCacheTest {
    @Test
    public void offsetCacheExpiry() {
        MockTime time = new MockTime(0L, 0L, 0L);
        FetchOffsetCache offsetCache = new FetchOffsetCache((Time)time, 100, 100);
        UUID objectId1 = UUID.randomUUID();
        offsetCache.put(objectId1, 100L, 100, OptionalInt.of(200));
        FetchOffsetMetadata cached1 = offsetCache.get(objectId1, 100L);
        Assert.assertEquals((long)200L, (long)cached1.recordBatchSize.getAsInt());
        Assert.assertEquals((double)1.0, (double)offsetCache.hitRatio(), (double)1.0E-6);
        time.sleep(99L);
        offsetCache.expireEntries();
        FetchOffsetMetadata cached2 = offsetCache.get(objectId1, 100L);
        Assert.assertEquals((String)"entry should still be present within expiry time", (long)200L, (long)cached2.recordBatchSize.getAsInt());
        Assert.assertEquals((double)1.0, (double)offsetCache.hitRatio(), (double)1.0E-6);
        time.sleep(50L);
        Assert.assertEquals((String)"expiration timestamp should have been refreshed due to cache hit", (long)1L, (long)offsetCache.size());
        time.sleep(50L);
        offsetCache.expireEntries();
        Assert.assertNull((Object)offsetCache.get(objectId1, 100L));
        Assert.assertEquals((String)"entry should have expired", (long)0L, (long)offsetCache.size());
        Assert.assertEquals((double)0.66666666666666, (double)offsetCache.hitRatio(), (double)1.0E-6);
    }

    @Test
    public void offsetCacheMaxSize() {
        MockTime time = new MockTime(0L, 0L, 0L);
        FetchOffsetCache offsetCache = new FetchOffsetCache((Time)time, 2, 100);
        UUID objectId1 = UUID.randomUUID();
        offsetCache.put(objectId1, 100L, 100, OptionalInt.of(200));
        offsetCache.put(objectId1, 200L, 100, OptionalInt.of(200));
        offsetCache.put(objectId1, 300L, 100, OptionalInt.of(200));
        Assert.assertEquals((long)2L, (long)offsetCache.size());
        Assert.assertNull((String)"least recent entry should have expired", (Object)offsetCache.get(objectId1, 100L));
        Assert.assertNotNull((Object)offsetCache.get(objectId1, 200L));
        Assert.assertNotNull((Object)offsetCache.get(objectId1, 300L));
        Assert.assertEquals((double)0.66666666666666, (double)offsetCache.hitRatio(), (double)1.0E-6);
        Assert.assertEquals((long)2L, (long)offsetCache.size());
    }
}

