/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kafka.log.OffsetIndex;
import kafka.log.OffsetPosition;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.FetchRequestTestUtils;
import kafka.tier.fetcher.OffsetIndexFetchRequest;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OffsetIndexFetchRequestTest {
    private OffsetIndex offsetIndex = null;
    private int maxEntries = 3;
    private long baseOffset = 45L;
    private TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
    private TierObjectStore.ObjectMetadata tierObjectMetadata = new TierObjectStore.ObjectMetadata(this.topicIdPartition, UUID.randomUUID(), 0, this.baseOffset, false);

    @Before
    public void setup() {
        this.offsetIndex = new OffsetIndex(this.nonExistentTempFile(), this.baseOffset, this.maxEntries * 8, true);
    }

    @After
    public void teardown() {
        if (this.offsetIndex != null) {
            this.offsetIndex.file().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyIndexFileTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(this.offsetIndex.file(), null);
        try {
            OffsetPosition result = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (TierObjectStore.ObjectMetadata)this.tierObjectMetadata, (long)55L);
            Assert.assertEquals((String)"an empty index file should return a segment position of 0", (long)0L, (long)result.position());
        }
        catch (Exception e) {
            Assert.fail((String)"unexpected exception");
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seekIndexFileExceptionTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.offsetIndex.append(50L, 50);
        this.offsetIndex.append(55L, 55);
        this.offsetIndex.append(60L, 60);
        this.offsetIndex.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(this.offsetIndex.file(), null);
        try {
            try {
                OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)FetchRequestTestUtils.ioExceptionThrowingTierObjectStore(), (TierObjectStore.ObjectMetadata)this.tierObjectMetadata, (long)30L);
            }
            catch (IOException e) {
                Assert.assertNotNull((String)"IoExceptions are not propagated correctly", (Object)e);
            }
            catch (Exception e) {
                Assert.fail((String)("Unexpected exception " + e));
            }
            CancellationContext canceledCancellationContext = CancellationContext.newContext();
            canceledCancellationContext.cancel();
            try {
                OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)canceledCancellationContext, (TierObjectStore)mockTierObjectStore, (TierObjectStore.ObjectMetadata)this.tierObjectMetadata, (long)30L);
            }
            catch (CancellationException cancellationException) {
            }
            catch (Exception e) {
                Assert.fail((String)"Unexpected exception");
            }
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seekIndexFileTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.offsetIndex.append(50L, 50);
        this.offsetIndex.append(55L, 55);
        this.offsetIndex.append(60L, 60);
        this.offsetIndex.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(this.offsetIndex.file(), null);
        try {
            OffsetPosition offsetPosition;
            try {
                offsetPosition = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (TierObjectStore.ObjectMetadata)this.tierObjectMetadata, (long)55L);
                Assert.assertEquals((String)"the desired offset position matches the appended position", (long)55L, (long)offsetPosition.position());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("unexpected exception " + e));
            }
            try {
                offsetPosition = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (TierObjectStore.ObjectMetadata)this.tierObjectMetadata, (long)100L);
                Assert.assertEquals((String)"if the desired offset is out of range, return the highest position in the index file", (long)60L, (long)offsetPosition.position());
            }
            catch (Exception e) {
                Assert.fail((String)"unexpected exception");
            }
            try {
                offsetPosition = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (TierObjectStore.ObjectMetadata)this.tierObjectMetadata, (long)30L);
                Assert.assertEquals((String)"if the desired offset is lower than all recorded offsets, return 0 for position", (long)0L, (long)offsetPosition.position());
            }
            catch (Exception e) {
                Assert.fail((String)"unexpected exception");
            }
            Assert.assertFalse((String)"The CancellationContext is not canceled", (boolean)cancellationContext.isCancelled());
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    private File nonExistentTempFile() {
        File file;
        try {
            file = TestUtils.tempFile();
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }
}

