/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.UUID;
import kafka.tier.serdes.MaterializationTrackingInfo;
import kafka.tier.serdes.TierPartitionStateHeader;
import kafka.tier.state.Header;
import kafka.tier.state.TierPartitionStatus;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d2A!\u0001\u0002\u0001\u0013\tQ\u0001*Z1eKJ$Vm\u001d;\u000b\u0005\r!\u0011!B:uCR,'BA\u0003\u0007\u0003\u0011!\u0018.\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u0005Q\u0001Q\"\u0001\u0002\t\u000bY\u0001A\u0011A\f\u0002!Q,7\u000f\u001e*fC\u0012DU-\u00193feZ\u0003D#\u0001\r\u0011\u0005-I\u0012B\u0001\u000e\r\u0005\u0011)f.\u001b;)\u0005Ua\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0015QWO\\5u\u0015\u0005\t\u0013aA8sO&\u00111E\b\u0002\u0005)\u0016\u001cH\u000fC\u0003&\u0001\u0011\u0005q#\u0001\tuKN$(+Z1e\u0011\u0016\fG-\u001a:We!\u0012A\u0005\b")
public class HeaderTest {
    @Test
    public void testReadHeaderV0() {
        UUID topicId = UUID.randomUUID();
        byte version = 0;
        int epoch = 0;
        TierPartitionStatus status = TierPartitionStatus.INIT;
        FlatBufferBuilder builder = new FlatBufferBuilder(100).forceDefaults(true);
        TierPartitionStateHeader.startTierPartitionStateHeader((FlatBufferBuilder)builder);
        int topicIdOffset = kafka.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)topicId.getMostSignificantBits(), (long)topicId.getLeastSignificantBits());
        TierPartitionStateHeader.addTopicId((FlatBufferBuilder)builder, (int)topicIdOffset);
        TierPartitionStateHeader.addTierEpoch((FlatBufferBuilder)builder, (int)epoch);
        TierPartitionStateHeader.addVersion((FlatBufferBuilder)builder, (byte)version);
        TierPartitionStateHeader.addStatus((FlatBufferBuilder)builder, (byte)TierPartitionStatus.toByte((TierPartitionStatus)status));
        int entryId = TierPartitionStateHeader.endTierPartitionStateHeader((FlatBufferBuilder)builder);
        builder.finish(entryId);
        Header header = new Header(TierPartitionStateHeader.getRootAsTierPartitionStateHeader((ByteBuffer)builder.dataBuffer()));
        Assert.assertEquals((long)version, (long)header.version());
        Assert.assertEquals((Object)topicId, (Object)header.topicId());
        Assert.assertEquals((long)epoch, (long)header.tierEpoch());
        Assert.assertEquals((Object)status, (Object)header.status());
        Assert.assertEquals((long)-1L, (long)header.endOffset());
        Assert.assertEquals((long)-1L, (long)header.localMaterializedOffset());
        Assert.assertEquals((long)-1L, (long)header.globalMaterializedOffset());
    }

    @Test
    public void testReadHeaderV2() {
        UUID topicId = UUID.randomUUID();
        byte version = 2;
        int epoch = 0;
        TierPartitionStatus status = TierPartitionStatus.INIT;
        int endOffset = 100;
        int localMaterializedOffset = 50;
        FlatBufferBuilder builder = new FlatBufferBuilder(100).forceDefaults(true);
        int materializedInfo = MaterializationTrackingInfo.createMaterializationTrackingInfo((FlatBufferBuilder)builder, (long)-1L, (long)localMaterializedOffset);
        TierPartitionStateHeader.startTierPartitionStateHeader((FlatBufferBuilder)builder);
        int topicIdOffset = kafka.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)topicId.getMostSignificantBits(), (long)topicId.getLeastSignificantBits());
        TierPartitionStateHeader.addTopicId((FlatBufferBuilder)builder, (int)topicIdOffset);
        TierPartitionStateHeader.addTierEpoch((FlatBufferBuilder)builder, (int)epoch);
        TierPartitionStateHeader.addVersion((FlatBufferBuilder)builder, (byte)version);
        TierPartitionStateHeader.addStatus((FlatBufferBuilder)builder, (byte)TierPartitionStatus.toByte((TierPartitionStatus)status));
        TierPartitionStateHeader.addEndOffset((FlatBufferBuilder)builder, (long)endOffset);
        TierPartitionStateHeader.addMaterializationInfo((FlatBufferBuilder)builder, (int)materializedInfo);
        int entryId = TierPartitionStateHeader.endTierPartitionStateHeader((FlatBufferBuilder)builder);
        builder.finish(entryId);
        Header header = new Header(TierPartitionStateHeader.getRootAsTierPartitionStateHeader((ByteBuffer)builder.dataBuffer()));
        Assert.assertEquals((long)version, (long)header.version());
        Assert.assertEquals((Object)topicId, (Object)header.topicId());
        Assert.assertEquals((long)epoch, (long)header.tierEpoch());
        Assert.assertEquals((Object)status, (Object)header.status());
        Assert.assertEquals((long)localMaterializedOffset, (long)header.localMaterializedOffset());
        Assert.assertEquals((long)-1L, (long)header.globalMaterializedOffset());
    }
}

