/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeManager;
import kafka.tier.tasks.ChangeManagerTest$;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.LeadershipChange;
import kafka.tier.tasks.MockTask;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.TierTaskQueue;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u0001%\u0011\u0011c\u00115b]\u001e,W*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!A\u0003uCN\\7O\u0003\u0002\u0006\r\u0005!A/[3s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u001d1\u0002A1A\u0005\n]\t1a\u0019;y+\u0005A\u0002CA\r\u001d\u001b\u0005Q\"BA\u000e\u0005\u0003\u001d1W\r^2iKJL!!\b\u000e\u0003'\r\u000bgnY3mY\u0006$\u0018n\u001c8D_:$X\r\u001f;\t\r}\u0001\u0001\u0015!\u0003\u0019\u0003\u0011\u0019G\u000f\u001f\u0011\t\u000f\u0005\u0002!\u0019!C\u0005E\u0005!A/[7f+\u0005\u0019\u0003C\u0001\u0013/\u001b\u0005)#B\u0001\u0014(\u0003\u0015)H/\u001b7t\u0015\tA\u0013&\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f)R!a\u000b\u0017\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0013aA8sO&\u0011q&\n\u0002\u0005)&lW\r\u0003\u00042\u0001\u0001\u0006IaI\u0001\u0006i&lW\r\t\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0003!i\u0017\r\u001f+bg.\u001cX#A\u001b\u0011\u0005-1\u0014BA\u001c\r\u0005\rIe\u000e\u001e\u0005\u0007s\u0001\u0001\u000b\u0011B\u001b\u0002\u00135\f\u0007\u0010V1tWN\u0004\u0003bB\u001e\u0001\u0005\u0004%I\u0001P\u0001\u0006cV,W/Z\u000b\u0002{A\u0019AC\u0010!\n\u0005}\u0012!!\u0004+jKJ$\u0016m]6Rk\u0016,X\r\u0005\u0002\u0015\u0003&\u0011!I\u0001\u0002\t\u001b>\u001c7\u000eV1tW\"1A\t\u0001Q\u0001\nu\na!];fk\u0016\u0004\u0003b\u0002$\u0001\u0005\u0004%IaR\u0001\u0014Y\u0016\fG-\u001a:DQ\u0006tw-Z'b]\u0006<WM]\u000b\u0002\u0011B\u0011A#S\u0005\u0003\u0015\n\u0011Qb\u00115b]\u001e,W*\u00198bO\u0016\u0014\bB\u0002'\u0001A\u0003%\u0001*\u0001\u000bmK\u0006$WM]\"iC:<W-T1oC\u001e,'\u000f\t\u0005\u0006\u001d\u0002!\taT\u0001\ti\u0016\f'\u000fZ8x]R\t\u0001\u000b\u0005\u0002\f#&\u0011!\u000b\u0004\u0002\u0005+:LG\u000f\u000b\u0002N)B\u0011Q\u000bW\u0007\u0002-*\u0011q\u000bL\u0001\u0006UVt\u0017\u000e^\u0005\u00033Z\u0013Q!\u00114uKJDQa\u0017\u0001\u0005\u0002=\u000bq\u0003^3ti2+\u0017\rZ3sg\"L\u0007o\u0014<feJLG-Z:)\u0005ik\u0006CA+_\u0013\tyfK\u0001\u0003UKN$\b\"B1\u0001\t\u0003y\u0015\u0001\t;fgRdU-\u00193feND\u0017\u000e]\"iC:<Wm]\"b]\u000e,G\u000eV1tWND#\u0001Y/\t\u000b\u0011\u0004A\u0011A(\u0002;Q,7\u000f^#yC\u000e$H._(oG\u0016$\u0016m]6Qe>\u001cWm]:j]\u001eD#aY/\t\u000b\u001d\u0004A\u0011A(\u0002OQ,7\u000f\u001e'fC\u0012,'o\u001d5ja\u000eC\u0017M\\4f\tV\u0014\u0018N\\4UCN\\W\t_3dkRLwN\u001c\u0015\u0003MvCQA\u001b\u0001\u0005\u0002=\u000bq\u0004^3ti2{7o](g\u0019\u0016\fG-\u001a:tQ&\u0004(+Z7pm\u0016\u001cH+Y:lQ\tIW\fC\u0003n\u0001\u0011\u0005q*A\u0007uKN$H+[7f\t\u0016d\u0017-\u001f\u0015\u0003YvCQ\u0001\u001d\u0001\u0005\u0002=\u000ba\u0002^3ti\u0016\u0013(o\u001c:Ti\u0006$X\r\u000b\u0002p;\")1\u000f\u0001C\u0001\u001f\u0006QB/Z:u\t\u0016d\u0017-_,ji\"lU\u000f\u001c;ja2,G+Y:lg\"\u0012!/\u0018\u0005\u0006m\u0002!\taT\u0001\u0011i\u0016\u001cH/T1y)\u0006\u001c8n\u001d)pY2D#!^/\t\u000be\u0004A\u0011A(\u00025Q,7\u000f\u001e+pa&\u001cG)\u001a7fi&|gn\u0015;paN$\u0016m]6)\u0005al\u0006\"\u0002?\u0001\t\u0003y\u0015\u0001\n;fgR\u001c\u0015M\\2fY2\fG/[8o%\u0016lwN^3t)\u0006\u001c8N\u0012:p[F+X-^3)\u0005ml\u0006\"B@\u0001\t\u0003y\u0015\u0001\u0004;fgR$\u0016m]6E_:,\u0007F\u0001@^\u0011\u0019\t)\u0001\u0001C\u0001\u001f\u0006yB/Z:u!J|7-Z:t%\u0016$XO\u001d8t\u001f:\fV/Z;f\u0007\"\fgnZ3)\u0007\u0005\rQ\f\u0003\u0004\u0002\f\u0001!\taT\u0001\u001ai\u0016\u001cH\u000f\u0015:pG\u0016\u001c8OU3ukJt7o\u00148DY>\u001cX\rK\u0002\u0002\nu\u0003")
public class ChangeManagerTest {
    private final CancellationContext kafka$tier$tasks$ChangeManagerTest$$ctx = CancellationContext.newContext();
    private final Time kafka$tier$tasks$ChangeManagerTest$$time = new MockTime();
    private final int kafka$tier$tasks$ChangeManagerTest$$maxTasks;
    private final TierTaskQueue<MockTask> queue = new TierTaskQueue<MockTask>(this){
        private final /* synthetic */ ChangeManagerTest $outer;

        public List<MockTask> sortTasks(List<MockTask> tasks) {
            return tasks;
        }

        public MockTask newTask(TopicIdPartition topicIdPartition, StartChangeMetadata metadata) {
            StartChangeMetadata startChangeMetadata = metadata;
            if (startChangeMetadata instanceof StartLeadership) {
                StartLeadership startLeadership = (StartLeadership)startChangeMetadata;
                MockTask mockTask = new MockTask(this.$outer.kafka$tier$tasks$ChangeManagerTest$$ctx().subContext(), topicIdPartition, startLeadership.leaderEpoch());
                return mockTask;
            }
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startChangeMetadata})));
        }

        public boolean mayProcess(ChangeMetadata metadata) {
            ChangeMetadata changeMetadata = metadata;
            boolean bl = changeMetadata instanceof LeadershipChange;
            return bl;
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super($outer.kafka$tier$tasks$ChangeManagerTest$$ctx().subContext(), $outer.kafka$tier$tasks$ChangeManagerTest$$maxTasks(), $outer.kafka$tier$tasks$ChangeManagerTest$$time());
        }
    };
    private final ChangeManager kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager = new ChangeManager(this.kafka$tier$tasks$ChangeManagerTest$$ctx().subContext(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TierTaskQueue[]{this.queue()})), this.kafka$tier$tasks$ChangeManagerTest$$time());

    public CancellationContext kafka$tier$tasks$ChangeManagerTest$$ctx() {
        return this.kafka$tier$tasks$ChangeManagerTest$$ctx;
    }

    public Time kafka$tier$tasks$ChangeManagerTest$$time() {
        return this.kafka$tier$tasks$ChangeManagerTest$$time;
    }

    public int kafka$tier$tasks$ChangeManagerTest$$maxTasks() {
        return this.kafka$tier$tasks$ChangeManagerTest$$maxTasks;
    }

    private TierTaskQueue<MockTask> queue() {
        return this.queue;
    }

    public ChangeManager kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager() {
        return this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager;
    }

    @After
    public void teardown() {
        this.kafka$tier$tasks$ChangeManagerTest$$ctx().cancel();
    }

    @Test
    public void testLeadershipOverrides() {
        TopicIdPartition tp1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition tp2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp1, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp1, 1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp2, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp2, 1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        List task = (List)this.queue().poll().get();
        Assert.assertEquals((long)2L, (long)task.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp1, tp2})), (Object)task.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicIdPartition apply(MockTask x$1) {
                return x$1.topicIdPartition();
            }
        }, List$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1})), (Object)task.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(MockTask x$2) {
                return x$2.leaderEpoch();
            }
        }, List$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testLeadershipChangesCancelTasks() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        TopicIdPartition tp1 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp1, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        List tasks = (List)this.queue().poll().get();
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp0, tp1})), (Object)tasks.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicIdPartition apply(MockTask x$3) {
                return x$3.topicIdPartition();
            }
        }, List$.MODULE$.canBuildFrom()));
        MockTask tp0Task = (MockTask)((Object)tasks.find((Function1)new Serializable(this, tp0){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition tp0$1;

            public final boolean apply(MockTask x$4) {
                TopicIdPartition topicIdPartition = x$4.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.tp0$1;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.tp0$1 = tp0$1;
            }
        }).get());
        MockTask tp1Task = (MockTask)((Object)tasks.find((Function1)new Serializable(this, tp1){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition tp1$1;

            public final boolean apply(MockTask x$5) {
                TopicIdPartition topicIdPartition = x$5.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.tp1$1;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.tp1$1 = tp1$1;
            }
        }).get());
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeFollower(tp0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        Assert.assertTrue((String)"expected tp0 task to be cancelled due to become follower", (boolean)tp0Task.ctx().isCancelled());
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp1, 1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        Assert.assertTrue((String)"expected tp1 task to be cancelled due to new leadership", (boolean)tp1Task.ctx().isCancelled());
    }

    @Test
    public void testExactlyOnceTaskProcessing() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        MockTask tp0Task = (MockTask)((Object)((IterableLike)this.queue().poll().get()).head());
        Assert.assertEquals((Object)tp0, (Object)tp0Task.topicIdPartition());
        Assert.assertTrue((String)"expected no other tasks to be available", (boolean)this.queue().poll().isEmpty());
        this.queue().done((TierTask)tp0Task);
        tp0Task = (MockTask)((Object)((IterableLike)this.queue().poll().get()).head());
        Assert.assertEquals((Object)tp0, (Object)tp0Task.topicIdPartition());
    }

    @Test
    public void testLeadershipChangeDuringTaskExecution() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        MockTask tp0Task = (MockTask)((Object)((IterableLike)this.queue().poll().get()).head());
        Assert.assertEquals((Object)tp0, (Object)tp0Task.topicIdPartition());
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        this.queue().done((TierTask)tp0Task);
        Assert.assertTrue((String)"expected task to be immediately canceled since a new onBecomeLeader event occurred", (boolean)tp0Task.ctx().isCancelled());
        List tasks = (List)Option$.MODULE$.option2Iterable(this.queue().poll()).head();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((long)1L, (long)((MockTask)((Object)tasks.head())).leaderEpoch());
        Assert.assertTrue((String)"expected to find nothing else in the queue", (boolean)this.queue().poll().isEmpty());
    }

    @Test
    public void testLossOfLeadershipRemovesTask() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        TopicIdPartition tp1 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp1, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        List tasks = (List)this.queue().poll().get();
        MockTask tp0Task = (MockTask)((Object)tasks.find((Function1)new Serializable(this, tp0){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition tp0$2;

            public final boolean apply(MockTask x$6) {
                TopicIdPartition topicIdPartition = x$6.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.tp0$2;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.tp0$2 = tp0$2;
            }
        }).get());
        MockTask tp1Task = (MockTask)((Object)tasks.find((Function1)new Serializable(this, tp1){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition tp1$2;

            public final boolean apply(MockTask x$7) {
                TopicIdPartition topicIdPartition = x$7.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.tp1$2;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.tp1$2 = tp1$2;
            }
        }).get());
        this.queue().done((TierTask)tp0Task);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeFollower(tp0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        Assert.assertTrue((String)"expected task to be cancelled due to leadership change", (boolean)tp0Task.ctx().isCancelled());
        Assert.assertEquals((String)"expected task to be removed from the queue due to leadership change", (long)1L, (long)this.queue().taskCount());
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeFollower(tp1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        Assert.assertTrue((String)"expected task to be cancelled due to leadership change", (boolean)tp1Task.ctx().isCancelled());
        Assert.assertEquals((String)"expected queue to be empty", (long)this.queue().taskCount(), (long)0L);
    }

    @Test
    public void testTimeDelay() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        MockTask tp0Task = (MockTask)((Object)((IterableLike)this.queue().poll().get()).head());
        Assert.assertEquals((Object)tp0Task.topicIdPartition(), (Object)tp0);
        tp0Task.retryTaskLater(5000, this.kafka$tier$tasks$ChangeManagerTest$$time().hiResClockMs(), new Throwable());
        this.queue().done((TierTask)tp0Task);
        Assert.assertTrue((boolean)this.queue().poll().isEmpty());
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(200L);
        Assert.assertTrue((boolean)this.queue().poll().isEmpty());
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(4801L);
        Assert.assertEquals((Object)tp0, (Object)((MockTask)((Object)((IterableLike)this.queue().poll().get()).head())).topicIdPartition());
    }

    @Test
    public void testErrorState() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        MockTask tp0Task = (MockTask)((Object)((IterableLike)this.queue().poll().get()).head());
        Assert.assertEquals((Object)tp0Task.topicIdPartition(), (Object)tp0);
        tp0Task.cancelAndSetErrorState(tp0Task, new Throwable("failed"));
        this.queue().done((TierTask)tp0Task);
        Assert.assertEquals((long)1L, (long)this.queue().errorPartitionCount());
        Assert.assertTrue((boolean)this.queue().poll().isEmpty());
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(200L);
        Assert.assertTrue((boolean)this.queue().poll().isEmpty());
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        Assert.assertTrue((boolean)this.queue().poll().isEmpty());
        TopicIdPartition tp1 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp1, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        MockTask tp1Task = (MockTask)((Object)((IterableLike)this.queue().poll().get()).head());
        Assert.assertEquals((Object)tp1Task.topicIdPartition(), (Object)tp1);
        Assert.assertEquals((long)1L, (long)this.queue().errorPartitionCount());
    }

    @Test
    public void testDelayWithMultipleTasks() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        TopicIdPartition tp1 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 1);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp1, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        List tasks = (List)this.queue().poll().get();
        Assert.assertEquals((long)2L, (long)tasks.size());
        MockTask tp0Task = (MockTask)((Object)tasks.find((Function1)new Serializable(this, tp0){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition tp0$3;

            public final boolean apply(MockTask x$8) {
                TopicIdPartition topicIdPartition = x$8.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.tp0$3;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.tp0$3 = tp0$3;
            }
        }).get());
        MockTask tp1Task = (MockTask)((Object)tasks.find((Function1)new Serializable(this, tp1){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition tp1$3;

            public final boolean apply(MockTask x$9) {
                TopicIdPartition topicIdPartition = x$9.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.tp1$3;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.tp1$3 = tp1$3;
            }
        }).get());
        tp0Task.retryTaskLater(5000, this.kafka$tier$tasks$ChangeManagerTest$$time().hiResClockMs(), new Throwable());
        this.queue().done((TierTask)tp0Task);
        this.queue().done((TierTask)tp1Task);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp1})), (Object)((List)this.queue().poll().get()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicIdPartition apply(MockTask x$10) {
                return x$10.topicIdPartition();
            }
        }, List$.MODULE$.canBuildFrom()));
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(200L);
        Assert.assertTrue((boolean)this.queue().poll().isEmpty());
        this.kafka$tier$tasks$ChangeManagerTest$$time().sleep(4801L);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp0})), (Object)((List)this.queue().poll().get()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicIdPartition apply(MockTask x$11) {
                return x$11.topicIdPartition();
            }
        }, List$.MODULE$.canBuildFrom()));
        Assert.assertEquals((long)2L, (long)this.queue().taskCount());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.queue().poll());
    }

    @Test
    public void testMaxTasksPoll() {
        int numTasks = 2 * this.kafka$tier$tasks$ChangeManagerTest$$maxTasks();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTasks).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChangeManagerTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TopicIdPartition tp = new TopicIdPartition(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), UUID.randomUUID(), 0);
                this.$outer.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp, 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        List tasks = (List)this.queue().poll().get();
        Assert.assertEquals((long)this.kafka$tier$tasks$ChangeManagerTest$$maxTasks(), (long)tasks.size());
        Assert.assertEquals((long)this.kafka$tier$tasks$ChangeManagerTest$$maxTasks(), (long)((SeqLike)tasks.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicIdPartition apply(MockTask x$12) {
                return x$12.topicIdPartition();
            }
        }, List$.MODULE$.canBuildFrom())).size());
        Assert.assertTrue((boolean)this.queue().poll().isEmpty());
        MockTask doneTask = (MockTask)((Object)tasks.head());
        this.queue().done((TierTask)doneTask);
        Assert.assertEquals((long)1L, (long)((SeqLike)this.queue().poll().get()).size());
    }

    @Test
    public void testTopicDeletionStopsTask() {
        TopicIdPartition tp = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        MockTask task = (MockTask)((Object)((IterableLike)this.queue().poll().get()).head());
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onDelete(tp);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        this.queue().done((TierTask)task);
        Assert.assertTrue((String)"expected task to be canceled", (boolean)task.ctx().isCancelled());
        Assert.assertEquals((String)"expected no tasks to be present", (long)0L, (long)this.queue().taskCount());
    }

    @Test
    public void testCancellationRemovesTaskFromQueue() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 0);
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        MockTask task = (MockTask)((Object)((IterableLike)this.queue().poll().get()).head());
        Assert.assertFalse((String)"expected task not to be canceled", (boolean)task.ctx().isCancelled());
        this.queue().withAllTasks((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Set<MockTask> allTasks) {
                Assert.assertTrue((String)"expected there to be at least one task in the queue", (boolean)allTasks.nonEmpty());
            }
        });
        task.ctx().cancel();
        this.queue().done((TierTask)task);
        this.queue().withAllTasks((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Set<MockTask> allTasks) {
                Assert.assertTrue((String)"expected all tasks to have been removed", (boolean)allTasks.isEmpty());
            }
        });
    }

    @Test
    public void testTaskDone() {
        int numTasks = this.kafka$tier$tasks$ChangeManagerTest$$maxTasks();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTasks).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChangeManagerTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TopicIdPartition tp = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), i);
                this.$outer.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp, 0);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().process();
        List polledTasks = (List)this.queue().poll().get();
        Assert.assertEquals((long)this.kafka$tier$tasks$ChangeManagerTest$$maxTasks(), (long)polledTasks.size());
        this.queue().done((TierTask)polledTasks.apply(0));
        this.queue().done((TierTask)polledTasks.apply(2));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MockTask[]{(MockTask)((Object)polledTasks.apply(0)), (MockTask)((Object)polledTasks.apply(2))})), (Object)this.queue().poll().get());
    }

    @Test
    public void testProcessReturnsOnQueueChange() {
        TopicIdPartition tp0 = new TopicIdPartition("foo", UUID.fromString("3036601f-dfb2-46e0-a809-69b710e0944a"), 0);
        Future future = Future$.MODULE$.apply((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChangeManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                package$.MODULE$.blocking((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$tier$tasks$ChangeManagerTest$$anonfun$$$outer().kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().processAtLeastOne();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ChangeManagerTest kafka$tier$tasks$ChangeManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Assert.assertFalse((boolean)future.isCompleted());
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().onBecomeLeader(tp0, 0);
        Await$.MODULE$.ready((Awaitable)future, (Duration)Duration$.MODULE$.create(200L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)future.isCompleted());
        Assert.assertTrue((boolean)((Try)future.value().get()).isSuccess());
        Assert.assertEquals((long)1L, (long)this.queue().taskCount());
    }

    @Test
    public void testProcessReturnsOnClose() {
        Future future = Future$.MODULE$.apply((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ChangeManagerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                package$.MODULE$.blocking((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$tier$tasks$ChangeManagerTest$$anonfun$$$outer().kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().processAtLeastOne();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ChangeManagerTest kafka$tier$tasks$ChangeManagerTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Assert.assertFalse((boolean)future.isCompleted());
        this.kafka$tier$tasks$ChangeManagerTest$$leaderChangeManager().close();
        Await$.MODULE$.ready((Awaitable)future, (Duration)Duration$.MODULE$.create(200L, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)future.isCompleted());
        Assert.assertTrue((boolean)((Try)future.value().get()).isFailure());
        Assert.assertEquals((long)0L, (long)this.queue().taskCount());
    }

    public ChangeManagerTest() {
        this.kafka$tier$tasks$ChangeManagerTest$$maxTasks = 3;
    }
}

