/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.archive;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.TierArchiver;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u0017\t\u0001B+[3s\u0003J\u001c\u0007.\u001b<feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq!\u0019:dQ&4XM\u0003\u0002\u0006\r\u0005)A/Y:lg*\u0011q\u0001C\u0001\u0005i&,'OC\u0001\n\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0003\u0019\u0001\u0011\u0005\u0011$\u0001\nuKN$H*Y4DC2\u001cW\u000f\\1uS>tG#\u0001\u000e\u0011\u00055Y\u0012B\u0001\u000f\u000f\u0005\u0011)f.\u001b;)\u0005]q\u0002CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0013aA8sO&\u0011Q\u0005\t\u0002\u0005)\u0016\u001cH\u000fC\u0003(\u0001\u0011%\u0001&A\u0006nKR\u0014\u0018n\u0019,bYV,WCA\u0015-)\tQS\u0007\u0005\u0002,Y1\u0001A!B\u0017'\u0005\u0004q#!\u0001+\u0012\u0005=\u0012\u0004CA\u00071\u0013\t\tdBA\u0004O_RD\u0017N\\4\u0011\u00055\u0019\u0014B\u0001\u001b\u000f\u0005\r\te.\u001f\u0005\u0006m\u0019\u0002\raN\u0001\u0005]\u0006lW\r\u0005\u00029w9\u0011Q\"O\u0005\u0003u9\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001f>\u0005\u0019\u0019FO]5oO*\u0011!H\u0004")
public class TierArchiverTest {
    @Test
    public void testLagCalculation() {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        TopicPartition partition1 = new TopicPartition("mytopic-1", 0);
        TopicPartition partition2 = new TopicPartition("mytopic-2", 0);
        TopicPartition partition3 = new TopicPartition("mytopic-3", 0);
        Map topicIdPartitionsMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition1), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition2), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition3), (Object)BoxesRunTime.boxToInteger((int)30))}));
        Iterable partitions = (Iterable)topicIdPartitionsMap.map((Function1)new Serializable(this, replicaManager){
            public static final long serialVersionUID = 0L;
            private final ReplicaManager replicaManager$1;

            public final Partition apply(Tuple2<TopicPartition, Object> x0$1) {
                Tuple2<TopicPartition, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    int segmentSize = tuple2._2$mcI$sp();
                    LogSegment segment = (LogSegment)Mockito.mock(LogSegment.class);
                    Mockito.when((Object)BoxesRunTime.boxToInteger((int)segment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)segmentSize));
                    AbstractLog log2 = (AbstractLog)Mockito.mock(AbstractLog.class);
                    Mockito.when((Object)this.replicaManager$1.getLog(topicPartition)).thenReturn((Object)new Some((Object)log2));
                    Mockito.when((Object)log2.tierableLogSegments()).thenReturn((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{segment, segment, segment, segment})));
                    Mockito.when((Object)log2.topicPartition()).thenReturn((Object)topicPartition);
                    TierPartitionState tierPartitionState2 = (TierPartitionState)Mockito.mock(TierPartitionState.class);
                    Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)tierPartitionState2.isTieringEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    Mockito.when((Object)log2.tierPartitionState()).thenReturn((Object)tierPartitionState2);
                    Partition partition = (Partition)Mockito.mock(Partition.class);
                    Mockito.when((Object)partition.log()).thenReturn((Object)new Some((Object)log2));
                    Partition partition2 = partition;
                    return partition2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.replicaManager$1 = replicaManager$1;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer((Answer)new Answer<Iterator<Partition>>(this, partitions){
            private final Iterable partitions$1;

            public Iterator<Partition> answer(InvocationOnMock invocation) {
                return this.partitions$1.iterator();
            }
            {
                this.partitions$1 = partitions$1;
            }
        });
        TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        MockTime time = new MockTime();
        TierTasksConfig config = new TierTasksConfig(2, TierTasksConfig$.MODULE$.apply$default$2(), TierTasksConfig$.MODULE$.apply$default$3(), TierTasksConfig$.MODULE$.apply$default$4(), TierTasksConfig$.MODULE$.apply$default$5());
        TestUtils$.MODULE$.clearYammerMetrics();
        TierArchiver archiver = new TierArchiver(config, replicaManager, (TierTopicAppender)tierTopicManager, tierObjectStore, CancellationContext.newContext(), config.numThreads(), (Time)time, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        List laggingPartitions = archiver.partitionLagInfo();
        Assert.assertEquals((long)3L, (long)laggingPartitions.size());
        Assert.assertEquals((Object)new Tuple2((Object)partition3, (Object)BoxesRunTime.boxToInteger((int)120)), (Object)laggingPartitions.apply(0));
        Assert.assertEquals((Object)new Tuple2((Object)partition1, (Object)BoxesRunTime.boxToInteger((int)80)), (Object)laggingPartitions.apply(1));
        Assert.assertEquals((Object)new Tuple2((Object)partition2, (Object)BoxesRunTime.boxToInteger((int)40)), (Object)laggingPartitions.apply(2));
        archiver.logPartitionLagInfo();
        Assert.assertEquals((long)240L, (long)BoxesRunTime.unboxToLong(this.metricValue("TotalLag")));
        Assert.assertEquals((long)120L, (long)BoxesRunTime.unboxToLong(this.metricValue("PartitionLagMaxValue")));
        Assert.assertEquals((long)3L, (long)BoxesRunTime.unboxToInt(this.metricValue("LaggingPartitionsCount")));
    }

    private <T> T metricValue(String name) {
        return (T)((Gauge)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final String name$1;

            public final boolean apply(MetricName x$1) {
                String string = x$1.getName();
                String string2 = this.name$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.name$1 = name$1;
            }
        }).values().headOption().get()).value();
    }
}

