/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierRecordType;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.topic.TierMessageFormatter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;

public class TierMessageFormatterTest {
    private TierMessageFormatter formatter = new TierMessageFormatter();

    @Test
    public void formatTierTopicInitLeaderTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID messageId = UUID.randomUUID();
        TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, 1, messageId, 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", topicIdPartition.partition(), 0L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1L, -1, -1, (Object)initLeader.serializeKey(), (Object)initLeader.serializeValue());
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %s): %s\n", topicIdPartition.partition(), record.offset(), Instant.ofEpochMilli(record.timestamp()), initLeader.toString());
        Assert.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatTierPartitionDeleteInitiateTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID messageId = UUID.randomUUID();
        TierPartitionDeleteInitiate partDeleteInit = new TierPartitionDeleteInitiate(topicIdPartition, 1, messageId);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", topicIdPartition.partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1L, -1, -1, (Object)partDeleteInit.serializeKey(), (Object)partDeleteInit.serializeValue());
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %s): %s\n", topicIdPartition.partition(), record.offset(), Instant.ofEpochMilli(record.timestamp()), partDeleteInit.toString());
        Assert.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatTierSegmentDeleteTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        TierSegmentDeleteInitiate segDeleteInit = new TierSegmentDeleteInitiate(topicIdPartition, 1, UUID.randomUUID());
        TierSegmentDeleteComplete segDeleteComplete = new TierSegmentDeleteComplete(topicIdPartition, 1, UUID.randomUUID());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord initRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1L, -1, -1, (Object)segDeleteInit.serializeKey(), (Object)segDeleteInit.serializeValue());
        this.formatter.writeTo(initRecord, ps);
        ConsumerRecord completeRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 2L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1L, -1, -1, (Object)segDeleteComplete.serializeKey(), (Object)segDeleteComplete.serializeValue());
        this.formatter.writeTo(completeRecord, ps);
        String expected = String.format("(%d, %d, %s): %s\n(%d, %d, %s): %s\n", topicIdPartition.partition(), initRecord.offset(), Instant.ofEpochMilli(initRecord.timestamp()), segDeleteInit.toString(), topicIdPartition.partition(), completeRecord.offset(), Instant.ofEpochMilli(completeRecord.timestamp()), segDeleteComplete.toString());
        Assert.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatTierSegmentUploadTest() {
        UUID topicId = UUID.randomUUID();
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        TierSegmentUploadInitiate segUploadInit = new TierSegmentUploadInitiate(topicIdPartition, 1, UUID.randomUUID(), 0L, 0L, 0L, 0, false, false, false);
        TierSegmentUploadComplete segUploadComplete = new TierSegmentUploadComplete(topicIdPartition, 1, UUID.randomUUID());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord initRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1L, -1, -1, (Object)segUploadInit.serializeKey(), (Object)segUploadInit.serializeValue());
        this.formatter.writeTo(initRecord, ps);
        ConsumerRecord completeRecord = new ConsumerRecord("foo", topicIdPartition.partition(), 2L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1L, -1, -1, (Object)segUploadComplete.serializeKey(), (Object)segUploadComplete.serializeValue());
        this.formatter.writeTo(completeRecord, ps);
        String expected = String.format("(%d, %d, %s): %s\n(%d, %d, %s): %s\n", topicIdPartition.partition(), initRecord.offset(), Instant.ofEpochMilli(initRecord.timestamp()), segUploadInit.toString(), topicIdPartition.partition(), completeRecord.offset(), Instant.ofEpochMilli(completeRecord.timestamp()), segUploadComplete.toString());
        Assert.assertEquals((Object)expected, (Object)baos.toString());
    }

    @Test
    public void formatDeserializationFailureTest() {
        UnknownTierMetadata unknown = new UnknownTierMetadata();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ConsumerRecord record = new ConsumerRecord("foo", 0, 1L, System.currentTimeMillis(), TimestampType.LOG_APPEND_TIME, -1L, -1, -1, (Object)unknown.serializeKey(), (Object)unknown.serializeValue());
        this.formatter.writeTo(record, ps);
        String expected = String.format("(%d, %d, %s): failed to deserialize tier metadata. Error message: Deserialization error [Unknown id -1]. Record: %s\n", record.partition(), record.offset(), Instant.ofEpochMilli(record.timestamp()), record.toString());
        Assert.assertEquals((Object)expected, (Object)baos.toString());
    }

    private class UnknownTierMetadata
    extends AbstractTierMetadata {
        private UnknownTierMetadata() {
        }

        public TierRecordType type() {
            return null;
        }

        public TopicIdPartition topicIdPartition() {
            return new TopicIdPartition("foo", UUID.randomUUID(), 0);
        }

        public ByteBuffer payloadBuffer() {
            return null;
        }

        public int tierEpoch() {
            return 0;
        }

        public UUID messageId() {
            return UUID.randomUUID();
        }

        public byte[] serializeValue() {
            return new byte[]{-1};
        }
    }
}

