/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Supplier;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.exceptions.TierMetadataDeserializationException;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.InitializedTierTopic;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u0001%\u0011Q\u0003V5feR{\u0007/[2D_:\u001cX/\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)Ao\u001c9jG*\u0011QAB\u0001\u0005i&,'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0006\u0011\u0005-qQ\"\u0001\u0007\u000b\u00035\tQa]2bY\u0006L!a\u0004\u0007\u0003\r\u0005s\u0017PU3g\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u0015\u00015\t!!\u0002\u0003\u0017\u0001\u00119\"\u0001E\"p]N,X.\u001a:TkB\u0004H.[3s!\u0011A2$H\u000f\u000e\u0003eQ!A\u0007\u0003\u0002\r\rd\u0017.\u001a8u\u0013\ta\u0012D\u0001\u000bN_\u000e\\7i\u001c8tk6,'oU;qa2LWM\u001d\t\u0004\u0017y\u0001\u0013BA\u0010\r\u0005\u0015\t%O]1z!\tY\u0011%\u0003\u0002#\u0019\t!!)\u001f;f\u000b\u0011!\u0003\u0001B\u0013\u0003!A\u0013x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0003\u0002\r';uI!aJ\r\u0003)5{7m\u001b)s_\u0012,8-\u001a:TkB\u0004H.[3s\u0011\u001dI\u0003A1A\u0005\n)\n\u0011b\u00197vgR,'/\u00133\u0016\u0003-\u0002\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\t1\fgn\u001a\u0006\u0002a\u0005!!.\u0019<b\u0013\t\u0011TF\u0001\u0004TiJLgn\u001a\u0005\u0007i\u0001\u0001\u000b\u0011B\u0016\u0002\u0015\rdWo\u001d;fe&#\u0007\u0005C\u00047\u0001\t\u0007I\u0011B\u001c\u0002\u000fQ,W\u000e\u001d#jeV\t\u0001\b\u0005\u0002:y5\t!H\u0003\u0002<_\u0005\u0011\u0011n\\\u0005\u0003{i\u0012AAR5mK\"1q\b\u0001Q\u0001\na\n\u0001\u0002^3na\u0012K'\u000f\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003+\u0003\u0019awn\u001a#je\"11\t\u0001Q\u0001\n-\nq\u0001\\8h\t&\u0014\b\u0005C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u000f1|w\rR5sgV\tq\tE\u0002I\u0017.j\u0011!\u0013\u0006\u0003\u0015>\nA!\u001e;jY&\u0011A*\u0013\u0002\n\u0003J\u0014\u0018-\u001f'jgRDaA\u0014\u0001!\u0002\u00139\u0015\u0001\u00037pO\u0012K'o\u001d\u0011\t\u000fA\u0003!\u0019!C\u0005#\u00061B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7/F\u0001S!\tY1+\u0003\u0002U\u0019\t)1\u000b[8si\"1a\u000b\u0001Q\u0001\nI\u000bq\u0003^5feR{\u0007/[2Ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\t\u000fa\u0003!\u0019!C\u00053\u0006!B/[3s)>\u0004\u0018n\u0019)beRLG/[8oKJ,\u0012A\u0017\t\u0003)mK!\u0001\u0018\u0002\u0003)QKWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\3s\u0011\u0019q\u0006\u0001)A\u00055\u0006)B/[3s)>\u0004\u0018n\u0019)beRLG/[8oKJ\u0004\u0003b\u00021\u0001\u0005\u0004%I!Y\u0001\u0017i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cuN\u001c4jOV\t!\r\u0005\u0002\u0015G&\u0011AM\u0001\u0002\u0017)&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cuN\u001c4jO\"1a\r\u0001Q\u0001\n\t\fq\u0003^5feR{\u0007/[2NC:\fw-\u001a:D_:4\u0017n\u001a\u0011\t\u000f!\u0004!\u0019!C\u0005U\u0005iA/[3s)>\u0004\u0018n\u0019(b[\u0016DaA\u001b\u0001!\u0002\u0013Y\u0013A\u0004;jKJ$v\u000e]5d\u001d\u0006lW\r\t\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0003M!\u0018.\u001a:U_BL7\rU1si&$\u0018n\u001c8t+\u0005q\u0007c\u0001%pc&\u0011\u0001/\u0013\u0002\u0004'\u0016$\bC\u0001:{\u001b\u0005\u0019(B\u0001;v\u0003\u0019\u0019w.\\7p]*\u0011qA\u001e\u0006\u0003ob\fa!\u00199bG\",'\"A=\u0002\u0007=\u0014x-\u0003\u0002|g\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB?\u0001A\u0003%a.\u0001\u000buS\u0016\u0014Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\t\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002\u0005IA/[3s)>\u0004\u0018nY\u000b\u0003\u0003\u0007\u00012\u0001FA\u0003\u0013\r\t9A\u0001\u0002\u0015\u0013:LG/[1mSj,G\rV5feR{\u0007/[2\t\u0011\u0005-\u0001\u0001)A\u0005\u0003\u0007\t!\u0002^5feR{\u0007/[2!\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\"\u0001\tqe>$WoY3s'V\u0004\b\u000f\\5feV\tQ\u0005C\u0004\u0002\u0016\u0001\u0001\u000b\u0011B\u0013\u0002#A\u0014x\u000eZ;dKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0005C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003\u0002\u001c\u00059\u0002O]5nCJL8i\u001c8tk6,'oU;qa2LWM]\u000b\u0002/!9\u0011q\u0004\u0001!\u0002\u00139\u0012\u0001\u00079sS6\f'/_\"p]N,X.\u001a:TkB\u0004H.[3sA!I\u00111\u0005\u0001C\u0002\u0013%\u00111D\u0001\u0018G\u0006$8\r[;q\u0007>t7/^7feN+\b\u000f\u001d7jKJDq!a\n\u0001A\u0003%q#\u0001\rdCR\u001c\u0007.\u001e9D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0002B\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\u00023QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\\7nSR$XM]\u000b\u0003\u0003_\u0001B!!\r\u000245\tA!C\u0002\u00026\u0011\u0011\u0011\u0004V5feR{\u0007/[2NC:\fw-\u001a:D_6l\u0017\u000e\u001e;fe\"A\u0011\u0011\b\u0001!\u0002\u0013\ty#\u0001\u000euS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{W.\\5ui\u0016\u0014\b\u0005C\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002@\u0005\tB/[3s)>\u0004\u0018nY\"p]N,X.\u001a:\u0016\u0005\u0005\u0005\u0003c\u0001\u000b\u0002D%\u0019\u0011Q\t\u0002\u0003#QKWM\u001d+pa&\u001c7i\u001c8tk6,'\u000f\u0003\u0005\u0002J\u0001\u0001\u000b\u0011BA!\u0003I!\u0018.\u001a:U_BL7mQ8ogVlWM\u001d\u0011\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u0005)1/\u001a;vaR\u0011\u0011\u0011\u000b\t\u0004\u0017\u0005M\u0013bAA+\u0019\t!QK\\5uQ\u0011\tY%!\u0017\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u0018y\u0003\u0015QWO\\5u\u0013\u0011\t\u0019'!\u0018\u0003\r\t+gm\u001c:f\u0011\u001d\t9\u0007\u0001C\u0001\u0003\u001f\na\u0003^3tiJ+w-[:uKJ\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0005\u0003K\nY\u0007\u0005\u0003\u0002\\\u00055\u0014\u0002BA8\u0003;\u0012A\u0001V3ti\"9\u00111\u000f\u0001\u0005\u0002\u0005=\u0013A\u000e;fgR\u0004&/[7bef\u001cuN\\:v[\u0016\u00148+Z3lgR{G*Y:u\u0007>lW.\u001b;uK\u0012|eMZ:fi>s7\u000b^1siV\u0004\b\u0006BA9\u0003WBq!!\u001f\u0001\t\u0003\ty%A\nuKN$8)\u0019;dQV\u00048i\\7qY\u0016$X\r\u000b\u0003\u0002x\u0005-\u0004bBA@\u0001\u0011\u0005\u0011qJ\u0001\u0014i\u0016\u001cHoR1sE\u0006<W\rS1oI2Lgn\u001a\u0015\u0005\u0003{\nY\u0007")
public class TierTopicConsumerTest {
    private final String clusterId;
    private final File tempDir = TestUtils$.MODULE$.tempDir();
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final short tierTopicNumPartitions = (short)7;
    private final TierTopicPartitioner kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner = new TierTopicPartitioner((int)this.tierTopicNumPartitions());
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig((Supplier)new Supplier<Map<String, Object>>(this){

        public Map<String, Object> get() {
            return Collections.singletonMap("bootstrap.servers", "bootstrap");
        }
    }, "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private final String kafka$tier$topic$TierTopicConsumerTest$$tierTopicName = TierTopic.topicName((String)"");
    private final java.util.Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (int)this.tierTopicNumPartitions());
    private final InitializedTierTopic tierTopic = (InitializedTierTopic)Mockito.mock(InitializedTierTopic.class);
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final TierTopicManagerCommitter kafka$tier$topic$TierTopicConsumerTest$$tierTopicManagerCommitter = (TierTopicManagerCommitter)Mockito.mock(TierTopicManagerCommitter.class);
    private final TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(this.tierTopicManagerConfig(), this.primaryConsumerSupplier(), this.catchupConsumerSupplier(), this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicManagerCommitter());

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    public TierTopicPartitioner kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner() {
        return this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public String kafka$tier$topic$TierTopicConsumerTest$$tierTopicName() {
        return this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName;
    }

    private java.util.Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private InitializedTierTopic tierTopic() {
        return this.tierTopic;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> primaryConsumerSupplier() {
        return this.primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    public TierTopicManagerCommitter kafka$tier$topic$TierTopicConsumerTest$$tierTopicManagerCommitter() {
        return this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicManagerCommitter;
    }

    private TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.tierTopic().numPartitions()).thenReturn((Object)OptionalInt.of(this.tierTopicNumPartitions()));
        Mockito.when((Object)this.tierTopic().topicName()).thenReturn((Object)this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName());
        Mockito.when((Object)this.tierTopic().toTierTopicPartition((TopicIdPartition)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<TopicPartition>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public TopicPartition answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartition((TopicIdPartition)((TopicIdPartition)invocation.getArgument(0)), (String)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (TierTopicPartitioner)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.tierTopic().toTierTopicPartitions((Collection)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<java.util.Set<TopicPartition>>(this){
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public java.util.Set<TopicPartition> answer(InvocationOnMock invocation) {
                return TierTopic.toTierTopicPartitions((Collection)((Collection)invocation.getArgument(0)), (String)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicName(), (TierTopicPartitioner)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicPartitioner());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Mockito.when((Object)this.kafka$tier$topic$TierTopicConsumerTest$$tierTopicManagerCommitter().positionFor(BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()))).thenReturn(null);
    }

    @Test
    public void testRegisterPartitions() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
        TopicIdPartition tp_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_3 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_3.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TopicIdPartition tp_4 = new TopicIdPartition("foo-4", UUID.randomUUID(), 0);
        TierTopicConsumer.ClientCtx ctx_4 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_4.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().register(tp_3, ctx_3);
        this.tierTopicConsumer().register(tp_4, ctx_4);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2, tp_3, tp_4})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().onlinePartitions().keySet()).asScala());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3, tp_4})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchingUpPartitions().keySet()).asScala());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().immigratingPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_3, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_4, (VerificationMode)Mockito.times((int)1))).beginCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)1))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)1))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_3, (VerificationMode)Mockito.times((int)1))).status();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_4, (VerificationMode)Mockito.times((int)1))).status();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_2});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_3});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx_4});
        Assert.assertEquals((Object)this.tierTopic().toTierTopicPartitions((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_3, tp_4}))).asJava()), (Object)this.catchupConsumerSupplier().consumers().get(0).assignment());
        Assert.assertEquals(this.tierTopicPartitions(), (Object)this.primaryConsumerSupplier().consumers().get(0).assignment());
    }

    @Test
    public void testPrimaryConsumerSeeksToLastCommittedOffsetOnStartup() {
        scala.collection.mutable.Set committedOffsetMap = (scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicPartitions()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tierTopicPartition) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierTopicPartition), (Object)BoxesRunTime.boxToLong((long)((long)tierTopicPartition.partition() + 100L)));
            }
        }, Set$.MODULE$.canBuildFrom());
        committedOffsetMap.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public final OngoingStubbing<Long> apply(Tuple2<TopicPartition, Object> x0$1) {
                Tuple2<TopicPartition, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition tierTopicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    OngoingStubbing ongoingStubbing = Mockito.when((Object)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)Predef$.MODULE$.long2Long(offset));
                    return ongoingStubbing;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        Assert.assertNotNull((Object)this.tierTopicConsumer().tierTopic());
        Consumer<byte[], byte[]> primaryConsumer = this.primaryConsumerSupplier().consumers().get(0);
        Assert.assertEquals(this.tierTopicPartitions(), (Object)primaryConsumer.assignment());
        committedOffsetMap.foreach((Function1)new Serializable(this, primaryConsumer){
            public static final long serialVersionUID = 0L;
            private final Consumer primaryConsumer$1;

            public final void apply(Tuple2<TopicPartition, Object> x0$2) {
                Tuple2<TopicPartition, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition tierTopicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    Assert.assertEquals((long)offset, (long)this.primaryConsumer$1.position(tierTopicPartition));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.primaryConsumer$1 = primaryConsumer$1;
            }
        });
    }

    @Test
    public void testCatchupComplete() {
        TopicIdPartition tp_1 = new TopicIdPartition("foo-1", UUID.fromString("26081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_1.status()).thenReturn((Object)TierPartitionStatus.INIT);
        TopicIdPartition tp_2 = new TopicIdPartition("foo-2", UUID.fromString("36081828-71a4-453f-ab1b-6ea27c5f65fb"), 0);
        TierTopicConsumer.ClientCtx ctx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
        Mockito.when((Object)ctx_2.status()).thenReturn((Object)TierPartitionStatus.CATCHUP);
        scala.collection.mutable.Set committedOffsetMap = (scala.collection.mutable.Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicPartitions()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tierTopicPartition) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierTopicPartition), (Object)BoxesRunTime.boxToLong((long)100L));
            }
        }, Set$.MODULE$.canBuildFrom());
        committedOffsetMap.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTopicConsumerTest $outer;

            public final OngoingStubbing<Long> apply(Tuple2<TopicPartition, Object> x0$3) {
                Tuple2<TopicPartition, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicPartition tierTopicPartition = (TopicPartition)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    OngoingStubbing ongoingStubbing = Mockito.when((Object)this.$outer.kafka$tier$topic$TierTopicConsumerTest$$tierTopicManagerCommitter().positionFor(tierTopicPartition.partition())).thenReturn((Object)Predef$.MODULE$.long2Long(offset));
                    return ongoingStubbing;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.tierTopicConsumer().initialize(this.tierTopic());
        this.tierTopicConsumer().doWork();
        this.tierTopicConsumer().register(tp_1, ctx_1);
        this.tierTopicConsumer().register(tp_2, ctx_2);
        this.tierTopicConsumer().doWork();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchingUpPartitions().keySet()).asScala());
        Consumer<byte[], byte[]> catchupConsumer = this.catchupConsumerSupplier().consumers().get(0);
        scala.collection.mutable.Set assignment2 = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(catchupConsumer.assignment()).asScala();
        Assert.assertEquals((long)2L, (long)assignment2.size());
        assignment2.foreach((Function1)new Serializable(this, catchupConsumer){
            public static final long serialVersionUID = 0L;
            private final Consumer catchupConsumer$1;

            public final void apply(TopicPartition assignedPartition) {
                this.catchupConsumer$1.seek(assignedPartition, 50L);
            }
            {
                this.catchupConsumer$1 = catchupConsumer$1;
            }
        });
        this.tierTopicConsumer().doWork();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchingUpPartitions().keySet()).asScala());
        catchupConsumer.seek((TopicPartition)assignment2.head(), 100L);
        this.tierTopicConsumer().doWork();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchingUpPartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)0))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)0))).completeCatchup();
        catchupConsumer.seek((TopicPartition)assignment2.head(), 100L);
        catchupConsumer.seek((TopicPartition)assignment2.last(), 150L);
        this.tierTopicConsumer().doWork();
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().catchingUpPartitions().keySet()).asScala());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{tp_1, tp_2})), (Object)JavaConverters$.MODULE$.asScalaSetConverter(this.tierTopicConsumer().onlinePartitions().keySet()).asScala());
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_1, (VerificationMode)Mockito.times((int)1))).completeCatchup();
        ((TierTopicConsumer.ClientCtx)Mockito.verify((Object)ctx_2, (VerificationMode)Mockito.times((int)1))).completeCatchup();
    }

    @Test
    public void testGarbageHandling() {
        ConsumerRecord garbageRecord = new ConsumerRecord("foo-1", 0, 1L, (Object)"key".getBytes(), (Object)"value".getBytes());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, garbageRecord){
            public static final long serialVersionUID = 0L;
            private final ConsumerRecord garbageRecord$1;

            public final Optional<AbstractTierMetadata> apply() {
                return AbstractTierMetadata.deserialize((byte[])((byte[])this.garbageRecord$1.key()), (byte[])((byte[])this.garbageRecord$1.value()));
            }
            {
                this.garbageRecord$1 = garbageRecord$1;
            }
        }, ClassTag$.MODULE$.apply(TierMetadataDeserializationException.class), new Position("TierTopicConsumerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
    }

    public TierTopicConsumerTest() {
        this.clusterId = "mycluster";
    }
}

