/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import kafka.admin.AdminOperationException;
import kafka.admin.RackAwareMode;
import kafka.log.Log$;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tma\u0001B\u0001\u0003\u0001%\u0011A\u0003V5feR{\u0007/[2NC:\fw-\u001a:UKN$(BA\u0002\u0005\u0003\u0015!x\u000e]5d\u0015\t)a!\u0001\u0003uS\u0016\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0003\t\u0003\u00179i\u0011\u0001\u0004\u0006\u0002\u001b\u0005)1oY1mC&\u0011q\u0002\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bE\u0001A\u0011\u0001\n\u0002\rqJg.\u001b;?)\u0005\u0019\u0002C\u0001\u000b\u0001\u001b\u0005\u0011Q\u0001\u0002\f\u0001\t]\u0011\u0001cQ8ogVlWM]*vaBd\u0017.\u001a:\u0011\taYR$H\u0007\u00023)\u0011!\u0004B\u0001\u0007G2LWM\u001c;\n\u0005qI\"\u0001F'pG.\u001cuN\\:v[\u0016\u00148+\u001e9qY&,'\u000fE\u0002\f=\u0001J!a\b\u0007\u0003\u000b\u0005\u0013(/Y=\u0011\u0005-\t\u0013B\u0001\u0012\r\u0005\u0011\u0011\u0015\u0010^3\u0006\t\u0011\u0002A!\n\u0002\u0011!J|G-^2feN+\b\u000f\u001d7jKJ\u0004B\u0001\u0007\u0014\u001e;%\u0011q%\u0007\u0002\u0015\u001b>\u001c7\u000e\u0015:pIV\u001cWM]*vaBd\u0017.\u001a:\t\u000f%\u0002!\u0019!C\u0005U\u0005I1\r\\;ti\u0016\u0014\u0018\nZ\u000b\u0002WA\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0005Y\u0006twMC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#AB*ue&tw\r\u0003\u00045\u0001\u0001\u0006IaK\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%IaN\u0001\bi\u0016l\u0007\u000fR5s+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e0\u0003\tIw.\u0003\u0002>u\t!a)\u001b7f\u0011\u0019y\u0004\u0001)A\u0005q\u0005AA/Z7q\t&\u0014\b\u0005C\u0004B\u0001\t\u0007I\u0011\u0002\u0016\u0002\r1|w\rR5s\u0011\u0019\u0019\u0005\u0001)A\u0005W\u00059An\\4ESJ\u0004\u0003bB#\u0001\u0005\u0004%IAR\u0001\bY><G)\u001b:t+\u00059\u0005c\u0001%LW5\t\u0011J\u0003\u0002K_\u0005!Q\u000f^5m\u0013\ta\u0015JA\u0005BeJ\f\u0017\u0010T5ti\"1a\n\u0001Q\u0001\n\u001d\u000b\u0001\u0002\\8h\t&\u00148\u000f\t\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0003Y!\u0018.\u001a:U_BL7MT;n!\u0006\u0014H/\u001b;j_:\u001cX#\u0001*\u0011\u0005-\u0019\u0016B\u0001+\r\u0005\u0015\u0019\u0006n\u001c:u\u0011\u00191\u0006\u0001)A\u0005%\u00069B/[3s)>\u0004\u0018n\u0019(v[B\u000b'\u000f^5uS>t7\u000f\t\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0003Y!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<W#\u0001.\u0011\u0005QY\u0016B\u0001/\u0003\u0005Y!\u0016.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<\u0007B\u00020\u0001A\u0003%!,A\fuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5hA!9\u0001\r\u0001b\u0001\n\u0013Q\u0013!\u0004;jKJ$v\u000e]5d\u001d\u0006lW\r\u0003\u0004c\u0001\u0001\u0006IaK\u0001\u000fi&,'\u000fV8qS\u000et\u0015-\\3!\u0011\u001d!\u0007A1A\u0005\n\u0015\f1\u0003^5feR{\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012A\u001a\t\u0004\u0011\u001eL\u0017B\u00015J\u0005\r\u0019V\r\u001e\t\u0003UJl\u0011a\u001b\u0006\u0003Y6\faaY8n[>t'BA\u0004o\u0015\ty\u0007/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002c\u0006\u0019qN]4\n\u0005M\\'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007k\u0002\u0001\u000b\u0011\u00024\u0002)QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0011\u001d9\bA1A\u0005\na\f\u0001\u0003\u001d:pIV\u001cWM]*vaBd\u0017.\u001a:\u0016\u0003\u0015BaA\u001f\u0001!\u0002\u0013)\u0013!\u00059s_\u0012,8-\u001a:TkB\u0004H.[3sA!9A\u0010\u0001b\u0001\n\u0013i\u0018a\u00069sS6\f'/_\"p]N,X.\u001a:TkB\u0004H.[3s+\u00059\u0002BB@\u0001A\u0003%q#\u0001\rqe&l\u0017M]=D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0002B\u0001\"a\u0001\u0001\u0005\u0004%I!`\u0001\u0018G\u0006$8\r[;q\u0007>t7/^7feN+\b\u000f\u001d7jKJDq!a\u0002\u0001A\u0003%q#\u0001\rdCR\u001c\u0007.\u001e9D_:\u001cX/\\3s'V\u0004\b\u000f\\5fe\u0002B\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\u0002\u001b\u0005$W.\u001b8[W\u000ec\u0017.\u001a8u+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BB\u0001\u0003u.LA!!\u0007\u0002\u0014\ti\u0011\tZ7j]j[7\t\\5f]RD\u0001\"!\b\u0001A\u0003%\u0011qB\u0001\u000fC\u0012l\u0017N\u001c.l\u00072LWM\u001c;!\u0011%\t\t\u0003\u0001b\u0001\n\u0013\t\u0019#A\nbI6Lgn\u00117jK:$8+\u001e9qY&,'/\u0006\u0002\u0002&I1\u0011qEA\u0018\u0003k1q!!\u000b\u0002,\u0001\t)C\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0013\u0003Q\tG-\\5o\u00072LWM\u001c;TkB\u0004H.[3sAA\u0019A&!\r\n\u0007\u0005MRF\u0001\u0004PE*,7\r\u001e\t\u0007\u0003o\ti$a\u0004\u000e\u0005\u0005e\"bAA\u001e\u0013\u0006Aa-\u001e8di&|g.\u0003\u0003\u0002@\u0005e\"\u0001C*vaBd\u0017.\u001a:\t\u0013\u0005\r\u0003\u00011A\u0005\n\u0005\u0015\u0013a\u0006;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015\u000e\\3t+\t\t9\u0005\u0005\u0003\f=\u0005%\u0003\u0003BA&\u0003#j!!!\u0014\u000b\u0007\u0005=C!A\u0003ti\u0006$X-\u0003\u0003\u0002T\u00055#A\u0006$jY\u0016$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u0013\u0005]\u0003\u00011A\u0005\n\u0005e\u0013a\u0007;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u00164\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002\\\u0005\u0005\u0004cA\u0006\u0002^%\u0019\u0011q\f\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003G\n)&!AA\u0002\u0005\u001d\u0013a\u0001=%c!A\u0011q\r\u0001!B\u0013\t9%\u0001\ruS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,g)\u001b7fg\u0002Bq!a\u001b\u0001\t\u0003\ti'\u0001\u0005uK\u0006\u0014Hm\\<o)\t\tY\u0006\u000b\u0003\u0002j\u0005E\u0004\u0003BA:\u0003sj!!!\u001e\u000b\u0007\u0005]\u0004/A\u0003kk:LG/\u0003\u0003\u0002|\u0005U$!B!gi\u0016\u0014\bbBA@\u0001\u0011\u0005\u0011QN\u0001\u001bi\u0016\u001cH/\u00113e\u001b\u0016$\u0018\rZ1uC\n+gm\u001c:f%\u0016\fG-\u001f\u0015\u0005\u0003{\n\u0019\t\u0005\u0003\u0002t\u0005\u0015\u0015\u0002BAD\u0003k\u0012A\u0001V3ti\"9\u00111\u0012\u0001\u0005\u0002\u00055\u0014a\b;fgR$U\u000f\u001d7jG\u0006$XMU3rk\u0016\u001cHOQ3g_J,'+Z1es\"\"\u0011\u0011RAB\u0011\u001d\t\t\n\u0001C\u0001\u0003[\na\u0006^3tiJ+GO]=P]Vs7N\\8x]\u0016C8-\u001a9uS>tG)\u001e:j]\u001e$v\u000e]5d\u0007J,\u0017\r^5p]\"\"\u0011qRAB\u0011\u001d\t9\n\u0001C\u0001\u0003[\n1\u0005^3tiB\u000b'\u000f^5uS>tWM]*fiV\u0004x\u000b[3o)>\u0004\u0018nY#ySN$8\u000f\u000b\u0003\u0002\u0016\u0006\r\u0005bBAO\u0001\u0011\u0005\u0011QN\u0001\u0014i\u0016\u001cHOU3ue&,G-T3tg\u0006<Wm\u001d\u0015\u0005\u00037\u000b\u0019\tC\u0004\u0002$\u0002!I!!*\u0002\u0015\u0005$GMU3qY&\u001c\u0017\r\u0006\u0004\u0002\\\u0005\u001d\u00161\u0017\u0005\t\u0003S\u000b\t\u000b1\u0001\u0002,\u0006\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003[\u000by+D\u0001\u0005\u0013\r\t\t\f\u0002\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:D\u0001\"!.\u0002\"\u0002\u0007\u0011qW\u0001\u0012i&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\bc\u0001\u000b\u0002:&\u0019\u00111\u0018\u0002\u0003#QKWM\u001d+pa&\u001c7i\u001c8tk6,'\u000fC\u0004\u0002@\u0002!I!!1\u0002'M,G/\u001e9US\u0016\u00148i\\7q_:,g\u000e^:\u0015\r\u0005\r\u0017Q[Al!%Y\u0011QYA\\\u0003\u0013\fy-C\u0002\u0002H2\u0011a\u0001V;qY\u0016\u001c\u0004\u0003BAW\u0003\u0017L1!!4\u0005\u0005I!\u0016.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\u0011\u0007Q\t\t.C\u0002\u0002T\n\u0011\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\t\u0011a\u000bi\f%AA\u0002iC\u0001\"!7\u0002>\u0002\u0007\u00111\\\u0001\fE\u0016\u001cw.\\3SK\u0006$\u0017\u0010E\u0002\f\u0003;L1!a8\r\u0005\u001d\u0011un\u001c7fC:Dq!a9\u0001\t\u0013\ti'A\rn_Z,'+Z2pe\u0012\u001cHk\\!mY\u000e{gn];nKJ\u001c\bbBAt\u0001\u0011%\u0011QN\u0001\u001de\u0016\u001cXM\u001c3Qe\u00164\u0018n\\;t!J|G-^2f%\u0016\fX/Z:u\u0011\u001d\tY\u000f\u0001C\u0005\u0003[\faBY3d_6,\u0017I]2iSZ,'\u000f\u0006\u0006\u0002\\\u0005=\u0018\u0011_A~\u0003\u007fD\u0001\"!+\u0002j\u0002\u0007\u00111\u0016\u0005\t\u0003g\fI\u000f1\u0001\u0002v\u0006YA.Z1eKJ,\u0005o\\2i!\rY\u0011q_\u0005\u0004\u0003sd!aA%oi\"A\u0011Q`Au\u0001\u0004\ty-\u0001\tuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\"A\u0011QWAu\u0001\u0004\t9\fC\u0005\u0003\u0004\u0001\t\n\u0011\"\u0003\u0003\u0006\u0005i2/\u001a;vaRKWM]\"p[B|g.\u001a8ug\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\b)\u001a!L!\u0003,\u0005\t-\u0001\u0003\u0002B\u0007\u0005/i!Aa\u0004\u000b\t\tE!1C\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0006\r\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00053\u0011yAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class TierTopicManagerTest {
    private final String clusterId;
    private final File tempDir = TestUtils$.MODULE$.tempDir();
    private final String logDir = this.tempDir().getAbsolutePath();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(this.logDir()));
    private final short tierTopicNumPartitions = (short)7;
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig((Supplier)new Supplier<Map<String, Object>>(this){

        public Map<String, Object> get() {
            return Collections.singletonMap("bootstrap.servers", "bootstrap");
        }
    }, "", this.tierTopicNumPartitions(), (short)1, 3, this.clusterId(), Predef$.MODULE$.long2Long(5L), Predef$.MODULE$.int2Integer(30000), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private final String tierTopicName = TierTopic.topicName((String)"");
    private final Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions((String)this.tierTopicName(), (int)this.tierTopicNumPartitions());
    private final MockProducerSupplier<byte[], byte[]> producerSupplier = new MockProducerSupplier();
    private final MockConsumerSupplier<byte[], byte[]> kafka$tier$topic$TierTopicManagerTest$$primaryConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("primary", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier = new MockConsumerSupplier<byte[], byte[]>("catchup", this.tierTopicPartitions(), this.producerSupplier().producer());
    private final AdminZkClient kafka$tier$topic$TierTopicManagerTest$$adminZkClient = (AdminZkClient)Mockito.mock(AdminZkClient.class);
    private final Object adminClientSupplier = new Supplier<AdminZkClient>(this){
        private final /* synthetic */ TierTopicManagerTest $outer;

        public AdminZkClient get() {
            return this.$outer.kafka$tier$topic$TierTopicManagerTest$$adminZkClient();
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    };
    private FileTierPartitionState[] tierPartitionStateFiles = (FileTierPartitionState[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FileTierPartitionState.class));

    private String clusterId() {
        return this.clusterId;
    }

    private File tempDir() {
        return this.tempDir;
    }

    private String logDir() {
        return this.logDir;
    }

    private ArrayList<String> logDirs() {
        return this.logDirs;
    }

    private short tierTopicNumPartitions() {
        return this.tierTopicNumPartitions;
    }

    private TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    private String tierTopicName() {
        return this.tierTopicName;
    }

    private Set<TopicPartition> tierTopicPartitions() {
        return this.tierTopicPartitions;
    }

    private MockProducerSupplier<byte[], byte[]> producerSupplier() {
        return this.producerSupplier;
    }

    public MockConsumerSupplier<byte[], byte[]> kafka$tier$topic$TierTopicManagerTest$$primaryConsumerSupplier() {
        return this.kafka$tier$topic$TierTopicManagerTest$$primaryConsumerSupplier;
    }

    private MockConsumerSupplier<byte[], byte[]> catchupConsumerSupplier() {
        return this.catchupConsumerSupplier;
    }

    public AdminZkClient kafka$tier$topic$TierTopicManagerTest$$adminZkClient() {
        return this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient;
    }

    private Object adminClientSupplier() {
        return this.adminClientSupplier;
    }

    private FileTierPartitionState[] tierPartitionStateFiles() {
        return this.tierPartitionStateFiles;
    }

    private void tierPartitionStateFiles_$eq(FileTierPartitionState[] x$1) {
        this.tierPartitionStateFiles = x$1;
    }

    @After
    public void teardown() {
        Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(FileTierPartitionState tierPartitionState2) {
                tierPartitionState2.close();
                tierPartitionState2.delete();
            }
        });
        Utils.delete((File)new File(this.logDir()));
    }

    @Test
    public void testAddMetadataBeforeReady() {
        int epoch = 0;
        boolean x$6 = false;
        TierTopicManagerConfig x$7 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$7, x$6);
        if (tuple3 != null) {
            Tuple2 tuple2;
            TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
            TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)tierTopicConsumer, (Object)tierTopicManager);
            TierTopicConsumer tierTopicConsumer2 = (TierTopicConsumer)tuple22._1();
            TierTopicManager tierTopicManager2 = (TierTopicManager)tuple22._2();
            Assert.assertFalse((boolean)tierTopicManager2.isReady());
            TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo_1", UUID.randomUUID(), 0);
            TierTopicInitLeader initLeader_1 = new TierTopicInitLeader(topicIdPartition_1, epoch, UUID.randomUUID(), 0);
            TierTopicConsumer.ClientCtx clientCtx_1 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
            Mockito.when((Object)clientCtx_1.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
            Mockito.when((Object)clientCtx_1.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_1), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
            tierTopicConsumer2.register(topicIdPartition_1, clientCtx_1);
            TopicIdPartition topicIdPartition_2 = new TopicIdPartition("foo_2", UUID.randomUUID(), 0);
            TierTopicInitLeader initLeader_2 = new TierTopicInitLeader(topicIdPartition_2, epoch, UUID.randomUUID(), 0);
            TierTopicConsumer.ClientCtx clientCtx_2 = (TierTopicConsumer.ClientCtx)Mockito.mock(TierTopicConsumer.ClientCtx.class);
            Mockito.when((Object)clientCtx_2.status()).thenReturn((Object)TierPartitionStatus.ONLINE);
            Mockito.when((Object)clientCtx_2.process((AbstractTierMetadata)ArgumentMatchers.eq((Object)initLeader_2), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()))).thenReturn((Object)TierPartitionState.AppendResult.ACCEPTED);
            tierTopicConsumer2.register(topicIdPartition_2, clientCtx_2);
            CompletableFuture future_1 = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader_1);
            CompletableFuture future_2 = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader_2);
            Assert.assertTrue((boolean)tierTopicManager2.tryBecomeReady(false));
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierTopicConsumer2, future_1, future_2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TierTopicManagerTest $outer;
                private final TierTopicConsumer tierTopicConsumer$1;
                private final CompletableFuture future_1$1;
                private final CompletableFuture future_2$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    this.$outer.kafka$tier$topic$TierTopicManagerTest$$primaryConsumerSupplier().moveRecordsFromProducer();
                    this.tierTopicConsumer$1.doWork();
                    return this.future_1$1.isDone() && this.future_2$1.isDone();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tierTopicConsumer$1 = tierTopicConsumer$1;
                    this.future_1$1 = future_1$1;
                    this.future_2$1 = future_2$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Timed out waiting for futures to complete";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_1.get());
            Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, future_2.get());
            return;
        }
        throw new MatchError(tuple3);
    }

    @Test
    public void testDuplicateRequestBeforeReady() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int epoch = 0;
        boolean x$8 = false;
        TierTopicManagerConfig x$9 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$9, x$8);
        if (tuple3 != null) {
            Tuple2 tuple2;
            TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
            TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)tierTopicConsumer, (Object)tierTopicManager);
            TierTopicConsumer tierTopicConsumer2 = (TierTopicConsumer)tuple22._1();
            TierTopicManager tierTopicManager2 = (TierTopicManager)tuple22._2();
            this.addReplica(topicIdPartition, tierTopicConsumer2);
            Assert.assertFalse((boolean)tierTopicManager2.isReady());
            UUID objectId = UUID.randomUUID();
            TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, epoch, objectId, 0);
            CompletableFuture oldInitLeaderResult = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader);
            CompletableFuture newInitLeaderResult = tierTopicManager2.addMetadata((AbstractTierMetadata)initLeader);
            ExecutionException caught = (ExecutionException)Assertions$.MODULE$.intercept((Function0)new Serializable(this, oldInitLeaderResult){
                public static final long serialVersionUID = 0L;
                private final CompletableFuture oldInitLeaderResult$1;

                public final TierPartitionState.AppendResult apply() {
                    return (TierPartitionState.AppendResult)this.oldInitLeaderResult$1.get();
                }
                {
                    this.oldInitLeaderResult$1 = oldInitLeaderResult$1;
                }
            }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TierTopicManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            Assert.assertTrue((boolean)(caught.getCause() instanceof TierMetadataFatalException));
            boolean ready = tierTopicManager2.tryBecomeReady(false);
            Assert.assertTrue((boolean)ready);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierTopicConsumer2, newInitLeaderResult){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TierTopicManagerTest $outer;
                private final TierTopicConsumer tierTopicConsumer$2;
                private final CompletableFuture newInitLeaderResult$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    this.$outer.kafka$tier$topic$TierTopicManagerTest$$moveRecordsToAllConsumers();
                    this.tierTopicConsumer$2.doWork();
                    return this.newInitLeaderResult$1.isDone();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tierTopicConsumer$2 = tierTopicConsumer$2;
                    this.newInitLeaderResult$1 = newInitLeaderResult$1;
                }
            }, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Timed out waiting to become archiver";
                }
            }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, newInitLeaderResult.get());
            return;
        }
        throw new MatchError(tuple3);
    }

    @Test
    public void testRetryOnUnknownExceptionDuringTopicCreation() {
        boolean x$10 = false;
        TierTopicManagerConfig x$11 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$11, x$10);
        if (tuple3 != null) {
            Tuple2 tuple2;
            TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
            TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)tierTopicConsumer, (Object)tierTopicManager);
            TierTopicConsumer tierTopicConsumer2 = (TierTopicConsumer)tuple22._1();
            TierTopicManager tierTopicManager2 = (TierTopicManager)tuple22._2();
            Assert.assertFalse((boolean)tierTopicManager2.isReady());
            ((AdminZkClient)Mockito.doThrow((Throwable[])new Throwable[]{new TimeoutException("timeout when creating topic")}).doThrow(new Throwable[]{new AdminOperationException("admin operation exception")}).doNothing().when((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient())).createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
            tierTopicManager2.tryBecomeReady(false);
            Assert.assertFalse((boolean)tierTopicManager2.isReady());
            ((AdminZkClient)Mockito.verify((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient(), (VerificationMode)Mockito.times((int)1))).createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
            tierTopicManager2.tryBecomeReady(false);
            Assert.assertFalse((boolean)tierTopicManager2.isReady());
            ((AdminZkClient)Mockito.verify((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient(), (VerificationMode)Mockito.times((int)2))).createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
            tierTopicManager2.tryBecomeReady(false);
            Assert.assertTrue((boolean)tierTopicManager2.isReady());
            ((AdminZkClient)Mockito.verify((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient(), (VerificationMode)Mockito.times((int)3))).createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
            Assert.assertEquals((long)this.tierTopicNumPartitions(), (long)tierTopicConsumer2.tierTopic().numPartitions().getAsInt());
            return;
        }
        throw new MatchError(tuple3);
    }

    @Test
    public void testPartitionerSetupWhenTopicExists() {
        int existingPartitions = this.tierTopicNumPartitions() - 2;
        boolean x$12 = false;
        TierTopicManagerConfig x$13 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$13, x$12);
        if (tuple3 != null) {
            Tuple2 tuple2;
            TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
            TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)tierTopicConsumer, (Object)tierTopicManager);
            TierTopicConsumer tierTopicConsumer2 = (TierTopicConsumer)tuple22._1();
            TierTopicManager tierTopicManager2 = (TierTopicManager)tuple22._2();
            Assert.assertFalse((boolean)tierTopicManager2.isReady());
            this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient().createTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any(), (RackAwareMode)ArgumentMatchers.any(), BoxesRunTime.unboxToBoolean((Object)ArgumentMatchers.any()));
            Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TopicExistsException("topic exists")});
            Mockito.when((Object)this.kafka$tier$topic$TierTopicManagerTest$$adminZkClient().numPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tierTopicName()})))).thenReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tierTopicName()), (Object)BoxesRunTime.boxToInteger((int)existingPartitions))})));
            tierTopicManager2.tryBecomeReady(false);
            Assert.assertTrue((boolean)tierTopicManager2.isReady());
            Assert.assertEquals((long)existingPartitions, (long)tierTopicConsumer2.tierTopic().numPartitions().getAsInt());
            return;
        }
        throw new MatchError(tuple3);
    }

    @Test
    public void testRetriedMessages() {
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int leaderEpoch = 0;
        boolean x$14 = true;
        TierTopicManagerConfig x$15 = this.setupTierComponents$default$1();
        Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> tuple3 = this.setupTierComponents(x$15, x$14);
        if (tuple3 != null) {
            Tuple2 tuple2;
            TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple3._1();
            TierTopicManager tierTopicManager = (TierTopicManager)tuple3._3();
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)tierTopicConsumer, (Object)tierTopicManager);
            TierTopicConsumer tierTopicConsumer2 = (TierTopicConsumer)tuple22._1();
            TierTopicManager tierTopicManager2 = (TierTopicManager)tuple22._2();
            this.addReplica(topicIdPartition, tierTopicConsumer2);
            this.becomeArchiver(topicIdPartition, leaderEpoch, tierTopicManager2, tierTopicConsumer2);
            UUID objectId = UUID.randomUUID();
            TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId, 0L, 100L, 100L, 100, true, false, false);
            CompletableFuture initiateResult = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadInitiate);
            this.kafka$tier$topic$TierTopicManagerTest$$moveRecordsToAllConsumers();
            tierTopicConsumer2.doWork();
            Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, initiateResult.get());
            this.resendPreviousProduceRequest();
            TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
            CompletableFuture completeResult = tierTopicManager2.addMetadata((AbstractTierMetadata)uploadComplete);
            tierTopicConsumer2.doWork();
            Assert.assertFalse((String)"Upload complete result should not have been completed by materialization of UploadInitiate", (boolean)completeResult.isDone());
            Assert.assertEquals((long)1L, (long)tierTopicConsumer2.numListeners());
            return;
        }
        throw new MatchError(tuple3);
    }

    private void addReplica(TopicIdPartition topicIdPartition, TierTopicConsumer tierTopicConsumer) {
        File dir = new File(new StringBuilder().append((Object)this.logDir()).append((Object)"/").append((Object)Log$.MODULE$.logDirName(topicIdPartition.topicPartition())).toString());
        dir.mkdir();
        FileTierPartitionState tierPartitionState2 = new FileTierPartitionState(dir, topicIdPartition.topicPartition(), true);
        tierPartitionState2.setTopicId(topicIdPartition.topicId());
        this.tierPartitionStateFiles_$eq((FileTierPartitionState[])Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionStateFiles()).$colon$plus((Object)tierPartitionState2, ClassTag$.MODULE$.apply(FileTierPartitionState.class)));
        tierTopicConsumer.register(topicIdPartition, new TierTopicConsumer.ClientCtx(this, tierPartitionState2){
            private final FileTierPartitionState tierPartitionState$1;

            public TierPartitionState.AppendResult process(AbstractTierMetadata metadata, long offset) {
                return this.tierPartitionState$1.append(metadata, offset);
            }

            public TierPartitionStatus status() {
                return this.tierPartitionState$1.status();
            }

            public void beginCatchup() {
                this.tierPartitionState$1.beginCatchup();
            }

            public void completeCatchup() {
                this.tierPartitionState$1.onCatchUpComplete();
            }
            {
                this.tierPartitionState$1 = tierPartitionState$1;
            }
        });
    }

    private Tuple3<TierTopicConsumer, TierReplicaManager, TierTopicManager> setupTierComponents(TierTopicManagerConfig tierTopicManagerConfig, boolean becomeReady) {
        TierTopicConsumer tierTopicConsumer = new TierTopicConsumer(tierTopicManagerConfig, this.kafka$tier$topic$TierTopicManagerTest$$primaryConsumerSupplier(), this.catchupConsumerSupplier(), new TierTopicManagerCommitter(tierTopicManagerConfig, new LogDirFailureChannel(1)));
        TierReplicaManager tierReplicaManager = new TierReplicaManager();
        TierTopicManager tierTopicManager = new TierTopicManager(tierTopicManagerConfig, tierTopicConsumer, this.producerSupplier(), (Supplier)this.adminClientSupplier());
        if (becomeReady) {
            boolean ready = tierTopicManager.tryBecomeReady(false);
            Assert.assertTrue((boolean)ready);
        }
        return new Tuple3((Object)tierTopicConsumer, (Object)tierReplicaManager, (Object)tierTopicManager);
    }

    private TierTopicManagerConfig setupTierComponents$default$1() {
        return this.tierTopicManagerConfig();
    }

    public void kafka$tier$topic$TierTopicManagerTest$$moveRecordsToAllConsumers() {
        this.kafka$tier$topic$TierTopicManagerTest$$primaryConsumerSupplier().moveRecordsFromProducer();
        this.catchupConsumerSupplier().moveRecordsFromProducer();
    }

    private void resendPreviousProduceRequest() {
        MockProducer<byte[], byte[]> mockProducer = this.producerSupplier().producer();
        ProducerRecord lastSentRecord = (ProducerRecord)mockProducer.history().get(mockProducer.history().size() - 1);
        this.producerSupplier().producer().send(lastSentRecord);
        this.kafka$tier$topic$TierTopicManagerTest$$moveRecordsToAllConsumers();
    }

    private void becomeArchiver(TopicIdPartition topicIdPartition, int leaderEpoch, TierTopicManager tierTopicManager, TierTopicConsumer tierTopicConsumer) {
        CompletableFuture becomeArchiverFuture = tierTopicManager.becomeArchiver(topicIdPartition, leaderEpoch);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, tierTopicConsumer, becomeArchiverFuture){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTopicManagerTest $outer;
            private final TierTopicConsumer tierTopicConsumer$3;
            private final CompletableFuture becomeArchiverFuture$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.$outer.kafka$tier$topic$TierTopicManagerTest$$moveRecordsToAllConsumers();
                this.tierTopicConsumer$3.doWork();
                return this.becomeArchiverFuture$1.isDone();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tierTopicConsumer$3 = tierTopicConsumer$3;
                this.becomeArchiverFuture$1 = becomeArchiverFuture$1;
            }
        }, (Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Timed out waiting to become archiver";
            }
        }, TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, becomeArchiverFuture.get());
    }

    public TierTopicManagerTest() {
        this.clusterId = "mycluster";
    }
}

