/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Arrays;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import kafka.utils.Exit$;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.junit.Assert;
import org.junit.Test;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u000f\t\u00192i\u001c8t_2,\u0007K]8ek\u000e,'\u000fV3ti*\u00111\u0001B\u0001\u0006i>|Gn\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003M\u0011'o\\6fe2K7\u000f\u001e,bY&$\u0017I]4t+\u00051\u0002cA\u0005\u00183%\u0011\u0001D\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00035uq!!C\u000e\n\u0005qQ\u0011A\u0002)sK\u0012,g-\u0003\u0002\u001f?\t11\u000b\u001e:j]\u001eT!\u0001\b\u0006\t\r\u0005\u0002\u0001\u0015!\u0003\u0017\u0003Q\u0011'o\\6fe2K7\u000f\u001e,bY&$\u0017I]4tA!91\u0005\u0001b\u0001\n\u0003)\u0012\u0001\u00072p_R\u001cHO]1q'\u0016\u0014h/\u001a:WC2LG-\u0011:hg\"1Q\u0005\u0001Q\u0001\nY\t\u0011DY8piN$(/\u00199TKJ4XM\u001d,bY&$\u0017I]4tA!9q\u0005\u0001b\u0001\n\u0003)\u0012aC5om\u0006d\u0017\u000eZ!sONDa!\u000b\u0001!\u0002\u00131\u0012\u0001D5om\u0006d\u0017\u000eZ!sON\u0004\u0003bB\u0016\u0001\u0005\u0004%\t!F\u0001\u0018E>|Go\u001d;sCB\u001cVM\u001d<fe>3XM\u001d:jI\u0016Da!\f\u0001!\u0002\u00131\u0012\u0001\u00072p_R\u001cHO]1q'\u0016\u0014h/\u001a:Pm\u0016\u0014(/\u001b3fA!)q\u0006\u0001C\u0001a\u0005QB/Z:u-\u0006d\u0017\u000eZ\"p]\u001aLwm\u001d\"s_.,'\u000fT5tiR\t\u0011\u0007\u0005\u0002\ne%\u00111G\u0003\u0002\u0005+:LG\u000f\u000b\u0002/kA\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002u\u0005\u0019qN]4\n\u0005q:$\u0001\u0002+fgRDQA\u0010\u0001\u0005\u0002A\nq\u0004^3tiZ\u000bG.\u001b3D_:4\u0017nZ:C_>$8\u000f\u001e:baN+'O^3sQ\tiT\u0007C\u0003B\u0001\u0011\u0005\u0001'\u0001\nuKN$\u0018J\u001c<bY&$7i\u001c8gS\u001e\u001c\b\u0006\u0002!6\u0007\u0012\u000b\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0002\u000bB\u0011aI\u0014\b\u0003\u000f2s!\u0001S&\u000e\u0003%S!A\u0013\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA'\u000b\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0014)\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gN\u0003\u0002N\u0015!)!\u000b\u0001C\u0001a\u0005\u0001B/Z:u!\u0006\u00148/Z&fsB\u0013x\u000e\u001d\u0015\u0003#VBQ!\u0016\u0001\u0005\u0002A\n1\u0004^3ti\n{w\u000e^:ue\u0006\u00048+\u001a:wKJ|e/\u001a:sS\u0012,\u0007F\u0001+6\u0001")
public class ConsoleProducerTest {
    private final String[] brokerListValidArgs = (String[])((Object[])new String[]{"--broker-list", "localhost:1001,localhost:1002", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] bootstrapServerValidArgs = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1003,localhost:1004", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] invalidArgs = (String[])((Object[])new String[]{"--t", "t3"});
    private final String[] bootstrapServerOverride = (String[])((Object[])new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3"});

    public String[] brokerListValidArgs() {
        return this.brokerListValidArgs;
    }

    public String[] bootstrapServerValidArgs() {
        return this.bootstrapServerValidArgs;
    }

    public String[] invalidArgs() {
        return this.invalidArgs;
    }

    public String[] bootstrapServerOverride() {
        return this.bootstrapServerOverride;
    }

    @Test
    public void testValidConfigsBrokerList() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1001", "localhost:1002"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testValidConfigsBootstrapServer() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1003", "localhost:1004"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConfigs() {
        Exit$.MODULE$.setExitProcedure((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(int x$1, Option<String> message) {
                throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
            }
        });
        try {
            new ConsoleProducer.ProducerConfig(this.invalidArgs());
            return;
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testParseKeyProp() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        String string = reader.keySeparator();
        String string2 = "#";
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
        Predef$.MODULE$.assert(reader.parseKey());
    }

    @Test
    public void testBootstrapServerOverride() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerOverride());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assert.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1002"}), (Object)producerConfig.getList("bootstrap.servers"));
    }
}

