/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.tools.BatchInfo;
import kafka.tools.DumpLogSegments;
import kafka.tools.DumpLogSegments$;
import kafka.tools.DumpLogSegmentsTest$$anonfun$kafka$tools$DumpLogSegmentsTest$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.ResizableArray;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u0001\u001d\u00111\u0003R;na2{wmU3h[\u0016tGo\u001d+fgRT!a\u0001\u0003\u0002\u000bQ|w\u000e\\:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001aDQa\u0004\u0001\u0005\u0002A\ta\u0001P5oSRtD#A\t\u0011\u0005I\u0001Q\"\u0001\u0002\t\u000fQ\u0001!\u0019!C\u0001+\u00051A/\u001c9ESJ,\u0012A\u0006\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\t!![8\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0005\r&dW\r\u0003\u0004 \u0001\u0001\u0006IAF\u0001\bi6\u0004H)\u001b:!\u0011\u001d\t\u0003A1A\u0005\u0002U\ta\u0001\\8h\t&\u0014\bBB\u0012\u0001A\u0003%a#A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000f\u0015\u0002!\u0019!C\u0001M\u0005Y1/Z4nK:$h*Y7f+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001b\u0003\u0011a\u0017M\\4\n\u00051J#AB*ue&tw\r\u0003\u0004/\u0001\u0001\u0006IaJ\u0001\rg\u0016<W.\u001a8u\u001d\u0006lW\r\t\u0005\ba\u0001\u0011\r\u0011\"\u00012\u0003-awn\u001a$jY\u0016\u0004\u0016\r\u001e5\u0016\u0003I\u0002\"a\r\u001c\u000f\u0005%!\u0014BA\u001b\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011Af\u000e\u0006\u0003k)Aa!\u000f\u0001!\u0002\u0013\u0011\u0014\u0001\u00047pO\u001aKG.\u001a)bi\"\u0004\u0003bB\u001e\u0001\u0005\u0004%\t!M\u0001\u000eS:$W\r\u001f$jY\u0016\u0004\u0016\r\u001e5\t\ru\u0002\u0001\u0015!\u00033\u00039Ig\u000eZ3y\r&dW\rU1uQ\u0002Bqa\u0010\u0001C\u0002\u0013\u0005\u0011'A\tuS6,\u0017J\u001c3fq\u001aKG.\u001a)bi\"Da!\u0011\u0001!\u0002\u0013\u0011\u0014A\u0005;j[\u0016Le\u000eZ3y\r&dW\rU1uQ\u0002Bqa\u0011\u0001C\u0002\u0013\u0005A)\u0001\u0003uS6,W#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!#\u0011!B;uS2\u001c\u0018B\u0001&H\u0005!iunY6US6,\u0007B\u0002'\u0001A\u0003%Q)A\u0003uS6,\u0007\u0005C\u0004O\u0001\t\u0007I\u0011A(\u0002\u000f\t\fGo\u00195fgV\t\u0001\u000bE\u0002R-bk\u0011A\u0015\u0006\u0003'R\u000bq!\\;uC\ndWM\u0003\u0002V\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]\u0013&aC!se\u0006L()\u001e4gKJ\u0004\"AE-\n\u0005i\u0013!!\u0003\"bi\u000eD\u0017J\u001c4p\u0011\u0019a\u0006\u0001)A\u0005!\u0006A!-\u0019;dQ\u0016\u001c\b\u0005C\u0005_\u0001\u0001\u0007\t\u0019!C\u0001?\u0006\u0019An\\4\u0016\u0003\u0001\u0004\"!Y2\u000e\u0003\tT!A\u0018\u0003\n\u0005\u0011\u0014'aC!cgR\u0014\u0018m\u0019;M_\u001eD\u0011B\u001a\u0001A\u0002\u0003\u0007I\u0011A4\u0002\u000f1|wm\u0018\u0013fcR\u0011\u0001n\u001b\t\u0003\u0013%L!A\u001b\u0006\u0003\tUs\u0017\u000e\u001e\u0005\bY\u0016\f\t\u00111\u0001a\u0003\rAH%\r\u0005\u0007]\u0002\u0001\u000b\u0015\u00021\u0002\t1|w\r\t\u0005\u0006a\u0002!\t!]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002Q\"\u0012qn\u001d\t\u0003ifl\u0011!\u001e\u0006\u0003m^\fQA[;oSRT\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>v\u0005\u0019\u0011UMZ8sK\")A\u0010\u0001C\u0001c\u0006AA/Z1s\t><h\u000e\u000b\u0002|}B\u0011Ao`\u0005\u0004\u0003\u0003)(!B!gi\u0016\u0014\bBBA\u0003\u0001\u0011\u0005\u0011/\u0001\tuKN$\bK]5oi\u0012\u000bG/\u0019'pO\"\"\u00111AA\u0005!\r!\u00181B\u0005\u0004\u0003\u001b)(\u0001\u0002+fgRDa!!\u0005\u0001\t\u0003\t\u0018a\u0006;fgR$U/\u001c9J]\u0012,\u00070T5t[\u0006$8\r[3tQ\u0011\ty!!\u0003\t\r\u0005]\u0001\u0001\"\u0001r\u0003]!Xm\u001d;Ek6\u0004H+[7f\u0013:$W\r_#se>\u00148\u000f\u000b\u0003\u0002\u0016\u0005%\u0001bBA\u000f\u0001\u0011%\u0011qD\u0001\u0013eVtG)^7q\u0019><7+Z4nK:$8\u000fF\u00023\u0003CA\u0001\"a\t\u0002\u001c\u0001\u0007\u0011QE\u0001\u0005CJ<7\u000f\u0005\u0003\n\u0003O\u0011\u0014bAA\u0015\u0015\t)\u0011I\u001d:bs\u0002")
public class DumpLogSegmentsTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final String segmentName;
    private final String logFilePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".log"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logDir(), this.segmentName()}));
    private final String indexFilePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logDir(), this.segmentName()}));
    private final String timeIndexFilePath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".timeindex"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logDir(), this.segmentName()}));
    private final MockTime time = new MockTime(0L, 0L);
    private final ArrayBuffer<BatchInfo> batches = new ArrayBuffer();
    private AbstractLog log;

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public String logFilePath() {
        return this.logFilePath;
    }

    public String indexFilePath() {
        return this.indexFilePath;
    }

    public String timeIndexFilePath() {
        return this.timeIndexFilePath;
    }

    public MockTime time() {
        return this.time;
    }

    public ArrayBuffer<BatchInfo> batches() {
        return this.batches;
    }

    public AbstractLog log() {
        return this.log;
    }

    public void log_$eq(AbstractLog x$1) {
        this.log = x$1;
    }

    @Before
    public void setUp() {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.IndexIntervalBytesProp(), "128");
        this.log_$eq((AbstractLog)MergedLog$.MODULE$.apply(this.logDir(), new LogConfig((Map)props, LogConfig$.MODULE$.apply$default$2()), 0L, 0L, (Scheduler)this.time().scheduler(), new BrokerTopicStats(), (Time)this.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), new LogDirFailureChannel(10), TierLogComponents$.MODULE$.EMPTY()));
        long now = System.currentTimeMillis();
        IndexedSeq firstBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final SimpleRecord apply(int i) {
                return new SimpleRecord(this.now$1 + (long)(i * 2), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
            }
            {
                this.now$1 = now$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)firstBatchRecords, true, true));
        IndexedSeq secondBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 30).map((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final SimpleRecord apply(int i) {
                return new SimpleRecord(this.now$1 + (long)(i * 3), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes(), null);
            }
            {
                this.now$1 = now$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)secondBatchRecords, true, false));
        IndexedSeq thirdBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(30), 50).map((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final SimpleRecord apply(int i) {
                return new SimpleRecord(this.now$1 + (long)(i * 5), null, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"message value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes());
            }
            {
                this.now$1 = now$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)thirdBatchRecords, false, true));
        IndexedSeq fourthBatchRecords = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 60).map((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final long now$1;

            public final SimpleRecord apply(int i) {
                return new SimpleRecord(this.now$1 + (long)(i * 7), null);
            }
            {
                this.now$1 = now$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.batches().$plus$eq((Object)new BatchInfo((Seq<SimpleRecord>)fourthBatchRecords, false, false));
        this.batches().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DumpLogSegmentsTest $outer;

            public final LogAppendInfo apply(BatchInfo batchInfo) {
                AbstractLog qual$1 = this.$outer.log();
                MemoryRecords x$2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (int)0, (SimpleRecord[])((SimpleRecord[])batchInfo.records().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
                int x$3 = 0;
                AppendOrigin x$4 = qual$1.appendAsLeader$default$3();
                ApiVersion x$5 = qual$1.appendAsLeader$default$4();
                return qual$1.appendAsLeader(x$2, x$3, x$4, x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.log().flush();
    }

    @After
    public void tearDown() {
        this.log().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testPrintDataLog() {
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--print-data-log", "--deep-iteration", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--value-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(true, (String[])((Object[])new String[]{"--key-decoder-class", "kafka.serializer.StringDecoder", "--files", this.logFilePath()}));
        this.verifyRecordsInOutput$1(false, (String[])((Object[])new String[]{"--deep-iteration", "--files", this.logFilePath()}));
        this.verifyNoRecordsInOutput$1((String[])((Object[])new String[]{"--files", this.logFilePath()}));
    }

    @Test
    public void testDumpIndexMismatches() {
        scala.collection.mutable.Map offsetMismatches = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        DumpLogSegments$.MODULE$.dumpIndex(new File(this.indexFilePath()), false, true, offsetMismatches, Integer.MAX_VALUE);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)offsetMismatches);
    }

    @Test
    public void testDumpTimeIndexErrors() {
        DumpLogSegments.TimeIndexDumpErrors errors = new DumpLogSegments.TimeIndexDumpErrors();
        DumpLogSegments$.MODULE$.dumpTimeIndex(new File(this.timeIndexFilePath()), false, true, errors, Integer.MAX_VALUE);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.misMatchesForTimeIndexFilesMap());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.outOfOrderTimestamp());
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)errors.shallowOffsetNotFound());
    }

    private String runDumpLogSegments(String[] args) {
        ByteArrayOutputStream outContent = new ByteArrayOutputStream();
        Console$.MODULE$.withOut((OutputStream)outContent, (Function0)new Serializable(this, args){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DumpLogSegments$.MODULE$.main(this.args$1);
            }
            {
                this.args$1 = args$1;
            }
        });
        return outContent.toString();
    }

    public final boolean kafka$tools$DumpLogSegmentsTest$$isBatch$1(int index) {
        Object object = new Object();
        try {
            IntRef i = IntRef.create((int)0);
            ((ResizableArray)this.batches().zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, index, i, object){
                public static final long serialVersionUID = 0L;
                public final int index$1;
                public final IntRef i$1;
                public final Object nonLocalReturnKey1$1;

                public final void apply(Tuple2<BatchInfo, Object> x0$1) {
                    Tuple2<BatchInfo, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        BatchInfo batch = (BatchInfo)tuple2._1();
                        if (this.i$1.elem == this.index$1) {
                            throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, true);
                        }
                        ++this.i$1.elem;
                        batch.records().indices().foreach$mVc$sp((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$kafka$tools$DumpLogSegmentsTest$$isBatch$1$1 $outer;

                            public final void apply(int recordIndex) {
                                this.apply$mcVI$sp(recordIndex);
                            }

                            public void apply$mcVI$sp(int recordIndex) {
                                if (this.$outer.i$1.elem == this.$outer.index$1) {
                                    throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, false);
                                }
                                ++this.$outer.i$1.elem;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.index$1 = index$1;
                    this.i$1 = i$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            throw Assertions$.MODULE$.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No match for index ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)})), new Position("DumpLogSegmentsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                return nonLocalReturnControl.value$mcZ$sp();
            }
            throw nonLocalReturnControl;
        }
    }

    private final void verifyRecordsInOutput$1(boolean checkKeysAndValues, String[] args) {
        String output = this.runDumpLogSegments(args);
        String[] lines = output.split("\n");
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data not printed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output})), (lines.length > 2 ? 1 : 0) != 0);
        int totalRecords = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.batches().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BatchInfo x$1) {
                return x$1.records().size();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef offset = IntRef.create((int)0);
        Iterator batchIterator = this.batches().iterator();
        ObjectRef batch = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalRecords + this.batches().size()).foreach$mVc$sp((Function1)new Serializable(this, checkKeysAndValues, lines, totalRecords, offset, batchIterator, batch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DumpLogSegmentsTest $outer;
            private final boolean checkKeysAndValues$1;
            private final String[] lines$1;
            private final int totalRecords$1;
            private final IntRef offset$1;
            private final Iterator batchIterator$1;
            private final ObjectRef batch$1;

            public final void apply(int index) {
                this.apply$mcVI$sp(index);
            }

            public void apply$mcVI$sp(int index) {
                String line = this.lines$1[this.lines$1.length - this.totalRecords$1 - this.$outer.batches().size() + index];
                if (this.$outer.kafka$tools$DumpLogSegmentsTest$$isBatch$1(index)) {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a valid batch-level message record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})), (boolean)line.startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baseOffset: ", " lastOffset: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.offset$1.elem)}))));
                    this.batch$1.elem = (BatchInfo)this.batchIterator$1.next();
                } else {
                    Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not a valid message record: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})), (boolean)line.startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DumpLogSegments$.MODULE$.RecordIndent(), BoxesRunTime.boxToInteger((int)this.offset$1.elem)}))));
                    if (this.checkKeysAndValues$1) {
                        String suffix = "headerKeys: []";
                        if (((BatchInfo)this.batch$1.elem).hasKeys()) {
                            suffix = new StringBuilder().append((Object)suffix).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" key: message key ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.offset$1.elem)}))).toString();
                        }
                        if (((BatchInfo)this.batch$1.elem).hasValues()) {
                            suffix = new StringBuilder().append((Object)suffix).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" payload: message value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.offset$1.elem)}))).toString();
                        }
                        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Message record missing key or value: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line})), (boolean)line.endsWith(suffix));
                    }
                    ++this.offset$1.elem;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.checkKeysAndValues$1 = checkKeysAndValues$1;
                this.lines$1 = lines$1;
                this.totalRecords$1 = totalRecords$1;
                this.offset$1 = offset$1;
                this.batchIterator$1 = batchIterator$1;
                this.batch$1 = batch$1;
            }
        });
    }

    private final void verifyNoRecordsInOutput$1(String[] args) {
        String output = this.runDumpLogSegments(args);
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Data should not have been printed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{output})), (boolean)output.matches("(?s).*offset: [0-9]* isvalid.*"));
    }

    public DumpLogSegmentsTest() {
        this.segmentName = "00000000000000000000";
    }
}

