/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import javax.security.auth.login.Configuration;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import kafka.zk.ZooKeeperTestHarness$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.IntegrationTest;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Category(value={IntegrationTest.class})
@ScalaSignature(bytes="\u0006\u0001\u00055e!B\u0001\u0003\u0003\u00039!\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8O\u0003\u0002\u0004\t\u0005\u0011!p\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\u0006+\u0001!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\tAqA\u0007\u0001C\u0002\u0013\u00051$A\n{W\u000e{gN\\3di&|g\u000eV5nK>,H/F\u0001\u001d!\tIQ$\u0003\u0002\u001f\u0015\t\u0019\u0011J\u001c;\t\r\u0001\u0002\u0001\u0015!\u0003\u001d\u0003QQ8nQ8o]\u0016\u001cG/[8o)&lWm\\;uA!9!\u0005\u0001b\u0001\n\u0003Y\u0012\u0001\u0005>l'\u0016\u001c8/[8o)&lWm\\;u\u0011\u0019!\u0003\u0001)A\u00059\u0005\t\"p[*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0011\t\u000f\u0019\u0002!\u0019!C\u00017\u0005)\"p['bq&sg\t\\5hQR\u0014V-];fgR\u001c\bB\u0002\u0015\u0001A\u0003%A$\u0001\f{W6\u000b\u00070\u00138GY&<\u0007\u000e\u001e*fcV,7\u000f^:!\u0011\u0015Q\u0003\u0001\"\u0005,\u00035Q8.Q2mg\u0016s\u0017M\u00197fIV\tA\u0006E\u0002\n[=J!A\f\u0006\u0003\r=\u0003H/[8o!\tI\u0001'\u0003\u00022\u0015\t9!i\\8mK\u0006t\u0007bB\u001a\u0001\u0001\u0004%\t\u0001N\u0001\tu.\u001cE.[3oiV\tQ\u0007\u0005\u0002\u0019m%\u0011qG\u0001\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u000fe\u0002\u0001\u0019!C\u0001u\u0005a!p[\"mS\u0016tGo\u0018\u0013fcR\u00111H\u0010\t\u0003\u0013qJ!!\u0010\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b\u007fa\n\t\u00111\u00016\u0003\rAH%\r\u0005\u0007\u0003\u0002\u0001\u000b\u0015B\u001b\u0002\u0013i\\7\t\\5f]R\u0004\u0003bB\"\u0001\u0001\u0004%\t\u0001R\u0001\u000eC\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0016\u0003\u0015\u0003\"\u0001\u0007$\n\u0005\u001d\u0013!!D!e[&t'l[\"mS\u0016tG\u000fC\u0004J\u0001\u0001\u0007I\u0011\u0001&\u0002#\u0005$W.\u001b8[W\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002<\u0017\"9q\bSA\u0001\u0002\u0004)\u0005BB'\u0001A\u0003&Q)\u0001\bbI6LgNW6DY&,g\u000e\u001e\u0011\t\u000f=\u0003\u0001\u0019!C\u0001!\u0006I!p\\8lK\u0016\u0004XM]\u000b\u0002#B\u0011\u0001DU\u0005\u0003'\n\u0011\u0011#R7cK\u0012$W\r\u001a.p_.,W\r]3s\u0011\u001d)\u0006\u00011A\u0005\u0002Y\u000bQB_8pW\u0016,\u0007/\u001a:`I\u0015\fHCA\u001eX\u0011\u001dyD+!AA\u0002ECa!\u0017\u0001!B\u0013\t\u0016A\u0003>p_.,W\r]3sA!)1\f\u0001C\u00017\u00051!p\u001b)peRDQ!\u0018\u0001\u0005\u0002y\u000b\u0011B_6D_:tWm\u0019;\u0016\u0003}\u0003\"\u0001Y2\u000f\u0005%\t\u0017B\u00012\u000b\u0003\u0019\u0001&/\u001a3fM&\u0011A-\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tT\u0001\"B4\u0001\t\u0003A\u0017!B:fiV\u0003H#A\u001e)\u0005\u0019T\u0007CA6q\u001b\u0005a'BA7o\u0003\u0015QWO\\5u\u0015\u0005y\u0017aA8sO&\u0011\u0011\u000f\u001c\u0002\u0007\u0005\u00164wN]3\t\u000bM\u0004A\u0011\u00015\u0002\u0011Q,\u0017M\u001d#po:D#A];\u0011\u0005-4\u0018BA<m\u0005\u0015\te\r^3s\u0011\u0015I\b\u0001\"\u0001{\u0003-\u001a'/Z1uKj{wnS3fa\u0016\u00148\t\\5f]R$v\u000e\u0016:jO\u001e,'oU3tg&|g.\u0012=qSJLHcA>\u0002\u0006A\u0019A0!\u0001\u000e\u0003uT!a\u0014@\u000b\u0005}t\u0017AB1qC\u000eDW-C\u0002\u0002\u0004u\u0014\u0011BW8p\u0017\u0016,\u0007/\u001a:\t\r\u0005\u001d\u0001\u00101\u0001|\u0003%Qxn\\&fKB,'\u000fK\u0004\u0001\u0003\u0017\tY\"!\b\u0011\t\u00055\u0011qC\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005Q1-\u0019;fO>\u0014\u0018.Z:\u000b\u0007\u0005UA.\u0001\u0007fqB,'/[7f]R\fG.\u0003\u0003\u0002\u001a\u0005=!\u0001C\"bi\u0016<wN]=\u0002\u000bY\fG.^3-\u0005\u0005}1EAA\u0011!\u0011\t\u0019#a\u000b\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tA\u0001^3ti*\u0011QA`\u0005\u0005\u0003[\t)CA\bJ]R,wM]1uS>tG+Z:u\u000f\u001d\t\tD\u0001E\u0001\u0003g\tACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\bc\u0001\r\u00026\u00191\u0011A\u0001E\u0001\u0003o\u00192!!\u000e\t\u0011\u001d)\u0012Q\u0007C\u0001\u0003w!\"!a\r\t\u0015\u0005}\u0012Q\u0007b\u0001\n\u0003\t\t%A\r[W\u000ec\u0017.\u001a8u\u000bZ,g\u000e\u001e+ie\u0016\fGmU;gM&DXCAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nA\u0001\\1oO*\u0011\u0011QJ\u0001\u0005U\u00064\u0018-C\u0002e\u0003\u000fB\u0011\"a\u0015\u00026\u0001\u0006I!a\u0011\u00025i[7\t\\5f]R,e/\u001a8u)\"\u0014X-\u00193Tk\u001a4\u0017\u000e\u001f\u0011\t\u0015\u0005]\u0013Q\u0007b\u0001\n\u0003\tI&A\u000bv]\u0016D\b/Z2uK\u0012$\u0006N]3bI:\u000bW.Z:\u0016\u0005\u0005m\u0003CBA/\u0003G\n\u0019%\u0004\u0002\u0002`)\u0019\u0011\u0011\r\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002f\u0005}#aA*fi\"I\u0011\u0011NA\u001bA\u0003%\u00111L\u0001\u0017k:,\u0007\u0010]3di\u0016$G\u000b\u001b:fC\u0012t\u0015-\\3tA!9\u0011QNA\u001b\t\u0003A\u0017AC:fiV\u00038\t\\1tg\"\"\u00111NA9!\rY\u00171O\u0005\u0004\u0003kb'a\u0003\"fM>\u0014Xm\u00117bgNDq!!\u001f\u00026\u0011\u0005\u0001.A\u0007uK\u0006\u0014Hi\\<o\u00072\f7o\u001d\u0015\u0005\u0003o\ni\bE\u0002l\u0003\u007fJ1!!!m\u0005)\te\r^3s\u00072\f7o\u001d\u0005\t\u0003\u000b\u000b)\u0004\"\u0001\u0002\b\u0006Ib/\u001a:jMftu.\u00168fqB,7\r^3e)\"\u0014X-\u00193t)\rY\u0014\u0011\u0012\u0005\b\u0003\u0017\u000b\u0019\t1\u0001`\u0003\u001d\u0019wN\u001c;fqR\u0004")
public abstract class ZooKeeperTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private KafkaZkClient zkClient;
    private AdminZkClient adminZkClient;
    private EmbeddedZookeeper zookeeper;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void verifyNoUnexpectedThreads(String string) {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads(string);
    }

    @AfterClass
    public static void tearDownClass() {
        ZooKeeperTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeClass
    public static void setUpClass() {
        ZooKeeperTestHarness$.MODULE$.setUpClass();
    }

    public static Set<String> unexpectedThreadNames() {
        return ZooKeeperTestHarness$.MODULE$.unexpectedThreadNames();
    }

    public static String ZkClientEventThreadSuffix() {
        return ZooKeeperTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    private Logger logger$lzycompute() {
        ZooKeeperTestHarness zooKeeperTestHarness = this;
        synchronized (zooKeeperTestHarness) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.class.msgWithLogIdent((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(KafkaZkClient x$1) {
        this.zkClient = x$1;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    public void adminZkClient_$eq(AdminZkClient x$1) {
        this.adminZkClient = x$1;
    }

    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    public int zkPort() {
        return this.zookeeper().port();
    }

    public String zkConnect() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"127.0.0.1:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    @Before
    public void setUp() {
        this.zookeeper_$eq(new EmbeddedZookeeper());
        this.zkClient_$eq(KafkaZkClient$.MODULE$.apply(this.zkConnect(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return JaasUtils.isZkSaslEnabled();
            }
        })), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10()));
        this.adminZkClient_$eq(new AdminZkClient(this.zkClient()));
    }

    @After
    public void tearDown() {
        if (this.zkClient() != null) {
            this.zkClient().close();
        }
        if (this.zookeeper() != null) {
            CoreUtils$.MODULE$.swallow((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ZooKeeperTestHarness $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.zookeeper().shutdown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        }
        Configuration.setConfiguration(null);
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(this){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assert.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public ZooKeeperTestHarness() {
        Logging.class.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.zkClient = null;
        this.adminZkClient = null;
        this.zookeeper = null;
    }
}

