/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.cluster;

import kafka.cluster.AssignmentState;
import kafka.cluster.SimpleAssignmentState;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import unit.kafka.cluster.AbstractPartitionTest;
import unit.kafka.cluster.AssignmentStateTest$;

@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\rq!B\u0001\u0003\u0011\u0003I\u0011aE!tg&<g.\\3oiN#\u0018\r^3UKN$(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT!!\u0002\u0004\u0002\u000b-\fgm[1\u000b\u0003\u001d\tA!\u001e8ji\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u0003i!aE!tg&<g.\\3oiN#\u0018\r^3UKN$8CA\u0006\u000f!\tQq\"\u0003\u0002\u0011\u0005\t)\u0012IY:ue\u0006\u001cG\u000fU1si&$\u0018n\u001c8UKN$\b\"\u0002\n\f\t\u0003\u0019\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u0015)2\u0002\"\u0001\u0017\u0003\u0011!\u0017\r^1\u0016\u0003]\u00012\u0001G\u000e\u001e\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"!B!se\u0006L\bc\u0001\r\u001c=A\u0011\u0001dH\u0005\u0003Ae\u00111!\u00118zQ\t!\"\u0005\u0005\u0002$k9\u0011AE\r\b\u0003K=r!A\n\u0017\u000f\u0005\u001dRS\"\u0001\u0015\u000b\u0005%B\u0011A\u0002\u001fs_>$h(C\u0001,\u0003\ry'oZ\u0005\u0003[9\nQA[;oSRT\u0011aK\u0005\u0003aE\nqA];o]\u0016\u00148O\u0003\u0002.]%\u00111\u0007N\u0001\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\u000b\u0005A\n\u0014B\u0001\u001c8\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0003gQ2A\u0001\u0004\u0002\u0001sM\u0011\u0001H\u0004\u0005\twa\u0012\t\u0011)A\u0005y\u0005\u0019\u0011n\u001d:\u0011\u0007u\u0012UI\u0004\u0002?\u0001:\u0011qeP\u0005\u00025%\u0011\u0011)G\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019EI\u0001\u0003MSN$(BA!\u001a!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013q!\u00138uK\u001e,'\u000f\u0003\u0005Oq\t\u0005\t\u0015!\u0003=\u0003!\u0011X\r\u001d7jG\u0006\u001c\b\u0002\u0003)9\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\r\u0005$G-\u001b8h\u0011!\u0011\u0006H!A!\u0002\u0013a\u0014\u0001\u0003:f[>4\u0018N\\4\t\u0011QC$\u0011!Q\u0001\nU\u000b\u0001b\u001c:jO&t\u0017\r\u001c\t\u0004{YC\u0016BA,E\u0005\r\u0019V-\u001d\t\u00031eK!AW\r\u0003\u0007%sG\u000f\u0003\u0005]q\t\u0005\t\u0015!\u0003^\u0003EI7/\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a\t\u00031yK!aX\r\u0003\u000f\t{w\u000e\\3b]\")!\u0003\u000fC\u0001CR9!m\u00193fM\u001eD\u0007C\u0001\u00069\u0011\u0015Y\u0004\r1\u0001=\u0011\u0015q\u0005\r1\u0001=\u0011\u0015\u0001\u0006\r1\u0001=\u0011\u0015\u0011\u0006\r1\u0001=\u0011\u0015!\u0006\r1\u0001V\u0011\u0015a\u0006\r1\u0001^\u0011\u0015Q\u0007\b\"\u0001l\u0003u!Xm\u001d;QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tGo\u0015;biV\u001cH#\u00017\u0011\u0005ai\u0017B\u00018\u001a\u0005\u0011)f.\u001b;)\u0005%\u0004\bCA9s\u001b\u0005\t\u0014BA:2\u0005\u0011!Vm\u001d;)\ta*8\u0010 \t\u0003mfl\u0011a\u001e\u0006\u0003qF\naA];o]\u0016\u0014\u0018B\u0001>x\u0005\u001d\u0011VO\\,ji\"\fQA^1mk\u0016\u001c\u0013! \t\u0003}~l\u0011\u0001N\u0005\u0004\u0003\u0003!$!\u0004)be\u0006lW\r^3sSj,G\r")
public class AssignmentStateTest
extends AbstractPartitionTest {
    private final List<Integer> isr;
    private final List<Integer> replicas;
    private final List<Integer> adding;
    private final List<Integer> removing;
    private final Seq<Object> original;
    private final boolean isUnderReplicated;

    @Parameterized.Parameters
    public static Object[][] data() {
        return AssignmentStateTest$.MODULE$.data();
    }

    @Test
    public void testPartitionAssignmentStatus() {
        boolean isReassigning;
        int controllerId = 0;
        int controllerEpoch = 3;
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.isr).asJava()).setZkVersion(1).setReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.replicas).asJava()).setIsNew(false);
        Object object = this.adding.nonEmpty() ? leaderState.setAddingReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.adding).asJava()) : BoxedUnit.UNIT;
        Object object2 = this.removing.nonEmpty() ? leaderState.setRemovingReplicas((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.removing).asJava()) : BoxedUnit.UNIT;
        boolean bl = isReassigning = this.adding.nonEmpty() || this.removing.nonEmpty();
        if (this.original.nonEmpty()) {
            this.partition().assignmentState_$eq((AssignmentState)new SimpleAssignmentState(this.original, Predef$.MODULE$.Set().empty()));
        }
        this.partition().makeLeader(controllerId, leaderState, 0, this.offsetCheckpoints());
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning), (Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isReassigning()));
        if (this.adding.nonEmpty()) {
            this.adding.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AssignmentStateTest $outer;

                public final void apply(Integer r) {
                    Assert.assertTrue((boolean)this.$outer.partition().isAddingReplica(Predef$.MODULE$.Integer2int(r)));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        if (this.adding.contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId()))) {
            Assert.assertTrue((boolean)this.partition().isAddingLocalReplica());
        } else {
            Assert.assertFalse((boolean)this.partition().isAddingLocalReplica());
        }
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)this.isUnderReplicated), (Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isUnderReplicated()));
    }

    public AssignmentStateTest(List<Integer> isr, List<Integer> replicas, List<Integer> adding, List<Integer> removing, Seq<Object> original, boolean isUnderReplicated) {
        this.isr = isr;
        this.replicas = replicas;
        this.adding = adding;
        this.removing = removing;
        this.original = original;
        this.isUnderReplicated = isUnderReplicated;
    }
}

