/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server;

import java.util.Collections;
import java.util.Optional;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.TierListOffsetRequestData;
import org.apache.kafka.common.message.TierListOffsetResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TierListOffsetRequest;
import org.apache.kafka.common.requests.TierListOffsetResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import unit.kafka.server.TierListOffsetRequestTest$;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u0013\tIB+[3s\u0019&\u001cHo\u00144gg\u0016$(+Z9vKN$H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000b\u0019\tQa[1gW\u0006T\u0011aB\u0001\u0005k:LGo\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u000f\u001b\u0005a!BA\u0002\u000e\u0015\u0005)\u0011BA\b\r\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\b\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\t!\u0002!D\u0001\u0003\u0011\u00151\u0002\u0001\"\u0001\u0018\u0003q!Xm\u001d;US\u0016\u0014H*[:u\u001f\u001a47/\u001a;FeJ|'oQ8eKN$\u0012\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0016?A\u0011\u0001%J\u0007\u0002C)\u0011!eI\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002I\u0005\u0019qN]4\n\u0005\u0019\n#\u0001\u0002+fgRDQ\u0001\u000b\u0001\u0005\u0002]\t!\u0004^3ti\u000e+(O]3oi\u0016\u0003xn\u00195WC2LG-\u0019;j_:D#aJ\u0010\t\u000b-\u0002A\u0011\u0002\u0017\u0002'\u0005\u001c8/\u001a:u%\u0016\u001c\bo\u001c8tK\u0016\u0013(o\u001c:\u0015\tai#h\u0010\u0005\u0006])\u0002\raL\u0001\u0006KJ\u0014xN\u001d\t\u0003aaj\u0011!\r\u0006\u0003eM\n\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\u0006\u0003iU\naaY8n[>t'BA\u00037\u0015\t94%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003sE\u0012a!\u0012:s_J\u001c\b\"B\u001e+\u0001\u0004a\u0014\u0001\u00032s_.,'/\u00133\u0011\u0005ei\u0014B\u0001 \u001b\u0005\rIe\u000e\u001e\u0005\u0006\u0001*\u0002\r!Q\u0001\be\u0016\fX/Z:u!\t\u0011U)D\u0001D\u0015\t!5'\u0001\u0005sKF,Xm\u001d;t\u0013\t15IA\u000bUS\u0016\u0014H*[:u\u001f\u001a47/\u001a;SKF,Xm\u001d;\t\u000b!\u0003A\u0011B%\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0004\u00156{\u0005C\u0001\"L\u0013\ta5I\u0001\fUS\u0016\u0014H*[:u\u001f\u001a47/\u001a;SKN\u0004xN\\:f\u0011\u0015qu\t1\u0001=\u0003!aW-\u00193fe&#\u0007\"\u0002!H\u0001\u0004\t\u0005")
public class TierListOffsetRequestTest
extends BaseRequestTest {
    @Test
    public void testTierListOffsetErrorCodes() {
        TopicPartition topicPartition = new TopicPartition("topic", 0);
        TierListOffsetRequestData.TierListOffsetTopic tierListOffsetTopic = new TierListOffsetRequestData.TierListOffsetTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new TierListOffsetRequestData.TierListOffsetPartition().setPartitionIndex(topicPartition.partition()).setOffsetType(TierListOffsetRequest.OffsetType.toId((TierListOffsetRequest.OffsetType)TierListOffsetRequest.OffsetType.LOCAL_START_OFFSET)).setCurrentLeaderEpoch(0)));
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        TierListOffsetRequest replicaRequest = (TierListOffsetRequest)new TierListOffsetRequest.Builder(new TierListOffsetRequestData().setReplicaId(randomBrokerId).setTopics(Collections.singletonList(tierListOffsetTopic))).build();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topicPartition.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(topicPartition).toSet();
        int leader2 = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        int follower2 = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)new Serializable(this, leader2){
            public static final long serialVersionUID = 0L;
            private final int leader$1;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return x$1 != this.leader$1;
            }
            {
                this.leader$1 = leader$1;
            }
        }).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(KafkaServer x$2) {
                return x$2.config().brokerId();
            }
        }, Buffer$.MODULE$.canBuildFrom())).find((Function1)new Serializable(this, replicas){
            public static final long serialVersionUID = 0L;
            private final Set replicas$1;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return !this.replicas$1.contains((Object)BoxesRunTime.boxToInteger((int)x$3));
            }
            {
                this.replicas$1 = replicas$1;
            }
        }).get());
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, follower2, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_FOR_PARTITION, nonReplica, replicaRequest);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_FOR_PARTITION, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    private void assertResponseError(Errors error, int brokerId, TierListOffsetRequest request) {
        TierListOffsetResponse response = this.sendRequest(brokerId, request);
        Assert.assertEquals((long)request.data().topics().size(), (long)response.data().topics().size());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(response.data().topics()).asScala()).foreach((Function1)new Serializable(this, error){
            public static final long serialVersionUID = 0L;
            public final Errors error$1;

            public final void apply(TierListOffsetResponseData.TierListOffsetTopicResponse topicResponse) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicResponse.partitions()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$assertResponseError$1 $outer;

                    public final void apply(TierListOffsetResponseData.TierListOffsetPartitionResponse partitionResponse) {
                        Assert.assertEquals((long)this.$outer.error$1.code(), (long)partitionResponse.errorCode());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.error$1 = error$1;
            }
        });
    }

    private TierListOffsetResponse sendRequest(int leaderId, TierListOffsetRequest request) {
        SocketServer socketServer = this.brokerSocketServer(leaderId);
        return (TierListOffsetResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(TierListOffsetResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        TierListOffsetRequestData.TierListOffsetTopic tierListOffsetTopic = new TierListOffsetRequestData.TierListOffsetTopic().setName(topicPartition$1.topic()).setPartitions(Collections.singletonList(new TierListOffsetRequestData.TierListOffsetPartition().setPartitionIndex(topicPartition$1.partition()).setOffsetType(TierListOffsetRequest.OffsetType.toId((TierListOffsetRequest.OffsetType)TierListOffsetRequest.OffsetType.LOCAL_START_OFFSET)).setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1))))));
        TierListOffsetRequest request = (TierListOffsetRequest)new TierListOffsetRequest.Builder(new TierListOffsetRequestData().setReplicaId(brokerId).setTopics(Collections.singletonList(tierListOffsetTopic))).build();
        this.assertResponseError(error, brokerId, request);
    }
}

