/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.KafkaException;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ApiUtils$ {
    public static final ApiUtils$ MODULE$;

    static {
        new ApiUtils$();
    }

    public String readShortString(ByteBuffer buffer) {
        short size2 = buffer.getShort();
        if (size2 < 0) {
            return null;
        }
        byte[] bytes = new byte[size2];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void writeShortString(ByteBuffer buffer, String string) {
        if (string == null) {
            buffer.putShort((short)-1);
        } else {
            byte[] encodedString = string.getBytes(StandardCharsets.UTF_8);
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            buffer.putShort((short)encodedString.length);
            buffer.put(encodedString);
        }
    }

    public int shortStringLength(String string) {
        int n;
        if (string == null) {
            n = 2;
        } else {
            byte[] encodedString = string.getBytes(StandardCharsets.UTF_8);
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            n = 2 + encodedString.length;
        }
        return n;
    }

    private ApiUtils$() {
        MODULE$ = this;
    }
}

