/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import kafka.log.Log$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012a\b\t\u0003A!j\u0011!\t\u0006\u0003E\r\naaY8n[>t'BA\u0003%\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\n\u0005%\n#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\tW\u0001\u0011\t\u0011)A\u0005?\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0004_E\u0012\u0004C\u0001\u0019\u0001\u001b\u0005\u0011\u0001\"B\u000b-\u0001\u00049\u0002\"B\u000f-\u0001\u0004y\u0002B\u0002\u001b\u0001A\u0003&Q'A\u000b`Y><WI\u001c3PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\u0011\u0005YJT\"A\u001c\u000b\u0005a\"\u0011AB:feZ,'/\u0003\u0002;o\t\tBj\\4PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1)\u0005Mb\u0004CA\u0005>\u0013\tq$B\u0001\u0005w_2\fG/\u001b7f\u0011\u0019\u0001\u0005\u0001)Q\u0005\u0003\u0006yq\f\\8h'R\f'\u000f^(gMN,G\u000f\u0005\u0002\n\u0005&\u00111I\u0003\u0002\u0005\u0019>tw\r\u000b\u0002@y!1a\t\u0001Q!\n\u0005\u000b1\u0004\\1ti\u001a+Go\u00195MK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$\bFA#=\u0011\u0019I\u0005\u0001)Q\u0005\u0003\u0006\u0001r\f\\1ti\u001a+Go\u00195US6,Wj\u001d\u0015\u0003\u0011rBa\u0001\u0014\u0001!B\u0013\t\u0015aE0mCN$8)Y;hQR,\u0006\u000fV5nK6\u001b\bFA&=\u0011\u0019y\u0005\u0001)Q\u0005\u0003\u00061r\f\\1tiN+g\u000e\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u000b\u0002Oy!)!\u000b\u0001C\u0001'\u0006qAn\\4Ti\u0006\u0014Ho\u00144gg\u0016$X#A!\t\u000bU\u0003A\u0011\u0001,\u0002)1|w-\u00128e\u001f\u001a47/\u001a;NKR\fG-\u0019;b+\u0005)\u0004\"\u0002-\u0001\t\u0003\u0019\u0016\u0001\u00047pO\u0016sGm\u00144gg\u0016$\b\"\u0002.\u0001\t\u0003\u0019\u0016a\u00047bgR4U\r^2i)&lW-T:\t\u000bq\u0003A\u0011A*\u0002%1\f7\u000f^\"bk\u001eDG/\u00169US6,Wj\u001d\u0005\u0006=\u0002!\taU\u0001\u0016Y\u0006\u001cHoU3oi\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003A)\b\u000fZ1uK\u001a+Go\u00195Ti\u0006$X\r\u0006\u0004cK\u001eL7.\u001c\t\u0003\u0013\rL!\u0001\u001a\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006M~\u0003\r!N\u0001\u001cM>dGn\\<fe\u001a+Go\u00195PM\u001a\u001cX\r^'fi\u0006$\u0017\r^1\t\u000b!|\u0006\u0019A!\u0002'\u0019|G\u000e\\8xKJ\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u000b)|\u0006\u0019A!\u0002'\u0019|G\u000e\\8xKJ4U\r^2i)&lW-T:\t\u000b1|\u0006\u0019A!\u0002\u001f1,\u0017\rZ3s\u000b:$wJ\u001a4tKRDQA\\0A\u0002\u0005\u000bQ\u0003\\1tiN+g\u000e\u001e%jO\"<\u0018\r^3s[\u0006\u00148\u000eC\u0003q\u0001\u0011%\u0011/A\u000eva\u0012\fG/\u001a'bgR\u001cVM\u001c;IS\u001eDw+\u0019;fe6\f'o\u001b\u000b\u0003EJDQa]8A\u0002\u0005\u000bQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007\"B;\u0001\t\u00031\u0018!\u0006:fg\u0016$H*Y:u\u0007\u0006,x\r\u001b;VaRKW.\u001a\u000b\u0005E^L8\u0010C\u0003yi\u0002\u0007\u0011)A\u000bdkJdU-\u00193fe2{w-\u00128e\u001f\u001a47/\u001a;\t\u000bi$\b\u0019A!\u0002\u0013\r,(\u000fV5nK6\u001b\b\"\u0002/u\u0001\u0004\t\u0005\"B?\u0001\t\u0003r\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003}\u0004B!!\u0001\u0002\b9\u0019\u0011\"a\u0001\n\u0007\u0005\u0015!\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000bQ\u0001bBA\b\u0001\u0011\u0005\u0013\u0011C\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005M\u0011\u0011\u0004\t\u0004\u0013\u0005U\u0011bAA\f\u0015\t9!i\\8mK\u0006t\u0007\u0002CA\u000e\u0003\u001b\u0001\r!!\b\u0002\tQD\u0017\r\u001e\t\u0004\u0013\u0005}\u0011bAA\u0011\u0015\t\u0019\u0011I\\=\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(\u0005A\u0001.Y:i\u0007>$W\rF\u0001\u0018\u0001")
public class Replica
implements Logging {
    private final int brokerId;
    private final TopicPartition topicPartition;
    private volatile LogOffsetMetadata _logEndOffsetMetadata;
    private volatile long _logStartOffset;
    private volatile long lastFetchLeaderLogEndOffset;
    private volatile long _lastFetchTimeMs;
    private volatile long _lastCaughtUpTimeMs;
    private volatile long _lastSentHighWatermark;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long logStartOffset() {
        return this._logStartOffset;
    }

    public LogOffsetMetadata logEndOffsetMetadata() {
        return this._logEndOffsetMetadata;
    }

    public long logEndOffset() {
        return this.logEndOffsetMetadata().messageOffset();
    }

    public long lastFetchTimeMs() {
        return this._lastFetchTimeMs;
    }

    public long lastCaughtUpTimeMs() {
        return this._lastCaughtUpTimeMs;
    }

    public long lastSentHighWatermark() {
        return this._lastSentHighWatermark;
    }

    public void updateFetchState(LogOffsetMetadata followerFetchOffsetMetadata, long followerStartOffset, long followerFetchTimeMs, long leaderEndOffset, long lastSentHighwatermark) {
        if (followerFetchOffsetMetadata.messageOffset() >= leaderEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, followerFetchTimeMs);
        } else if (followerFetchOffsetMetadata.messageOffset() >= this.lastFetchLeaderLogEndOffset) {
            this._lastCaughtUpTimeMs = package$.MODULE$.max(this._lastCaughtUpTimeMs, this._lastFetchTimeMs);
        }
        this._logStartOffset = followerStartOffset;
        this._logEndOffsetMetadata = followerFetchOffsetMetadata;
        this.lastFetchLeaderLogEndOffset = leaderEndOffset;
        this._lastFetchTimeMs = followerFetchTimeMs;
        this.updateLastSentHighWatermark(lastSentHighwatermark);
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated state of replica to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void updateLastSentHighWatermark(long highWatermark) {
        this._lastSentHighWatermark = highWatermark;
        this.trace((Function0<String>)new Serializable(this, highWatermark){
            public static final long serialVersionUID = 0L;
            private final long highWatermark$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated HW of replica to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.highWatermark$1)}));
            }
            {
                this.highWatermark$1 = highWatermark$1;
            }
        });
    }

    public void resetLastCaughtUpTime(long curLeaderLogEndOffset, long curTimeMs, long lastCaughtUpTimeMs) {
        this.lastFetchLeaderLogEndOffset = curLeaderLogEndOffset;
        this._lastFetchTimeMs = curTimeMs;
        this._lastCaughtUpTimeMs = lastCaughtUpTimeMs;
        this.trace((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset state of replica to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public String toString() {
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new StringBuilder().append((Object)"Replica(replicaId=").append((Object)BoxesRunTime.boxToInteger((int)this.brokerId())).toString());
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", topic=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition().topic()})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", partition=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.topicPartition().partition())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastCaughtUpTimeMs=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastCaughtUpTimeMs())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", logStartOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.logStartOffset())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", logEndOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.logEndOffset())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", logEndOffsetMetadata=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logEndOffsetMetadata()})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastFetchLeaderLogEndOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastFetchLeaderLogEndOffset)})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastFetchTimeMs=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastFetchTimeMs())})));
        replicaString.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{", lastSentHighWatermark=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastSentHighWatermark())})));
        replicaString.append(")");
        return replicaString.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Replica)) return false;
        Replica replica = (Replica)object;
        if (this.brokerId() != replica.brokerId()) return false;
        TopicPartition topicPartition = this.topicPartition();
        TopicPartition topicPartition2 = replica.topicPartition();
        if (topicPartition != null) {
            if (!topicPartition.equals(topicPartition2)) return false;
            return true;
        }
        if (topicPartition2 == null) return true;
        return false;
    }

    public int hashCode() {
        return 31 + this.topicPartition().hashCode() + 17 * this.brokerId();
    }

    public Replica(int brokerId, TopicPartition topicPartition) {
        this.brokerId = brokerId;
        this.topicPartition = topicPartition;
        Logging$class.$init$(this);
        this._logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this._logStartOffset = Log$.MODULE$.UnknownOffset();
        this.lastFetchLeaderLogEndOffset = 0L;
        this._lastFetchTimeMs = 0L;
        this._lastCaughtUpTimeMs = 0L;
        this._lastSentHighWatermark = 0L;
    }
}

