/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.common.RecordValidationException;
import kafka.log.AppendOrigin;
import kafka.log.AppendOrigin$Client$;
import kafka.log.InterceptorStats;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.log.LogValidator$$anonfun$assignOffsetsNonCompressed$1$;
import kafka.log.LogValidator$$anonfun$convertAndAssignOffsetsNonCompressed$1$;
import kafka.log.LogValidator$$anonfun$kafka$log$LogValidator$;
import kafka.log.LogValidator$$anonfun$kafka$log$LogValidator$$validateRecord$1$;
import kafka.log.LogValidator$$anonfun$validateMessagesAndAssignOffsetsCompressed$1$;
import kafka.log.LogValidator$$anonfun$validateMessagesAndAssignOffsetsCompressed$1$$anonfun$apply$9$;
import kafka.message.CompressionCodec;
import kafka.message.NoCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.interceptor.RecordInterceptor;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableView$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableViewLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

public final class LogValidator$
implements Logging {
    public static final LogValidator$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogValidator$();
    }

    private Logger logger$lzycompute() {
        LogValidator$ logValidator$ = this;
        synchronized (logValidator$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsets(MemoryRecords records, TopicPartition topicPartition, kafka.common.LongRef offsetCounter, Time time, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte magic, TimestampType timestampType, long timestampDiffMaxMs, Iterable<RecordInterceptor> interceptors, InterceptorStats interceptorStats, int partitionLeaderEpoch, AppendOrigin origin, ApiVersion interBrokerProtocolVersion, BrokerTopicStats brokerTopicStats) {
        LogValidator.ValidationAndOffsetAssignResult validationAndOffsetAssignResult;
        CompressionCodec compressionCodec = sourceCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            CompressionCodec compressionCodec2 = targetCodec;
            NoCompressionCodec$ noCompressionCodec$2 = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$2) : noCompressionCodec$2 != null)) {
                if (records.hasMatchingMagic(magic)) {
                    validationAndOffsetAssignResult = this.assignOffsetsNonCompressed(records, topicPartition, offsetCounter, now, compactedTopic, timestampType, timestampDiffMaxMs, partitionLeaderEpoch, origin, magic, interceptors, interceptorStats, brokerTopicStats);
                    return validationAndOffsetAssignResult;
                }
                validationAndOffsetAssignResult = this.convertAndAssignOffsetsNonCompressed(records, topicPartition, offsetCounter, compactedTopic, time, now, timestampType, timestampDiffMaxMs, magic, partitionLeaderEpoch, interceptors, interceptorStats, origin, brokerTopicStats);
                return validationAndOffsetAssignResult;
            }
        }
        validationAndOffsetAssignResult = this.validateMessagesAndAssignOffsetsCompressed(records, topicPartition, offsetCounter, time, now, sourceCodec, targetCodec, compactedTopic, magic, timestampType, timestampDiffMaxMs, partitionLeaderEpoch, origin, interBrokerProtocolVersion, interceptors, interceptorStats, brokerTopicStats);
        return validationAndOffsetAssignResult;
    }

    private RecordBatch getFirstBatchAndMaybeValidateNoMoreBatches(MemoryRecords records, CompressionCodec sourceCodec) {
        block4: {
            MutableRecordBatch batch;
            block6: {
                java.util.Iterator batchIterator;
                block5: {
                    batchIterator = records.batches().iterator();
                    if (!batchIterator.hasNext()) break block4;
                    batch = (MutableRecordBatch)batchIterator.next();
                    if (batch.magic() >= 2) break block5;
                    CompressionCodec compressionCodec = sourceCodec;
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    if (!(compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$))) break block6;
                }
                if (batchIterator.hasNext()) {
                    throw new InvalidRecordException("Compressed outer record has more than one batch");
                }
            }
            return batch;
        }
        throw new InvalidRecordException("Record batch has no batches at all");
    }

    public void kafka$log$LogValidator$$validateBatch(TopicPartition topicPartition, RecordBatch firstBatch, RecordBatch batch, AppendOrigin origin, byte toMagic, BrokerTopicStats brokerTopicStats) {
        if (firstBatch.magic() != batch.magic()) {
            brokerTopicStats.allTopicsStats().invalidMagicNumberRecordsPerSec().mark();
            throw new InvalidRecordException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch magic ", " is not the same as the first batch'es magic byte ", " in topic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)batch.magic()), BoxesRunTime.boxToByte((byte)firstBatch.magic()), topicPartition})));
        }
        AppendOrigin appendOrigin = origin;
        AppendOrigin$Client$ appendOrigin$Client$ = AppendOrigin$Client$.MODULE$;
        if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Client$) : appendOrigin$Client$ != null)) {
            if (batch.magic() >= 2) {
                long countFromOffsets = batch.lastOffset() - batch.baseOffset() + 1L;
                if (countFromOffsets <= 0L) {
                    brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                    throw new InvalidRecordException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch has an invalid offset range: [", ", ", "] in topic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)batch.baseOffset()), BoxesRunTime.boxToLong((long)batch.lastOffset()), topicPartition})));
                }
                Integer count = batch.countOrNull();
                if (Predef$.MODULE$.Integer2int(count) <= 0) {
                    brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                    throw new InvalidRecordException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid reported count for record batch: ", " in topic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{count, topicPartition})));
                }
                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)countFromOffsets), (Object)batch.countOrNull())) {
                    brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                    throw new InvalidRecordException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inconsistent batch offset range [", ", ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)batch.baseOffset()), BoxesRunTime.boxToLong((long)batch.lastOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and count of records ", " in topic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{count, topicPartition}))).toString());
                }
            }
            if (batch.isControlBatch()) {
                brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                throw new InvalidRecordException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Clients are not allowed to write control records in topic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            }
            if (batch.hasProducerId() && batch.baseSequence() < 0) {
                brokerTopicStats.allTopicsStats().invalidOffsetOrSequenceRecordsPerSec().mark();
                throw new InvalidRecordException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sequence number ", " in record batch "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)batch.baseSequence())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with producerId ", " in topic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)batch.producerId()), topicPartition}))).toString());
            }
        }
        if (batch.isTransactional() && toMagic < 2) {
            throw new UnsupportedForMessageFormatException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transactional records cannot be used with magic version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)toMagic)})));
        }
        if (batch.hasProducerId() && toMagic < 2) {
            throw new UnsupportedForMessageFormatException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Idempotent records cannot be used with magic version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)toMagic)})));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<LogValidator.ApiRecordError> kafka$log$LogValidator$$validateRecord(RecordBatch batch, TopicPartition topicPartition, Record record2, int batchIndex, long now, TimestampType timestampType, long timestampDiffMaxMs, boolean compactedTopic, BrokerTopicStats brokerTopicStats, Iterable<RecordInterceptor> interceptors, InterceptorStats interceptorStats) {
        if (!record2.hasMagic(batch.magic())) {
            brokerTopicStats.allTopicsStats().invalidMagicNumberRecordsPerSec().mark();
            return new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_RECORD, new ProduceResponse.RecordError(batchIndex, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log record ", "'s magic does not match outer magic ", " in topic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record2, BoxesRunTime.boxToByte((byte)batch.magic()), topicPartition})))));
        }
        if (batch.magic() > 1 || !batch.isCompressed()) return this.validateKey(record2, batchIndex, topicPartition, compactedTopic, brokerTopicStats).orElse((Function0)new Serializable(batch, topicPartition, record2, batchIndex, now, timestampType, timestampDiffMaxMs, interceptors, interceptorStats){
            public static final long serialVersionUID = 0L;
            private final RecordBatch batch$1;
            public final TopicPartition topicPartition$4;
            public final Record record$1;
            public final int batchIndex$1;
            private final long now$4;
            private final TimestampType timestampType$4;
            private final long timestampDiffMaxMs$4;
            public final Iterable interceptors$4;
            public final InterceptorStats interceptorStats$4;

            public final Option<LogValidator.ApiRecordError> apply() {
                return LogValidator$.MODULE$.kafka$log$LogValidator$$validateTimestamp(this.batch$1, this.record$1, this.batchIndex$1, this.now$4, this.timestampType$4, this.timestampDiffMaxMs$4).orElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$kafka$log$LogValidator$$validateRecord$1 $outer;

                    public final Option<LogValidator.ApiRecordError> apply() {
                        Option interceptorOpt = this.$outer.interceptors$4.find((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$kafka$log$LogValidator$$validateRecord$1$$anonfun$apply$1 $outer;

                            public final boolean apply(RecordInterceptor interceptor) {
                                RecordInterceptor.RecordInterceptorResponse recordInterceptorResponse = interceptor.onAppend(this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().topicPartition$4, this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().record$1);
                                RecordInterceptor.RecordInterceptorResponse recordInterceptorResponse2 = RecordInterceptor.RecordInterceptorResponse.REJECT;
                                return !(recordInterceptorResponse != null ? !recordInterceptorResponse.equals(recordInterceptorResponse2) : recordInterceptorResponse2 != null);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        return interceptorOpt.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$kafka$log$LogValidator$$validateRecord$1$$anonfun$apply$1 $outer;

                            public final LogValidator.ApiRecordError apply(RecordInterceptor interceptor) {
                                this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().interceptorStats$4.logRejectedRecords(this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().topicPartition$4.topic(), interceptor.getClass().getName());
                                return new LogValidator.ApiRecordError(Errors.INVALID_RECORD, new ProduceResponse.RecordError(this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().batchIndex$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log record ", " is rejected by the record interceptor ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().record$1, interceptor.getClass().getName()}))));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ anonfun$kafka$log$LogValidator$$validateRecord$1 kafka$log$LogValidator$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.batch$1 = batch$1;
                this.topicPartition$4 = topicPartition$4;
                this.record$1 = record$1;
                this.batchIndex$1 = batchIndex$1;
                this.now$4 = now$4;
                this.timestampType$4 = timestampType$4;
                this.timestampDiffMaxMs$4 = timestampDiffMaxMs$4;
                this.interceptors$4 = interceptors$4;
                this.interceptorStats$4 = interceptorStats$4;
            }
        });
        try {
            record2.ensureValid();
            return this.validateKey(record2, batchIndex, topicPartition, compactedTopic, brokerTopicStats).orElse((Function0)new /* invalid duplicate definition of identical inner class */);
        }
        catch (InvalidRecordException invalidRecordException) {
            brokerTopicStats.allTopicsStats().invalidMessageCrcRecordsPerSec().mark();
            throw new CorruptRecordException(new StringBuilder().append((Object)invalidRecordException.getMessage()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" in topic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition}))).toString());
        }
    }

    private LogValidator.ValidationAndOffsetAssignResult convertAndAssignOffsetsNonCompressed(MemoryRecords records, TopicPartition topicPartition, kafka.common.LongRef offsetCounter, boolean compactedTopic, Time time, long now, TimestampType timestampType, long timestampDiffMaxMs, byte toMagicValue, int partitionLeaderEpoch, Iterable<RecordInterceptor> interceptors, InterceptorStats interceptorStats, AppendOrigin origin, BrokerTopicStats brokerTopicStats) {
        long startNanos = time.nanoseconds();
        int sizeInBytesAfterConversion = AbstractRecords.estimateSizeInBytes((byte)toMagicValue, (long)offsetCounter.value(), (CompressionType)CompressionType.NONE, (java.lang.Iterable)records.records());
        MutableRecordBatch first = (MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head();
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToLong((long)first.producerId()), (Object)BoxesRunTime.boxToShort((short)first.producerEpoch()), (Object)BoxesRunTime.boxToInteger((int)first.baseSequence()), (Object)BoxesRunTime.boxToBoolean((boolean)first.isTransactional()));
        if (tuple4 != null) {
            Tuple4 tuple42;
            long producerId = BoxesRunTime.unboxToLong((Object)tuple4._1());
            short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple4._2());
            int sequence = BoxesRunTime.unboxToInt((Object)tuple4._3());
            boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)sequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional));
            long producerId2 = BoxesRunTime.unboxToLong((Object)tuple43._1());
            short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple43._2());
            int sequence2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
            boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple43._4());
            ByteBuffer newBuffer = ByteBuffer.allocate(sizeInBytesAfterConversion);
            MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)newBuffer, (byte)toMagicValue, (CompressionType)CompressionType.NONE, (TimestampType)timestampType, (long)offsetCounter.value(), (long)now, (long)producerId2, (short)producerEpoch2, (int)sequence2, (boolean)isTransactional2, (int)partitionLeaderEpoch);
            RecordBatch firstBatch = this.getFirstBatchAndMaybeValidateNoMoreBatches(records, NoCompressionCodec$.MODULE$);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1)new Serializable(topicPartition, offsetCounter, compactedTopic, now, timestampType, timestampDiffMaxMs, toMagicValue, interceptors, interceptorStats, origin, brokerTopicStats, builder, firstBatch){
                public static final long serialVersionUID = 0L;
                public final TopicPartition topicPartition$1;
                public final kafka.common.LongRef offsetCounter$1;
                public final boolean compactedTopic$1;
                public final long now$1;
                public final TimestampType timestampType$1;
                public final long timestampDiffMaxMs$1;
                private final byte toMagicValue$1;
                public final Iterable interceptors$1;
                public final InterceptorStats interceptorStats$1;
                private final AppendOrigin origin$1;
                public final BrokerTopicStats brokerTopicStats$1;
                public final MemoryRecordsBuilder builder$1;
                private final RecordBatch firstBatch$1;

                public final void apply(MutableRecordBatch batch) {
                    LogValidator$.MODULE$.kafka$log$LogValidator$$validateBatch(this.topicPartition$1, this.firstBatch$1, (RecordBatch)batch, this.origin$1, this.toMagicValue$1, this.brokerTopicStats$1);
                    ArrayBuffer recordErrors = new ArrayBuffer(0);
                    ((IterableLike)((TraversableViewLike)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).view().zipWithIndex(IterableView$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Record, Object> check$ifrefutable$1) {
                            Tuple2<Record, Object> tuple2 = check$ifrefutable$1;
                            boolean bl = tuple2 != null;
                            return bl;
                        }
                    })).foreach((Function1)new Serializable(this, recordErrors, batch){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.convertAndAssignOffsetsNonCompressed.1 $outer;
                        public final ArrayBuffer recordErrors$1;
                        private final MutableRecordBatch batch$2;

                        public final void apply(Tuple2<Record, Object> x$2) {
                            Tuple2<Record, Object> tuple2 = x$2;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                Record record2 = (Record)tuple2._1();
                                int batchIndex = tuple2._2$mcI$sp();
                                LogValidator$.MODULE$.kafka$log$LogValidator$$validateRecord((RecordBatch)this.batch$2, this.$outer.topicPartition$1, record2, batchIndex, this.$outer.now$1, this.$outer.timestampType$1, this.$outer.timestampDiffMaxMs$1, this.$outer.compactedTopic$1, this.$outer.brokerTopicStats$1, (Iterable<RecordInterceptor>)this.$outer.interceptors$1, this.$outer.interceptorStats$1).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$convertAndAssignOffsetsNonCompressed$1$$anonfun$apply$4 $outer;

                                    public final ArrayBuffer<LogValidator.ApiRecordError> apply(LogValidator.ApiRecordError recordError) {
                                        return this.$outer.recordErrors$1.$plus$eq((Object)recordError);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                if (this.recordErrors$1.isEmpty()) {
                                    this.$outer.builder$1.appendWithOffset(this.$outer.offsetCounter$1.getAndIncrement(), record2);
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.recordErrors$1 = recordErrors$1;
                            this.batch$2 = batch$2;
                        }
                    });
                    LogValidator$.MODULE$.kafka$log$LogValidator$$processRecordErrors((Seq<LogValidator.ApiRecordError>)recordErrors);
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.offsetCounter$1 = offsetCounter$1;
                    this.compactedTopic$1 = compactedTopic$1;
                    this.now$1 = now$1;
                    this.timestampType$1 = timestampType$1;
                    this.timestampDiffMaxMs$1 = timestampDiffMaxMs$1;
                    this.toMagicValue$1 = toMagicValue$1;
                    this.interceptors$1 = interceptors$1;
                    this.interceptorStats$1 = interceptorStats$1;
                    this.origin$1 = origin$1;
                    this.brokerTopicStats$1 = brokerTopicStats$1;
                    this.builder$1 = builder$1;
                    this.firstBatch$1 = firstBatch$1;
                }
            });
            MemoryRecords convertedRecords = builder.build();
            MemoryRecordsBuilder.RecordsInfo info = builder.info();
            RecordConversionStats recordConversionStats = new RecordConversionStats((long)builder.uncompressedBytesWritten(), builder.numRecords(), time.nanoseconds() - startNanos);
            return new LogValidator.ValidationAndOffsetAssignResult(convertedRecords, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true, recordConversionStats);
        }
        throw new MatchError((Object)tuple4);
    }

    private LogValidator.ValidationAndOffsetAssignResult assignOffsetsNonCompressed(MemoryRecords records, TopicPartition topicPartition, kafka.common.LongRef offsetCounter, long now, boolean compactedTopic, TimestampType timestampType, long timestampDiffMaxMs, int partitionLeaderEpoch, AppendOrigin origin, byte magic, Iterable<RecordInterceptor> interceptors, InterceptorStats interceptorStats, BrokerTopicStats brokerTopicStats) {
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
        long initialOffset = offsetCounter.value();
        RecordBatch firstBatch = this.getFirstBatchAndMaybeValidateNoMoreBatches(records, NoCompressionCodec$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1)new Serializable(topicPartition, offsetCounter, now, compactedTopic, timestampType, timestampDiffMaxMs, partitionLeaderEpoch, origin, magic, interceptors, interceptorStats, brokerTopicStats, maxTimestamp, offsetOfMaxTimestamp, firstBatch){
            public static final long serialVersionUID = 0L;
            public final TopicPartition topicPartition$2;
            public final kafka.common.LongRef offsetCounter$2;
            public final long now$2;
            public final boolean compactedTopic$2;
            public final TimestampType timestampType$2;
            public final long timestampDiffMaxMs$2;
            private final int partitionLeaderEpoch$1;
            private final AppendOrigin origin$2;
            private final byte magic$1;
            public final Iterable interceptors$2;
            public final InterceptorStats interceptorStats$2;
            public final BrokerTopicStats brokerTopicStats$2;
            private final LongRef maxTimestamp$1;
            private final LongRef offsetOfMaxTimestamp$1;
            private final RecordBatch firstBatch$2;

            public final void apply(MutableRecordBatch batch) {
                LogValidator$.MODULE$.kafka$log$LogValidator$$validateBatch(this.topicPartition$2, this.firstBatch$2, (RecordBatch)batch, this.origin$2, this.magic$1, this.brokerTopicStats$2);
                LongRef maxBatchTimestamp = LongRef.create((long)-1L);
                LongRef offsetOfMaxBatchTimestamp = LongRef.create((long)-1L);
                ArrayBuffer recordErrors = new ArrayBuffer(0);
                ((IterableLike)((TraversableViewLike)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).view().zipWithIndex(IterableView$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Record, Object> check$ifrefutable$2) {
                        Tuple2<Record, Object> tuple2 = check$ifrefutable$2;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                })).foreach((Function1)new Serializable(this, maxBatchTimestamp, offsetOfMaxBatchTimestamp, recordErrors, batch){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignOffsetsNonCompressed.1 $outer;
                    private final LongRef maxBatchTimestamp$1;
                    private final LongRef offsetOfMaxBatchTimestamp$1;
                    public final ArrayBuffer recordErrors$2;
                    private final MutableRecordBatch batch$3;

                    public final void apply(Tuple2<Record, Object> x$3) {
                        Tuple2<Record, Object> tuple2 = x$3;
                        if (tuple2 != null) {
                            BoxedUnit boxedUnit;
                            Record record2 = (Record)tuple2._1();
                            int batchIndex = tuple2._2$mcI$sp();
                            LogValidator$.MODULE$.kafka$log$LogValidator$$validateRecord((RecordBatch)this.batch$3, this.$outer.topicPartition$2, record2, batchIndex, this.$outer.now$2, this.$outer.timestampType$2, this.$outer.timestampDiffMaxMs$2, this.$outer.compactedTopic$2, this.$outer.brokerTopicStats$2, (Iterable<RecordInterceptor>)this.$outer.interceptors$2, this.$outer.interceptorStats$2).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$assignOffsetsNonCompressed$1$$anonfun$apply$7 $outer;

                                public final ArrayBuffer<LogValidator.ApiRecordError> apply(LogValidator.ApiRecordError recordError) {
                                    return this.$outer.recordErrors$2.$plus$eq((Object)recordError);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            long offset2 = this.$outer.offsetCounter$2.getAndIncrement();
                            if (this.batch$3.magic() > 0 && record2.timestamp() > this.maxBatchTimestamp$1.elem) {
                                this.maxBatchTimestamp$1.elem = record2.timestamp();
                                this.offsetOfMaxBatchTimestamp$1.elem = offset2;
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.maxBatchTimestamp$1 = maxBatchTimestamp$1;
                        this.offsetOfMaxBatchTimestamp$1 = offsetOfMaxBatchTimestamp$1;
                        this.recordErrors$2 = recordErrors$2;
                        this.batch$3 = batch$3;
                    }
                });
                LogValidator$.MODULE$.kafka$log$LogValidator$$processRecordErrors((Seq<LogValidator.ApiRecordError>)recordErrors);
                if (batch.magic() > 0 && maxBatchTimestamp.elem > this.maxTimestamp$1.elem) {
                    this.maxTimestamp$1.elem = maxBatchTimestamp.elem;
                    this.offsetOfMaxTimestamp$1.elem = offsetOfMaxBatchTimestamp.elem;
                }
                batch.setLastOffset(this.offsetCounter$2.value() - 1L);
                if (batch.magic() >= 2) {
                    batch.setPartitionLeaderEpoch(this.partitionLeaderEpoch$1);
                }
                if (batch.magic() > 0) {
                    TimestampType timestampType = this.timestampType$2;
                    TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
                    if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                        batch.setMaxTimestamp(TimestampType.LOG_APPEND_TIME, this.now$2);
                    } else {
                        batch.setMaxTimestamp(this.timestampType$2, maxBatchTimestamp.elem);
                    }
                }
            }
            {
                this.topicPartition$2 = topicPartition$2;
                this.offsetCounter$2 = offsetCounter$2;
                this.now$2 = now$2;
                this.compactedTopic$2 = compactedTopic$2;
                this.timestampType$2 = timestampType$2;
                this.timestampDiffMaxMs$2 = timestampDiffMaxMs$2;
                this.partitionLeaderEpoch$1 = partitionLeaderEpoch$1;
                this.origin$2 = origin$2;
                this.magic$1 = magic$1;
                this.interceptors$2 = interceptors$2;
                this.interceptorStats$2 = interceptorStats$2;
                this.brokerTopicStats$2 = brokerTopicStats$2;
                this.maxTimestamp$1 = maxTimestamp$1;
                this.offsetOfMaxTimestamp$1 = offsetOfMaxTimestamp$1;
                this.firstBatch$2 = firstBatch$2;
            }
        });
        TimestampType timestampType2 = timestampType;
        TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
            maxTimestamp.elem = now;
            offsetOfMaxTimestamp.elem = magic >= 2 ? offsetCounter.value() - 1L : initialOffset;
        }
        return new LogValidator.ValidationAndOffsetAssignResult(records, maxTimestamp.elem, offsetOfMaxTimestamp.elem, false, RecordConversionStats.EMPTY);
    }

    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsetsCompressed(MemoryRecords records, TopicPartition topicPartition, kafka.common.LongRef offsetCounter, Time time, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte toMagic, TimestampType timestampType, long timestampDiffMaxMs, int partitionLeaderEpoch, AppendOrigin origin, ApiVersion interBrokerProtocolVersion, Iterable<RecordInterceptor> interceptors, InterceptorStats interceptorStats, BrokerTopicStats brokerTopicStats) {
        Tuple4 tuple4;
        block11: {
            LogValidator.ValidationAndOffsetAssignResult validationAndOffsetAssignResult;
            block10: {
                Tuple4 tuple42;
                IntRef uncompressedSizeInBytes;
                ArrayBuffer validatedRecords;
                block9: {
                    CompressionCodec compressionCodec = targetCodec;
                    ZStdCompressionCodec$ zStdCompressionCodec$ = ZStdCompressionCodec$.MODULE$;
                    if (!(compressionCodec != null ? !compressionCodec.equals(zStdCompressionCodec$) : zStdCompressionCodec$ != null) && interBrokerProtocolVersion.$less(KAFKA_2_1_IV0$.MODULE$)) {
                        throw new UnsupportedCompressionTypeException("Produce requests to inter.broker.protocol.version < 2.1 broker are not allowed to use ZStandard compression");
                    }
                    CompressionCodec compressionCodec2 = sourceCodec;
                    CompressionCodec compressionCodec3 = targetCodec;
                    BooleanRef inPlaceAssignment = BooleanRef.create((!(compressionCodec2 != null ? !compressionCodec2.equals(compressionCodec3) : compressionCodec3 != null) ? 1 : 0) != 0);
                    LongRef maxTimestamp = LongRef.create((long)-1L);
                    kafka.common.LongRef expectedInnerOffset = new kafka.common.LongRef(0L);
                    validatedRecords = new ArrayBuffer();
                    uncompressedSizeInBytes = IntRef.create((int)0);
                    RecordBatch firstBatch = this.getFirstBatchAndMaybeValidateNoMoreBatches(records, sourceCodec);
                    if (firstBatch.magic() != toMagic || toMagic == 0) {
                        inPlaceAssignment.elem = false;
                    }
                    CompressionCodec compressionCodec4 = sourceCodec;
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    if (!(compressionCodec4 != null ? !compressionCodec4.equals(noCompressionCodec$) : noCompressionCodec$ != null) && firstBatch.isControlBatch()) {
                        inPlaceAssignment.elem = true;
                    }
                    Iterable batches = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala();
                    batches.foreach((Function1)new Serializable(topicPartition, now, sourceCodec, compactedTopic, toMagic, timestampType, timestampDiffMaxMs, origin, interceptors, interceptorStats, brokerTopicStats, inPlaceAssignment, maxTimestamp, expectedInnerOffset, validatedRecords, uncompressedSizeInBytes, firstBatch){
                        public static final long serialVersionUID = 0L;
                        public final TopicPartition topicPartition$3;
                        public final long now$3;
                        public final CompressionCodec sourceCodec$1;
                        public final boolean compactedTopic$3;
                        public final byte toMagic$1;
                        public final TimestampType timestampType$3;
                        public final long timestampDiffMaxMs$3;
                        private final AppendOrigin origin$3;
                        public final Iterable interceptors$3;
                        public final InterceptorStats interceptorStats$3;
                        public final BrokerTopicStats brokerTopicStats$3;
                        public final BooleanRef inPlaceAssignment$1;
                        public final LongRef maxTimestamp$2;
                        public final kafka.common.LongRef expectedInnerOffset$1;
                        public final ArrayBuffer validatedRecords$1;
                        public final IntRef uncompressedSizeInBytes$1;
                        private final RecordBatch firstBatch$3;

                        /*
                         * WARNING - void declaration
                         */
                        public final void apply(MutableRecordBatch batch) {
                            LogValidator$.MODULE$.kafka$log$LogValidator$$validateBatch(this.topicPartition$3, this.firstBatch$3, (RecordBatch)batch, this.origin$3, this.toMagic$1, this.brokerTopicStats$3);
                            this.uncompressedSizeInBytes$1.elem += AbstractRecords.recordBatchHeaderSizeInBytes((byte)this.toMagic$1, (CompressionType)batch.compressionType());
                            CloseableIterator recordsIterator = this.inPlaceAssignment$1.elem && this.firstBatch$3.magic() >= 2 && this.interceptors$3.isEmpty() ? batch.skipKeyValueIterator(BufferSupplier.NO_CACHING) : batch.streamingIterator(BufferSupplier.NO_CACHING);
                            try {
                                ArrayBuffer recordErrors = new ArrayBuffer(0);
                                IntRef batchIndex = IntRef.create((int)0);
                                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)recordsIterator).asScala()).foreach((Function1)new Serializable(this, recordErrors, batchIndex, batch){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun.validateMessagesAndAssignOffsetsCompressed.1 $outer;
                                    private final ArrayBuffer recordErrors$3;
                                    public final IntRef batchIndex$2;
                                    public final MutableRecordBatch batch$4;

                                    public final void apply(Record record2) {
                                        Option option;
                                        block4: {
                                            block3: {
                                                ArrayBuffer arrayBuffer;
                                                block2: {
                                                    long expectedOffset = this.$outer.expectedInnerOffset$1.getAndIncrement();
                                                    Option recordError = LogValidator$.MODULE$.kafka$log$LogValidator$$validateRecordCompression$1(this.batchIndex$2.elem, record2, this.$outer.sourceCodec$1).orElse((Function0)new Serializable(this, expectedOffset, record2){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ anonfun$validateMessagesAndAssignOffsetsCompressed$1$$anonfun$apply$9 $outer;
                                                        public final long expectedOffset$1;
                                                        public final Record record$2;

                                                        public final Option<LogValidator.ApiRecordError> apply() {
                                                            return LogValidator$.MODULE$.kafka$log$LogValidator$$validateRecord((RecordBatch)this.$outer.batch$4, this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().topicPartition$3, this.record$2, this.$outer.batchIndex$2.elem, this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().now$3, this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().timestampType$3, this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().timestampDiffMaxMs$3, this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().compactedTopic$3, this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().brokerTopicStats$3, (Iterable<RecordInterceptor>)this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().interceptors$3, this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$$outer().interceptorStats$3).orElse((Function0)new Serializable(this){
                                                                public static final long serialVersionUID = 0L;
                                                                private final /* synthetic */ anonfun$validateMessagesAndAssignOffsetsCompressed$1$$anonfun$apply$9$$anonfun$2 $outer;

                                                                public final None$ apply() {
                                                                    if (this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$anonfun$$$outer().batch$4.magic() > 0 && this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogValidator$$anonfun$$anonfun$$$outer().toMagic$1 > 0) {
                                                                        if (this.$outer.record$2.timestamp() > this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogValidator$$anonfun$$anonfun$$$outer().maxTimestamp$2.elem) {
                                                                            this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogValidator$$anonfun$$anonfun$$$outer().maxTimestamp$2.elem = this.$outer.record$2.timestamp();
                                                                        }
                                                                        if (this.$outer.record$2.offset() != this.$outer.expectedOffset$1) {
                                                                            this.$outer.kafka$log$LogValidator$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogValidator$$anonfun$$anonfun$$$outer().inPlaceAssignment$1.elem = false;
                                                                        }
                                                                    }
                                                                    return None$.MODULE$;
                                                                }
                                                                {
                                                                    if ($outer == null) {
                                                                        throw null;
                                                                    }
                                                                    this.$outer = $outer;
                                                                }
                                                            });
                                                        }

                                                        public /* synthetic */ anonfun$validateMessagesAndAssignOffsetsCompressed$1$$anonfun$apply$9 kafka$log$LogValidator$$anonfun$$anonfun$$anonfun$$$outer() {
                                                            return this.$outer;
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                            this.expectedOffset$1 = expectedOffset$1;
                                                            this.record$2 = record$2;
                                                        }
                                                    });
                                                    option = recordError;
                                                    if (!(option instanceof Some)) break block2;
                                                    Some some = (Some)option;
                                                    LogValidator.ApiRecordError e = (LogValidator.ApiRecordError)some.x();
                                                    arrayBuffer = this.recordErrors$3.$plus$eq((Object)e);
                                                    break block3;
                                                }
                                                if (!None$.MODULE$.equals(option)) break block4;
                                                this.$outer.uncompressedSizeInBytes$1.elem += record2.sizeInBytes();
                                                arrayBuffer = this.$outer.validatedRecords$1.$plus$eq((Object)record2);
                                            }
                                            ++this.batchIndex$2.elem;
                                            return;
                                        }
                                        throw new MatchError((Object)option);
                                    }

                                    public /* synthetic */ anonfun.validateMessagesAndAssignOffsetsCompressed.1 kafka$log$LogValidator$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.recordErrors$3 = recordErrors$3;
                                        this.batchIndex$2 = batchIndex$2;
                                        this.batch$4 = batch$4;
                                    }
                                });
                                LogValidator$.MODULE$.kafka$log$LogValidator$$processRecordErrors((Seq<LogValidator.ApiRecordError>)recordErrors);
                            }
                            catch (Throwable throwable) {
                                void var2_2;
                                var2_2.close();
                                throw throwable;
                            }
                            recordsIterator.close();
                        }
                        {
                            this.topicPartition$3 = topicPartition$3;
                            this.now$3 = now$3;
                            this.sourceCodec$1 = sourceCodec$1;
                            this.compactedTopic$3 = compactedTopic$3;
                            this.toMagic$1 = toMagic$1;
                            this.timestampType$3 = timestampType$3;
                            this.timestampDiffMaxMs$3 = timestampDiffMaxMs$3;
                            this.origin$3 = origin$3;
                            this.interceptors$3 = interceptors$3;
                            this.interceptorStats$3 = interceptorStats$3;
                            this.brokerTopicStats$3 = brokerTopicStats$3;
                            this.inPlaceAssignment$1 = inPlaceAssignment$1;
                            this.maxTimestamp$2 = maxTimestamp$2;
                            this.expectedInnerOffset$1 = expectedInnerOffset$1;
                            this.validatedRecords$1 = validatedRecords$1;
                            this.uncompressedSizeInBytes$1 = uncompressedSizeInBytes$1;
                            this.firstBatch$3 = firstBatch$3;
                        }
                    });
                    if (!inPlaceAssignment.elem) break block9;
                    MutableRecordBatch batch = (MutableRecordBatch)records.batches().iterator().next();
                    long lastOffset = offsetCounter.addAndGet(validatedRecords.size()) - 1L;
                    batch.setLastOffset(lastOffset);
                    TimestampType timestampType2 = timestampType;
                    TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
                    if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                        maxTimestamp.elem = now;
                    }
                    if (toMagic >= 1) {
                        batch.setMaxTimestamp(timestampType, maxTimestamp.elem);
                    }
                    if (toMagic >= 2) {
                        batch.setPartitionLeaderEpoch(partitionLeaderEpoch);
                    }
                    RecordConversionStats recordConversionStats = new RecordConversionStats((long)uncompressedSizeInBytes.elem, 0, 0L);
                    validationAndOffsetAssignResult = new LogValidator.ValidationAndOffsetAssignResult(records, maxTimestamp.elem, lastOffset, false, recordConversionStats);
                    break block10;
                }
                MutableRecordBatch first = (MutableRecordBatch)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head();
                tuple4 = new Tuple4((Object)BoxesRunTime.boxToLong((long)first.producerId()), (Object)BoxesRunTime.boxToShort((short)first.producerEpoch()), (Object)BoxesRunTime.boxToInteger((int)first.baseSequence()), (Object)BoxesRunTime.boxToBoolean((boolean)first.isTransactional()));
                if (tuple4 == null) break block11;
                long producerId = BoxesRunTime.unboxToLong((Object)tuple4._1());
                short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple4._2());
                int sequence = BoxesRunTime.unboxToInt((Object)tuple4._3());
                boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
                Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToLong((long)producerId), (Object)BoxesRunTime.boxToShort((short)producerEpoch), (Object)BoxesRunTime.boxToInteger((int)sequence), (Object)BoxesRunTime.boxToBoolean((boolean)isTransactional));
                long producerId2 = BoxesRunTime.unboxToLong((Object)tuple43._1());
                short producerEpoch2 = BoxesRunTime.unboxToShort((Object)tuple43._2());
                int sequence2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
                boolean isTransactional2 = BoxesRunTime.unboxToBoolean((Object)tuple43._4());
                validationAndOffsetAssignResult = this.buildRecordsAndAssignOffsets(toMagic, offsetCounter, time, timestampType, CompressionType.forId((int)targetCodec.codec()), now, (Seq<Record>)validatedRecords, producerId2, producerEpoch2, sequence2, isTransactional2, partitionLeaderEpoch, uncompressedSizeInBytes.elem);
            }
            return validationAndOffsetAssignResult;
        }
        throw new MatchError((Object)tuple4);
    }

    private LogValidator.ValidationAndOffsetAssignResult buildRecordsAndAssignOffsets(byte magic, kafka.common.LongRef offsetCounter, Time time, TimestampType timestampType, CompressionType compressionType, long logAppendTime, Seq<Record> validatedRecords, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, int partitionLeaderEpoch, int uncompressedSizeInBytes) {
        long startNanos = time.nanoseconds();
        int estimatedSize = AbstractRecords.estimateSizeInBytes((byte)magic, (long)offsetCounter.value(), (CompressionType)compressionType, (java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(validatedRecords).asJava()));
        ByteBuffer buffer = ByteBuffer.allocate(estimatedSize);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)magic, (CompressionType)compressionType, (TimestampType)timestampType, (long)offsetCounter.value(), (long)logAppendTime, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional, (int)partitionLeaderEpoch);
        validatedRecords.foreach((Function1)new Serializable(offsetCounter, builder){
            public static final long serialVersionUID = 0L;
            private final kafka.common.LongRef offsetCounter$3;
            private final MemoryRecordsBuilder builder$2;

            public final void apply(Record record2) {
                this.builder$2.appendWithOffset(this.offsetCounter$3.getAndIncrement(), record2);
            }
            {
                this.offsetCounter$3 = offsetCounter$3;
                this.builder$2 = builder$2;
            }
        });
        MemoryRecords records = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        int conversionCount = builder.numRecords();
        RecordConversionStats recordConversionStats = new RecordConversionStats((long)(uncompressedSizeInBytes + builder.uncompressedBytesWritten()), conversionCount, time.nanoseconds() - startNanos);
        return new LogValidator.ValidationAndOffsetAssignResult(records, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true, recordConversionStats);
    }

    private Option<LogValidator.ApiRecordError> validateKey(Record record2, int batchIndex, TopicPartition topicPartition, boolean compactedTopic, BrokerTopicStats brokerTopicStats) {
        None$ none$;
        if (compactedTopic && !record2.hasKey()) {
            brokerTopicStats.allTopicsStats().noKeyCompactedTopicRecordsPerSec().mark();
            none$ = new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_RECORD, new ProduceResponse.RecordError(batchIndex, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compacted topic cannot accept message without key in topic partition ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})))));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<LogValidator.ApiRecordError> kafka$log$LogValidator$$validateTimestamp(RecordBatch batch, Record record2, int batchIndex, long now, TimestampType timestampType, long timestampDiffMaxMs) {
        None$ none$;
        TimestampType timestampType2 = timestampType;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
            if (record2.timestamp() != -1L && package$.MODULE$.abs(record2.timestamp() - now) > timestampDiffMaxMs) {
                none$ = new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_TIMESTAMP, new ProduceResponse.RecordError(batchIndex, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp ", " of message with offset ", " is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record2.timestamp()), BoxesRunTime.boxToLong((long)record2.offset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"out of range. The timestamp should be within [", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now - timestampDiffMaxMs))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now + timestampDiffMaxMs))}))).toString())));
                return none$;
            }
        }
        TimestampType timestampType4 = batch.timestampType();
        TimestampType timestampType5 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType4 != null ? !timestampType4.equals(timestampType5) : timestampType5 != null)) {
            none$ = new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_TIMESTAMP, new ProduceResponse.RecordError(batchIndex, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid timestamp type in message ", ". Producer should not set timestamp "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record2}))).append((Object)"type to LogAppendTime.").toString())));
            return none$;
        }
        none$ = None$.MODULE$;
        return none$;
    }

    public void kafka$log$LogValidator$$processRecordErrors(Seq<LogValidator.ApiRecordError> recordErrors) {
        if (recordErrors.nonEmpty()) {
            Seq errors = (Seq)recordErrors.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ProduceResponse.RecordError apply(LogValidator.ApiRecordError x$5) {
                    return x$5.recordError();
                }
            }, Seq$.MODULE$.canBuildFrom());
            if (recordErrors.exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(LogValidator.ApiRecordError x$6) {
                    Errors errors = x$6.apiError();
                    Errors errors2 = Errors.INVALID_TIMESTAMP;
                    return !(errors != null ? !errors.equals(errors2) : errors2 != null);
                }
            })) {
                throw new RecordValidationException((ApiException)new InvalidTimestampException("One or more records have been rejected due to invalid timestamp"), (Seq<ProduceResponse.RecordError>)errors);
            }
            throw new RecordValidationException((ApiException)((Object)new InvalidRecordException("One or more records have been rejected")), (Seq<ProduceResponse.RecordError>)errors);
        }
    }

    public final Option kafka$log$LogValidator$$validateRecordCompression$1(int batchIndex, Record record2, CompressionCodec sourceCodec$1) {
        CompressionCodec compressionCodec = sourceCodec$1;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        return (compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$)) && record2.isCompressed() ? new Some((Object)new LogValidator.ApiRecordError(Errors.INVALID_RECORD, new ProduceResponse.RecordError(batchIndex, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compressed outer record should not have an inner record with a compression attribute set: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record2}))))) : None$.MODULE$;
    }

    private LogValidator$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

