/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.util.Iterator;
import kafka.log.AppendOrigin;
import kafka.log.AppendOrigin$Client$;
import kafka.log.AppendOrigin$Replication$;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f!B\u0001\u0003\u0001\t1!A\u0005)s_\u0012,8-\u001a:BaB,g\u000eZ%oM>T!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b'\r\u0001q!\u0004\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0007\u0001)\u0012a\u0006\t\u00031\u0001j\u0011!\u0007\u0006\u00035m\taaY8n[>t'BA\u0003\u001d\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005J\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\tG\u0001\u0011\t\u0011)A\u0005/\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005\u0003\u0005&\u0001\t\u0015\r\u0011\"\u0001'\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u000b\u0002OA\u0011\u0001\u0002K\u0005\u0003S%\u0011A\u0001T8oO\"A1\u0006\u0001B\u0001B\u0003%q%A\u0006qe>$WoY3s\u0013\u0012\u0004\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011\u0001\u0018\u0002\u0019\r,(O]3oi\u0016sGO]=\u0016\u0003=\u0002\"\u0001M\u0019\u000e\u0003\tI!A\r\u0002\u0003%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0005\ti\u0001\u0011\t\u0011)A\u0005_\u0005i1-\u001e:sK:$XI\u001c;ss\u0002B\u0001B\u000e\u0001\u0003\u0006\u0004%\taN\u0001\u0007_JLw-\u001b8\u0016\u0003a\u0002\"\u0001M\u001d\n\u0005i\u0012!\u0001D!qa\u0016tGm\u0014:jO&t\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u000f=\u0014\u0018nZ5oA!)a\b\u0001C\u0001\u007f\u00051A(\u001b8jiz\"R\u0001Q!C\u0007\u0012\u0003\"\u0001\r\u0001\t\u000bQi\u0004\u0019A\f\t\u000b\u0015j\u0004\u0019A\u0014\t\u000b5j\u0004\u0019A\u0018\t\u000bYj\u0004\u0019\u0001\u001d\t\u000f\u0019\u0003!\u0019!C\u0005\u000f\u0006aAO]1og\u0006\u001cG/[8ogV\t\u0001\nE\u0002J\u001dBk\u0011A\u0013\u0006\u0003\u00172\u000bq!\\;uC\ndWM\u0003\u0002N\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=S%A\u0003'jgR\u0014UO\u001a4feB\u0011\u0001'U\u0005\u0003%\n\u00111\u0002\u0016=o\u001b\u0016$\u0018\rZ1uC\"1A\u000b\u0001Q\u0001\n!\u000bQ\u0002\u001e:b]N\f7\r^5p]N\u0004\u0003b\u0002,\u0001\u0005\u0004%IAL\u0001\rkB$\u0017\r^3e\u000b:$(/\u001f\u0005\u00071\u0002\u0001\u000b\u0011B\u0018\u0002\u001bU\u0004H-\u0019;fI\u0016sGO]=!\u0011\u0015Q\u0006\u0001\"\u0003\\\u0003Yi\u0017-\u001f2f-\u0006d\u0017\u000eZ1uK\u0012\u000bG/\u0019\"bi\u000eDG\u0003\u0002/`I&\u0004\"\u0001C/\n\u0005yK!\u0001B+oSRDQ\u0001Y-A\u0002\u0005\fQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007C\u0001\u0005c\u0013\t\u0019\u0017BA\u0003TQ>\u0014H\u000fC\u0003f3\u0002\u0007a-\u0001\u0005gSJ\u001cHoU3r!\tAq-\u0003\u0002i\u0013\t\u0019\u0011J\u001c;\t\u000b)L\u0006\u0019A\u0014\u0002\r=4gm]3u\u0011\u0015a\u0007\u0001\"\u0003n\u0003I\u0019\u0007.Z2l!J|G-^2fe\u0016\u0003xn\u00195\u0015\u0007qsw\u000eC\u0003aW\u0002\u0007\u0011\rC\u0003kW\u0002\u0007q\u0005C\u0003r\u0001\u0011%!/A\u0007dQ\u0016\u001c7nU3rk\u0016t7-\u001a\u000b\u00059N$h\u000fC\u0003aa\u0002\u0007\u0011\rC\u0003va\u0002\u0007a-\u0001\bbaB,g\u000e\u001a$jeN$8+Z9\t\u000b)\u0004\b\u0019A\u0014\t\u000ba\u0004A\u0011B=\u0002\u0015%t7+Z9vK:\u001cW\rF\u0002{{~\u0004\"\u0001C>\n\u0005qL!a\u0002\"p_2,\u0017M\u001c\u0005\u0006}^\u0004\rAZ\u0001\bY\u0006\u001cHoU3r\u0011\u0019\t\ta\u001ea\u0001M\u00069a.\u001a=u'\u0016\f\bbBA\u0003\u0001\u0011\u0005\u0011qA\u0001\u0007CB\u0004XM\u001c3\u0015\r\u0005%\u0011QCA\u0013!\u0015A\u00111BA\b\u0013\r\ti!\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007A\n\t\"C\u0002\u0002\u0014\t\u0011AbQ8na2,G/\u001a3Uq:D\u0001\"a\u0006\u0002\u0004\u0001\u0007\u0011\u0011D\u0001\u0006E\u0006$8\r\u001b\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011qD\r\u0002\rI,7m\u001c:e\u0013\u0011\t\u0019#!\b\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\t\u0003O\t\u0019\u00011\u0001\u0002*\u00051b-\u001b:ti>3gm]3u\u001b\u0016$\u0018\rZ1uC>\u0003H\u000fE\u0003\t\u0003\u0017\tY\u0003\u0005\u0003\u0002.\u0005MRBAA\u0018\u0015\r\t\t\u0004B\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005U\u0012q\u0006\u0002\u0012\u0019><wJ\u001a4tKRlU\r^1eCR\f\u0007bBA\u001d\u0001\u0011\u0005\u00111H\u0001\u0010CB\u0004XM\u001c3ECR\f')\u0019;dQRyA,!\u0010\u0002B\u0005\r\u0013QIA%\u0003\u001b\n\t\u0006C\u0004\u0002@\u0005]\u0002\u0019A1\u0002\u000b\u0015\u0004xn\u00195\t\r\u0015\f9\u00041\u0001g\u0011\u0019q\u0018q\u0007a\u0001M\"9\u0011qIA\u001c\u0001\u00049\u0013!\u00047bgR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0005\u0002L\u0005]\u0002\u0019AA\u0016\u0003M1\u0017N]:u\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011\u001d\ty%a\u000eA\u0002\u001d\n!\u0002\\1ti>3gm]3u\u0011\u001d\t\u0019&a\u000eA\u0002i\fq\"[:Ue\u0006t7/Y2uS>t\u0017\r\u001c\u0005\b\u0003/\u0002A\u0011BA-\u0003U\u0019\u0007.Z2l\u0007>|'\u000fZ5oCR|'/\u00129pG\"$R\u0001XA.\u0003KB\u0001\"!\u0018\u0002V\u0001\u0007\u0011qL\u0001\rK:$G\u000b\u001f8NCJ\\WM\u001d\t\u0005\u00037\t\t'\u0003\u0003\u0002d\u0005u!\u0001F#oIR\u0013\u0018M\\:bGRLwN\\'be.,'\u000f\u0003\u0004k\u0003+\u0002\ra\n\u0005\b\u0003S\u0002A\u0011AA6\u0003I\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015\u0015\u0005=\u0011QNA8\u0003c\n\u0019\b\u0003\u0005\u0002^\u0005\u001d\u0004\u0019AA0\u0011\u0019\u0001\u0017q\ra\u0001C\"1!.a\u001aA\u0002\u001dBq!!\u001e\u0002h\u0001\u0007q%A\u0005uS6,7\u000f^1na\"1\u0011\u0011\u0010\u0001\u0005\u00029\nq\u0001^8F]R\u0014\u0018\u0010C\u0004\u0002~\u0001!\t!a \u0002'M$\u0018M\u001d;fIR\u0013\u0018M\\:bGRLwN\\:\u0016\u0005\u0005\u0005\u0005#BAB\u0003'\u0003f\u0002BAC\u0003\u001fsA!a\"\u0002\u000e6\u0011\u0011\u0011\u0012\u0006\u0004\u0003\u0017+\u0012A\u0002\u001fs_>$h(C\u0001\u000b\u0013\r\t\t*C\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)*a&\u0003\t1K7\u000f\u001e\u0006\u0004\u0003#K\u0001bBAN\u0001\u0011\u0005\u0013QT\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0014\t\u0005\u0003C\u000b9KD\u0002\t\u0003GK1!!*\n\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011VAV\u0005\u0019\u0019FO]5oO*\u0019\u0011QU\u0005")
public class ProducerAppendInfo
implements Logging {
    private final TopicPartition topicPartition;
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final AppendOrigin origin;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry kafka$log$ProducerAppendInfo$$updatedEntry;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ProducerAppendInfo producerAppendInfo = this;
        synchronized (producerAppendInfo) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public AppendOrigin origin() {
        return this.origin;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    public ProducerStateEntry kafka$log$ProducerAppendInfo$$updatedEntry() {
        return this.kafka$log$ProducerAppendInfo$$updatedEntry;
    }

    private void maybeValidateDataBatch(short producerEpoch, int firstSeq, long offset2) {
        this.checkProducerEpoch(producerEpoch, offset2);
        AppendOrigin appendOrigin = this.origin();
        AppendOrigin$Client$ appendOrigin$Client$ = AppendOrigin$Client$.MODULE$;
        if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Client$) : appendOrigin$Client$ != null)) {
            this.checkSequence(producerEpoch, firstSeq, offset2);
        }
    }

    private void checkProducerEpoch(short producerEpoch, long offset2) {
        if (producerEpoch < this.kafka$log$ProducerAppendInfo$$updatedEntry().producerEpoch()) {
            String message = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Producer's epoch at offset ", " in ", " is ", ", which is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.topicPartition(), BoxesRunTime.boxToShort((short)producerEpoch)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"smaller than the last seen epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.kafka$log$ProducerAppendInfo$$updatedEntry().producerEpoch())}))).toString();
            AppendOrigin appendOrigin = this.origin();
            AppendOrigin$Replication$ appendOrigin$Replication$ = AppendOrigin$Replication$.MODULE$;
            if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Replication$) : appendOrigin$Replication$ != null)) {
                this.warn((Function0<String>)new Serializable(this, message){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;

                    public final String apply() {
                        return this.message$1;
                    }
                    {
                        this.message$1 = message$1;
                    }
                });
            } else {
                throw new ProducerFencedException(message);
            }
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq, long offset2) {
        int currentLastSeq;
        block7: {
            block6: {
                block5: {
                    if (producerEpoch == this.kafka$log$ProducerAppendInfo$$updatedEntry().producerEpoch()) break block5;
                    if (appendFirstSeq != 0 && this.kafka$log$ProducerAppendInfo$$updatedEntry().producerEpoch() != -1) {
                        throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid sequence number for new epoch at offset ", " in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition ", ": ", " (request epoch), ", " (seq. number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition(), BoxesRunTime.boxToShort((short)producerEpoch), BoxesRunTime.boxToInteger((int)appendFirstSeq)}))).toString());
                    }
                    break block6;
                }
                int n = this.kafka$log$ProducerAppendInfo$$updatedEntry().isEmpty() ? (producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1) : (currentLastSeq = this.kafka$log$ProducerAppendInfo$$updatedEntry().lastSeq());
                if (this.currentEntry().producerEpoch() != -1 && !this.inSequence(currentLastSeq, appendFirstSeq)) break block7;
            }
            return;
        }
        throw new OutOfOrderSequenceException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Out of order sequence number for producerId ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ": ", " (incoming seq. number), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.topicPartition(), BoxesRunTime.boxToInteger((int)appendFirstSeq)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (current end sequence number)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentLastSeq)}))).toString());
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch, Option<LogOffsetMetadata> firstOffsetMetadataOpt) {
        None$ none$;
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record2 = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record2);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record2.timestamp());
                none$ = new Some((Object)completedTxn);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            LogOffsetMetadata firstOffsetMetadata2 = (LogOffsetMetadata)firstOffsetMetadataOpt.getOrElse((Function0)new Serializable(this, batch){
                public static final long serialVersionUID = 0L;
                private final RecordBatch batch$1;

                public final LogOffsetMetadata apply() {
                    return new LogOffsetMetadata(this.batch$1.baseOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3());
                }
                {
                    this.batch$1 = batch$1;
                }
            });
            this.appendDataBatch(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), firstOffsetMetadata2, batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void appendDataBatch(short epoch, int firstSeq, int lastSeq, long lastTimestamp, LogOffsetMetadata firstOffsetMetadata2, long lastOffset, boolean isTransactional) {
        long firstOffset = firstOffsetMetadata2.messageOffset();
        this.maybeValidateDataBatch(epoch, firstSeq, firstOffset);
        this.kafka$log$ProducerAppendInfo$$updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.kafka$log$ProducerAppendInfo$$updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected transactional write from producer ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstOffsetMetadata2, this.topicPartition()}))).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.kafka$log$ProducerAppendInfo$$updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffsetMetadata2, TxnMetadata$.MODULE$.apply$default$3()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void checkCoordinatorEpoch(EndTransactionMarker endTxnMarker, long offset2) {
        if (this.kafka$log$ProducerAppendInfo$$updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            AppendOrigin appendOrigin = this.origin();
            AppendOrigin$Replication$ appendOrigin$Replication$ = AppendOrigin$Replication$.MODULE$;
            if (!(appendOrigin != null ? !appendOrigin.equals(appendOrigin$Replication$) : appendOrigin$Replication$ != null)) {
                this.info((Function0<String>)new Serializable(this, endTxnMarker, offset2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerAppendInfo $outer;
                    private final EndTransactionMarker endTxnMarker$1;
                    private final long offset$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected invalid coordinator epoch for producerId ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.offset$1), this.$outer.topicPartition(), BoxesRunTime.boxToInteger((int)this.endTxnMarker$1.coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is older than previously known coordinator epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$ProducerAppendInfo$$updatedEntry().coordinatorEpoch())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.endTxnMarker$1 = endTxnMarker$1;
                        this.offset$1 = offset$1;
                    }
                });
            } else {
                throw new TransactionCoordinatorFencedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid coordinator epoch for producerId ", " at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offset ", " in partition ", ": ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offset2), this.topicPartition(), BoxesRunTime.boxToInteger((int)endTxnMarker.coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(zombie), ", " (current)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$log$ProducerAppendInfo$$updatedEntry().coordinatorEpoch())}))).toString());
            }
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset2, long timestamp) {
        Option<Object> option;
        block4: {
            long l;
            block3: {
                block2: {
                    long txnFirstOffset;
                    this.checkProducerEpoch(producerEpoch, offset2);
                    this.checkCoordinatorEpoch(endTxnMarker, offset2);
                    option = this.kafka$log$ProducerAppendInfo$$updatedEntry().currentTxnFirstOffset();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.x());
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset2));
                l = offset2;
            }
            long firstOffset = l;
            this.kafka$log$ProducerAppendInfo$$updatedEntry().maybeUpdateProducerEpoch(producerEpoch);
            this.kafka$log$ProducerAppendInfo$$updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
            this.kafka$log$ProducerAppendInfo$$updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
            this.kafka$log$ProducerAppendInfo$$updatedEntry().lastTimestamp_$eq(timestamp);
            ControlRecordType controlRecordType = endTxnMarker.controlType();
            ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
            return new CompletedTxn(this.producerId(), firstOffset, offset2, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
        }
        throw new MatchError(option);
    }

    public ProducerStateEntry toEntry() {
        return this.kafka$log$ProducerAppendInfo$$updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public String toString() {
        return new StringBuilder().append((Object)"ProducerAppendInfo(").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.kafka$log$ProducerAppendInfo$$updatedEntry().producerEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firstSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$log$ProducerAppendInfo$$updatedEntry().firstSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastSequence=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$log$ProducerAppendInfo$$updatedEntry().lastSeq())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"currentTxnFirstOffset=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$log$ProducerAppendInfo$$updatedEntry().currentTxnFirstOffset()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coordinatorEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$log$ProducerAppendInfo$$updatedEntry().coordinatorEpoch())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"lastTimestamp=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.kafka$log$ProducerAppendInfo$$updatedEntry().lastTimestamp())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startedTransactions=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactions()}))).toString();
    }

    public ProducerAppendInfo(TopicPartition topicPartition, long producerId, ProducerStateEntry currentEntry, AppendOrigin origin) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.origin = origin;
        Logging$class.$init$(this);
        this.transactions = (ListBuffer)ListBuffer$.MODULE$.empty();
        this.kafka$log$ProducerAppendInfo$$updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.kafka$log$ProducerAppendInfo$$updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.kafka$log$ProducerAppendInfo$$updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.kafka$log$ProducerAppendInfo$$updatedEntry().lastTimestamp_$eq(currentEntry.lastTimestamp());
        this.kafka$log$ProducerAppendInfo$$updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

