/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.BrokerBackpressureMetrics$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ExemptRequest$;
import kafka.server.NonExemptRequest$;
import kafka.server.QuotaType$Request$;
import kafka.server.RequestQueueSizePercentiles$;
import kafka.server.RequestThrottleType;
import kafka.server.ThreadUsageMetrics$;
import kafka.server.ThreadUsageSensors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001\u001d\u0011\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000f\u0003\u0005\u000e\u0001\t\u0015\r\u0011\"\u0003\u000f\u0003\u0019\u0019wN\u001c4jOV\tq\u0002\u0005\u0002\n!%\u0011\u0011C\u0001\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011B\b\u0002\u000f\r|gNZ5hA!AQ\u0003\u0001BC\u0002\u0013%a#A\u0004nKR\u0014\u0018nY:\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!!\u0006\u000e\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0013DA\u0004NKR\u0014\u0018nY:\t\u0011\u0011\u0002!\u0011!Q\u0001\n]\t\u0001\"\\3ue&\u001c7\u000f\t\u0005\tM\u0001\u0011)\u0019!C\u0005O\u0005!A/[7f+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0015)H/\u001b7t\u0013\ti#F\u0001\u0003US6,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u000bQLW.\u001a\u0011\t\u0011E\u0002!\u0011!Q\u0001\nI\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0005MJdB\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*\u0014A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u001b\t\u0011u\u0002!\u0011!Q\u0001\ny\nQ\"];pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007c\u0001\u001b@\u0003&\u0011\u0001)\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\t3U\"A\"\u000b\u0005\u0011+\u0015!B9v_R\f'BA\u0002\u001d\u0013\t95IA\nDY&,g\u000e^)v_R\f7)\u00197mE\u0006\u001c7\u000e\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0003Q\t7\r^5wKR+g.\u00198ug6\u000bg.Y4feB\u0019AgP&\u0011\u0005%a\u0015BA'\u0003\u0005Q\t5\r^5wKR+g.\u00198ug6\u000bg.Y4fe\")q\n\u0001C\u0001!\u00061A(\u001b8jiz\"r!\u0015*T)V3v\u000b\u0005\u0002\n\u0001!)QB\u0014a\u0001\u001f!)QC\u0014a\u0001/!)aE\u0014a\u0001Q!)\u0011G\u0014a\u0001e!)QH\u0014a\u0001}!)\u0011J\u0014a\u0001\u0015\"9\u0011\f\u0001b\u0001\n\u0013Q\u0016A\u0005;ie\u0016\fG-V:bO\u0016\u001cVM\\:peN,\u0012a\u0017\t\u0003\u0013qK!!\u0018\u0002\u0003%QC'/Z1e+N\fw-Z*f]N|'o\u001d\u0005\u0007?\u0002\u0001\u000b\u0011B.\u0002'QD'/Z1e+N\fw-Z*f]N|'o\u001d\u0011\t\u000f\u0005\u0004\u0001\u0019!C\u0005E\u0006\u0019B.Y:u\u0019&l\u0017\u000e^\"peJ,7\r^5p]V\t1\r\u0005\u00025I&\u0011Q-\u000e\u0002\u0007\t>,(\r\\3\t\u000f\u001d\u0004\u0001\u0019!C\u0005Q\u00069B.Y:u\u0019&l\u0017\u000e^\"peJ,7\r^5p]~#S-\u001d\u000b\u0003S2\u0004\"\u0001\u000e6\n\u0005-,$\u0001B+oSRDq!\u001c4\u0002\u0002\u0003\u00071-A\u0002yIEBaa\u001c\u0001!B\u0013\u0019\u0017\u0001\u00067bgRd\u0015.\\5u\u0007>\u0014(/Z2uS>t\u0007\u0005C\u0004r\u0001\t\u0007I\u0011\u0001:\u0002#5\f\u0007\u0010\u00165s_R$H.\u001a+j[\u0016l5/F\u0001t!\t!D/\u0003\u0002vk\t!Aj\u001c8h\u0011\u00199\b\u0001)A\u0005g\u0006\u0011R.\u0019=UQJ|G\u000f\u001e7f)&lW-T:!\u0011\u0015I\b\u0001\"\u0001{\u00031)\u00070Z7qiN+gn]8s+\u0005Y\bC\u0001\r}\u0013\ti\u0018D\u0001\u0004TK:\u001cxN\u001d\u0005\u0006\u007f\u0002!\tA_\u0001\u0018]>tW\t_3naR\u001c\u0015\r]1dSRL8+\u001a8t_JDq!a\u0001\u0001\t\u0003\t)!A\rsK\u000e|'\u000fZ#yK6\u0004HOT3uo>\u00148\u000e\u00165sK\u0006$GcB5\u0002\b\u0005-\u0011q\u0002\u0005\b\u0003\u0013\t\t\u00011\u0001d\u0003\u00151\u0018\r\\;f\u0011\u001d\ti!!\u0001A\u0002I\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016Dq!!\u0005\u0002\u0002\u0001\u00071/\u0001\u0004uS6,Wj\u001d\u0005\b\u0003+\u0001A\u0011AA\f\u0003Q\u0011XmY8sI\u0016CX-\u001c9u\u0013>$\u0006N]3bIR)\u0011.!\u0007\u0002\u001c!9\u0011\u0011BA\n\u0001\u0004\u0019\u0007bBA\t\u0003'\u0001\ra\u001d\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003U\u0011X-\\8wK2K7\u000f^3oKJlU\r\u001e:jGN$2![A\u0012\u0011\u001d\ti!!\bA\u0002IBq!a\n\u0001\t\u0003\tI#A\u0010nCf\u0014WMU3d_J$\u0017I\u001c3HKR$\u0006N]8ui2,G+[7f\u001bN$B!a\u000b\u00022A\u0019A'!\f\n\u0007\u0005=RGA\u0002J]RD\u0001\"a\r\u0002&\u0001\u0007\u0011QG\u0001\be\u0016\fX/Z:u!\u0011\t9$a\u0011\u000f\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010\u0005\u0003\u001dqW\r^<pe.LA!!\u0011\u0002<\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017\u0002BA#\u0003\u000f\u0012qAU3rk\u0016\u001cHO\u0003\u0003\u0002B\u0005m\u0002bBA&\u0001\u0011\u0005\u0011QJ\u0001\u0012[\u0006L(-\u001a*fG>\u0014H-\u0012=f[B$HcA5\u0002P!A\u00111GA%\u0001\u0004\t)\u0004C\u0004\u0002T\u0001!\t%!\u0016\u0002'\t\f7m\u001b9sKN\u001cXO]3F]\u0006\u0014G.\u001a3\u0016\u0005\u0005]\u0003c\u0001\u001b\u0002Z%\u0019\u00111L\u001b\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\f\u0001\u0005R\u0005\u0005\u0014\u0001\u0004;ie>$H\u000f\\3US6,GcA:\u0002d!A\u0011QMA/\u0001\u0004\t9'\u0001\u0007dY&,g\u000e^'fiJL7\rE\u0002\u0019\u0003SJ1!a\u001b\u001a\u0005-Y\u0015MZ6b\u001b\u0016$(/[2\t\u000f\u0005=\u0004\u0001\"\u0015\u0002r\u0005!2\r\\5f]R\u0014\u0016\r^3NKR\u0014\u0018n\u0019(b[\u0016$B!a\u001d\u0002|A!\u0011QOA<\u001b\u0005Q\u0012bAA=5\tQQ*\u001a;sS\u000et\u0015-\\3\t\u0011\u0005u\u0014Q\u000ea\u0001\u0003\u007f\nq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\t\u0006g\u0005\u0005%GM\u0005\u0004\u0003\u0007[$aA'ba\"9\u0011q\u0011\u0001\u0005\n\u0005%\u0015\u0001E3yK6\u0004H/T3ue&\u001cg*Y7f+\t\t\u0019\bC\u0004\u0002\u000e\u0002!I!a$\u0002!\u0015DX-\u001c9u'\u0016t7o\u001c:OC6,W#\u0001\u001a\t\u000f\u0005M\u0005\u0001\"\u0003\u0002\u0016\u0006\tb.\u00198pgR{\u0007+\u001a:dK:$\u0018mZ3\u0015\u0007\r\f9\nC\u0004\u0002\u001a\u0006E\u0005\u0019A:\u0002\u000b9\fgn\\:\t\r\u0005u\u0005\u0001\"\u0011c\u0003M9W\r\u001e\"s_.,'/U;pi\u0006d\u0015.\\5u\u0011\u001d\t\t\u000b\u0001C\u0005\u0003G\u000b!C]3d_J$g*\u001a;x_J\\Wk]1hKRI\u0011.!*\u0002(\u0006%\u00161\u0017\u0005\b\u0003\u0013\ty\n1\u0001d\u0011\u001d\ti!a(A\u0002IB\u0001\"a+\u0002 \u0002\u0007\u0011QV\u0001\ri\"\u0014x\u000e\u001e;mKRK\b/\u001a\t\u0004\u0013\u0005=\u0016bAAY\u0005\t\u0019\"+Z9vKN$H\u000b\u001b:piRdW\rV=qK\"9\u0011\u0011CAP\u0001\u0004\u0019\b\u0002CA\\\u0001\u0011E#!!/\u0002-U\u0004H-\u0019;f\u0005J|7.\u001a:Rk>$\u0018\rT5nSR$\u0012!\u001b\u0005\b\u0003{\u0003A\u0011AA`\u0003Y)\b\u000fZ1uK\u0006#'.^:uK\u0012\u001c\u0015\r]1dSRLHcA2\u0002B\"9\u00111YA^\u0001\u0004\u0019\u0017A\u00052s_.,'OU3rk\u0016\u001cH\u000fT5nSR\u0004")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time kafka$server$ClientRequestQuotaManager$$time;
    private final ThreadUsageSensors threadUsageSensors;
    private double kafka$server$ClientRequestQuotaManager$$lastLimitCorrection;
    private final long maxThrottleTimeMs;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Time kafka$server$ClientRequestQuotaManager$$time() {
        return this.kafka$server$ClientRequestQuotaManager$$time;
    }

    private ThreadUsageSensors threadUsageSensors() {
        return this.threadUsageSensors;
    }

    public double kafka$server$ClientRequestQuotaManager$$lastLimitCorrection() {
        return this.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection;
    }

    private void kafka$server$ClientRequestQuotaManager$$lastLimitCorrection_$eq(double x$1) {
        this.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection = x$1;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.getOrCreateSensor(this.exemptSensorName(), this.exemptMetricName());
    }

    public Sensor nonExemptCapacitySensor() {
        return this.getOrCreateValueSensor("non-exempt-capacity", BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics()));
    }

    public void recordExemptNetworkThread(double value2, String listenerName, long timeMs) {
        this.exemptSensor().record(value2, timeMs);
        this.kafka$server$ClientRequestQuotaManager$$recordNetworkUsage(value2, listenerName, ExemptRequest$.MODULE$, timeMs);
    }

    public void recordExemptIoThread(double value2, long timeMs) {
        this.exemptSensor().record(value2, timeMs);
    }

    public void removeListenerMetrics(String listenerName) {
        this.threadUsageSensors().removeListenerMetrics(listenerName);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request) {
        int n;
        if (request.apiRemoteCompleteTimeNanos() == -1L) {
            request.apiRemoteCompleteTimeNanos_$eq(this.kafka$server$ClientRequestQuotaManager$$time().nanoseconds());
        }
        long currentTimeMs = this.kafka$server$ClientRequestQuotaManager$$time().milliseconds();
        double reqIoThreadPercentage = this.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        this.threadUsageSensors().recordIoThreadUsage(reqIoThreadPercentage, currentTimeMs, this.threadUsageSensors().recordIoThreadUsage$default$3());
        if (this.quotasEnabled()) {
            this.threadUsageSensors().recordIoThreadUsage(reqIoThreadPercentage, currentTimeMs, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((Object)new Serializable(this, request, listenerName){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientRequestQuotaManager $outer;
                private final RequestChannel.Request request$1;
                private final String listenerName$1;

                public final void apply(long timeNanos) {
                    this.apply$mcVJ$sp(timeNanos);
                }

                public void apply$mcVJ$sp(long timeNanos) {
                    this.$outer.recordNoThrottle(this.$outer.getOrCreateQuotaSensors(this.request$1.session(), this.request$1.header().clientId()), this.$outer.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(timeNanos));
                    this.$outer.kafka$server$ClientRequestQuotaManager$$recordNetworkUsage(this.$outer.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(timeNanos), this.listenerName$1, NonExemptRequest$.MODULE$, this.$outer.kafka$server$ClientRequestQuotaManager$$time().milliseconds());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.request$1 = request$1;
                    this.listenerName$1 = listenerName$1;
                }
            }));
            n = this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), reqIoThreadPercentage, currentTimeMs);
        } else {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((Object)new Serializable(this, listenerName){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientRequestQuotaManager $outer;
                private final String listenerName$1;

                public final void apply(long timeNanos) {
                    this.apply$mcVJ$sp(timeNanos);
                }

                public void apply$mcVJ$sp(long timeNanos) {
                    this.$outer.kafka$server$ClientRequestQuotaManager$$recordNetworkUsage(this.$outer.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(timeNanos), this.listenerName$1, NonExemptRequest$.MODULE$, this.$outer.kafka$server$ClientRequestQuotaManager$$time().milliseconds());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.listenerName$1 = listenerName$1;
                }
            }));
            n = 0;
        }
        return n;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        long currentTimeMs = this.kafka$server$ClientRequestQuotaManager$$time().milliseconds();
        double reqIoThreadPercentage = this.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(request.requestThreadTimeNanos());
        String listenerName = request.context().listenerName.value();
        this.threadUsageSensors().recordIoThreadUsage(reqIoThreadPercentage, currentTimeMs, this.threadUsageSensors().recordIoThreadUsage$default$3());
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((Object)new Serializable(this, listenerName){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientRequestQuotaManager $outer;
                private final String listenerName$2;

                public final void apply(long timeNanos) {
                    this.apply$mcVJ$sp(timeNanos);
                }

                public void apply$mcVJ$sp(long timeNanos) {
                    this.$outer.recordExemptNetworkThread(this.$outer.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(timeNanos), this.listenerName$2, this.$outer.kafka$server$ClientRequestQuotaManager$$time().milliseconds());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.listenerName$2 = listenerName$2;
                }
            }));
            this.recordExemptIoThread(reqIoThreadPercentage, currentTimeMs);
        } else {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((Object)new Serializable(this, listenerName){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ClientRequestQuotaManager $outer;
                private final String listenerName$2;

                public final void apply(long timeNanos) {
                    this.apply$mcVJ$sp(timeNanos);
                }

                public void apply$mcVJ$sp(long timeNanos) {
                    this.$outer.kafka$server$ClientRequestQuotaManager$$recordNetworkUsage(this.$outer.kafka$server$ClientRequestQuotaManager$$nanosToPercentage(timeNanos), this.listenerName$2, ExemptRequest$.MODULE$, this.$outer.kafka$server$ClientRequestQuotaManager$$time().milliseconds());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.listenerName$2 = listenerName$2;
                }
            }));
        }
    }

    @Override
    public boolean backpressureEnabled() {
        return this.dynamicBackpressureConfig().backpressureEnabledInConfig() && this.dynamicBackpressureConfig().tenantEndpointListenerNames().nonEmpty();
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric) {
        return package$.MODULE$.min(super.throttleTime(clientMetric), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", ((Object)QuotaType$Request$.MODULE$).toString(), "Tracking request-time per user/client-id", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", ((Object)QuotaType$Request$.MODULE$).toString(), "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return new StringBuilder().append((Object)"exempt-").append((Object)QuotaType$Request$.MODULE$).toString();
    }

    public double kafka$server$ClientRequestQuotaManager$$nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    @Override
    public double getBrokerQuotaLimit() {
        double d;
        Option metricOpt = Option$.MODULE$.apply((Object)this.metrics().metric(BrokerBackpressureMetrics$.MODULE$.nonExemptRequestCapacityMetricName(this.metrics())));
        Option option = metricOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            KafkaMetric metric = (KafkaMetric)some.x();
            d = BoxesRunTime.unboxToDouble((Object)metric.metricValue());
        } else {
            d = Double.MAX_VALUE;
        }
        return d;
    }

    public void kafka$server$ClientRequestQuotaManager$$recordNetworkUsage(double value2, String listenerName, RequestThrottleType throttleType, long timeMs) {
        this.threadUsageSensors().recordNetworkThreadUsage(value2, timeMs, listenerName, this.threadUsageSensors().recordNetworkThreadUsage$default$4());
        if (this.quotasEnabled()) {
            RequestThrottleType requestThrottleType = throttleType;
            if (NonExemptRequest$.MODULE$.equals(requestThrottleType)) {
                this.threadUsageSensors().recordNetworkThreadUsage(value2, timeMs, listenerName, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    @Override
    public void updateBrokerQuotaLimit() {
        Seq<String> tenantEndpointsListenerNames = this.dynamicBackpressureConfig().tenantEndpointListenerNames();
        if (this.quotasEnabled() && tenantEndpointsListenerNames.nonEmpty()) {
            double nonExemptIoThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            double ioThreadUsage = ThreadUsageMetrics$.MODULE$.ioThreadsUsage(this.metrics(), ThreadUsageMetrics$.MODULE$.ioThreadsUsage$default$2());
            double nonExemptNetworkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, (Option<RequestThrottleType>)new Some((Object)NonExemptRequest$.MODULE$));
            double networkThreadUsage = ThreadUsageMetrics$.MODULE$.networkThreadsUsage(this.metrics(), tenantEndpointsListenerNames, ThreadUsageMetrics$.MODULE$.networkThreadsUsage$default$3());
            double nonExemptIoThreadLimit = this.nonExemptThreadUsageLimit$1(nonExemptIoThreadUsage, ioThreadUsage, ThreadUsageMetrics$.MODULE$.ioThreadsCapacity(this.metrics()));
            double nonExemptNetworkThreadLimit = this.nonExemptThreadUsageLimit$1(nonExemptNetworkThreadUsage, networkThreadUsage, ThreadUsageMetrics$.MODULE$.networkThreadsCapacity(this.metrics(), tenantEndpointsListenerNames));
            double brokerRequestQuotaLimit = ioThreadUsage >= nonExemptIoThreadLimit && networkThreadUsage >= nonExemptNetworkThreadLimit || ioThreadUsage < nonExemptIoThreadLimit && networkThreadUsage < nonExemptNetworkThreadLimit ? nonExemptIoThreadLimit + nonExemptNetworkThreadLimit : package$.MODULE$.min(networkThreadUsage, nonExemptNetworkThreadLimit) + package$.MODULE$.min(ioThreadUsage, nonExemptIoThreadLimit);
            double correctedLimit = this.updateAdjustedCapacity(brokerRequestQuotaLimit);
            this.nonExemptCapacitySensor().record(correctedLimit);
        }
    }

    public double updateAdjustedCapacity(double brokerRequestLimit) {
        double d;
        double queueSize = RequestQueueSizePercentiles$.MODULE$.dataPlaneQueueSize(this.metrics(), "p95");
        double minCap = BrokerBackpressureConfig$.MODULE$.DefaultMinRequestQuotaLimit();
        if (queueSize >= this.dynamicBackpressureConfig().queueSizeCap()) {
            double maxAdjustmentLimit = package$.MODULE$.max(brokerRequestLimit - minCap, 0.0);
            d = this.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection() < maxAdjustmentLimit ? this.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection() + BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment() : this.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection();
        } else {
            d = package$.MODULE$.max(0.0, this.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection() - BrokerBackpressureConfig$.MODULE$.DefaultRequestQuotaAdjustment());
        }
        this.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection_$eq(d);
        this.debug((Function0<String>)new Serializable(this, queueSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientRequestQuotaManager $outer;
            private final double queueSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"queueSize(p95)=", ",  lastLimitCorrection=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.queueSize$1), BoxesRunTime.boxToDouble((double)this.$outer.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.queueSize$1 = queueSize$1;
            }
        });
        return package$.MODULE$.max(brokerRequestLimit - this.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection(), minCap);
    }

    private final double nonExemptThreadUsageLimit$1(double nonExemptUsage, double totalUsage, double totalCapacity) {
        double exemptUsage = totalUsage - nonExemptUsage;
        double nonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMaxResourceUtilization() - exemptUsage;
        double minNonExemptCapacity = totalCapacity * BrokerBackpressureConfig$.MODULE$.DefaultMinNonExemptRequestUtilization();
        return package$.MODULE$.max(nonExemptCapacity, minNonExemptCapacity);
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback, Option<ActiveTenantsManager> activeTenantsManager) {
        this.config = config;
        this.metrics = metrics;
        this.kafka$server$ClientRequestQuotaManager$$time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback, activeTenantsManager);
        this.threadUsageSensors = new ThreadUsageSensors(metrics, ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds());
        this.kafka$server$ClientRequestQuotaManager$$lastLimitCorrection = 0.0;
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
    }
}

