/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import kafka.cluster.EndPoint;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.QuotaType;
import kafka.server.QuotaType$AlterLogDirsReplication$;
import kafka.server.QuotaType$Fetch$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.QuotaType$LeaderReplication$;
import kafka.server.QuotaType$Produce$;
import kafka.server.QuotaType$Request$;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class QuotaFactory$
implements Logging {
    public static final QuotaFactory$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new QuotaFactory$();
    }

    private Logger logger$lzycompute() {
        QuotaFactory$ quotaFactory$ = this;
        synchronized (quotaFactory$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public QuotaFactory.QuotaManagers instantiate(KafkaConfig cfg, Metrics metrics, Time time, String threadNamePrefix) {
        Option clientQuotaCallback = Option$.MODULE$.apply(cfg.getConfiguredInstance(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp(), ClientQuotaCallback.class));
        None$ activeTenantsManager = this.isMultiTenant(cfg) ? Option$.MODULE$.apply((Object)new ActiveTenantsManager(metrics, time, BrokerBackpressureConfig$.MODULE$.DefaultActiveWindowMs())) : None$.MODULE$;
        return new QuotaFactory.QuotaManagers(new ClientQuotaManager(this.clientFetchConfig(cfg), metrics, QuotaType$Fetch$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager), new ClientQuotaManager(this.clientProduceConfig(cfg), metrics, QuotaType$Produce$.MODULE$, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager), new ClientRequestQuotaManager(this.clientRequestConfig(cfg), metrics, time, threadNamePrefix, (Option<ClientQuotaCallback>)clientQuotaCallback, (Option<ActiveTenantsManager>)activeTenantsManager), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$LeaderReplication$.MODULE$, time), new ReplicationQuotaManager(this.replicationConfig(cfg), metrics, QuotaType$FollowerReplication$.MODULE$, time), new ReplicationQuotaManager(this.alterLogDirsReplicationConfig(cfg), metrics, QuotaType$AlterLogDirsReplication$.MODULE$, time), (Option<ClientQuotaCallback>)clientQuotaCallback);
    }

    public ClientQuotaManagerConfig clientProduceConfig(KafkaConfig cfg) {
        if (!BoxesRunTime.equalsNumObject((Number)cfg.producerQuotaBytesPerSecondDefault(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE))) {
            this.warn((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " has been deprecated in 0.11.0.0 and will be removed in a future release. Use dynamic quota defaults instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaConfig$.MODULE$.ProducerQuotaBytesPerSecondDefaultProp()}));
                }
            });
        }
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.producerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()), this.brokerBackpressureConfig(cfg, QuotaType$Produce$.MODULE$));
    }

    public ClientQuotaManagerConfig clientFetchConfig(KafkaConfig cfg) {
        if (!BoxesRunTime.equalsNumObject((Number)cfg.consumerQuotaBytesPerSecondDefault(), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE))) {
            this.warn((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " has been deprecated in 0.11.0.0 and will be removed in a future release. Use dynamic quota defaults instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaConfig$.MODULE$.ConsumerQuotaBytesPerSecondDefaultProp()}));
                }
            });
        }
        return new ClientQuotaManagerConfig(Predef$.MODULE$.Long2long(cfg.consumerQuotaBytesPerSecondDefault()), Predef$.MODULE$.Integer2int(cfg.numQuotaSamples()), Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds()), this.brokerBackpressureConfig(cfg, QuotaType$Fetch$.MODULE$));
    }

    public ClientQuotaManagerConfig clientRequestConfig(KafkaConfig cfg) {
        int x$3 = Predef$.MODULE$.Integer2int(cfg.numQuotaSamples());
        int x$4 = Predef$.MODULE$.Integer2int(cfg.quotaWindowSizeSeconds());
        BrokerBackpressureConfig x$5 = this.brokerBackpressureConfig(cfg, QuotaType$Request$.MODULE$);
        long x$6 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ClientQuotaManagerConfig(x$6, x$3, x$4, x$5);
    }

    public ReplicationQuotaManagerConfig replicationConfig(KafkaConfig cfg) {
        int x$7 = Predef$.MODULE$.Integer2int(cfg.numReplicationQuotaSamples());
        int x$8 = Predef$.MODULE$.Integer2int(cfg.replicationQuotaWindowSizeSeconds());
        long x$9 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ReplicationQuotaManagerConfig(x$9, x$7, x$8);
    }

    public ReplicationQuotaManagerConfig alterLogDirsReplicationConfig(KafkaConfig cfg) {
        int x$10 = Predef$.MODULE$.Integer2int(cfg.numAlterLogDirsReplicationQuotaSamples());
        int x$11 = Predef$.MODULE$.Integer2int(cfg.alterLogDirsReplicationQuotaWindowSizeSeconds());
        long x$12 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        return new ReplicationQuotaManagerConfig(x$12, x$10, x$11);
    }

    public boolean isMultiTenant(KafkaConfig cfg) {
        String quotaCallbackStr = (String)Option$.MODULE$.apply((Object)cfg.originalsStrings().get(KafkaConfig$.MODULE$.ClientQuotaCallbackClassProp())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return x$2.toString();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        return quotaCallbackStr.contains("io.confluent.kafka.multitenant.quota.TenantQuotaCallback");
    }

    public boolean backpressureEnabledInConfig(KafkaConfig cfg, QuotaType quotaType) {
        return this.isMultiTenant(cfg) && Option$.MODULE$.apply((Object)cfg.getString("confluent.backpressure.types")).exists((Function1)new Serializable(quotaType){
            public static final long serialVersionUID = 0L;
            public final QuotaType quotaType$1;

            public final boolean apply(String backpressureTypeProp) {
                Seq<String> backressureTypesList = CoreUtils$.MODULE$.parseCsvList(backpressureTypeProp);
                return backressureTypesList.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.backpressureEnabledInConfig.1 $outer;

                    public final boolean apply(String backpressureType) {
                        String string = backpressureType;
                        String string2 = this.$outer.quotaType$1.toString().toLowerCase();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.quotaType$1 = quotaType$1;
            }
        });
    }

    public BrokerBackpressureConfig brokerBackpressureConfig(KafkaConfig cfg, QuotaType quotaType) {
        Seq seq;
        boolean backpressureEnabled = this.backpressureEnabledInConfig(cfg, quotaType);
        QuotaType quotaType2 = quotaType;
        if (QuotaType$Request$.MODULE$.equals(quotaType2)) {
            Seq listeners2 = (Seq)((TraversableLike)Option$.MODULE$.apply((Object)cfg.getString("confluent.multitenant.listener.names")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<String> apply(String listenerNameList) {
                    return CoreUtils$.MODULE$.parseCsvList(listenerNameList);
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Seq<Nothing$> apply() {
                    return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
            })).filter((Function1)new Serializable(cfg){
                public static final long serialVersionUID = 0L;
                private final KafkaConfig cfg$1;

                public final boolean apply(String listenerName) {
                    return this.cfg$1.advertisedListeners().exists((Function1)new Serializable(this, listenerName){
                        public static final long serialVersionUID = 0L;
                        private final String listenerName$1;

                        public final boolean apply(EndPoint endpoint) {
                            String string = endpoint.listenerName().value();
                            String string2 = this.listenerName$1;
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        }
                        {
                            this.listenerName$1 = listenerName$1;
                        }
                    });
                }
                {
                    this.cfg$1 = cfg$1;
                }
            });
            if (listeners2.isEmpty() && backpressureEnabled) {
                this.warn((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid multitenant listener names provided in config. Request backpressure will be disabled"})).s((Seq)Nil$.MODULE$);
                    }
                });
            }
            seq = listeners2;
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        Seq tenantListenerNames = seq;
        boolean x$13 = backpressureEnabled;
        Seq x$14 = tenantListenerNames;
        double x$15 = Predef$.MODULE$.Integer2int(cfg.queuedMaxRequests());
        long x$16 = BrokerBackpressureConfig$.MODULE$.apply$default$2();
        return new BrokerBackpressureConfig(x$13, x$16, (Seq<String>)x$14, x$15);
    }

    private QuotaFactory$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

