/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.controller.KafkaController;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.server.TopicConfigHandler$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003V8qS\u000e\u001cuN\u001c4jO\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u00119\u0011\u0002CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\ti1i\u001c8gS\u001eD\u0015M\u001c3mKJ\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\u0005\t3\u0001\u0011)\u0019!C\u00055\u0005q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#A\u000e\u0011\u0005=a\u0012BA\u000f\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0001b\b\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0006lC\u001a\\\u0017mQ8oM&<\u0007CA\b$\u0013\t!#AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011A\u0014\u0002\rE,x\u000e^1t+\u0005A\u0003CA\u00154\u001d\tQ\u0013G\u0004\u0002,a9\u0011AfL\u0007\u0002[)\u0011aFB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I!a\u0001\u0003\n\u0005I\u0012\u0011\u0001D)v_R\fg)Y2u_JL\u0018B\u0001\u001b6\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011!G\u0001\u0005\to\u0001\u0011\t\u0011)A\u0005Q\u00059\u0011/^8uCN\u0004\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002\u001f-\fgm[1D_:$(o\u001c7mKJ\u0004\"a\u000f \u000e\u0003qR!!\u0010\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0002@y\ty1*\u00194lC\u000e{g\u000e\u001e:pY2,'\u000fC\u0003B\u0001\u0011\u0005!)\u0001\u0004=S:LGO\u0010\u000b\u0006\u0007\u0012+ei\u0012\t\u0003\u001f\u0001AQ!\u0007!A\u0002mAQ!\t!A\u0002\tBQA\n!A\u0002!BQ!\u000f!A\u0002iBq!\u0013\u0001C\u0002\u0013%!*\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0012\t1\u0001\\8h\u0013\t\u0001VJ\u0001\u0006M_\u001el\u0015M\\1hKJDaA\u0015\u0001!\u0002\u0013Y\u0015a\u00037pO6\u000bg.Y4fe\u0002BQ\u0001\u0016\u0001\u0005\nU\u000bq\"\u001e9eCR,Gj\\4D_:4\u0017n\u001a\u000b\u0005-f\u0013G\u000e\u0005\u0002\n/&\u0011\u0001L\u0003\u0002\u0005+:LG\u000fC\u0003['\u0002\u00071,A\u0003u_BL7\r\u0005\u0002]?:\u0011\u0011\"X\u0005\u0003=*\ta\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011aL\u0003\u0005\u0006GN\u0003\r\u0001Z\u0001\fi>\u0004\u0018nY\"p]\u001aLw\r\u0005\u0002fU6\taM\u0003\u0002hQ\u0006!Q\u000f^5m\u0015\u0005I\u0017\u0001\u00026bm\u0006L!a\u001b4\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003n'\u0002\u0007a.\u0001\u000bd_:4\u0017n\u001a(b[\u0016\u001cHk\\#yG2,H-\u001a\t\u00049>\\\u0016B\u00019b\u0005\r\u0019V\r\u001e\u0005\u0006e\u0002!\ta]\u0001\u0015aJ|7-Z:t\u0007>tg-[4DQ\u0006tw-Z:\u0015\u0007Y#X\u000fC\u0003[c\u0002\u00071\fC\u0003dc\u0002\u0007A\rC\u0003x\u0001\u0011\u0005\u00010\u0001\rqCJ\u001cX\r\u00165s_R$H.\u001a3QCJ$\u0018\u000e^5p]N$r!_A\u0003\u0003\u000f\tY\u0001E\u0002{{~l\u0011a\u001f\u0006\u0003y*\t!bY8mY\u0016\u001cG/[8o\u0013\tq8PA\u0002TKF\u00042!CA\u0001\u0013\r\t\u0019A\u0003\u0002\u0004\u0013:$\b\"B2w\u0001\u0004!\u0007BBA\u0005m\u0002\u0007q0\u0001\u0005ce>\\WM]%e\u0011\u0019\tiA\u001ea\u00017\u0006!\u0001O]8q\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tq\"\u001a=dYV$W\rZ\"p]\u001aLwm\u001d\u000b\u0006]\u0006U\u0011q\u0003\u0005\u00075\u0006=\u0001\u0019A.\t\r\r\fy\u00011\u0001e\u0001")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final ReplicaManager kafka$server$TopicConfigHandler$$replicaManager;
    public final KafkaConfig kafka$server$TopicConfigHandler$$kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final KafkaController kafkaController;
    private final LogManager logManager;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TopicConfigHandler topicConfigHandler = this;
        synchronized (topicConfigHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ReplicaManager kafka$server$TopicConfigHandler$$replicaManager() {
        return this.kafka$server$TopicConfigHandler$$replicaManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private void updateLogConfig(String topic, Properties topicConfig, Set<String> configNamesToExclude) {
        this.logManager().topicConfigUpdated(topic);
        Seq<AbstractLog> logs = this.logManager().logsByTopic(topic);
        if (logs.nonEmpty()) {
            Properties props = new Properties();
            ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).foreach((Function1)new Serializable(this, configNamesToExclude, props){
                public static final long serialVersionUID = 0L;
                private final Set configNamesToExclude$1;
                private final Properties props$1;

                public final Object apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value2 = (String)tuple2._2();
                        BoxedUnit boxedUnit = this.configNamesToExclude$1.contains((Object)key) ? BoxedUnit.UNIT : this.props$1.put(key, value2);
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.configNamesToExclude$1 = configNamesToExclude$1;
                    this.props$1 = props$1;
                }
            });
            LogConfig logConfig = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
            ((IterableLike)logs.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TopicPartition apply(AbstractLog x$1) {
                    return x$1.topicPartition();
                }
            }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, logConfig){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicConfigHandler $outer;
                private final LogConfig logConfig$1;

                public final void apply(TopicPartition topicPartition) {
                    this.$outer.kafka$server$TopicConfigHandler$$replicaManager().updateLogConfig(topicPartition, this.logConfig$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.logConfig$1 = logConfig$1;
                }
            });
        }
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        this.updateLogConfig(topic, topicConfig, configNamesToExclude);
        this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topic, topicConfig);
        this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topic, topicConfig);
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final Properties topicConfig$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.topicConfig$1.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()))).toBoolean();
            }
            {
                this.topicConfig$1 = topicConfig$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }))) {
            this.kafkaController.enableTopicUncleanLeaderElection(topic);
        }
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        String string = configValue;
        Seq seq = "".equals(string) ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : ("*".equals(string) ? Constants$.MODULE$.AllReplicas() : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$2) {
                return x$2.split(":");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).filter((Function1)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(String[] x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3[1])).toInt() == this.brokerId$1;
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String[] x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4[0])).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSeq());
        return seq;
    }

    public Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicConfigHandler $outer;
            public final String topic$2;

            public final Option<String> apply(String versionString) {
                None$ none$;
                if (this.$outer.kafka$server$TopicConfigHandler$$kafkaConfig.interBrokerProtocolVersion().$less(ApiVersion$.MODULE$.apply(versionString))) {
                    this.$outer.warn((Function0<String>)new Serializable(this, versionString){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$excludedConfigs$1 $outer;
                        private final String versionString$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log configuration ", " is ignored for `", "` because `", "` "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), this.$outer.topic$2, this.versionString$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not compatible with Kafka inter-broker protocol version `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$TopicConfigHandler$$anonfun$$$outer().kafka$server$TopicConfigHandler$$kafkaConfig.interBrokerProtocolVersionString()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.versionString$1 = versionString$1;
                        }
                    });
                    none$ = new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }

            public /* synthetic */ TopicConfigHandler kafka$server$TopicConfigHandler$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, String topic$1, Properties topicConfig$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafka$server$TopicConfigHandler$$kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)new Serializable(this, topic$1, prop, partitions){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicConfigHandler $outer;
                private final String topic$1;
                private final String prop$1;
                private final Seq partitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting ", " on broker ", " for topic: ", " and partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prop$1, BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$TopicConfigHandler$$kafkaConfig.brokerId()), this.topic$1, this.partitions$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                    this.prop$1 = prop$1;
                    this.partitions$1 = partitions$1;
                }
            });
        } else {
            quotaManager.removeThrottle(topic$1);
            this.debug((Function0<String>)new Serializable(this, topic$1, prop){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicConfigHandler $outer;
                private final String topic$1;
                private final String prop$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " from broker ", " for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prop$1, BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$TopicConfigHandler$$kafkaConfig.brokerId()), this.topic$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                    this.prop$1 = prop$1;
                }
            });
        }
    }

    public TopicConfigHandler(ReplicaManager replicaManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, KafkaController kafkaController) {
        this.kafka$server$TopicConfigHandler$$replicaManager = replicaManager;
        this.kafka$server$TopicConfigHandler$$kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
        Logging$class.$init$(this);
        this.logManager = replicaManager.logManager();
    }
}

