/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.checkpoints;

import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import kafka.server.checkpoints.CheckpointFileFormatter;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u0013\t!2\t[3dWB|\u0017N\u001c;SK\u0006$')\u001e4gKJT!a\u0001\u0003\u0002\u0017\rDWmY6q_&tGo\u001d\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001U\u0011!bN\n\u0004\u0001-\t\u0002C\u0001\u0007\u0010\u001b\u0005i!\"\u0001\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Ai!AB!osJ+g\r\u0005\u0002\u0013+5\t1C\u0003\u0002\u0015\r\u0005)Q\u000f^5mg&\u0011ac\u0005\u0002\b\u0019><w-\u001b8h\u0011!A\u0002A!A!\u0002\u0013I\u0012\u0001\u00037pG\u0006$\u0018n\u001c8\u0011\u0005iibB\u0001\u0007\u001c\u0013\taR\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003=}\u0011aa\u0015;sS:<'B\u0001\u000f\u000e\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013A\u0002:fC\u0012,'\u000f\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005\u0011\u0011n\u001c\u0006\u0002O\u0005!!.\u0019<b\u0013\tICE\u0001\bCk\u001a4WM]3e%\u0016\fG-\u001a:\t\u0011-\u0002!\u0011!Q\u0001\n1\nqA^3sg&|g\u000e\u0005\u0002\r[%\u0011a&\u0004\u0002\u0004\u0013:$\b\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0013\u0019|'/\\1ui\u0016\u0014\bc\u0001\u001a4k5\t!!\u0003\u00025\u0005\t92\t[3dWB|\u0017N\u001c;GS2,gi\u001c:nCR$XM\u001d\t\u0003m]b\u0001\u0001B\u00039\u0001\t\u0007\u0011HA\u0001U#\tQT\b\u0005\u0002\rw%\u0011A(\u0004\u0002\b\u001d>$\b.\u001b8h!\taa(\u0003\u0002@\u001b\t\u0019\u0011I\\=\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\u0015\u0019E)\u0012$H!\r\u0011\u0004!\u000e\u0005\u00061\u0001\u0003\r!\u0007\u0005\u0006C\u0001\u0003\rA\t\u0005\u0006W\u0001\u0003\r\u0001\f\u0005\u0006a\u0001\u0003\r!\r\u0005\u0006\u0013\u0002!\tAS\u0001\u0005e\u0016\fG\rF\u0001L!\rau*N\u0007\u0002\u001b*\u0011a*D\u0001\u000bG>dG.Z2uS>t\u0017B\u0001)N\u0005\r\u0019V-\u001d")
public class CheckpointReadBuffer<T>
implements Logging {
    private final String location;
    private final BufferedReader reader;
    private final int version;
    private final CheckpointFileFormatter<T> formatter;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        CheckpointReadBuffer checkpointReadBuffer = this;
        synchronized (checkpointReadBuffer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * WARNING - void declaration
     */
    public Seq<T> read() {
        String line = null;
        try {
            line = this.reader.readLine();
            if (line == null) {
                return (Seq)Seq$.MODULE$.empty();
            }
            int n = new StringOps(Predef$.MODULE$.augmentString(line)).toInt();
            switch (n) {
                default: 
            }
            if (n == this.version) {
                line = this.reader.readLine();
                if (line == null) {
                    return (Seq)Seq$.MODULE$.empty();
                }
                int expectedSize = new StringOps(Predef$.MODULE$.augmentString(line)).toInt();
                Buffer entries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                line = this.reader.readLine();
                while (true) {
                    void var4_4;
                    if (line == null) {
                        if (entries.size() != expectedSize) {
                            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " entries in checkpoint file (", "), but found only ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedSize), this.location, BoxesRunTime.boxToInteger((int)entries.size())})));
                        }
                        return entries;
                    }
                    Option<T> entry2 = this.formatter.fromLine(line);
                    Option<T> option = entry2;
                    if (!(option instanceof Some)) break;
                    Some some = (Some)option;
                    Object e = some.x();
                    var4_4.$plus$eq(e);
                    line = this.reader.readLine();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw this.malformedLineException$1(line);
            }
            throw new IOException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized version of the checkpoint file (", "): "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.location}))).append((Object)BoxesRunTime.boxToInteger((int)this.version)).toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw this.malformedLineException$1(line);
        }
    }

    private final IOException malformedLineException$1(String line) {
        return new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed line in checkpoint file (", "): ", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.location, line})));
    }

    public CheckpointReadBuffer(String location, BufferedReader reader, int version, CheckpointFileFormatter<T> formatter) {
        this.location = location;
        this.reader = reader;
        this.version = version;
        this.formatter = formatter;
        Logging$class.$init$(this);
    }
}

