/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.InputStream;
import java.nio.ByteBuffer;
import kafka.log.OffsetPosition;
import kafka.tier.fetcher.AbstractInputStreamFixedSizeIterator;

class TierOffsetIndexIterator
extends AbstractInputStreamFixedSizeIterator<OffsetPosition> {
    private final long base;

    TierOffsetIndexIterator(InputStream inputStream, long base) {
        super(inputStream, 8);
        this.base = base;
    }

    @Override
    OffsetPosition toIndexEntry() {
        if (this.indexEntryBytes.length != 8) {
            throw new IllegalArgumentException("OffsetIndex entries must be 8 bytes");
        }
        ByteBuffer buf = ByteBuffer.wrap(this.indexEntryBytes);
        long offset2 = this.base + (long)buf.getInt();
        int position = buf.getInt(4);
        return OffsetPosition.apply(offset2, position);
    }
}

