/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.serdes.TierPartitionStateEntry;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.AbstractIterator;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTierPartitionIterator
extends AbstractIterator<TierObjectMetadata> {
    private static final Logger log = LoggerFactory.getLogger(FileTierPartitionIterator.class);
    private static final int ENTRY_LENGTH_SIZE = 2;
    private final ByteBuffer lengthBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
    private final TopicIdPartition topicIdPartition;
    private long position;
    private long endPosition;
    private FileChannel channel;
    private ByteBuffer entryBuffer = null;

    public FileTierPartitionIterator(TopicIdPartition topicIdPartition, FileChannel channel, long startPosition) throws IOException {
        this.topicIdPartition = topicIdPartition;
        this.channel = channel;
        this.position = startPosition;
        this.endPosition = channel.size();
    }

    protected TierObjectMetadata makeNext() {
        if (this.position >= this.endPosition) {
            return (TierObjectMetadata)this.allDone();
        }
        try {
            long currentPosition = this.position;
            Utils.readFully((FileChannel)this.channel, (ByteBuffer)this.lengthBuffer, (long)currentPosition);
            if (this.lengthBuffer.hasRemaining()) {
                return (TierObjectMetadata)this.allDone();
            }
            this.lengthBuffer.flip();
            short length = this.lengthBuffer.getShort();
            if ((currentPosition += (long)this.lengthBuffer.limit()) + (long)length > this.endPosition) {
                return (TierObjectMetadata)this.allDone();
            }
            if (this.entryBuffer == null || length > this.entryBuffer.capacity()) {
                if (this.entryBuffer != null) {
                    log.debug("Resizing tier partition state iterator buffer from " + this.entryBuffer.capacity() + " to " + length);
                }
                this.entryBuffer = ByteBuffer.allocate(length).order(ByteOrder.LITTLE_ENDIAN);
            }
            this.entryBuffer.clear();
            this.entryBuffer.limit(length);
            Utils.readFully((FileChannel)this.channel, (ByteBuffer)this.entryBuffer, (long)currentPosition);
            if (this.entryBuffer.hasRemaining()) {
                return (TierObjectMetadata)this.allDone();
            }
            this.entryBuffer.flip();
            this.position = currentPosition += (long)this.entryBuffer.limit();
            return new TierObjectMetadata(this.topicIdPartition, TierPartitionStateEntry.getRootAsTierPartitionStateEntry(this.entryBuffer));
        }
        catch (IOException e) {
            throw new KafkaStorageException((Throwable)e);
        }
    }

    public long position() {
        return this.position;
    }
}

