/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.time.Instant;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh!B\u0001\u0003\u0003\u0003I!\u0001\u0003+jKJ$\u0016m]6\u000b\u0005\r!\u0011!\u0002;bg.\u001c(BA\u0003\u0007\u0003\u0011!\u0018.\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001!\u0006\u0002\u000b_M\u0019\u0001aC\t\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g!\t\u0011R#D\u0001\u0014\u0015\t!b!A\u0003vi&d7/\u0003\u0002\u0017'\t9Aj\\4hS:<\u0007\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u0019I,GO]=SCR,w\n\u001d;\u0011\u00071QB$\u0003\u0002\u001c\u001b\t1q\n\u001d;j_:\u0004\"!\b\u0014\u000e\u0003yQ!a\b\u0011\u0002\t\r|'/\u001a\u0006\u0003C\t\nq!\\3ue&\u001c7O\u0003\u0002$I\u00051\u00110Y7nKJT\u0011!J\u0001\u0004G>l\u0017BA\u0014\u001f\u0005\u0015iU\r^3s\u0011\u0015I\u0003\u0001\"\u0001+\u0003\u0019a\u0014N\\5u}Q\u00111&\u000e\t\u0004Y\u0001iS\"\u0001\u0002\u0011\u00059zC\u0002\u0001\u0003\u0006a\u0001\u0011\r!\r\u0002\u0002)F\u0011!g\u000b\t\u0003\u0019MJ!\u0001N\u0007\u0003\u000f9{G\u000f[5oO\")\u0001\u0004\u000ba\u00013!9q\u0007\u0001a\u0001\n\u0013A\u0014A\u0003:fiJL8i\\;oiV\t\u0011\b\u0005\u0002\ru%\u00111(\u0004\u0002\u0004\u0013:$\bbB\u001f\u0001\u0001\u0004%IAP\u0001\u000fe\u0016$(/_\"pk:$x\fJ3r)\ty$\t\u0005\u0002\r\u0001&\u0011\u0011)\u0004\u0002\u0005+:LG\u000fC\u0004Dy\u0005\u0005\t\u0019A\u001d\u0002\u0007a$\u0013\u0007\u0003\u0004F\u0001\u0001\u0006K!O\u0001\fe\u0016$(/_\"pk:$\b\u0005\u000b\u0002E\u000fB\u0011A\u0002S\u0005\u0003\u00136\u0011\u0001B^8mCRLG.\u001a\u0005\b\u0017\u0002\u0001\r\u0011\"\u0003M\u00031y\u0006/Y;tK\u0012,f\u000e^5m+\u0005i\u0005c\u0001\u0007\u001b\u001dB\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\u0005i&lWMC\u0001T\u0003\u0011Q\u0017M^1\n\u0005U\u0003&aB%ogR\fg\u000e\u001e\u0005\b/\u0002\u0001\r\u0011\"\u0003Y\u0003Ay\u0006/Y;tK\u0012,f\u000e^5m?\u0012*\u0017\u000f\u0006\u0002@3\"91IVA\u0001\u0002\u0004i\u0005BB.\u0001A\u0003&Q*A\u0007`a\u0006,8/\u001a3V]RLG\u000e\t\u0015\u00035\u001eCqA\u0018\u0001A\u0002\u0013%q,\u0001\u0004`KJ\u0014xN]\u000b\u0002AB\u0019ABG1\u0011\u0005\tTgBA2i\u001d\t!w-D\u0001f\u0015\t1\u0007\"\u0001\u0004=e>|GOP\u0005\u0002\u001d%\u0011\u0011.D\u0001\ba\u0006\u001c7.Y4f\u0013\tYGNA\u0005UQJ|w/\u00192mK*\u0011\u0011.\u0004\u0005\b]\u0002\u0001\r\u0011\"\u0003p\u0003)yVM\u001d:pe~#S-\u001d\u000b\u0003\u007fADqaQ7\u0002\u0002\u0003\u0007\u0001\r\u0003\u0004s\u0001\u0001\u0006K\u0001Y\u0001\b?\u0016\u0014(o\u001c:!Q\t\tx\tC\u0003v\u0001\u0019\u0005a/\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]V\tq\u000f\u0005\u0002ys6\tA!\u0003\u0002{\t\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\u0006y\u00021\t!`\u0001\u0004GRDX#\u0001@\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0003\u0002\u000f\u0019,Go\u00195fe&!\u0011qAA\u0001\u0005M\u0019\u0015M\\2fY2\fG/[8o\u0007>tG/\u001a=u\u0011\u001d\tY\u0001\u0001D\u0001\u0003\u001b\t!\u0002\u001e:b]NLG/[8o)1\ty!a\n\u0002B\u0005E\u0013\u0011MA9)\u0011\t\t\"!\b\u0011\u000b\u0005M\u0011\u0011D\u0017\u000e\u0005\u0005U!bAA\f\u001b\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005m\u0011Q\u0003\u0002\u0007\rV$XO]3\t\u0011\u0005}\u0011\u0011\u0002a\u0002\u0003C\t!!Z2\u0011\t\u0005M\u00111E\u0005\u0005\u0003K\t)B\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"9\u0011+!\u0003A\u0002\u0005%\u0002\u0003BA\u0016\u0003{i!!!\f\u000b\u0007Q\tyC\u0003\u0003\u00022\u0005M\u0012AB2p[6|gNC\u0002\b\u0003kQA!a\u000e\u0002:\u00051\u0011\r]1dQ\u0016T!!a\u000f\u0002\u0007=\u0014x-\u0003\u0003\u0002@\u00055\"\u0001\u0002+j[\u0016D\u0001\"a\u0011\u0002\n\u0001\u0007\u0011QI\u0001\u0012i&,'\u000fV8qS\u000e\f\u0005\u000f]3oI\u0016\u0014\b\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-C!A\u0003u_BL7-\u0003\u0003\u0002P\u0005%#!\u0005+jKJ$v\u000e]5d\u0003B\u0004XM\u001c3fe\"A\u00111KA\u0005\u0001\u0004\t)&A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\t\u0005)1\u000f^8sK&!\u0011qLA-\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0007\u0002CA2\u0003\u0013\u0001\r!!\u001a\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB!\u0011qMA7\u001b\t\tIGC\u0002\u0002l\u0019\taa]3sm\u0016\u0014\u0018\u0002BA8\u0003S\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0006\u0002t\u0005%\u0001\u0013!a\u0001\u0003k\n\u0011#\\1y%\u0016$(/\u001f\"bG.|gMZ't!\ra!$\u000f\u0005\u0007\u0003s\u0002A\u0011\u0001'\u0002\u0017A\fWo]3e+:$\u0018\u000e\u001c\u0005\b\u0003{\u0002A\u0011AA@\u00031I7/\u0012:s_J\u001cF/\u0019;f+\t\t\t\tE\u0002\r\u0003\u0007K1!!\"\u000e\u0005\u001d\u0011un\u001c7fC:Dq!!#\u0001\t\u0003\tY)\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u00055\u0005\u0003BAH\u0003#k!!a\f\n\t\u0005M\u0015q\u0006\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011!\t9\n\u0001C\t\u0005\u0005e\u0015A\u0004:fiJLH+Y:l\u0019\u0006$XM\u001d\u000b\b\u007f\u0005m\u0015QTAT\u0011\u001d\t\u0019(!&A\u0002eB\u0001\"a(\u0002\u0016\u0002\u0007\u0011\u0011U\u0001\u0006]><Xj\u001d\t\u0004\u0019\u0005\r\u0016bAAS\u001b\t!Aj\u001c8h\u0011\u001d\tI+!&A\u0002\u0005\f\u0011\u0001\u001e\u0005\t\u0003[\u0003A\u0011\u0003\u0002\u00020\u000612-\u00198dK2\fe\u000eZ*fi\u0016\u0013(o\u001c:Ti\u0006$X\rF\u0003@\u0003c\u000b)\fC\u0004\u00024\u0006-\u0006\u0019A\u0016\u0002\u0011QLWM\u001d+bg.Dq!!+\u0002,\u0002\u0007\u0011\rC\u0004\u0002:\u0002!\t\"a/\u0002-=t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:$\u0012a\u0010\u0005\b\u0003\u007f\u0003A\u0011CAa\u0003}ygnU;dG\u0016\u001c8OZ;m)J\fgn]5uS>tw+\u001b;i\t\u0016d\u0017-\u001f\u000b\u0006\u007f\u0005\r\u0017q\u0019\u0005\t\u0003\u000b\fi\f1\u0001\u0002\"\u00069A-\u001a7bs6\u001b\b\u0002CAP\u0003{\u0003\r!!)\t\u0013\u0005-\u0007!%A\u0005\u0002\u00055\u0017\u0001\u0006;sC:\u001c\u0018\u000e^5p]\u0012\"WMZ1vYR$S'\u0006\u0002\u0002P*\"\u0011QOAiW\t\t\u0019\u000e\u0005\u0003\u0002V\u0006}WBAAl\u0015\u0011\tI.a7\u0002\u0013Ut7\r[3dW\u0016$'bAAo\u001b\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0018q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public abstract class TierTask<T extends TierTask<T>>
implements Logging {
    private final Option<Meter> retryRateOpt;
    private volatile int retryCount;
    private volatile Option<Instant> _pausedUntil;
    private volatile Option<Throwable> _error;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TierTask tierTask = this;
        synchronized (tierTask) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private int retryCount() {
        return this.retryCount;
    }

    private void retryCount_$eq(int x$1) {
        this.retryCount = x$1;
    }

    private Option<Instant> _pausedUntil() {
        return this._pausedUntil;
    }

    private void _pausedUntil_$eq(Option<Instant> x$1) {
        this._pausedUntil = x$1;
    }

    private Option<Throwable> _error() {
        return this._error;
    }

    private void _error_$eq(Option<Throwable> x$1) {
        this._error = x$1;
    }

    public abstract TopicIdPartition topicIdPartition();

    public abstract CancellationContext ctx();

    public abstract Future<T> transition(Time var1, TierTopicAppender var2, TierObjectStore var3, ReplicaManager var4, Option<Object> var5, ExecutionContext var6);

    public Option<Object> transition$default$5() {
        return None$.MODULE$;
    }

    public Option<Instant> pausedUntil() {
        return this._pausedUntil();
    }

    public boolean isErrorState() {
        return this._error().isDefined();
    }

    public TopicPartition topicPartition() {
        return this.topicIdPartition().topicPartition();
    }

    public void retryTaskLater(int maxRetryBackoffMs, long nowMs, Throwable t) {
        this.retryCount_$eq(this.retryCount() + 1);
        this.retryRateOpt.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Meter x$1) {
                x$1.mark();
            }
        });
        Instant now = Instant.ofEpochMilli(nowMs);
        int pauseMs = Math.min(maxRetryBackoffMs, (Random$.MODULE$.nextInt(this.retryCount()) + 1) * 1000);
        this.warn((Function0<String>)new Serializable(this, pauseMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTask $outer;
            private final int pauseMs$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"retrying ", " after ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer, BoxesRunTime.boxToInteger((int)this.pauseMs$1)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pauseMs$1 = pauseMs$1;
            }
        }, (Function0<Throwable>)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Throwable apply() {
                return this.t$1;
            }
            {
                this.t$1 = t$1;
            }
        });
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(pauseMs)));
    }

    public void cancelAndSetErrorState(TierTask<T> tierTask, Throwable t) {
        this.error((Function0<String>)new Serializable(this, tierTask){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTask $outer;
            private final TierTask tierTask$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", ", task ", " moved to error state due to unhandled exception"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topicIdPartition(), this.tierTask$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tierTask$1 = tierTask$1;
            }
        }, (Function0<Throwable>)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$2;

            public final Throwable apply() {
                return this.t$2;
            }
            {
                this.t$2 = t$2;
            }
        });
        this._error_$eq((Option<Throwable>)new Some((Object)t));
        this.ctx().cancel();
    }

    public void onSuccessfulTransition() {
        this.retryCount_$eq(0);
        this._pausedUntil_$eq((Option<Instant>)None$.MODULE$);
    }

    public void onSuccessfulTransitionWithDelay(long delayMs, long nowMs) {
        Instant now = Instant.ofEpochMilli(nowMs);
        this.onSuccessfulTransition();
        this._pausedUntil_$eq((Option<Instant>)new Some((Object)now.plusMillis(delayMs)));
    }

    public TierTask(Option<Meter> retryRateOpt) {
        this.retryRateOpt = retryRateOpt;
        Logging$class.$init$(this);
        this.retryCount = 0;
        this._pausedUntil = None$.MODULE$;
        this._error = None$.MODULE$;
    }
}

