/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.TierTask;
import kafka.tier.tasks.TierTaskQueue$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}g!B\u0001\u0003\u0003\u0003I!!\u0004+jKJ$\u0016m]6Rk\u0016,XM\u0003\u0002\u0004\t\u0005)A/Y:lg*\u0011QAB\u0001\u0005i&,'OC\u0001\b\u0003\u0015Y\u0017MZ6b\u0007\u0001)\"AC!\u0014\t\u0001Y\u0011c\u0006\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I)R\"A\n\u000b\u0005Q1\u0011!B;uS2\u001c\u0018B\u0001\f\u0014\u0005\u001daunZ4j]\u001e\u0004\"\u0001G\u000f\u000e\u0003eQ!AG\u000e\u0002\t1\fgn\u001a\u0006\u00029\u0005!!.\u0019<b\u0013\tq\u0012DA\u0007BkR|7\t\\8tK\u0006\u0014G.\u001a\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u0005\u00191\r\u001e=\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\"\u0011a\u00024fi\u000eDWM]\u0005\u0003M\r\u00121cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqRD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\t[\u0006DH+Y:lgB\u0011ABK\u0005\u0003W5\u00111!\u00138u\u0011!i\u0003A!A!\u0002\u0013q\u0013\u0001\u0002;j[\u0016\u0004\"a\f\u001d\u000e\u0003AR!\u0001F\u0019\u000b\u0005I\u001a\u0014AB2p[6|gN\u0003\u0002\bi)\u0011QGN\u0001\u0007CB\f7\r[3\u000b\u0003]\n1a\u001c:h\u0013\tI\u0004G\u0001\u0003US6,\u0007\"B\u001e\u0001\t\u0003a\u0014A\u0002\u001fj]&$h\b\u0006\u0003>\u0015.c\u0005c\u0001 \u0001\u007f5\t!\u0001\u0005\u0002A\u00032\u0001A!\u0002\"\u0001\u0005\u0004\u0019%!\u0001+\u0012\u0005\u0011;\u0005C\u0001\u0007F\u0013\t1UBA\u0004O_RD\u0017N\\4\u0011\u0007yBu(\u0003\u0002J\u0005\tAA+[3s)\u0006\u001c8\u000eC\u0003!u\u0001\u0007\u0011\u0005C\u0003)u\u0001\u0007\u0011\u0006C\u0003.u\u0001\u0007a\u0006C\u0003O\u0001\u0011\u0005s*\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\u0012\u0001\u0015\t\u0003#Rs!\u0001\u0004*\n\u0005Mk\u0011A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!aU\u0007\t\u000f\r\u0001\u0001\u0019!C\u00051V\t\u0011\fE\u0002[?~j\u0011a\u0017\u0006\u00039v\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005yk\u0011AC2pY2,7\r^5p]&\u0011\u0001m\u0017\u0002\b\u0019&\u001cHoU3u\u0011\u001d\u0011\u0007\u00011A\u0005\n\r\f\u0011\u0002^1tWN|F%Z9\u0015\u0005\u0011<\u0007C\u0001\u0007f\u0013\t1WB\u0001\u0003V]&$\bb\u00025b\u0003\u0003\u0005\r!W\u0001\u0004q\u0012\n\u0004B\u00026\u0001A\u0003&\u0011,\u0001\u0004uCN\\7\u000f\t\u0015\u0003S2\u0004\"\u0001D7\n\u00059l!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000fA\u0004!\u0019!C\u0005c\u0006\t\u0002/\u0019:uSRLwN\\:J]\u0016\u0013(o\u001c:\u0016\u0003I\u0004Ba\u001d={}6\tAO\u0003\u0002vm\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005]\\\u0012\u0001B;uS2L!!\u001f;\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002|y6\tA!\u0003\u0002~\t\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0003\u0019}L1!!\u0001\u000e\u0005\u0011auN\\4\t\u000f\u0005\u0015\u0001\u0001)A\u0005e\u0006\u0011\u0002/\u0019:uSRLwN\\:J]\u0016\u0013(o\u001c:!\u0011!\tI\u0001\u0001a\u0001\n\u0013A\u0016A\u00039s_\u000e,7o]5oO\"I\u0011Q\u0002\u0001A\u0002\u0013%\u0011qB\u0001\u000faJ|7-Z:tS:<w\fJ3r)\r!\u0017\u0011\u0003\u0005\tQ\u0006-\u0011\u0011!a\u00013\"9\u0011Q\u0003\u0001!B\u0013I\u0016a\u00039s_\u000e,7o]5oO\u0002B\u0001\"!\u0007\u0001\t#\u0011\u00111D\u0001\u0014KJ\u0014xN\u001d)beRLG/[8o\u0007>,h\u000e\u001e\u000b\u0002S!A\u0011q\u0004\u0001\u0007\u0012\t\t\t#A\u0005t_J$H+Y:lgR!\u00111EA\u001e!\u0015\t)#!\u000e@\u001d\u0011\t9#!\r\u000f\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f\t\u0003\u0019a$o\\8u}%\ta\"C\u0002\u000245\tq\u0001]1dW\u0006<W-\u0003\u0003\u00028\u0005e\"\u0001\u0002'jgRT1!a\r\u000e\u0011\u001d\u0019\u0011Q\u0004a\u0001\u0003GA\u0001\"a\u0010\u0001\r#\u0011\u0011\u0011I\u0001\b]\u0016<H+Y:l)\u0015y\u00141IA$\u0011\u001d\t)%!\u0010A\u0002i\f\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u0011\u0005%\u0013Q\ba\u0001\u0003\u0017\n\u0001\"\\3uC\u0012\fG/\u0019\t\u0004}\u00055\u0013bAA(\u0005\t\u00192\u000b^1si\u000eC\u0017M\\4f\u001b\u0016$\u0018\rZ1uC\"A\u00111\u000b\u0001\u0007\u0012\t\t)&\u0001\u0006nCf\u0004&o\\2fgN$B!a\u0016\u0002^A\u0019A\"!\u0017\n\u0007\u0005mSBA\u0004C_>dW-\u00198\t\u0011\u0005%\u0013\u0011\u000ba\u0001\u0003?\u00022APA1\u0013\r\t\u0019G\u0001\u0002\u000f\u0007\"\fgnZ3NKR\fG-\u0019;b\u0011\u001d\t9\u0007\u0001C\u0001\u0003S\nA\"\\1zE\u0016\fE\r\u001a+bg.$2\u0001ZA6\u0011!\tI%!\u001aA\u0002\u0005-\u0003bBA8\u0001\u0011\u0005\u0011\u0011O\u0001\u0010[\u0006L(-\u001a*f[>4X\rV1tWR\u0019A-a\u001d\t\u0011\u0005%\u0013Q\u000ea\u0001\u0003k\u00022APA<\u0013\r\tIH\u0001\u0002\u0013'R|\u0007o\u00115b]\u001e,W*\u001a;bI\u0006$\u0018\rC\u0004\u0002~\u0001!\t!a \u0002\tA|G\u000e\u001c\u000b\u0003\u0003\u0003\u0003R\u0001DAB\u0003GI1!!\"\u000e\u0005\u0019y\u0005\u000f^5p]\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0015\u0001\u00023p]\u0016$2\u0001ZAG\u0011\u001d\ty)a\"A\u0002}\nA\u0001^1tW\"9\u00111\u0013\u0001\u0005\u0002\u0005U\u0015!\u0003;bg.\u001cu.\u001e8u+\u0005I\u0003bBAM\u0001\u0011\u0005\u00111T\u0001\ro&$\b.\u00117m)\u0006\u001c8n]\u000b\u0005\u0003;\u000b\t\u000b\u0006\u0003\u0002 \u00065\u0006c\u0001!\u0002\"\u0012A\u00111UAL\u0005\u0004\t)KA\u0001V#\r!\u0015q\u0015\t\u0004\u0019\u0005%\u0016bAAV\u001b\t\u0019\u0011I\\=\t\u0011\u0005=\u0016q\u0013a\u0001\u0003c\u000b!A\u001a8\u0011\u000f1\t\u0019,a.\u0002 &\u0019\u0011QW\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003B)\u0002:~J1!a/W\u0005\r\u0019V\r\u001e\u0005\b\u0003\u007f\u0003A\u0011AAa\u0003\u0015\u0019Gn\\:f)\u0005!\u0007bBAc\u0001\u0011\u0005\u0013qY\u0001\ti>\u001cFO]5oOR\t\u0001\u000bC\u0004\u0002L\u0002!I!!4\u0002\rI,Wn\u001c<f)\r!\u0017q\u001a\u0005\b\u0003\u000b\nI\r1\u0001{\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003+\f\u0001BZ5oIR\u000b7o\u001b\u000b\u0007\u0003/\fI.a7\u0011\t1\t\u0019i\u0010\u0005\b\u0003\u000b\n\t\u000e1\u0001{\u0011\u001d\ti.!5A\u0002e\u000bQ!];fk\u0016\u0004")
public abstract class TierTaskQueue<T extends TierTask<T>>
implements Logging,
AutoCloseable {
    private final CancellationContext ctx;
    private final int maxTasks;
    private final Time time;
    private volatile ListSet<T> kafka$tier$tasks$TierTaskQueue$$tasks;
    private final ConcurrentHashMap<TopicIdPartition, Object> kafka$tier$tasks$TierTaskQueue$$partitionsInError;
    private ListSet<T> kafka$tier$tasks$TierTaskQueue$$processing;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TierTaskQueue tierTaskQueue = this;
        synchronized (tierTaskQueue) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.getClass().getName();
    }

    public ListSet<T> kafka$tier$tasks$TierTaskQueue$$tasks() {
        return this.kafka$tier$tasks$TierTaskQueue$$tasks;
    }

    public void kafka$tier$tasks$TierTaskQueue$$tasks_$eq(ListSet<T> x$1) {
        this.kafka$tier$tasks$TierTaskQueue$$tasks = x$1;
    }

    public ConcurrentHashMap<TopicIdPartition, Object> kafka$tier$tasks$TierTaskQueue$$partitionsInError() {
        return this.kafka$tier$tasks$TierTaskQueue$$partitionsInError;
    }

    public ListSet<T> kafka$tier$tasks$TierTaskQueue$$processing() {
        return this.kafka$tier$tasks$TierTaskQueue$$processing;
    }

    public void kafka$tier$tasks$TierTaskQueue$$processing_$eq(ListSet<T> x$1) {
        this.kafka$tier$tasks$TierTaskQueue$$processing = x$1;
    }

    public int errorPartitionCount() {
        return this.kafka$tier$tasks$TierTaskQueue$$partitionsInError().size();
    }

    public abstract List<T> sortTasks(List<T> var1);

    public abstract T newTask(TopicIdPartition var1, StartChangeMetadata var2);

    public abstract boolean mayProcess(ChangeMetadata var1);

    public void maybeAddTask(StartChangeMetadata metadata) {
        if (this.mayProcess(metadata)) {
            this.remove(metadata.topicIdPartition());
            this.kafka$tier$tasks$TierTaskQueue$$tasks_$eq(this.kafka$tier$tasks$TierTaskQueue$$tasks().$plus(this.newTask(metadata.topicIdPartition(), metadata)));
        }
    }

    public void maybeRemoveTask(StopChangeMetadata metadata) {
        if (this.mayProcess(metadata)) {
            this.remove(metadata.topicIdPartition());
        }
    }

    public synchronized Option<List<T>> poll() {
        List<T> sorted;
        List eligibleTasks;
        Instant now = Instant.ofEpochMilli(this.time.hiResClockMs());
        int processingSpace = this.maxTasks - this.kafka$tier$tasks$TierTaskQueue$$processing().size();
        if (processingSpace > 0 && (eligibleTasks = (List)this.kafka$tier$tasks$TierTaskQueue$$tasks().toList().filter((Function1)new Serializable(this, now){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTaskQueue $outer;
            public final Instant now$1;

            public final boolean apply(T task) {
                return !this.$outer.kafka$tier$tasks$TierTaskQueue$$processing().apply(task) && ((TierTask)task).pausedUntil().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final boolean apply(Instant x$1) {
                        return this.$outer.now$1.isAfter(x$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }) && !this.$outer.kafka$tier$tasks$TierTaskQueue$$partitionsInError().containsKey(((TierTask)task).topicIdPartition());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$1 = now$1;
            }
        })).nonEmpty() && (sorted = this.sortTasks(eligibleTasks)).nonEmpty()) {
            List tasks = sorted.take(processingSpace);
            this.kafka$tier$tasks$TierTaskQueue$$processing_$eq(this.kafka$tier$tasks$TierTaskQueue$$processing().$plus$plus((GenTraversableOnce)tasks));
            return new Some((Object)tasks);
        }
        return None$.MODULE$;
    }

    public synchronized void done(T task) {
        Object object = ((TierTask)task).isErrorState() ? this.kafka$tier$tasks$TierTaskQueue$$partitionsInError().put(((TierTask)task).topicIdPartition(), BoxesRunTime.boxToLong((long)this.time.milliseconds())) : BoxedUnit.UNIT;
        if (!this.kafka$tier$tasks$TierTaskQueue$$processing().contains(task)) {
            this.warn((Function0<String>)new Serializable(this, task){
                public static final long serialVersionUID = 0L;
                private final TierTask task$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"done task ", " not found in processing set"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task$1}));
                }
                {
                    this.task$1 = task$1;
                }
            });
        }
        this.kafka$tier$tasks$TierTaskQueue$$processing_$eq(this.kafka$tier$tasks$TierTaskQueue$$processing().$minus(task));
        if (!this.kafka$tier$tasks$TierTaskQueue$$tasks().contains(task)) {
            this.debug((Function0<String>)new Serializable(this, task){
                public static final long serialVersionUID = 0L;
                private final TierTask task$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cancelling done task ", " due to it no longer being in the task set"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task$1}));
                }
                {
                    this.task$1 = task$1;
                }
            });
            ((TierTask)task).ctx().cancel();
        }
        if (((TierTask)task).ctx().isCancelled()) {
            this.debug((Function0<String>)new Serializable(this, task){
                public static final long serialVersionUID = 0L;
                private final TierTask task$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"removing done task ", " from the task set"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.task$1}));
                }
                {
                    this.task$1 = task$1;
                }
            });
            this.kafka$tier$tasks$TierTaskQueue$$tasks_$eq(this.kafka$tier$tasks$TierTaskQueue$$tasks().$minus(task));
        }
    }

    public int taskCount() {
        return this.kafka$tier$tasks$TierTaskQueue$$tasks().size();
    }

    public <U> U withAllTasks(Function1<Set<T>, U> fn) {
        return (U)fn.apply(this.kafka$tier$tasks$TierTaskQueue$$tasks());
    }

    @Override
    public void close() {
        this.ctx.cancel();
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tasks=", " processing=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$tier$tasks$TierTaskQueue$$tasks(), this.kafka$tier$tasks$TierTaskQueue$$processing()}));
    }

    private void remove(TopicIdPartition topicIdPartition) {
        this.findTask(topicIdPartition, this.kafka$tier$tasks$TierTaskQueue$$tasks()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TierTaskQueue $outer;

            public final void apply(T task) {
                ((TierTask)task).ctx().cancel();
                this.$outer.kafka$tier$tasks$TierTaskQueue$$tasks_$eq(this.$outer.kafka$tier$tasks$TierTaskQueue$$tasks().$minus(task));
                this.$outer.kafka$tier$tasks$TierTaskQueue$$processing_$eq(this.$outer.kafka$tier$tasks$TierTaskQueue$$processing().$minus(task));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private Option<T> findTask(TopicIdPartition topicIdPartition, ListSet<T> queue) {
        return queue.find((Function1)new Serializable(this, topicIdPartition){
            public static final long serialVersionUID = 0L;
            private final TopicIdPartition topicIdPartition$1;

            public final boolean apply(T x$2) {
                TopicIdPartition topicIdPartition = ((TierTask)x$2).topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$1;
                return !(topicIdPartition != null ? !((Object)topicIdPartition).equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
            }
        });
    }

    public TierTaskQueue(CancellationContext ctx, int maxTasks, Time time) {
        this.ctx = ctx;
        this.maxTasks = maxTasks;
        this.time = time;
        Logging$class.$init$(this);
        this.kafka$tier$tasks$TierTaskQueue$$tasks = (ListSet)ListSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.kafka$tier$tasks$TierTaskQueue$$partitionsInError = new ConcurrentHashMap();
        this.kafka$tier$tasks$TierTaskQueue$$processing = (ListSet)ListSet$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

