/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.exceptions.TierArchiverFencedException;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.tasks.delete.DeletionTask$;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeletionTask$
implements Logging {
    public static final DeletionTask$ MODULE$;
    private final int FencedSegmentDeleteDelayMs;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new DeletionTask$();
    }

    private Logger logger$lzycompute() {
        DeletionTask$ deletionTask$ = this;
        synchronized (deletionTask$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    @Override
    public String loggerName() {
        return DeletionTask.class.getName();
    }

    public int FencedSegmentDeleteDelayMs() {
        return this.FencedSegmentDeleteDelayMs;
    }

    public long getDelayFromLogConfig(Option<AbstractLog> log) {
        return BoxesRunTime.unboxToLong((Object)log.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Long apply(AbstractLog x$10) {
                return x$10.config().fileDeleteDelayMs();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Long x) {
                return Predef$.MODULE$.Long2long(x);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
    }

    public Future<BoxedUnit> writeDeletionInitiatedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, TierObjectStore.ObjectMetadata segment, ExecutionContext ec) {
        TierSegmentDeleteInitiate marker = new TierSegmentDeleteInitiate(segment.topicIdPartition(), leaderEpoch, segment.objectId());
        return this.writeMarker(tierTopicAppender, leaderEpoch, marker, ec);
    }

    public Future<BoxedUnit> writeDeletionCompletedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, TierObjectStore.ObjectMetadata objectMetadata, ExecutionContext ec) {
        TierSegmentDeleteComplete marker = new TierSegmentDeleteComplete(objectMetadata.topicIdPartition(), leaderEpoch, objectMetadata.objectId());
        return this.writeMarker(tierTopicAppender, leaderEpoch, marker, ec);
    }

    public Future<BoxedUnit> writePartitionDeletionCompletedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, ExecutionContext ec) {
        TierPartitionDeleteComplete marker = new TierPartitionDeleteComplete(topicIdPartition, UUID.randomUUID());
        return this.writeMarker(tierTopicAppender, leaderEpoch, marker, ec);
    }

    public Future<BoxedUnit> writeMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, AbstractTierMetadata marker, ExecutionContext ec) {
        return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(marker))).map((Function1)new Serializable(marker){
            public static final long serialVersionUID = 0L;
            public final AbstractTierMetadata marker$1;

            public final void apply(TierPartitionState.AppendResult appendResult) {
                TierPartitionState.AppendResult appendResult2 = appendResult;
                if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)((Object)appendResult2))) {
                    DeletionTask$.MODULE$.debug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.writeMarker.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully completed ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.marker$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)((Object)appendResult2))) {
                    DeletionTask$.MODULE$.info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.writeMarker.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping state machine for ", " as attempt to transition was fenced"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.marker$1.topicIdPartition()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    throw new TierArchiverFencedException(this.marker$1.topicIdPartition());
                }
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected append result for ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.marker$1.topicIdPartition(), appendResult})));
            }
            {
                this.marker$1 = marker$1;
            }
        }, ec);
    }

    public Option<Meter> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    private DeletionTask$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.FencedSegmentDeleteDelayMs = 600000;
    }
}

