/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import kafka.log.Log;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import org.apache.kafka.common.TopicPartition;

public class DumpTierPartitionState {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: path to partition data, e.g. /var/lib/kafka/log/mytopic-partitionNum");
            System.exit(1);
        }
        File dir = new File(args[0]);
        TopicPartition topicPartition = Log.parseTopicPartitionName(dir);
        System.out.println("Reading tier partition state for " + topicPartition);
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !Log.isTierStateFile(file)) continue;
            DumpTierPartitionState.dumpTierState(topicPartition, file, false);
        }
    }

    public static void dumpTierState(TopicPartition topicPartition, File file, boolean headerOnly) {
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
            System.out.println("Dumping state in file " + file);
            Optional<Header> headerOpt = FileTierPartitionState.readHeader(fileChannel);
            if (!headerOpt.isPresent()) {
                System.out.println("Empty header");
                return;
            }
            System.out.println(headerOpt.get().toString());
            if (headerOnly) {
                return;
            }
            Optional<FileTierPartitionIterator> iteratorOpt = FileTierPartitionState.iterator(topicPartition, fileChannel);
            if (!iteratorOpt.isPresent()) {
                System.out.println("Empty file");
                return;
            }
            while (iteratorOpt.get().hasNext()) {
                System.out.println(iteratorOpt.get().next());
            }
        }
        catch (IOException e) {
            System.err.println("Caught exception for file " + file);
            e.printStackTrace();
        }
    }
}

