/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.AdminZkClient;
import org.apache.kafka.common.errors.TopicExistsException;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class TierTopicAdmin$
implements Logging {
    public static final TierTopicAdmin$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TierTopicAdmin$();
    }

    private Logger logger$lzycompute() {
        TierTopicAdmin$ tierTopicAdmin$ = this;
        synchronized (tierTopicAdmin$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int ensureTopic(AdminZkClient adminZkClient, String topicName, int configuredNumPartitions, short configuredReplicationFactor) {
        int n;
        try {
            adminZkClient.createTopic(topicName, configuredNumPartitions, configuredReplicationFactor, this.topicConfig(), adminZkClient.createTopic$default$5(), adminZkClient.createTopic$default$6());
            this.info((Function0<String>)new Serializable(topicName, configuredNumPartitions){
                public static final long serialVersionUID = 0L;
                private final String topicName$1;
                private final int configuredNumPartitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created topic ", " with ", " partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName$1, BoxesRunTime.boxToInteger((int)this.configuredNumPartitions$1)}));
                }
                {
                    this.topicName$1 = topicName$1;
                    this.configuredNumPartitions$1 = configuredNumPartitions$1;
                }
            });
            n = configuredNumPartitions;
        }
        catch (TopicExistsException topicExistsException) {
            int numPartitions2 = BoxesRunTime.unboxToInt((Object)adminZkClient.numPartitions((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicName})))).get((Object)topicName).get());
            if (numPartitions2 != configuredNumPartitions) {
                this.warn((Function0<String>)new Serializable(topicName, configuredNumPartitions, numPartitions2){
                    public static final long serialVersionUID = 0L;
                    private final String topicName$1;
                    private final int configuredNumPartitions$1;
                    private final int numPartitions$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " already exists. Mismatch between existing partition count ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName$1, BoxesRunTime.boxToInteger((int)this.numPartitions$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and configured partition count ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.configuredNumPartitions$1)}))).toString();
                    }
                    {
                        this.topicName$1 = topicName$1;
                        this.configuredNumPartitions$1 = configuredNumPartitions$1;
                        this.numPartitions$1 = numPartitions$1;
                    }
                });
            } else {
                this.info((Function0<String>)new Serializable(topicName, numPartitions2){
                    public static final long serialVersionUID = 0L;
                    private final String topicName$1;
                    private final int numPartitions$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " exists with ", " partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicName$1, BoxesRunTime.boxToInteger((int)this.numPartitions$1)}));
                    }
                    {
                        this.topicName$1 = topicName$1;
                        this.numPartitions$1 = numPartitions$1;
                    }
                });
            }
            n = numPartitions2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public Properties topicConfig() {
        void var1_1;
        Properties properties = new Properties();
        properties.put("cleanup.policy", "delete");
        properties.put("retention.ms", "-1");
        properties.put("retention.bytes", "-1");
        return var1_1;
    }

    private TierTopicAdmin$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

