/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Properties;
import joptsimple.OptionException;
import kafka.common.MessageReader;
import kafka.tools.ConsoleProducer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Serializable;
import scala.runtime.BoxedUnit;

public final class ConsoleProducer$ {
    public static final ConsoleProducer$ MODULE$;

    static {
        new ConsoleProducer$();
    }

    public void main(String[] args) {
        try {
            ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(args);
            MessageReader reader = (MessageReader)Class.forName(config.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            reader.init(System.in, this.getReaderProps(config));
            KafkaProducer producer = new KafkaProducer(this.producerProps(config));
            Exit$.MODULE$.addShutdownHook("producer-shutdown-hook", (Function0<BoxedUnit>)new Serializable(producer){
                public static final long serialVersionUID = 0L;
                private final KafkaProducer producer$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.producer$1.close();
                }
                {
                    this.producer$1 = producer$1;
                }
            });
            ProducerRecord<byte[], byte[]> record2 = null;
            do {
                if ((record2 = reader.readMessage()) == null) continue;
                this.send((KafkaProducer<byte[], byte[]>)producer, record2, config.sync());
            } while (record2 != null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        catch (OptionException optionException) {
            System.err.println(optionException.getMessage());
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    private void send(KafkaProducer<byte[], byte[]> producer, ProducerRecord<byte[], byte[]> record2, boolean sync) {
        if (sync) {
            producer.send(record2).get();
        } else {
            producer.send(record2, (Callback)new ErrorLoggingCallback(record2.topic(), (byte[])record2.key(), (byte[])record2.value(), false));
        }
    }

    /*
     * WARNING - void declaration
     */
    public Properties getReaderProps(ConsoleProducer.ProducerConfig config) {
        void var2_2;
        Properties props = new Properties();
        props.put("topic", config.topic());
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.cmdLineProps());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Properties producerProps(ConsoleProducer.ProducerConfig config) {
        void var2_2;
        Properties props = config.options().has(config.producerConfigOpt()) ? Utils.loadProps((String)((String)config.options().valueOf(config.producerConfigOpt()))) : new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(config.extraProducerProps());
        Object object = config.bootstrapServer() == null ? props.put("bootstrap.servers", config.brokerList()) : props.put("bootstrap.servers", config.bootstrapServer());
        props.put("compression.type", config.compressionCodec());
        props.put("client.id", "console-producer");
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "linger.ms", config.options(), config.sendTimeoutOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "acks", config.options(), config.requestRequiredAcksOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "request.timeout.ms", config.options(), config.requestTimeoutMsOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "retries", config.options(), config.messageSendMaxRetriesOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "retry.backoff.ms", config.options(), config.retryBackoffMsOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "send.buffer.bytes", config.options(), config.socketBufferSizeOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "buffer.memory", config.options(), config.maxMemoryBytesOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "batch.size", config.options(), config.maxPartitionMemoryBytesOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "metadata.max.age.ms", config.options(), config.metadataExpiryMsOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(props, "max.block.ms", config.options(), config.maxBlockMsOpt());
        return var2_2;
    }

    private ConsoleProducer$() {
        MODULE$ = this;
    }
}

