/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtils$;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentStatus;
import kafka.common.AdminCommandFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ReassignedPartitionsContext;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t-u!B\u0001\u0003\u0011\u00039\u0011!\u0007*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]N\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\u000b\u0005$W.\u001b8\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051BA\rSK\u0006\u001c8/[4o!\u0006\u0014H/\u001b;j_:\u001c8i\\7nC:$7cA\u0005\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\u0005\u00063%!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAQ\u0001H\u0005\u0005\u0002u\tA!\\1j]R\u0011a$\t\t\u0003\u001b}I!\u0001\t\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Em\u0001\raI\u0001\u0005CJ<7\u000fE\u0002\u000eI\u0019J!!\n\b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001drcB\u0001\u0015-!\tIc\"D\u0001+\u0015\tYc!\u0001\u0004=e>|GOP\u0005\u0003[9\ta\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011QF\u0004\u0005\u0006e%!\taM\u0001\u0011m\u0016\u0014\u0018NZ=BgNLwM\\7f]R$2A\b\u001b:\u0011\u0015)\u0014\u00071\u00017\u0003\u001dQ8.\u0016;jYN\u0004\"aE\u001c\n\u0005a\"\"a\u0002.l+RLGn\u001d\u0005\u0006uE\u0002\raO\u0001\u0005_B$8\u000f\u0005\u0002={5\t\u0011B\u0002\u0003?\u0013\u0001y$\u0001\t*fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]N\u001cu.\\7b]\u0012|\u0005\u000f^5p]N\u001c\"!\u0010\u0007\t\u0011\tj$\u0011!Q\u0001\n\rBQ!G\u001f\u0005\u0002\t#\"aO\"\t\u000b\t\n\u0005\u0019A\u0012\t\u000f\u0015k$\u0019!C\u0001\r\u00061\u0001/\u0019:tKJ,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006Q!n\u001c9ug&l\u0007\u000f\\3\n\u00051K%\u0001D(qi&|g\u000eU1sg\u0016\u0014\bB\u0002(>A\u0003%q)A\u0004qCJ\u001cXM\u001d\u0011\t\u000fAk$\u0019!C\u0001#\u0006a!p[\"p]:,7\r^(qiV\t!\u000bE\u0002I'\u001aJ!\u0001V%\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0011\u00191V\b)A\u0005%\u0006i!p[\"p]:,7\r^(qi\u0002Bq\u0001W\u001fC\u0002\u0013\u0005\u0011,A\u0006hK:,'/\u0019;f\u001fB$X#\u0001.\u0011\u0005![\u0016B\u0001/J\u0005Ey\u0005\u000f^5p]N\u0003Xm\u0019\"vS2$WM\u001d\u0005\u0007=v\u0002\u000b\u0011\u0002.\u0002\u0019\u001d,g.\u001a:bi\u0016|\u0005\u000f\u001e\u0011\t\u000f\u0001l$\u0019!C\u00013\u0006QQ\r_3dkR,w\n\u001d;\t\r\tl\u0004\u0015!\u0003[\u0003-)\u00070Z2vi\u0016|\u0005\u000f\u001e\u0011\t\u000f\u0011l$\u0019!C\u00013\u0006Ia/\u001a:jMf|\u0005\u000f\u001e\u0005\u0007Mv\u0002\u000b\u0011\u0002.\u0002\u0015Y,'/\u001b4z\u001fB$\b\u0005C\u0004i{\t\u0007I\u0011A)\u0002/I,\u0017m]:jO:lWM\u001c;Kg>tg)\u001b7f\u001fB$\bB\u00026>A\u0003%!+\u0001\rsK\u0006\u001c8/[4o[\u0016tGOS:p]\u001aKG.Z(qi\u0002Bq\u0001\\\u001fC\u0002\u0013\u0005\u0011+A\fu_BL7m\u001d+p\u001b>4XMS:p]\u001aKG.Z(qi\"1a.\u0010Q\u0001\nI\u000b\u0001\u0004^8qS\u000e\u001cHk\\'pm\u0016T5o\u001c8GS2,w\n\u001d;!\u0011\u001d\u0001XH1A\u0005\u0002E\u000bQB\u0019:pW\u0016\u0014H*[:u\u001fB$\bB\u0002:>A\u0003%!+\u0001\bce>\\WM\u001d'jgR|\u0005\u000f\u001e\u0011\t\u000fQl$\u0019!C\u00013\u0006\u0001B-[:bE2,'+Y2l\u0003^\f'/\u001a\u0005\u0007mv\u0002\u000b\u0011\u0002.\u0002#\u0011L7/\u00192mKJ\u000b7m[!xCJ,\u0007\u0005C\u0004y{\t\u0007I\u0011A=\u0002\u0017QD'o\u001c;uY\u0016|\u0005\u000f^\u000b\u0002uB\u0019\u0001jU>\u0011\u00055a\u0018BA?\u000f\u0005\u0011auN\\4\t\r}l\u0004\u0015!\u0003{\u00031!\bN]8ui2,w\n\u001d;!\u0011%\t\u0019!\u0010b\u0001\n\u0003\t)!A\u0004paRLwN\\:\u0016\u0005\u0005\u001d\u0001c\u0001%\u0002\n%\u0019\u00111B%\u0003\u0013=\u0003H/[8o'\u0016$\b\u0002CA\b{\u0001\u0006I!a\u0002\u0002\u0011=\u0004H/[8og\u0002BaAM\u0005\u0005\u0002\u0005MA#\u0002\u0010\u0002\u0016\u0005]\u0001BB\u001b\u0002\u0012\u0001\u0007a\u0007C\u0004\u0002\u001a\u0005E\u0001\u0019\u0001\u0014\u0002\u0015)\u001cxN\\*ue&tw\r\u0003\u0005\u0002\u001e%!\tAAA\u0010\u00039\u0011X-\\8wKRC'o\u001c;uY\u0016$\u0012BHA\u0011\u0003G\tY%a\u0016\t\rU\nY\u00021\u00017\u0011!\t)#a\u0007A\u0002\u0005\u001d\u0012\u0001\u00079beRLG/[8ogR{')\u001a*fCN\u001c\u0018n\u001a8fIBA\u0011\u0011FA\u0018\u0003g\ty$\u0004\u0002\u0002,)\u0019\u0011Q\u0006\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00022\u0005-\"aA'baB!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:\u0011\taaY8n[>t\u0017\u0002BA\u001f\u0003o\u0011\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o!\u0019\tI#!\u0011\u0002F%!\u00111IA\u0016\u0005\r\u0019V-\u001d\t\u0004\u001b\u0005\u001d\u0013bAA%\u001d\t\u0019\u0011J\u001c;\t\u0011\u00055\u00131\u0004a\u0001\u0003\u001f\n!D]3bgNLwM\\3e!\u0006\u0014H/\u001b;j_:\u001c8\u000b^1ukN\u0004\u0002\"!\u000b\u00020\u0005M\u0012\u0011\u000b\t\u0004\u0011\u0005M\u0013bAA+\u0005\t\u0011\"+Z1tg&<g.\\3oiN#\u0018\r^;t\u0011%\u0019\u00111\u0004I\u0001\u0002\u0004\tI\u0006E\u0002\t\u00037J1!!\u0018\u0003\u00059\tE-\\5o+RLG.\u001b;jKNDq!!\u0019\n\t\u0003\t\u0019'\u0001\nhK:,'/\u0019;f\u0003N\u001c\u0018n\u001a8nK:$H#\u0002\u0010\u0002f\u0005\u001d\u0004BB\u001b\u0002`\u0001\u0007a\u0007\u0003\u0004;\u0003?\u0002\ra\u000f\u0005\b\u0003CJA\u0011AA6))\ti'a\u001d\u0002v\u0005e\u0014Q\u0010\t\b\u001b\u0005=\u0014qEA\u0014\u0013\r\t\tH\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\rU\nI\u00071\u00017\u0011!\t9(!\u001bA\u0002\u0005}\u0012\u0001\u00062s_.,'\u000fT5tiR{'+Z1tg&<g\u000eC\u0004\u0002|\u0005%\u0004\u0019\u0001\u0014\u0002-Q|\u0007/[2t)>luN^3Kg>t7\u000b\u001e:j]\u001eDq\u0001^A5\u0001\u0004\ty\bE\u0002\u000e\u0003\u0003K1!a!\u000f\u0005\u001d\u0011un\u001c7fC:Dq!a\"\n\t\u0003\tI)A\tfq\u0016\u001cW\u000f^3BgNLwM\\7f]R$RAHAF\u0003\u001bCa!NAC\u0001\u00041\u0004B\u0002\u001e\u0002\u0006\u0002\u00071\bC\u0004\u0002\b&!\t!!%\u0015\u000fy\t\u0019*!&\u0002\u001a\"1Q'a$A\u0002YBq!a&\u0002\u0010\u0002\u0007a%\u0001\fsK\u0006\u001c8/[4o[\u0016tGOS:p]N#(/\u001b8h\u0011%\tY*a$\u0011\u0002\u0003\u000710\u0001\u0005uQJ|G\u000f\u001e7f\u0011\u001d\ty*\u0003C\u0001\u0003C\u000ba\u0003\u001d:j]R\u001cUO\u001d:f]R\f5o]5h]6,g\u000e\u001e\u000b\u0006=\u0005\r\u0016Q\u0015\u0005\u0007k\u0005u\u0005\u0019\u0001\u001c\t\u0011\u0005\u0015\u0012Q\u0014a\u0001\u0003O\u0003b!!\u000b\u0002B\u0005%\u0006cB\u0007\u0002p\u0005M\u0012q\b\u0005\b\u0003[KA\u0011AAX\u0003A\u0001\u0018M]:f\u0003:$g+\u00197jI\u0006$X\r\u0006\u0004\u0002(\u0006E\u00161\u0017\u0005\u0007k\u0005-\u0006\u0019\u0001\u001c\t\u000f\u0005]\u00151\u0016a\u0001M!9\u0011qW\u0005\u0005\n\u0005e\u0016\u0001H2iK\u000e\\\u0017J\u001a*fCN\u001c\u0018n\u001a8nK:$8+^2dK\u0016$W\r\u001a\u000b\u0007\u0003\u001f\nY,!0\t\rU\n)\f1\u00017\u0011!\t)#!.A\u0002\u0005\u001d\u0002bBAa\u0013\u0011\u0005\u00111Y\u0001&G\",7m[%g!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u'V\u001c7-Z3eK\u0012$\"\"!\u0015\u0002F\u0006\u001d\u00171ZAg\u0011\u0019)\u0014q\u0018a\u0001m!A\u0011\u0011ZA`\u0001\u0004\t\u0019$A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001\"!\n\u0002@\u0002\u0007\u0011q\u0005\u0005\t\u0003\u001f\fy\f1\u0001\u0002(\u0005I\u0002/\u0019:uSRLwN\\:CK&twMU3bgNLwM\\3e\u0011\u001d\t\u0019.\u0003C\u0001\u0003+\fAC^1mS\u0012\fG/Z!oIB\u000b'o]3Be\u001e\u001cHcA\u001e\u0002X\"1!%!5A\u0002\rB\u0011\"a7\n#\u0003%\t!!8\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyN\u000b\u0003\u0002Z\u0005\u00058FAAr!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055h\"\u0001\u0006b]:|G/\u0019;j_:LA!!=\u0002h\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005U\u0018\"%A\u0005\u0002\u0005]\u0018aG3yK\u000e,H/Z!tg&<g.\\3oi\u0012\"WMZ1vYR$3'\u0006\u0002\u0002z*\u001a10!9\t\u0015\u0005u\u0018\"%A\u0005\u0002\t\ti.\u0001\rsK6|g/\u001a+ie>$H\u000f\\3%I\u00164\u0017-\u001e7uIQ2QA\u0003\u0002\u0001\u0005\u0003\u0019B!a@\r%!IQ'a@\u0003\u0002\u0003\u0006IA\u000e\u0005\f\u0005\u000f\tyP!A!\u0002\u0013\t9#\u0001\nqe>\u0004xn]3e\u0003N\u001c\u0018n\u001a8nK:$\bBC\u0002\u0002\u0000\n\u0005\t\u0015!\u0003\u0002Z!9\u0011$a@\u0005\u0002\t5A\u0003\u0003B\b\u0005#\u0011\u0019B!\u0006\u0011\u0007!\ty\u0010\u0003\u00046\u0005\u0017\u0001\rA\u000e\u0005\t\u0005\u000f\u0011Y\u00011\u0001\u0002(!I1Aa\u0003\u0011\u0002\u0003\u0007\u0011\u0011\f\u0005\t\u00053\ty\u0010\"\u0001\u0003\u001c\u0005\u0011R\r_5ti&tw-Q:tS\u001etW.\u001a8u)\t\t9\u0003\u0003\u0005\u0003 \u0005}H\u0011\u0002B\u0011\u00035i\u0017-\u001f2f)\"\u0014x\u000e\u001e;mKR\u0019aDa\t\t\u000f\u0005m%Q\u0004a\u0001w\"A!qEA\u0000\t\u0003\u0011I#\u0001\u0006nCf\u0014W\rT5nSR$2A\bB\u0016\u0011\u001d\tYJ!\nA\u0002mD\u0011Ba\f\u0002\u0000\u0012\u0005!A!\r\u0002/\u0005\u001c8/[4o)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001cHc\u0002\u0010\u00034\t]\"1\b\u0005\t\u0005k\u0011i\u00031\u0001\u0002(\u0005Y\u0011\r\u001c7Fq&\u001cH/\u001b8h\u0011!\u0011ID!\fA\u0002\u0005\u001d\u0012aC1mYB\u0013x\u000e]8tK\u0012D\u0011b\u0001B\u0017!\u0003\u0005\r!!\u0017\t\u0011\t}\u0012q C\u0005\u0005\u0003\na\u0004]8tiJ+'-\u00197b]\u000e,'+\u001a9mS\u000e\f7\u000f\u00165bi6{g/\u001a3\u0015\r\u0005\u001d\"1\tB$\u0011!\u0011)E!\u0010A\u0002\u0005\u001d\u0012\u0001C3ySN$\u0018N\\4\t\u0011\t%#Q\ba\u0001\u0003O\t\u0001\u0002\u001d:pa>\u001cX\r\u001a\u0005\t\u0005\u001b\ny\u0010\"\u0003\u0003P\u00051\u0003O]3SK\n\fG.\u00198dKJ+\u0007\u000f\\5dC\u001a{'/T8wS:<\u0007+\u0019:uSRLwN\\:\u0015\r\u0005\u001d\"\u0011\u000bB*\u0011!\u0011)Ea\u0013A\u0002\u0005\u001d\u0002\u0002\u0003B%\u0005\u0017\u0002\r!a\n\t\u0011\t]\u0013q C\u0001\u00053\naAZ8s[\u0006$Hc\u0001\u0014\u0003\\!A!Q\fB+\u0001\u0004\t9#A\u0003n_Z,7\u000f\u0003\u0005\u0003b\u0005}H\u0011\u0001B2\u0003!1\u0017\u000e\u001c;fe\nKH\u0003CA7\u0005K\u0012IGa\u001b\t\u000f\t\u001d$q\fa\u0001M\u0005)Ao\u001c9jG\"A!Q\u0007B0\u0001\u0004\t9\u0003\u0003\u0005\u0003:\t}\u0003\u0019AA\u0014\u0011!\u0011y'a@\u0005\u0002\tE\u0014A\u0005:fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]N$B!a \u0003t!I\u00111\u0014B7!\u0003\u0005\ra\u001f\u0005\t\u0005o\ny\u0010\"\u0001\u0003z\u0005\tb/\u00197jI\u0006$X\rU1si&$\u0018n\u001c8\u0015\u0011\u0005}$1\u0010B?\u0005\u007fBa!\u000eB;\u0001\u00041\u0004b\u0002B4\u0005k\u0002\rA\n\u0005\t\u0005\u0003\u0013)\b1\u0001\u0002F\u0005I\u0001/\u0019:uSRLwN\u001c\u0005\u000b\u0005\u000b\u000by0%A\u0005\u0002\u0005]\u0018\u0001\b:fCN\u001c\u0018n\u001a8QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$H%\r\u0005\f\u0005\u0013\u000by0%A\u0005\u0002\t\ti.A\u0011bgNLwM\u001c+ie>$H\u000f\\3e%\u0016\u0004H.[2bg\u0012\"WMZ1vYR$3\u0007")
public class ReassignPartitionsCommand
implements Logging {
    private final ZkUtils zkUtils;
    private final Map<TopicAndPartition, Seq<Object>> proposedAssignment;
    private final AdminUtilities admin;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static long executeAssignment$default$3() {
        return ReassignPartitionsCommand$.MODULE$.executeAssignment$default$3();
    }

    public static AdminUtilities $lessinit$greater$default$3() {
        return ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$3();
    }

    public static ReassignPartitionsCommandOptions validateAndParseArgs(String[] stringArray) {
        return ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(stringArray);
    }

    public static ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkUtils zkUtils, TopicAndPartition topicAndPartition, Map<TopicAndPartition, Seq<Object>> map, Map<TopicAndPartition, Seq<Object>> map2) {
        return ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(zkUtils, topicAndPartition, map, map2);
    }

    public static Seq<Tuple2<TopicAndPartition, Seq<Object>>> parseAndValidate(ZkUtils zkUtils, String string) {
        return ReassignPartitionsCommand$.MODULE$.parseAndValidate(zkUtils, string);
    }

    public static void printCurrentAssignment(ZkUtils zkUtils, Seq<Tuple2<TopicAndPartition, Seq<Object>>> seq) {
        ReassignPartitionsCommand$.MODULE$.printCurrentAssignment(zkUtils, seq);
    }

    public static void executeAssignment(ZkUtils zkUtils, String string, long l) {
        ReassignPartitionsCommand$.MODULE$.executeAssignment(zkUtils, string, l);
    }

    public static void executeAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.executeAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> generateAssignment(ZkUtils zkUtils, Seq<Object> seq, String string, boolean bl) {
        return ReassignPartitionsCommand$.MODULE$.generateAssignment(zkUtils, seq, string, bl);
    }

    public static void generateAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.generateAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static void verifyAssignment(ZkUtils zkUtils, String string) {
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkUtils, string);
    }

    public static void verifyAssignment(ZkUtils zkUtils, ReassignPartitionsCommandOptions reassignPartitionsCommandOptions) {
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(zkUtils, reassignPartitionsCommandOptions);
    }

    public static void main(String[] stringArray) {
        ReassignPartitionsCommand$.MODULE$.main(stringArray);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand reassignPartitionsCommand = this;
        synchronized (reassignPartitionsCommand) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public Map<TopicAndPartition, Seq<Object>> existingAssignment() {
        Seq proposedTopics = ((SetLike)this.proposedAssignment.keySet().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.topic(), Set$.MODULE$.canBuildFrom())).toSeq();
        return this.zkUtils.getReplicaAssignmentForTopics((Seq<String>)proposedTopics);
    }

    private void maybeThrottle(long throttle) {
        block0: {
            if (throttle < 0L) break block0;
            this.maybeLimit(throttle);
            this.assignThrottledReplicas(this.existingAssignment(), this.proposedAssignment, this.assignThrottledReplicas$default$3());
        }
    }

    public void maybeLimit(long throttle) {
        block0: {
            if (throttle < 0L) break block0;
            Seq existingBrokers = ((TraversableOnce)this.existingAssignment().values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq();
            Seq proposedBrokers = ((TraversableOnce)this.proposedAssignment.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq();
            Seq brokers = (Seq)((SeqLike)existingBrokers.$plus$plus((GenTraversableOnce)proposedBrokers, Seq$.MODULE$.canBuildFrom())).distinct();
            brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> {
                Properties configs = $this.admin.fetchEntityConfig($this.zkUtils, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)id)).toString());
                configs.put(DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)throttle)).toString());
                configs.put(DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), ((Object)BoxesRunTime.boxToLong((long)throttle)).toString());
                $this.admin.changeBrokerConfig($this.zkUtils, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{id}))), configs);
            });
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The throttle limit was set to ", " B/s"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)throttle)})));
        }
    }

    public void assignThrottledReplicas(Map<TopicAndPartition, Seq<Object>> allExisting, Map<TopicAndPartition, Seq<Object>> allProposed, AdminUtilities admin) {
        ((SetLike)allProposed.keySet().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.topic(), Set$.MODULE$.canBuildFrom())).toSeq().foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ReassignPartitionsCommand.$anonfun$assignThrottledReplicas$2(this, allExisting, allProposed, admin, topic);
            return BoxedUnit.UNIT;
        });
    }

    public AdminUtilities assignThrottledReplicas$default$3() {
        return AdminUtils$.MODULE$;
    }

    private Map<TopicAndPartition, Seq<Object>> postRebalanceReplicasThatMoved(Map<TopicAndPartition, Seq<Object>> existing, Map<TopicAndPartition, Seq<Object>> proposed) {
        return (Map)proposed.map((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Tuple2 tuple2 = x0$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            Seq proposedReplicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)((SetLike)proposedReplicas.toSet().$minus$minus((GenTraversableOnce)existing.apply((Object)tp))).toSeq());
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    private Map<TopicAndPartition, Seq<Object>> preRebalanceReplicaForMovingPartitions(Map<TopicAndPartition, Seq<Object>> existing, Map<TopicAndPartition, Seq<Object>> proposed) {
        return (Map)existing.filter((Function1 & Serializable & scala.Serializable)x0$13 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand.$anonfun$preRebalanceReplicaForMovingPartitions$1(proposed, x0$13)));
    }

    public String format(Map<TopicAndPartition, Seq<Object>> moves) {
        return ((TraversableOnce)moves.flatMap((Function1 & Serializable & scala.Serializable)x0$14 -> {
            Tuple2 tuple2 = x0$14;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicAndPartition tp = (TopicAndPartition)tuple2._1();
            Seq moves = (Seq)tuple2._2();
            Seq seq = (Seq)moves.map((Function1 & Serializable & scala.Serializable)replicaId -> ReassignPartitionsCommand.$anonfun$format$2(tp, BoxesRunTime.unboxToInt((Object)replicaId)), Seq$.MODULE$.canBuildFrom());
            return seq;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> filterBy(String topic, Map<TopicAndPartition, Seq<Object>> allExisting, Map<TopicAndPartition, Seq<Object>> allProposed) {
        return new Tuple2(allExisting.filter((Function1 & Serializable & scala.Serializable)x0$15 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand.$anonfun$filterBy$1(topic, x0$15))), allProposed.filter((Function1 & Serializable & scala.Serializable)x0$16 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand.$anonfun$filterBy$2(topic, x0$16))));
    }

    public boolean reassignPartitions(long throttle) {
        boolean bl;
        this.maybeThrottle(throttle);
        try {
            Map validPartitions = (Map)this.proposedAssignment.filter((Function1 & Serializable & scala.Serializable)x0$17 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsCommand.$anonfun$reassignPartitions$1(this, x0$17)));
            if (validPartitions.isEmpty()) {
                bl = false;
            } else {
                String jsonReassignmentData = ZkUtils$.MODULE$.formatAsReassignmentJson((Map<TopicAndPartition, Seq<Object>>)validPartitions);
                this.zkUtils.createPersistentPath(ZkUtils$.MODULE$.ReassignPartitionsPath(), jsonReassignmentData, this.zkUtils.createPersistentPath$default$3());
                bl = true;
            }
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            Map<TopicAndPartition, ReassignedPartitionsContext> partitionsBeingReassigned = this.zkUtils.getPartitionsBeingReassigned();
            throw new AdminCommandFailedException("Partition reassignment currently in " + new StringOps(Predef$.MODULE$.augmentString("progress for %s. Aborting operation")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsBeingReassigned})));
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Admin command failed", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public long reassignPartitions$default$1() {
        return -1L;
    }

    public boolean validatePartition(ZkUtils zkUtils, String topic, int partition) {
        boolean bl;
        Option partitionsOpt = zkUtils.getPartitionsForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).get((Object)topic);
        Option option = partitionsOpt;
        if (option instanceof Some) {
            boolean bl2;
            Some some = (Some)option;
            Seq partitions = (Seq)some.value();
            if (partitions.contains((Object)BoxesRunTime.boxToInteger((int)partition))) {
                bl2 = true;
            } else {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Skipping reassignment of partition [%s,%d] ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})) + "since it doesn't exist");
                bl2 = false;
            }
            bl = bl2;
        } else if (None$.MODULE$.equals(option)) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping reassignment of partition " + new StringOps(Predef$.MODULE$.augmentString("[%s,%d] since topic %s doesn't exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition), topic})));
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$assignThrottledReplicas$2(ReassignPartitionsCommand $this, Map allExisting$1, Map allProposed$1, AdminUtilities admin$2, String topic) {
        Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple2 = $this.filterBy(topic, (Map<TopicAndPartition, Seq<Object>>)allExisting$1, (Map<TopicAndPartition, Seq<Object>>)allProposed$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map existing = (Map)tuple2._1();
        Map proposed = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existing, (Object)proposed);
        Tuple2 tuple23 = tuple22;
        Map existing2 = (Map)tuple23._1();
        Map proposed2 = (Map)tuple23._2();
        String leader = $this.format($this.preRebalanceReplicaForMovingPartitions((Map<TopicAndPartition, Seq<Object>>)existing2, (Map<TopicAndPartition, Seq<Object>>)proposed2));
        String follower = $this.format($this.postRebalanceReplicasThatMoved((Map<TopicAndPartition, Seq<Object>>)existing2, (Map<TopicAndPartition, Seq<Object>>)proposed2));
        Properties configs = admin$2.fetchEntityConfig($this.zkUtils, ConfigType$.MODULE$.Topic(), topic);
        configs.put(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), leader);
        configs.put(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), follower);
        admin$2.changeTopicConfig($this.zkUtils, topic, configs);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated leader-throttled replicas for topic ", " with: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, leader})));
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated follower-throttled replicas for topic ", " with: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, follower})));
    }

    private static final boolean moving$1(Seq before, Seq after) {
        return ((TraversableOnce)after.toSet().$minus$minus((GenTraversableOnce)before.toSet())).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$preRebalanceReplicaForMovingPartitions$1(Map proposed$1, Tuple2 x0$13) {
        Tuple2 tuple2 = x0$13;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
        Seq preMoveReplicas = (Seq)tuple2._2();
        boolean bl = proposed$1.contains((Object)tp) && ReassignPartitionsCommand.moving$1(preMoveReplicas, (Seq)proposed$1.apply((Object)tp));
        return bl;
    }

    public static final /* synthetic */ String $anonfun$format$2(TopicAndPartition tp$1, int replicaId) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tp$1.partition()), BoxesRunTime.boxToInteger((int)replicaId)}));
    }

    public static final /* synthetic */ boolean $anonfun$filterBy$1(String topic$2, Tuple2 x0$15) {
        Tuple2 tuple2 = x0$15;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
        String string = tp.topic();
        String string2 = topic$2;
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterBy$2(String topic$2, Tuple2 x0$16) {
        Tuple2 tuple2 = x0$16;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition tp = (TopicAndPartition)tuple2._1();
        String string = tp.topic();
        String string2 = topic$2;
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$reassignPartitions$1(ReassignPartitionsCommand $this, Tuple2 x0$17) {
        Tuple2 tuple2 = x0$17;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition p = (TopicAndPartition)tuple2._1();
        boolean bl = $this.validatePartition($this.zkUtils, p.topic(), p.partition());
        return bl;
    }

    public ReassignPartitionsCommand(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> proposedAssignment, AdminUtilities admin) {
        this.zkUtils = zkUtils;
        this.proposedAssignment = proposedAssignment;
        this.admin = admin;
        Logging.$init$(this);
    }

    public static class ReassignPartitionsCommandOptions {
        private final OptionParser parser = new OptionParser();
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final OptionSpecBuilder generateOpt = this.parser().accepts("generate", "Generate a candidate partition reassignment configuration. Note that this only generates a candidate assignment, it does not execute it.");
        private final OptionSpecBuilder executeOpt = this.parser().accepts("execute", "Kick off the reassignment as specified by the --reassignment-json-file option.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify", "Verify if the reassignment completed as specified by the --reassignment-json-file option. If there is a throttle engaged for the replicas specified, and the rebalance has completed, the throttle will be removed");
        private final ArgumentAcceptingOptionSpec<String> reassignmentJsonFileOpt = this.parser().accepts("reassignment-json-file", "The JSON file with the partition reassignment configurationThe format to use is - \n{\"partitions\":\n\t[{\"topic\": \"foo\",\n\t  \"partition\": 1,\n\t  \"replicas\": [1,2,3] }],\n\"version\":1\n}").withRequiredArg().describedAs("manual assignment json file path").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicsToMoveJsonFileOpt = this.parser().accepts("topics-to-move-json-file", "Generate a reassignment configuration to move the partitions of the specified topics to the list of brokers specified by the --broker-list option. The format to use is - \n{\"topics\":\n\t[{\"topic\": \"foo\"},{\"topic\": \"foo1\"}],\n\"version\":1\n}").withRequiredArg().describedAs("topics to reassign json file path").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> brokerListOpt = this.parser().accepts("broker-list", "The list of brokers to which the partitions need to be reassigned in the form \"0,1,2\". This is required if --topics-to-move-json-file is used to generate reassignment configuration").withRequiredArg().describedAs("brokerlist").ofType(String.class);
        private final OptionSpecBuilder disableRackAware = this.parser().accepts("disable-rack-aware", "Disable rack aware replica assignment");
        private final ArgumentAcceptingOptionSpec<Object> throttleOpt = this.parser().accepts("throttle", "The movement of partitions will be throttled to this value (bytes/sec). Rerunning with this option, whilst a rebalance is in progress, will alter the throttle value. The throttle rate should be at least 1 KB/s.").withRequiredArg().describedAs("throttle").defaultsTo((Object)"-1", (Object[])new String[0]).ofType(Long.TYPE);
        private final OptionSet options;

        public OptionParser parser() {
            return this.parser;
        }

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public OptionSpecBuilder generateOpt() {
            return this.generateOpt;
        }

        public OptionSpecBuilder executeOpt() {
            return this.executeOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public ArgumentAcceptingOptionSpec<String> reassignmentJsonFileOpt() {
            return this.reassignmentJsonFileOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicsToMoveJsonFileOpt() {
            return this.topicsToMoveJsonFileOpt;
        }

        public ArgumentAcceptingOptionSpec<String> brokerListOpt() {
            return this.brokerListOpt;
        }

        public OptionSpecBuilder disableRackAware() {
            return this.disableRackAware;
        }

        public ArgumentAcceptingOptionSpec<Object> throttleOpt() {
            return this.throttleOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public ReassignPartitionsCommandOptions(String[] args) {
            this.options = this.parser().parse(args);
        }
    }
}

