/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.api.OffsetRequest$;
import kafka.consumer.BaseConsumer;
import kafka.consumer.BaseConsumerRecord;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.NewShinyConsumer$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple4;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0001CT3x'\"Lg._\"p]N,X.\u001a:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u00051\u0011\u0015m]3D_:\u001cX/\\3s\u0011!\u0019\u0002A!A!\u0002\u0013!\u0012!\u0002;pa&\u001c\u0007cA\u0005\u0016/%\u0011aC\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005aybBA\r\u001e!\tQ\"\"D\u0001\u001c\u0015\tab!\u0001\u0004=e>|GOP\u0005\u0003=)\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0011\"\u0005\u0019\u0019FO]5oO*\u0011aD\u0003\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u0005Y\u0001/\u0019:uSRLwN\\%e!\rIQ#\n\t\u0003\u0013\u0019J!a\n\u0006\u0003\u0007%sG\u000f\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0003\u0019ygMZ:fiB\u0019\u0011\"F\u0016\u0011\u0005%a\u0013BA\u0017\u000b\u0005\u0011auN\\4\t\u0011=\u0002!\u0011!Q\u0001\nQ\t\u0011b\u001e5ji\u0016d\u0017n\u001d;\t\u0011E\u0002!\u0011!Q\u0001\nI\nQbY8ogVlWM\u001d)s_B\u001c\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011)H/\u001b7\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011\u0001\u001f\u0002\u0013QLW.Z8vi6\u001bX#A\u0016\t\u0011y\u0002!\u0011!Q\u0001\n-\n!\u0002^5nK>,H/T:!\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q9!i\u0011#F\r\u001eC\u0005CA\b\u0001\u0011\u0015\u0019r\b1\u0001\u0015\u0011\u0015\u0019s\b1\u0001%\u0011\u0015Is\b1\u0001+\u0011\u0015ys\b1\u0001\u0015\u0011\u0015\tt\b1\u00013\u0011\u001dYt\b%AA\u0002-Bqa\u0001\u0001C\u0002\u0013\u0005!*F\u0001L!\u0011aUkV,\u000e\u00035S!a\u0001(\u000b\u0005=\u0003\u0016aB2mS\u0016tGo\u001d\u0006\u0003\u000bES!AU*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0016aA8sO&\u0011a+\u0014\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0011\u0007%A&,\u0003\u0002Z\u0015\t)\u0011I\u001d:bsB\u0011\u0011bW\u0005\u00039*\u0011AAQ=uK\"1a\f\u0001Q\u0001\n-\u000b\u0011bY8ogVlWM\u001d\u0011\t\u000f\u0001\u0004\u0001\u0019!C\u0001C\u0006Q!/Z2pe\u0012LE/\u001a:\u0016\u0003\t\u00042aM2f\u0013\t!GG\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011aemV,\n\u0005\u001dl%AD\"p]N,X.\u001a:SK\u000e|'\u000f\u001a\u0005\bS\u0002\u0001\r\u0011\"\u0001k\u00039\u0011XmY8sI&#XM]0%KF$\"a\u001b8\u0011\u0005%a\u0017BA7\u000b\u0005\u0011)f.\u001b;\t\u000f=D\u0017\u0011!a\u0001E\u0006\u0019\u0001\u0010J\u0019\t\rE\u0004\u0001\u0015)\u0003c\u0003-\u0011XmY8sI&#XM\u001d\u0011\t\u000bM\u0004A\u0011\u0001;\u0002\u0019\r|gn];nKJLe.\u001b;\u0015\u0003-DQA\u001e\u0001\u0005\u0002]\fAa]3fWR!1\u000e_={\u0011\u0015\u0019R\u000f1\u0001\u0018\u0011\u0015\u0019S\u000f1\u0001&\u0011\u0015IS\u000f1\u0001,\u0011\u0015a\b\u0001\"\u0011~\u0003\u001d\u0011XmY3jm\u0016$\u0012A \t\u0003\u001f}L1!!\u0001\u0003\u0005I\u0011\u0015m]3D_:\u001cX/\\3s%\u0016\u001cwN\u001d3\t\r\u0005\u0015\u0001\u0001\"\u0011u\u0003\u0011\u0019Ho\u001c9\t\r\u0005%\u0001\u0001\"\u0011u\u0003\u001d\u0019G.Z1okBDa!!\u0004\u0001\t\u0003\"\u0018AB2p[6LGoB\u0005\u0002\u0012\t\t\t\u0011#\u0001\u0002\u0014\u0005\u0001b*Z<TQ&t\u0017pQ8ogVlWM\u001d\t\u0004\u001f\u0005Ua\u0001C\u0001\u0003\u0003\u0003E\t!a\u0006\u0014\u0007\u0005U\u0001\u0002C\u0004A\u0003+!\t!a\u0007\u0015\u0005\u0005M\u0001BCA\u0010\u0003+\t\n\u0011\"\u0001\u0002\"\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"!a\t+\u0007-\n)c\u000b\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!C;oG\",7m[3e\u0015\r\t\tDC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001b\u0003W\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class NewShinyConsumer
implements BaseConsumer {
    private final Option<String> topic;
    private final Option<Object> partitionId;
    private final Option<Object> offset;
    private final Option<String> whitelist;
    private final long timeoutMs;
    private final KafkaConsumer<byte[], byte[]> consumer;
    private Iterator<ConsumerRecord<byte[], byte[]>> recordIter;

    public static long $lessinit$greater$default$6() {
        return NewShinyConsumer$.MODULE$.$lessinit$greater$default$6();
    }

    public long timeoutMs() {
        return this.timeoutMs;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public Iterator<ConsumerRecord<byte[], byte[]>> recordIter() {
        return this.recordIter;
    }

    public void recordIter_$eq(Iterator<ConsumerRecord<byte[], byte[]>> x$1) {
        this.recordIter = x$1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void consumerInit() {
        Tuple4 tuple4 = new Tuple4(this.topic, this.partitionId, this.offset, this.whitelist);
        if (tuple4 != null) {
            Option option = (Option)tuple4._1();
            Option option2 = (Option)tuple4._2();
            Option option3 = (Option)tuple4._3();
            Option option4 = (Option)tuple4._4();
            if (option instanceof Some) {
                Some some = (Some)option;
                String topic = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int partitionId = BoxesRunTime.unboxToInt((Object)some2.value());
                    if (option3 instanceof Some) {
                        Some some3 = (Some)option3;
                        long offset = BoxesRunTime.unboxToLong((Object)some3.value());
                        if (None$.MODULE$.equals(option4)) {
                            this.seek(topic, partitionId, offset);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
            }
        }
        if (tuple4 != null) {
            Option option = (Option)tuple4._1();
            Option option5 = (Option)tuple4._2();
            Option option6 = (Option)tuple4._3();
            Option option7 = (Option)tuple4._4();
            if (option instanceof Some) {
                Some some = (Some)option;
                String topic = (String)some.value();
                if (option5 instanceof Some) {
                    Some some4 = (Some)option5;
                    int partitionId = BoxesRunTime.unboxToInt((Object)some4.value());
                    if (None$.MODULE$.equals(option6) && None$.MODULE$.equals(option7)) {
                        this.seek(topic, partitionId, OffsetRequest$.MODULE$.LatestTime());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
        }
        if (tuple4 != null) {
            Option option = (Option)tuple4._1();
            Option option8 = (Option)tuple4._2();
            Option option9 = (Option)tuple4._3();
            Option option10 = (Option)tuple4._4();
            if (option instanceof Some) {
                Some some = (Some)option;
                String topic = (String)some.value();
                if (None$.MODULE$.equals(option8) && None$.MODULE$.equals(option9) && None$.MODULE$.equals(option10)) {
                    this.consumer().subscribe(Collections.singletonList(topic));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (tuple4 == null) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        Option option = (Option)tuple4._1();
        Option option11 = (Option)tuple4._2();
        Option option12 = (Option)tuple4._3();
        Option option13 = (Option)tuple4._4();
        if (!None$.MODULE$.equals(option)) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        if (!None$.MODULE$.equals(option11)) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        if (!None$.MODULE$.equals(option12)) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        if (!(option13 instanceof Some)) throw new IllegalArgumentException("An invalid combination of arguments is provided. Exactly one of 'topic' or 'whitelist' must be provided. If 'topic' is provided, an optional 'partition' may also be provided. If 'partition' is provided, an optional 'offset' may also be provided, otherwise, consumption starts from the end of the partition.");
        Some some = (Some)option13;
        String whitelist = (String)some.value();
        this.consumer().subscribe(Pattern.compile(whitelist), (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void seek(String topic, int partitionId, long offset) {
        TopicPartition topicPartition = new TopicPartition(topic, partitionId);
        this.consumer().assign(Collections.singletonList(topicPartition));
        long l = offset;
        if (OffsetRequest$.MODULE$.EarliestTime() == l) {
            this.consumer().seekToBeginning(Collections.singletonList(topicPartition));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (OffsetRequest$.MODULE$.LatestTime() == l) {
            this.consumer().seekToEnd(Collections.singletonList(topicPartition));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.consumer().seek(topicPartition, offset);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public BaseConsumerRecord receive() {
        if (!this.recordIter().hasNext()) {
            this.recordIter_$eq(this.consumer().poll(this.timeoutMs()).iterator());
            if (!this.recordIter().hasNext()) {
                throw new ConsumerTimeoutException();
            }
        }
        ConsumerRecord<byte[], byte[]> record = this.recordIter().next();
        return new BaseConsumerRecord(record.topic(), record.partition(), record.offset(), record.timestamp(), record.timestampType(), (byte[])record.key(), (byte[])record.value());
    }

    @Override
    public void stop() {
        this.consumer().wakeup();
    }

    @Override
    public void cleanup() {
        this.consumer().close();
    }

    @Override
    public void commit() {
        this.consumer().commitSync();
    }

    public NewShinyConsumer(Option<String> topic, Option<Object> partitionId, Option<Object> offset, Option<String> whitelist, Properties consumerProps, long timeoutMs) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.offset = offset;
        this.whitelist = whitelist;
        this.timeoutMs = timeoutMs;
        this.consumer = new KafkaConsumer(consumerProps);
        this.consumerInit();
        this.recordIter = this.consumer().poll(0L).iterator();
    }
}

