/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.log.Log$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.Record;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DumpLogSegments$ {
    public static DumpLogSegments$ MODULE$;

    static {
        new DumpLogSegments$();
    }

    public void main(String[] args) {
        DumpLogSegments.MessageParser<String, String> messageParser;
        OptionParser parser = new OptionParser();
        OptionSpecBuilder printOpt = parser.accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        OptionSpecBuilder verifyOpt = parser.accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        OptionSpecBuilder indexSanityOpt = parser.accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        ArgumentAcceptingOptionSpec maxMessageSizeOpt = parser.accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        OptionSpecBuilder deepIterationOpt = parser.accepts("deep-iteration", "if set, uses deep instead of shallow iteration.");
        ArgumentAcceptingOptionSpec valueDecoderOpt = parser.accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec keyDecoderOpt = parser.accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        OptionSpecBuilder offsetsOpt = parser.accepts("offsets-decoder", "if set, log data will be parsed as offset data from __consumer_offsets topic.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Parse a log file and dump its contents to the console, useful for debugging a seemingly corrupt log segment.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{filesOpt}));
        boolean printDataLog = options.has((OptionSpec)printOpt) || options.has((OptionSpec)offsetsOpt) || options.has((OptionSpec)valueDecoderOpt) || options.has((OptionSpec)keyDecoderOpt);
        boolean verifyOnly = options.has((OptionSpec)verifyOpt);
        boolean indexSanityOnly = options.has((OptionSpec)indexSanityOpt);
        String[] files = ((String)options.valueOf((OptionSpec)filesOpt)).split(",");
        int maxMessageSize = (Integer)options.valueOf((OptionSpec)maxMessageSizeOpt);
        boolean isDeepIteration = options.has((OptionSpec)deepIterationOpt);
        if (options.has((OptionSpec)offsetsOpt)) {
            messageParser = new DumpLogSegments.OffsetsMessageParser();
        } else {
            Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)options.valueOf((OptionSpec)valueDecoderOpt), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)options.valueOf((OptionSpec)keyDecoderOpt), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
            messageParser = new DumpLogSegments.DecoderMessageParser(keyDecoder, valueDecoder);
        }
        DumpLogSegments.OffsetsMessageParser messageParser2 = messageParser;
        HashMap misMatchesForIndexFilesMap = new HashMap();
        DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors = new DumpLogSegments.TimeIndexDumpErrors();
        HashMap nonConsecutivePairsForLogFilesMap = new HashMap();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).foreach((Function1 & Serializable & scala.Serializable)arg -> {
            DumpLogSegments$.$anonfun$main$1(this, printDataLog, verifyOnly, indexSanityOnly, maxMessageSize, isDeepIteration, messageParser2, misMatchesForIndexFilesMap, timeIndexDumpErrors, nonConsecutivePairsForLogFilesMap, arg);
            return BoxedUnit.UNIT;
        });
        misMatchesForIndexFilesMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DumpLogSegments$.$anonfun$main$2(x0$1);
            return BoxedUnit.UNIT;
        });
        timeIndexDumpErrors.printErrors();
        nonConsecutivePairsForLogFilesMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            DumpLogSegments$.$anonfun$main$4(x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void dumpIndex(File file, boolean indexSanityOnly, boolean verifyOnly, HashMap<String, List<Tuple2<Object, Object>>> misMatchesForIndexFilesMap, int maxMessageSize) {
        Object object = new Object();
        try {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + Log$.MODULE$.LogFileSuffix());
            FileRecords fileRecords = FileRecords.open((File)logFile, (boolean)false);
            OffsetIndex index = new OffsetIndex(file, startOffset, OffsetIndex$.MODULE$.$lessinit$greater$default$3());
            if (indexSanityOnly) {
                index.sanityCheck();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                return;
            }
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), index.entries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                block3: {
                    BoxedUnit boxedUnit;
                    OffsetPosition entry = index.entry(i);
                    FileRecords slice = fileRecords.read(entry.position(), maxMessageSize);
                    LogEntry logEntry = (LogEntry)this.getIterator((LogEntry)slice.shallowEntries().iterator().next(), true).next();
                    if (logEntry.offset() != entry.offset() + index.baseOffset()) {
                        List misMatchesSeq = (List)misMatchesForIndexFilesMap.getOrElse((Object)file.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                        misMatchesSeq = misMatchesSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(entry.offset() + index.baseOffset(), logEntry.offset()));
                        boxedUnit = misMatchesForIndexFilesMap.put((Object)file.getAbsolutePath(), (Object)misMatchesSeq);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    if (entry.offset() == 0L && i > 0) {
                        throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                    }
                    if (verifyOnly) break block3;
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("offset: %d position: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(entry.offset() + index.baseOffset())), BoxesRunTime.boxToInteger((int)entry.position())})));
                }
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void dumpTimeIndex(File file, boolean indexSanityOnly, boolean verifyOnly, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors, int maxMessageSize) {
        Object object = new Object();
        try {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            File logFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + Log$.MODULE$.LogFileSuffix());
            FileRecords fileRecords = FileRecords.open((File)logFile, (boolean)false);
            File indexFile = new File(file.getAbsoluteFile().getParent(), file.getName().split("\\.")[0] + Log$.MODULE$.IndexFileSuffix());
            OffsetIndex index = new OffsetIndex(indexFile, startOffset, OffsetIndex$.MODULE$.$lessinit$greater$default$3());
            TimeIndex timeIndex = new TimeIndex(file, startOffset, TimeIndex$.MODULE$.$lessinit$greater$default$3());
            if (indexSanityOnly) {
                timeIndex.sanityCheck();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " passed sanity check."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                return;
            }
            LongRef prevTimestamp = LongRef.create((long)-1L);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), timeIndex.entries()).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DumpLogSegments$.$anonfun$dumpTimeIndex$1(this, file, verifyOnly, timeIndexDumpErrors, fileRecords, index, timeIndex, prevTimestamp, object, arg_0)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void dumpLog(File file, boolean printContents, HashMap<String, List<Tuple2<Object, Object>>> nonConsecutivePairsForLogFilesMap, boolean isDeepIteration, int maxMessageSize, DumpLogSegments.MessageParser<?, ?> parser) {
        block0: {
            long startOffset = new StringOps(Predef$.MODULE$.augmentString(file.getName().split("\\.")[0])).toLong();
            Predef$.MODULE$.println((Object)("Starting offset: " + startOffset));
            FileRecords messageSet = FileRecords.open((File)file, (boolean)false);
            LongRef validBytes = LongRef.create((long)0L);
            LongRef lastOffset = LongRef.create((long)-1L);
            ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(messageSet.shallowEntries(maxMessageSize)).asScala()).foreach((Function1 & Serializable & scala.Serializable)shallowLogEntry -> {
                DumpLogSegments$.$anonfun$dumpLog$1(this, file, printContents, nonConsecutivePairsForLogFilesMap, isDeepIteration, parser, validBytes, lastOffset, shallowLogEntry);
                return BoxedUnit.UNIT;
            });
            long trailingBytes = (long)messageSet.sizeInBytes() - validBytes.elem;
            if (trailingBytes <= 0L) break block0;
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Found %d invalid bytes at the end of %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)trailingBytes), file.getName()})));
        }
    }

    private Iterator<LogEntry> getIterator(LogEntry logEntry, boolean isDeepIteration) {
        return isDeepIteration ? (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(logEntry.iterator()).asScala() : package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogEntry[]{logEntry}));
    }

    public static final /* synthetic */ void $anonfun$main$1(DumpLogSegments$ $this, boolean printDataLog$1, boolean verifyOnly$1, boolean indexSanityOnly$1, int maxMessageSize$1, boolean isDeepIteration$1, DumpLogSegments.MessageParser messageParser$1, HashMap misMatchesForIndexFilesMap$1, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$1, HashMap nonConsecutivePairsForLogFilesMap$1, String arg) {
        block1: {
            File file;
            block2: {
                block0: {
                    file = new File(arg);
                    if (!file.getName().endsWith(Log$.MODULE$.LogFileSuffix())) break block0;
                    Predef$.MODULE$.println((Object)("Dumping " + file));
                    $this.dumpLog(file, printDataLog$1, (HashMap<String, List<Tuple2<Object, Object>>>)nonConsecutivePairsForLogFilesMap$1, isDeepIteration$1, maxMessageSize$1, messageParser$1);
                    break block1;
                }
                if (!file.getName().endsWith(Log$.MODULE$.IndexFileSuffix())) break block2;
                Predef$.MODULE$.println((Object)("Dumping " + file));
                $this.dumpIndex(file, indexSanityOnly$1, verifyOnly$1, (HashMap<String, List<Tuple2<Object, Object>>>)misMatchesForIndexFilesMap$1, maxMessageSize$1);
                break block1;
            }
            if (!file.getName().endsWith(Log$.MODULE$.TimeIndexFileSuffix())) break block1;
            Predef$.MODULE$.println((Object)("Dumping " + file));
            $this.dumpTimeIndex(file, indexSanityOnly$1, verifyOnly$1, timeIndexDumpErrors$1, maxMessageSize$1);
        }
    }

    public static final /* synthetic */ void $anonfun$main$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fileName = (String)tuple2._1();
        List listOfMismatches = (List)tuple2._2();
        System.err.println("Mismatches in :" + fileName);
        listOfMismatches.foreach((Function1 & Serializable & scala.Serializable)m -> {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index offset: %d, log offset: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$main$4(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fileName = (String)tuple2._1();
        List listOfNonConsecutivePairs = (List)tuple2._2();
        System.err.println("Non-secutive offsets in :" + fileName);
        listOfNonConsecutivePairs.foreach((Function1 & Serializable & scala.Serializable)m -> {
            System.err.println(new StringOps(Predef$.MODULE$.augmentString("  %d is followed by %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$dumpTimeIndex$2(TimeIndex timeIndex$1, TimestampOffset entry$1, FileLogInputStream.FileChannelLogEntry x$1) {
        return x$1.offset() >= entry$1.offset() + timeIndex$1.baseOffset();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$dumpTimeIndex$1(DumpLogSegments$ $this, File file$3, boolean verifyOnly$3, DumpLogSegments.TimeIndexDumpErrors timeIndexDumpErrors$2, FileRecords fileRecords$2, OffsetIndex index$2, TimeIndex timeIndex$1, LongRef prevTimestamp$1, Object nonLocalReturnKey2$1, int i) {
        block9: {
            block8: {
                entry = timeIndex$1.entry(i);
                position = index$2.lookup(entry.offset() + timeIndex$1.baseOffset()).position();
                partialFileRecords = fileRecords$2.read(position, 0x7FFFFFFF);
                shallowEntries = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(partialFileRecords.shallowEntries()).asScala();
                maxTimestamp = LongRef.create((long)-1L);
                maybeLogEntry = shallowEntries.find((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$2$adapted(kafka.log.TimeIndex kafka.log.TimestampOffset org.apache.kafka.common.record.FileLogInputStream$FileChannelLogEntry ), (Lorg/apache/kafka/common/record/FileLogInputStream$FileChannelLogEntry;)Ljava/lang/Object;)((TimeIndex)timeIndex$1, (TimestampOffset)entry));
                var17_16 = false;
                var18_17 = null;
                var19_18 = maybeLogEntry;
                if (!None$.MODULE$.equals(var19_18)) break block8;
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$3, entry.offset() + timeIndex$1.baseOffset(), -1);
                var10_19 = BoxedUnit.UNIT;
                break block9;
            }
            if (!(var19_18 instanceof Some)) ** GOTO lbl-1000
            var17_16 = true;
            var18_17 = (Some)var19_18;
            logEntry = (FileLogInputStream.FileChannelLogEntry)var18_17.value();
            if (logEntry.offset() != entry.offset() + timeIndex$1.baseOffset()) {
                timeIndexDumpErrors$2.recordShallowOffsetNotFound(file$3, entry.offset() + timeIndex$1.baseOffset(), logEntry.offset());
                var10_20 = BoxedUnit.UNIT;
            } else if (var17_16) {
                shallowLogEntry = (FileLogInputStream.FileChannelLogEntry)var18_17.value();
                deepIter = $this.getIterator((LogEntry)shallowLogEntry, true);
                deepIter.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$dumpTimeIndex$3$adapted(scala.runtime.LongRef org.apache.kafka.common.record.LogEntry ), (Lorg/apache/kafka/common/record/LogEntry;)Ljava/lang/Object;)((LongRef)maxTimestamp));
                if (maxTimestamp.elem != entry.timestamp()) {
                    timeIndexDumpErrors$2.recordMismatchTimeIndex(file$3, entry.timestamp(), maxTimestamp.elem);
                }
                if (prevTimestamp$1.elem >= entry.timestamp()) {
                    timeIndexDumpErrors$2.recordOutOfOrderIndexTimestamp(file$3, entry.timestamp(), prevTimestamp$1.elem);
                }
                if (entry.offset() == 0L && i > 0) {
                    throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
                }
                var10_21 = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)var19_18);
            }
        }
        if (!verifyOnly$3) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("timestamp: %s offset: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)entry.timestamp()), BoxesRunTime.boxToLong((long)(timeIndex$1.baseOffset() + entry.offset()))})));
        }
        prevTimestamp$1.elem = entry.timestamp();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$2(File file$1, boolean printContents$1, HashMap nonConsecutivePairsForLogFilesMap$2, DumpLogSegments.MessageParser parser$1, LongRef validBytes$1, LongRef lastOffset$1, LogEntry deepLogEntry) {
        BoxedUnit boxedUnit;
        Record record = deepLogEntry.record();
        if (lastOffset$1.elem == -1L) {
            lastOffset$1.elem = deepLogEntry.offset();
            boxedUnit = BoxedUnit.UNIT;
        } else {
            CompressionType compressionType = record.compressionType();
            CompressionType compressionType2 = CompressionType.NONE;
            if (!(compressionType != null ? !compressionType.equals(compressionType2) : compressionType2 != null) && deepLogEntry.offset() != lastOffset$1.elem + 1L) {
                List nonConsecutivePairsSeq = (List)nonConsecutivePairsForLogFilesMap$2.getOrElse((Object)file$1.getAbsolutePath(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                nonConsecutivePairsSeq = nonConsecutivePairsSeq.$colon$colon((Object)new Tuple2.mcJJ.sp(lastOffset$1.elem, deepLogEntry.offset()));
                boxedUnit = nonConsecutivePairsForLogFilesMap$2.put((Object)file$1.getAbsolutePath(), (Object)nonConsecutivePairsSeq);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        lastOffset$1.elem = deepLogEntry.offset();
        Predef$.MODULE$.print((Object)("offset: " + deepLogEntry.offset() + " position: " + validBytes$1.elem + " " + record.timestampType() + ": " + record.timestamp() + " isvalid: " + record.isValid() + " payloadsize: " + record.valueSize() + " magic: " + record.magic() + " compresscodec: " + record.compressionType() + " crc: " + record.checksum()));
        if (record.hasKey()) {
            Predef$.MODULE$.print((Object)(" keysize: " + record.keySize()));
        }
        if (printContents$1) {
            Tuple2 tuple2 = parser$1.parse(record);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option key2 = (Option)tuple2._1();
            Option payload2 = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key2, (Object)payload2);
            Tuple2 tuple23 = tuple22;
            Option key3 = (Option)tuple23._1();
            Option payload3 = (Option)tuple23._2();
            key3.foreach((Function1 & Serializable & scala.Serializable)key -> {
                Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                return BoxedUnit.UNIT;
            });
            payload3.foreach((Function1 & Serializable & scala.Serializable)payload -> {
                Predef$.MODULE$.print((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" payload: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{payload})));
                return BoxedUnit.UNIT;
            });
        }
        Predef$.MODULE$.println();
    }

    public static final /* synthetic */ void $anonfun$dumpLog$1(DumpLogSegments$ $this, File file$1, boolean printContents$1, HashMap nonConsecutivePairsForLogFilesMap$2, boolean isDeepIteration$2, DumpLogSegments.MessageParser parser$1, LongRef validBytes$1, LongRef lastOffset$1, FileLogInputStream.FileChannelLogEntry shallowLogEntry) {
        Iterator<LogEntry> itr = $this.getIterator((LogEntry)shallowLogEntry, isDeepIteration$2);
        itr.foreach((Function1 & Serializable & scala.Serializable)deepLogEntry -> {
            DumpLogSegments$.$anonfun$dumpLog$2(file$1, printContents$1, nonConsecutivePairsForLogFilesMap$2, parser$1, validBytes$1, lastOffset$1, deepLogEntry);
            return BoxedUnit.UNIT;
        });
        validBytes$1.elem += (long)shallowLogEntry.sizeInBytes();
    }

    private DumpLogSegments$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$2$adapted(TimeIndex timeIndex$1, TimestampOffset entry$1, FileLogInputStream.FileChannelLogEntry x$1) {
        return BoxesRunTime.boxToBoolean((boolean)DumpLogSegments$.$anonfun$dumpTimeIndex$2(timeIndex$1, entry$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$dumpTimeIndex$3$adapted(LongRef maxTimestamp$1, LogEntry deepLogEntry) {
        maxTimestamp$1.elem = scala.math.package$.MODULE$.max(maxTimestamp$1.elem, deepLogEntry.record().timestamp());
        return BoxedUnit.UNIT;
    }
}

