/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.IOException;
import java.io.Serializable;
import kafka.utils.NetworkClientBlockingOps;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class NetworkClientBlockingOps$ {
    public static NetworkClientBlockingOps$ MODULE$;

    static {
        new NetworkClientBlockingOps$();
    }

    public NetworkClient networkClientBlockingOps(NetworkClient client) {
        return client;
    }

    public final boolean isReady$extension(NetworkClient $this, Node node, Time time) {
        long currentTime = time.milliseconds();
        $this.poll(0L, currentTime);
        return $this.isReady(node, currentTime);
    }

    public final boolean blockingReady$extension(NetworkClient $this, Node node, long timeout, Time time) {
        Predef$.MODULE$.require(timeout >= 0L, (Function0 & Serializable & scala.Serializable)() -> "timeout should be >= 0");
        long startTime = time.milliseconds();
        long expiryTime = startTime + timeout;
        return this.isReady$extension($this, node, time) || $this.ready(node, startTime) || this.awaitReady$1(startTime, expiryTime, node, time, $this);
    }

    public final ClientResponse blockingSendAndReceive$extension(NetworkClient $this, ClientRequest request, Time time) {
        $this.send(request, time.milliseconds());
        return (ClientResponse)this.pollContinuously$extension($this, (Function1 & Serializable & scala.Serializable)responses -> {
            void var2_2;
            Option response2 = responses.find((Function1 & Serializable & scala.Serializable)response -> BoxesRunTime.boxToBoolean((boolean)NetworkClientBlockingOps$.$anonfun$blockingSendAndReceive$2(request, response)));
            response2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                NetworkClientBlockingOps$.$anonfun$blockingSendAndReceive$3(request, r);
                return BoxedUnit.UNIT;
            });
            return var2_2;
        }, time);
    }

    public final <T> T pollContinuously$extension(NetworkClient $this, Function1<Seq<ClientResponse>, Option<T>> collect, Time time) {
        return (T)this.recursivePoll$1(collect, time, $this);
    }

    public final int hashCode$extension(NetworkClient $this) {
        return $this.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals$extension(NetworkClient $this, Object x$1) {
        Object object = x$1;
        if (!(object instanceof NetworkClientBlockingOps)) return false;
        boolean bl = true;
        if (!bl) return false;
        NetworkClient networkClient = x$1 == null ? null : ((NetworkClientBlockingOps)x$1).client();
        NetworkClient networkClient2 = $this;
        NetworkClient networkClient3 = networkClient;
        if (networkClient2 != null) {
            if (!networkClient2.equals(networkClient3)) return false;
            return true;
        }
        if (networkClient3 == null) return true;
        return false;
    }

    private final boolean awaitReady$1(long iterationStartTime, long expiryTime$1, Node node$1, Time time$1, NetworkClient $this$1) {
        boolean bl;
        block3: {
            while (true) {
                if ($this$1.isReady(node$1, iterationStartTime)) {
                    bl = true;
                    break block3;
                }
                if ($this$1.connectionFailed(node$1)) {
                    throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection to ", " failed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{node$1})));
                }
                long pollTimeout = expiryTime$1 - iterationStartTime;
                $this$1.poll(pollTimeout, iterationStartTime);
                long afterPollTime = time$1.milliseconds();
                if (afterPollTime >= expiryTime$1) break;
                iterationStartTime = afterPollTime;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$blockingSendAndReceive$2(ClientRequest request$1, ClientResponse response) {
        return response.requestHeader().correlationId() == request$1.correlationId();
    }

    public static final /* synthetic */ void $anonfun$blockingSendAndReceive$3(ClientRequest request$1, ClientResponse r) {
        if (r.wasDisconnected()) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connection to ", " was disconnected before the response was read"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request$1.destination()})));
        }
        if (r.versionMismatch() != null) {
            throw r.versionMismatch();
        }
    }

    private final Object recursivePoll$1(Function1 collect$1, Time time$2, NetworkClient $this$2) {
        Object result;
        Option option;
        block1: {
            do {
                Buffer responses;
                if ((option = (Option)collect$1.apply((Object)(responses = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter($this$2.poll(Long.MAX_VALUE, time$2.milliseconds())).asScala()))) instanceof Some) break block1;
            } while (None$.MODULE$.equals(option));
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Object object = result = some.value();
        return object;
    }

    private NetworkClientBlockingOps$() {
        MODULE$ = this;
    }
}

