/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentCompleted$;
import kafka.admin.ReassignmentStatus;
import kafka.admin.ReplicaDistributions;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\"\u00113nS:$Vm\u001d;\u000b\u0005\r!\u0011!B1e[&t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\b\u0015!\tIA\"D\u0001\u000b\u0015\tYA!\u0001\u0002{W&\u0011QB\u0003\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u001bI\u000b7m[!xCJ,G+Z:u\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!9Q\u0004\u0001a\u0001\n\u0003q\u0012aB:feZ,'o]\u000b\u0002?A\u0019\u0001EK\u0017\u000f\u0005\u0005:cB\u0001\u0012&\u001b\u0005\u0019#B\u0001\u0013\u0007\u0003\u0019a$o\\8u}%\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)S\u00059\u0001/Y2lC\u001e,'\"\u0001\u0014\n\u0005-b#aA*fc*\u0011\u0001&\u000b\t\u0003]Ej\u0011a\f\u0006\u0003a\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u001a0\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000fQ\u0002\u0001\u0019!C\u0001k\u0005Y1/\u001a:wKJ\u001cx\fJ3r)\t1$\b\u0005\u00028q5\t\u0011&\u0003\u0002:S\t!QK\\5u\u0011\u001dY4'!AA\u0002}\t1\u0001\u001f\u00132\u0011\u0019i\u0004\u0001)Q\u0005?\u0005A1/\u001a:wKJ\u001c\b\u0005C\u0003@\u0001\u0011\u0005\u0003)\u0001\u0005uK\u0006\u0014Hi\\<o)\u00051\u0004F\u0001 C!\t\u0019\u0005*D\u0001E\u0015\t)e)A\u0003kk:LGOC\u0001H\u0003\ry'oZ\u0005\u0003\u0013\u0012\u0013Q!\u00114uKJDQa\u0013\u0001\u0005\u0002\u0001\u000bQ\u0003^3tiJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002K\u001bB\u00111IT\u0005\u0003\u001f\u0012\u0013A\u0001V3ti\")\u0011\u000b\u0001C\u0001\u0001\u0006YB/Z:u\u001b\u0006tW/\u00197SKBd\u0017nY1BgNLwM\\7f]RD#\u0001U'\t\u000bQ\u0003A\u0011\u0001!\u0002+Q,7\u000f\u001e+pa&\u001c7I]3bi&|g.\u00138[\u0017\"\u00121+\u0014\u0005\u0006/\u0002!\t\u0001Q\u0001\u001fi\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>tw+\u001b;i\u0007>dG.[:j_:D#AV'\t\u000bi\u0003A\u0011\u0001!\u00027Q,7\u000f^\"p]\u000e,(O]3oiR{\u0007/[2De\u0016\fG/[8oQ\tIV\nC\u0003^\u0001\u0011%a,\u0001\u000ehKR\u0014%o\\6feN<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\u0012K'\u000f\u0006\u0003`Q24\bc\u00011dK6\t\u0011M\u0003\u0002cS\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011\f'aA*fiB\u0011qGZ\u0005\u0003O&\u00121!\u00138u\u0011\u0015iB\f1\u0001j!\r\u0001#.L\u0005\u0003W2\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\u0006[r\u0003\rA\\\u0001\u0006i>\u0004\u0018n\u0019\t\u0003_Nt!\u0001]9\u0011\u0005\tJ\u0013B\u0001:*\u0003\u0019\u0001&/\u001a3fM&\u0011A/\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005IL\u0003\"B<]\u0001\u0004)\u0017a\u00039beRLG/[8o\u0013\u0012DQ!\u001f\u0001\u0005\u0002\u0001\u000b\u0001\u0007^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi^KG\u000f\u001b'fC\u0012,'/\u00138OK^\u0014V\r\u001d7jG\u0006\u001c\bF\u0001=N\u0011\u0015a\b\u0001\"\u0001A\u0003M\"Xm\u001d;QCJ$\u0018\u000e^5p]J+\u0017m]:jO:lWM\u001c;XSRDG*Z1eKJtu\u000e^%o\u001d\u0016<(+\u001a9mS\u000e\f7\u000f\u000b\u0002|\u001b\")q\u0010\u0001C\u0001\u0001\u0006yC/Z:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8u\u001d>twJ^3sY\u0006\u0004\b/\u001b8h%\u0016\u0004H.[2bg\"\u0012a0\u0014\u0005\u0007\u0003\u000b\u0001A\u0011\u0001!\u0002GQ,7\u000f\u001e*fCN\u001c\u0018n\u001a8j]\u001etuN\\#ySN$\u0018N\\4QCJ$\u0018\u000e^5p]\"\u001a\u00111A'\t\r\u0005-\u0001\u0001\"\u0001A\u0003=\"Xm\u001d;SKN,X.\u001a)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e+iCR<\u0016m]\"p[BdW\r^3eQ\r\tI!\u0014\u0005\u0007\u0003#\u0001A\u0011\u0001!\u00029Q,7\u000f\u001e)sK\u001a,'O]3e%\u0016\u0004H.[2b\u0015N|g\u000eR1uC\"\u001a\u0011qB'\t\r\u0005]\u0001\u0001\"\u0001A\u0003\u0005\"Xm\u001d;CCNL7\r\u0015:fM\u0016\u0014(/\u001a3SKBd\u0017nY1FY\u0016\u001cG/[8oQ\r\t)\"\u0014\u0005\u0007\u0003;\u0001A\u0011\u0001!\u0002%Q,7\u000f^*ikR$wn\u001e8Ce>\\WM\u001d\u0015\u0004\u00037i\u0005BBA\u0012\u0001\u0011\u0005\u0001)A\u000buKN$Hk\u001c9jG\u000e{gNZ5h\u0007\"\fgnZ3)\u0007\u0005\u0005R\n\u0003\u0004\u0002*\u0001!\t\u0001Q\u0001$g\"|W\u000f\u001c3Qe>\u0004\u0018mZ1uK\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4tQ\r\t9#\u0014\u0005\u0007\u0003_\u0001A\u0011\u0001!\u00027Q,7\u000f\u001e\"p_R\u001cHO]1q\u00072LWM\u001c;JI\u000e{gNZ5hQ\r\ti#\u0014\u0005\u0007\u0003k\u0001A\u0011\u0001!\u0002-Q,7\u000f^$fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCND3!a\rN\u0001")
public class AdminTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testReplicaAssignment() {
        IndexedSeq brokerMetadatas = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)x$1 -> AdminTest.$anonfun$testReplicaAssignment$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)brokerMetadatas, 10, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.intercept((Function0 & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)brokerMetadatas, 10, 6, AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5()), ClassTag$.MODULE$.apply(InvalidReplicationFactorException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        Map expectedAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2})))}));
        Map actualAssignment = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq)brokerMetadatas, 10, 3, 0, AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
        Assert.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)brokers);
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5()), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), "test", (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))})), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5()), ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        Map assignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), "test", assignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        scala.collection.mutable.Map found = this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assert.assertEquals((Object)assignment, (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 4, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkUtils(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaList = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])leaderForPartitionMap.keys().toArray(ClassTag$.MODULE$.Int()))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)p))), (Object)this.zkUtils().getReplicasForPartition(topic, BoxesRunTime.unboxToInt((Object)p))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)expectedReplicaAssignment.size(), (long)actualReplicaList.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), actualReplicaList.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assert.assertEquals((Object)expectedReplicaAssignment.get((Object)BoxesRunTime.boxToInteger((int)i)).get(), (Object)actualReplicaList.apply((Object)BoxesRunTime.boxToInteger((int)i))));
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5()), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkUtils(), (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})));
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), topic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.createTopic(this.zkUtils(), collidingTopic, 3, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6()), ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test.topic";
        ZkUtils zkMock = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.pathExists(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/brokers/topics/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic}))))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.expect((Object)zkMock.getAllTopics()).andReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"})));
        EasyMock.replay((Object[])new Object[]{zkMock});
        this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.validateCreateOrUpdateTopic(zkMock, topic, (Map)Map$.MODULE$.empty(), new Properties(), false), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
    }

    private Set<Object> getBrokersWithPartitionDir(Iterable<KafkaServer> servers, String topic, int partitionId) {
        return ((TraversableOnce)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)server -> BoxesRunTime.boxToBoolean((boolean)AdminTest.$anonfun$getBrokersWithPartitionDir$1(topic, partitionId, server)))).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)AdminTest.$anonfun$getBrokersWithPartitionDir$2(x$2)), Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Test
    public void testPartitionReassignmentWithLeaderInNewReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Option)None$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4(), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$5());
        Assert.assertTrue((String)"Partition reassignment attempt failed for [test, 0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map partitionsBeingReassigned = this.zkUtils().getPartitionsBeingReassigned().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.newReplicas());
            ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkUtils(), topicAndPartition, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), partitionsBeingReassigned);
            ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
            return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            scala.collection.immutable.Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPartitionReassignmentWithLeaderNotInNewReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Option)None$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4(), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$5());
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map partitionsBeingReassigned = this.zkUtils().getPartitionsBeingReassigned().mapValues((Function1 & Serializable & scala.Serializable)x$4 -> x$4.newReplicas());
            ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkUtils(), topicAndPartition, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), partitionsBeingReassigned);
            ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
            return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            scala.collection.immutable.Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPartitionReassignmentNonOverlappingReplicas() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Option)None$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4(), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$5());
        Assert.assertTrue((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map partitionsBeingReassigned = this.zkUtils().getPartitionsBeingReassigned().mapValues((Function1 & Serializable & scala.Serializable)x$5 -> x$5.newReplicas());
            ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkUtils(), topicAndPartition, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), partitionsBeingReassigned);
            ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
            return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentCompleted$) : reassignmentCompleted$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 2, 3", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            scala.collection.immutable.Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testReassigningNonExistingPartition() {
        String topic = "test";
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Option)None$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4(), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$5());
        Assert.assertFalse((String)"Partition reassignment failed for test, 0", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        Map reassignedPartitions = this.zkUtils().getPartitionsBeingReassigned();
        Assert.assertFalse((String)"Partition should not be reassigned", (boolean)reassignedPartitions.contains((Object)topicAndPartition));
    }

    @Test
    public void testResumePartitionReassignmentThatWasCompleted() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        String topic = "test";
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        int partitionToBeReassigned = 0;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partitionToBeReassigned);
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Option)None$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4(), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$5());
        reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !TestUtils$.MODULE$.checkIfReassignPartitionPathExists(this.zkUtils()), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment should complete", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, partitionToBeReassigned);
        Assert.assertEquals((String)"Partition should have been reassigned to 0, 1", (Object)newReplicas, (Object)assignedReplicas);
        TestUtils$.MODULE$.checkForPhantomInSyncReplicas(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas);
        TestUtils$.MODULE$.ensureNoUnderReplicatedPartitions(this.zkUtils(), topic, partitionToBeReassigned, (Seq<Object>)assignedReplicas, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Set<Object> set = this.getBrokersWithPartitionDir((Iterable<KafkaServer>)this.servers(), topic, 0);
            scala.collection.immutable.Set set2 = newReplicas.toSet();
            return !(set != null ? !set.equals((Object)set2) : set2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "New replicas should exist on brokers", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testPreferredReplicaJsonData() {
        Set partitionsForPreferredReplicaElection = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition("test", 1), new TopicAndPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkUtils(), partitionsForPreferredReplicaElection);
        String preferredReplicaElectionZkData = (String)this.zkUtils().readData(ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath())._1();
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = PreferredReplicaLeaderElectionCommand$.MODULE$.parsePreferredReplicaElectionData(preferredReplicaElectionZkData);
        Assert.assertEquals((String)"Preferred replica election ser-de failed", (Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection);
    }

    @Test
    public void testBasicPreferredReplicaElection() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        int preferredReplica = 0;
        Map brokerRack = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2")}));
        int x$16 = 3;
        String x$17 = this.zkConnect();
        boolean x$18 = false;
        Map x$19 = brokerRack;
        boolean x$20 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$21 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$22 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$23 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$24 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$25 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$26 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$27 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$28 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$16, x$17, x$18, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, (Map<Object, String>)x$19, x$28).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        ZkUtils x$29 = this.zkUtils();
        String x$30 = topic;
        int x$31 = partition;
        None$ x$32 = None$.MODULE$;
        long x$33 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$34 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int currentLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$29, x$30, x$31, x$33, (Option<Object>)x$32, x$34);
        PreferredReplicaLeaderElectionCommand preferredReplicaElection = new PreferredReplicaLeaderElectionCommand(this.zkUtils(), (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicAndPartition[]{new TopicAndPartition(topic, partition)})));
        preferredReplicaElection.moveLeaderToPreferredReplica();
        ZkUtils x$35 = this.zkUtils();
        String x$36 = topic;
        int x$37 = partition;
        Some x$38 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long x$39 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$40 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$35, x$36, x$37, x$39, (Option<Object>)x$38, x$40);
        Assert.assertEquals((String)"Preferred replica election failed", (long)preferredReplica, (long)newLeader);
    }

    @Test
    public void testShutdownBroker() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 1;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)((Seq)serverConfigs.reverseMap((Function1 & Serializable & scala.Serializable)s -> TestUtils$.MODULE$.createServer((KafkaConfig)s, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), topic, (Map<Object, Seq<Object>>)expectedReplicaAssignment, this.servers());
        int controllerId = this.zkUtils().getController();
        KafkaController controller = ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)AdminTest.$anonfun$testShutdownBroker$3(controllerId, p))).get()).kafkaController();
        LinkedBlockingQueue resultQueue = new LinkedBlockingQueue();
        Function1 & Serializable & scala.Serializable controlledShutdownCallback = (Function1 & Serializable & scala.Serializable)controlledShutdownResult -> {
            resultQueue.put(controlledShutdownResult);
            return BoxedUnit.UNIT;
        };
        controller.shutdownBroker(2, (Function1)controlledShutdownCallback);
        Set partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        ObjectRef activeServers = ObjectRef.create((Object)((Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AdminTest.$anonfun$testShutdownBroker$5(s)))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Seq)activeServers$1.elem).forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AdminTest.$anonfun$testShutdownBroker$8(topic, partition, x$6))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Topic test not created after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        UpdateMetadataRequest.PartitionState partitionStateInfo = (UpdateMetadataRequest.PartitionState)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
        int leaderAfterShutdown = partitionStateInfo.basePartitionState.leader;
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertEquals((long)2L, (long)partitionStateInfo.basePartitionState.isr.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(partitionStateInfo.basePartitionState.isr).asScala());
        controller.shutdownBroker(1, (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)0L, (long)partitionsRemaining.size());
        activeServers.elem = (Seq)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AdminTest.$anonfun$testShutdownBroker$9(s)));
        partitionStateInfo = (UpdateMetadataRequest.PartitionState)((KafkaServer)((Seq)activeServers.elem).head()).apis().metadataCache().getPartitionInfo(topic, partition).get();
        leaderAfterShutdown = partitionStateInfo.basePartitionState.leader;
        Assert.assertEquals((long)0L, (long)leaderAfterShutdown);
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminTest.$anonfun$testShutdownBroker$10(topic, partition, x$7))));
        controller.shutdownBroker(0, (Function1)controlledShutdownCallback);
        partitionsRemaining = (Set)((Try)resultQueue.take()).get();
        Assert.assertEquals((long)1L, (long)partitionsRemaining.size());
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AdminTest.$anonfun$testShutdownBroker$11(topic, partition, x$8))));
    }

    @Test
    public void testTopicConfigChange() {
        int partitions = 3;
        String topic = "my-topic";
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminUtils$.MODULE$.createTopic(server.zkUtils(), topic, partitions, 1, AdminTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"), AdminUtils$.MODULE$.createTopic$default$6());
        AdminTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, AdminTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = AdminTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, AdminTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        AdminTest.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = AdminUtils$.MODULE$.fetchEntityConfig(server.zkUtils(), ConfigType$.MODULE$.Topic(), topic);
        Assert.assertEquals((Object)newConfig, (Object)configInZk);
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, new Properties());
        AdminTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, AdminTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        AdminUtils$.MODULE$.changeTopicConfig(server.zkUtils(), topic, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)""), new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"")})));
        AdminTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> TestUtils$.MODULE$.createServer((KafkaConfig)x$9, TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        long limit = 1000000L;
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)limit)).toString())})));
        this.checkConfig$2(limit);
        long newLimit = 2L * limit;
        AdminUtils$.MODULE$.changeBrokerConfig(this.zkUtils(), brokerIds, CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)BoxesRunTime.boxToLong((long)newLimit)).toString())})));
        this.checkConfig$2(newLimit);
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            Properties configInZk = AdminUtils$.MODULE$.fetchEntityConfig(((KafkaServer)this.servers().apply(brokerId)).zkUtils(), ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)brokerId)).toString());
            Assert.assertEquals((long)newLimit, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()))).toInt());
            Assert.assertEquals((long)newLimit, (long)new StringOps(Predef$.MODULE$.augmentString(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp()))).toInt());
        });
        AdminUtils$.MODULE$.changeBrokerConfig(((KafkaServer)this.servers().apply(0)).zkUtils(), brokerIds, new Properties());
        this.checkConfig$2(DynamicConfig.Broker$.MODULE$.DefaultReplicationThrottledRate());
    }

    @Test
    public void testBootstrapClientIdConfig() {
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        Map configMap = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producer_byte_rate"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"consumer_byte_rate"), (Object)"2000")}));
        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)configMap)}));
        ZkUtils qual$1 = this.zkUtils();
        String x$41 = ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Client(), clientId);
        String x$42 = Json$.MODULE$.encode((Object)map);
        java.util.List x$43 = qual$1.updatePersistentPath$default$3();
        qual$1.updatePersistentPath(x$41, x$42, x$43);
        Map configInZk = AdminUtils$.MODULE$.fetchAllEntityConfigs(this.zkUtils(), ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overriden client config", (long)1L, (long)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17())), TestUtils$.MODULE$.createServer$default$2());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        Assert.assertEquals((Object)new Quota(1000.0, true), (Object)server.apis().quotas().produce().quota("ANONYMOUS", clientId));
        Assert.assertEquals((Object)new Quota(2000.0, true), (Object)server.apis().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    @Test
    public void testGetBrokerMetadatas() {
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5);
        Map rackInfo = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkUtils());
        Seq processedMetadatas1 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Disabled$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()), Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$), (Object)processedMetadatas1.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.rack(), Seq$.MODULE$.canBuildFrom()));
        Seq processedMetadatas2 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Safe$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()), Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.fill(brokerList.size(), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$), (Object)processedMetadatas2.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.rack(), Seq$.MODULE$.canBuildFrom()));
        this.intercept((Function0 & Serializable & scala.Serializable)() -> AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$, AdminUtils$.MODULE$.getBrokerMetadatas$default$3()), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("AdminTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
        List partialList = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), (RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assert.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.id()), Seq$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)partialList.map((Function1)rackInfo, List$.MODULE$.canBuildFrom()), (Object)processedMetadatas3.flatMap((Function1 & Serializable & scala.Serializable)x$15 -> Option$.MODULE$.option2Iterable(x$15.rack()), Seq$.MODULE$.canBuildFrom()));
        int numPartitions = 3;
        ZkUtils x$44 = this.zkUtils();
        String x$45 = "foo";
        int x$46 = numPartitions;
        int x$47 = 2;
        RackAwareMode.Safe$ x$48 = RackAwareMode.Safe$.MODULE$;
        Properties x$49 = AdminUtils$.MODULE$.createTopic$default$5();
        AdminUtils$.MODULE$.createTopic(x$44, x$45, x$46, x$47, x$49, (RackAwareMode)x$48);
        scala.collection.mutable.Map assignment = this.zkUtils().getReplicaAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assert.assertEquals((long)numPartitions, (long)assignment.size());
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testReplicaAssignment$1(int x$1) {
        return new BrokerMetadata(x$1, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$getBrokersWithPartitionDir$1(String topic$3, int partitionId$1, KafkaServer server) {
        return new File((String)server.config().logDirs().head(), topic$3 + "-" + partitionId$1).exists();
    }

    public static final /* synthetic */ int $anonfun$getBrokersWithPartitionDir$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testShutdownBroker$3(int controllerId$1, KafkaServer p) {
        return p.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testShutdownBroker$5(KafkaServer s) {
        return s.config().brokerId() != 2;
    }

    public static final /* synthetic */ boolean $anonfun$testShutdownBroker$8(String topic$8, int partition$1, KafkaServer x$6) {
        return ((UpdateMetadataRequest.PartitionState)x$6.apis().metadataCache().getPartitionInfo((String)topic$8, (int)partition$1).get()).basePartitionState.isr.size() != 3;
    }

    public static final /* synthetic */ boolean $anonfun$testShutdownBroker$9(KafkaServer s) {
        return s.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testShutdownBroker$10(String topic$8, int partition$1, KafkaServer x$7) {
        return ((UpdateMetadataRequest.PartitionState)x$7.apis().metadataCache().getPartitionInfo((String)topic$8, (int)partition$1).get()).basePartitionState.leader == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testShutdownBroker$11(String topic$8, int partition$1, KafkaServer x$8) {
        return ((UpdateMetadataRequest.PartitionState)x$8.apis().metadataCache().getPartitionInfo((String)topic$8, (int)partition$1).get()).basePartitionState.leader == 0;
    }

    private static final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)messageSize)).toString());
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), ((Object)BoxesRunTime.boxToLong((long)retentionMs)).toString());
        props.setProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), throttledLeaders);
        props.setProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), throttledFollowers);
        return props;
    }

    private static final void checkList$1(java.util.List actual, String expected) {
        Assert.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Assert.assertTrue((boolean)actual.isEmpty());
        } else {
            Assert.assertEquals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected.split(","))).toSeq(), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(actual).asScala());
        }
    }

    private static final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$9, KafkaServer server$1) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)part -> {
            TopicPartition tp = new TopicPartition(topic$9, part);
            Option log = server$1.logManager().getLog(tp);
            Assert.assertTrue((boolean)log.isDefined());
            Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)retentionMs), (Object)((Log)log.get()).config().retentionMs());
            Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)messageSize), (Object)((Log)log.get()).config().maxMessageSize());
            AdminTest.checkList$1(((Log)log.get()).config().LeaderReplicationThrottledReplicas(), throttledLeaders);
            AdminTest.checkList$1(((Log)log.get()).config().FollowerReplicationThrottledReplicas(), throttledFollowers);
            Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)quotaManagerIsThrottled), (Object)BoxesRunTime.boxToBoolean((boolean)server$1.quotaManagers().leader().isThrottled(tp)));
        }));
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$4(long limit$1, KafkaServer server) {
        Assert.assertEquals((String)"Leader Quota Manager was not updated", (long)limit$1, (long)server.quotaManagers().leader().upperBound());
        Assert.assertEquals((String)"Follower Quota Manager was not updated", (long)limit$1, (long)server.quotaManagers().follower().upperBound());
    }

    private final void checkConfig$2(long limit) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            AdminTest.$anonfun$shouldPropagateDynamicBrokerConfigs$4(limit, server);
            return BoxedUnit.UNIT;
        }));
    }

    public AdminTest() {
        RackAwareTest.$init$(this);
        this.servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

