/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignmentFailed$;
import kafka.admin.ReassignmentStatus;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.common.TopicAndPartition;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002R3mKR,Gk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u00193nS:T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!B\u0003\u0002\f\t\u0005\u0011!p[\u0005\u0003\u001b)\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002\u00011A\u0005\u0002U\tqa]3sm\u0016\u00148/F\u0001\u0017!\r9\u0012\u0005\n\b\u00031yq!!\u0007\u000f\u000e\u0003iQ!a\u0007\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012!B:dC2\f\u0017BA\u0010!\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!H\u0005\u0003E\r\u00121aU3r\u0015\ty\u0002\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u000511/\u001a:wKJL!!\u000b\u0014\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\bW\u0001\u0001\r\u0011\"\u0001-\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u00055\n\u0004C\u0001\u00180\u001b\u0005\u0001\u0013B\u0001\u0019!\u0005\u0011)f.\u001b;\t\u000fIR\u0013\u0011!a\u0001-\u0005\u0019\u0001\u0010J\u0019\t\rQ\u0002\u0001\u0015)\u0003\u0017\u0003!\u0019XM\u001d<feN\u0004\u0003b\u0002\u001c\u0001\u0005\u0004%\taN\u0001\u001aKb\u0004Xm\u0019;fIJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tG/F\u00019!\u0011Id\bQ\"\u000e\u0003iR!a\u000f\u001f\u0002\u0013%lW.\u001e;bE2,'BA\u001f!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u007fi\u00121!T1q!\tq\u0013)\u0003\u0002CA\t\u0019\u0011J\u001c;\u0011\u0007e\"\u0005)\u0003\u0002Fu\t!A*[:u\u0011\u00199\u0005\u0001)A\u0005q\u0005QR\r\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uA!)\u0011\n\u0001C!\u0015\u0006AA/Z1s\t><h\u000eF\u0001.Q\tAE\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006)!.\u001e8ji*\t\u0011+A\u0002pe\u001eL!a\u0015(\u0003\u000b\u00053G/\u001a:\t\u000bU\u0003A\u0011\u0001&\u0002GQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e<\u0016\u000e\u001e5BY2\fE.\u001b<f%\u0016\u0004H.[2bg\"\u0012Ak\u0016\t\u0003\u001bbK!!\u0017(\u0003\tQ+7\u000f\u001e\u0005\u00067\u0002!\tAS\u0001+i\u0016\u001cHOU3tk6,G)\u001a7fi\u0016$v\u000e]5d/&$\bNU3d_Z,'/\u001a3G_2dwn^3sQ\tQv\u000bC\u0003_\u0001\u0011\u0005!*A\u0015uKN$(+Z:v[\u0016$U\r\\3uKR{\u0007/[2P]\u000e{g\u000e\u001e:pY2,'OR1jY>4XM\u001d\u0015\u0003;^CQ!\u0019\u0001\u0005\u0002)\u000b!\u0006^3tiB\u000b'\u000f^5uS>t'+Z1tg&<g.\\3oi\u0012+(/\u001b8h\t\u0016dW\r^3U_BL7\r\u000b\u0002a/\")A\r\u0001C\u0001\u0015\u0006\tC/Z:u\t\u0016dW\r^3U_BL7\rR;sS:<\u0017\t\u001a3QCJ$\u0018\u000e^5p]\"\u00121m\u0016\u0005\u0006O\u0002!\tAS\u0001\"i\u0016\u001cH/\u00113e!\u0006\u0014H/\u001b;j_:$UO]5oO\u0012+G.\u001a;f)>\u0004\u0018n\u0019\u0015\u0003M^CQA\u001b\u0001\u0005\u0002)\u000ba\u0004^3tiJ+7M]3bi\u0016$v\u000e]5d\u0003\u001a$XM\u001d#fY\u0016$\u0018n\u001c8)\u0005%<\u0006\"B7\u0001\t\u0003Q\u0015A\u0007;fgR$U\r\\3uK:{g.\u0012=jgRLgn\u001a+pa&\u001c\u0007F\u00017X\u0011\u0015\u0001\b\u0001\"\u0001K\u0003i!Xm\u001d;EK2,G/\u001a+pa&\u001cw+\u001b;i\u00072,\u0017M\\3sQ\tyw\u000bC\u0003t\u0001\u0011\u0005!*A\u0013uKN$H)\u001a7fi\u0016$v\u000e]5d\u00032\u0014X-\u00193z\u001b\u0006\u00148.\u001a3Bg\u0012+G.\u001a;fI\"\u0012!o\u0016\u0005\u0006m\u0002!Ia^\u0001\u001aGJ,\u0017\r^3UKN$Hk\u001c9jG\u0006sGm\u00117vgR,'\u000f\u0006\u0003\u0017q\u0006\u0015\u0001\"B=v\u0001\u0004Q\u0018!\u0002;pa&\u001c\u0007CA>\u0000\u001d\taX\u0010\u0005\u0002\u001aA%\u0011a\u0010I\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00111\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u0004\u0003\"CA\u0004kB\u0005\t\u0019AA\u0005\u0003I!W\r\\3uKR{\u0007/[2F]\u0006\u0014G.\u001a3\u0011\u00079\nY!C\u0002\u0002\u000e\u0001\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004w\u0001\u0011%\u0011\u0011\u0003\u000b\u0006-\u0005M\u0011Q\u0003\u0005\u0007s\u0006=\u0001\u0019\u0001>\t\u0011\u0005]\u0011q\u0002a\u0001\u00033\tQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\b\u0003B\f\"\u00037\u0001B!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0003vi&d'BAA\u0013\u0003\u0011Q\u0017M^1\n\t\u0005%\u0012q\u0004\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA\u0017\u0001\u0011%\u0011qF\u0001\noJLG/\u001a#vaN$\u0002\"!\r\u0002:\u0005u\u0012\u0011\t\t\u0005/\u0005\n\u0019\u0004E\u0003/\u0003k\u0001\u0005)C\u0002\u00028\u0001\u0012a\u0001V;qY\u0016\u0014\u0004bBA\u001e\u0003W\u0001\r\u0001Q\u0001\b]Vl7*Z=t\u0011\u001d\ty$a\u000bA\u0002\u0001\u000bqA\\;n\tV\u00048\u000f\u0003\u0005\u0002D\u0005-\u0002\u0019AA#\u0003\rawn\u001a\t\u0005\u0003\u000f\nY%\u0004\u0002\u0002J)\u0019\u00111\t\u0003\n\t\u00055\u0013\u0011\n\u0002\u0004\u0019><\u0007BBA)\u0001\u0011\u0005!*\u0001\fuKN$H)[:bE2,G)\u001a7fi\u0016$v\u000e]5dQ\r\tye\u0016\u0005\n\u0003/\u0002\u0011\u0013!C\u0005\u00033\n1e\u0019:fCR,G+Z:u)>\u0004\u0018nY!oI\u000ecWo\u001d;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\\)\"\u0011\u0011BA/W\t\ty\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAA5A\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00141\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class DeleteTopicTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public scala.collection.immutable.Map<Object, List<Object>> expectedReplicaAssignment() {
        return this.expectedReplicaAssignment;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testDeleteTopicWithAllAliveReplicas() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicWithRecoveredFollower() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$1(leaderIdOpt, s)))).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$4(follower, s)))).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicWithRecoveredFollower$5(topicPartition, x$1))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas 0,1 have not deleted log.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkUtils().isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Admin path /admin/delete_topic/test path deleted even when a follower replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
    }

    @Test
    public void testResumeDeleteTopicOnControllerFailover() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        int controllerId = this.zkUtils().getController();
        KafkaServer controller = (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$1(controllerId, s)))).head();
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testResumeDeleteTopicOnControllerFailover$2(controllerId, leaderIdOpt, s)))).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        controller.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkUtils().isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Admin path /admin/delete_topic/test path deleted even when a replica is down", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        controller.startup();
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
    }

    @Test
    public void testPartitionReassignmentDuringDeleteTopic() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(4, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)p -> p.setProperty("delete.topic.enable", "true"));
        Seq allServers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        this.servers_$eq((Seq<KafkaServer>)allServers);
        Seq servers = (Seq)allServers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$3(expectedReplicaAssignment, s)));
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$6(topicPartition, x$2))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$7(leaderIdOpt, s)))).last();
        follower.shutdown();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        Seq oldAssignedReplicas = this.zkUtils().getReplicasForPartition(topic, 0);
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(this.zkUtils(), (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topicPartition)), (Object)newReplicas)})), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4(), ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$5());
        Assert.assertTrue((String)"Partition reassignment should fail for [test,0]", (boolean)reassignPartitionsCommand.reassignPartitions(reassignPartitionsCommand.reassignPartitions$default$1(), reassignPartitionsCommand.reassignPartitions$default$2()));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map partitionsBeingReassigned = this.zkUtils().getPartitionsBeingReassigned().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.newReplicas());
            ReassignmentStatus reassignmentStatus = ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkUtils(), new TopicAndPartition(topicPartition), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topicPartition)), (Object)newReplicas)})), partitionsBeingReassigned);
            ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
            return !(reassignmentStatus != null ? !reassignmentStatus.equals(reassignmentFailed$) : reassignmentFailed$ != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition reassignment shouldn't complete.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        int controllerId = this.zkUtils().getController();
        KafkaServer controller = (KafkaServer)((IterableLike)servers.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testPartitionReassignmentDuringDeleteTopic$11(controllerId, s)))).head();
        Assert.assertFalse((String)"Partition reassignment should fail", (boolean)controller.kafkaController().controllerContext().partitionsBeingReassigned().contains((Object)new TopicAndPartition(topicPartition)));
        Seq assignedReplicas = this.zkUtils().getReplicasForPartition(topic, 0);
        Assert.assertEquals((String)"Partition should not be reassigned to 0, 1, 2", (Object)oldAssignedReplicas, (Object)assignedReplicas);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, (Seq<KafkaServer>)servers);
    }

    @Test
    public void testDeleteTopicDuringAddPartition() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for partition [test,0]", (boolean)leaderIdOpt.isDefined());
        KafkaServer follower = (KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$1(leaderIdOpt, x$4)))).last();
        TopicPartition newPartition = new TopicPartition(topic, 1);
        Seq brokers = AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), AdminUtils$.MODULE$.getBrokerMetadatas$default$2(), AdminUtils$.MODULE$.getBrokerMetadatas$default$3());
        follower.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.zkUtils().getBrokerInfo(follower.config().brokerId()).isEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower ", " was not removed from ZK"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)follower.config().brokerId())})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), topic, this.expectedReplicaAssignment(), brokers, 2, (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), AdminUtils$.MODULE$.addPartitions$default$7());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        follower.startup();
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteTopicDuringAddPartition$6(newPartition, x$5))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replica logs not for new partition [test,1] not deleted after delete topic is complete.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testAddPartitionDuringDeleteTopic() {
        String topic = "test";
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TopicPartition newPartition = new TopicPartition(topic, 1);
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), topic, this.expectedReplicaAssignment(), AdminUtils$.MODULE$.getBrokerMetadatas(this.zkUtils(), AdminUtils$.MODULE$.getBrokerMetadatas$default$2(), AdminUtils$.MODULE$.getBrokerMetadatas$default$3()), 2, (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), AdminUtils$.MODULE$.addPartitions$default$7());
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
        Assert.assertTrue((String)"Replica logs not deleted after delete topic is complete", (boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testAddPartitionDuringDeleteTopic$1(newPartition, x$6))));
    }

    @Test
    public void testRecreateTopicAfterDeletion() {
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, (Map)expectedReplicaAssignment, AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testRecreateTopicAfterDeletion$3(topicPartition, x$7))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testDeleteNonExistingTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        try {
            AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), "test2");
            throw this.fail("Expected UnknownTopicOrPartitionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), "test2", 1, this.servers());
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.servers().forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDeleteNonExistingTopic$3(topicPartition, x$8))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            Assert.assertTrue((String)"Topic test mistakenly deleted", (boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.getTopicPath(topic)));
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), topic, 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
            return;
        }
    }

    @Test
    public void testDeleteTopicWithCleaner() {
        String topicName = "test";
        TopicPartition topicPartition = new TopicPartition(topicName, 0);
        String topic = topicPartition.topic();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13());
        ((Properties)brokerConfigs.head()).setProperty("delete.topic.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.enable", "true");
        ((Properties)brokerConfigs.head()).setProperty("log.cleanup.policy", "compact");
        ((Properties)brokerConfigs.head()).setProperty("log.segment.bytes", "100");
        ((Properties)brokerConfigs.head()).setProperty("log.cleaner.dedupe.buffer.size", "1048577");
        this.servers_$eq(this.createTestTopicAndCluster(topic, brokerConfigs));
        KafkaServer server = (KafkaServer)this.servers().head();
        Log log = (Log)server.logManager().getLog(topicPartition).get();
        this.writeDups(100, 3, log);
        LogCleaner qual$1 = server.logManager().cleaner();
        TopicPartition x$12 = new TopicPartition(topicName, 0);
        long x$13 = 0L;
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, x$13, x$14);
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), "test");
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), "test", 1, this.servers());
    }

    @Test
    public void testDeleteTopicAlreadyMarkedAsDeleted() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, this.createTestTopicAndCluster$default$2()));
        try {
            AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
            AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), topic);
            throw this.fail("Expected TopicAlreadyMarkedForDeletionException", new Position("DeleteTopicTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }
        catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
            TestUtils$.MODULE$.verifyTopicDeletion(this.zkUtils(), topic, 1, this.servers());
            return;
        }
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, boolean deleteTopicEnabled) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13());
        brokerConfigs.foreach((Function1 & Serializable & scala.Serializable)x$9 -> x$9.setProperty("delete.topic.enable", ((Object)BoxesRunTime.boxToBoolean((boolean)deleteTopicEnabled)).toString()));
        return this.createTestTopicAndCluster(topic, brokerConfigs);
    }

    private Seq<KafkaServer> createTestTopicAndCluster(String topic, Seq<Properties> brokerConfigs) {
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Seq servers = (Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)b -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(b), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom());
        AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK(this.zkUtils(), topic, this.expectedReplicaAssignment(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$4(), AdminUtils$.MODULE$.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> servers.forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$createTestTopicAndCluster$5(topicPartition, x$10))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Replicas for topic test not created", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        return servers;
    }

    private boolean createTestTopicAndCluster$default$2() {
        return true;
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log) {
        IntRef counter = IntRef.create((int)0);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> DeleteTopicTest.$anonfun$writeDups$1(numKeys, log, counter, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testDisableDeleteTopic() {
        TopicPartition topicPartition = new TopicPartition("test", 0);
        String topic = topicPartition.topic();
        this.servers_$eq(this.createTestTopicAndCluster(topic, false));
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), "test");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkUtils().isTopicMarkedForDeletion(topic), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Admin path /admin/delete_topic/%s path not deleted even if deleteTopic is disabled")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Assert.assertTrue((boolean)this.servers().forall((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicTest.$anonfun$testDisableDeleteTopic$3(topicPartition, x$11))));
        Assert.assertTrue((String)"Topic path disappeared", (boolean)this.zkUtils().pathExists(ZkUtils$.MODULE$.getTopicPath(topic)));
        Option leaderIdOpt = this.zkUtils().getLeaderForPartition(topic, 0);
        Assert.assertTrue((String)"Leader should exist for topic test", (boolean)leaderIdOpt.isDefined());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$1(Option leaderIdOpt$1, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$4(KafkaServer follower$1, KafkaServer s) {
        return s.config().brokerId() != follower$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicWithRecoveredFollower$5(TopicPartition topicPartition$1, KafkaServer x$1) {
        return x$1.getLogManager().getLog(topicPartition$1).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testResumeDeleteTopicOnControllerFailover$2(int controllerId$1, Option leaderIdOpt$2, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$2.get()) && s.config().brokerId() != controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$3(scala.collection.immutable.Map expectedReplicaAssignment$1, KafkaServer s) {
        return ((LinearSeqOptimized)expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).contains((Object)BoxesRunTime.boxToInteger((int)s.config().brokerId()));
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$6(TopicPartition topicPartition$2, KafkaServer x$2) {
        return x$2.getLogManager().getLog(topicPartition$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$7(Option leaderIdOpt$3, KafkaServer s) {
        return s.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$3.get());
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionReassignmentDuringDeleteTopic$11(int controllerId$2, KafkaServer s) {
        return s.config().brokerId() == controllerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$1(Option leaderIdOpt$4, KafkaServer x$4) {
        return x$4.config().brokerId() != BoxesRunTime.unboxToInt((Object)leaderIdOpt$4.get());
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicDuringAddPartition$6(TopicPartition newPartition$1, KafkaServer x$5) {
        return x$5.getLogManager().getLog(newPartition$1).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testAddPartitionDuringDeleteTopic$1(TopicPartition newPartition$2, KafkaServer x$6) {
        return x$6.getLogManager().getLog(newPartition$2).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRecreateTopicAfterDeletion$3(TopicPartition topicPartition$3, KafkaServer x$7) {
        return x$7.getLogManager().getLog(topicPartition$3).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonExistingTopic$3(TopicPartition topicPartition$4, KafkaServer x$8) {
        return x$8.getLogManager().getLog(topicPartition$4).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$5(TopicPartition topicPartition$5, KafkaServer x$10) {
        return x$10.getLogManager().getLog(topicPartition$5).isDefined();
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeDups$2(Log log$1, IntRef counter$1, int key) {
        int count = counter$1.elem;
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(((Object)BoxesRunTime.boxToInteger((int)counter$1.elem)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), 0, log$1.appendAsLeader$default$3());
        ++counter$1.elem;
        return new Tuple2.mcII.sp(key, count);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeDups$1(int numKeys$1, Log log$1, IntRef counter$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> DeleteTopicTest.$anonfun$writeDups$2(log$1, counter$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableDeleteTopic$3(TopicPartition topicPartition$6, KafkaServer x$11) {
        return x$11.getLogManager().getLog(topicPartition$6).isDefined();
    }
}

