/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0001\u001d\u0011ADU3tKR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005)\u0011\rZ7j]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005a\u0019uN\\:v[\u0016\u0014xI]8va\u000e{W.\\1oIR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000fE\u0001!\u0019!C\u0001%\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0003vi&d'\"\u0001\r\u0002\t)\fg/Y\u0005\u00035U\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u0019a\u0002\u0001)A\u0005'\u0005\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000f\t\u0005\b=\u0001\u0011\r\u0011\"\u0001 \u0003\u0019!x\u000e]5dcU\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$/\u0005!A.\u00198h\u0013\t)#E\u0001\u0004TiJLgn\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u000fQ|\u0007/[22A!9\u0011\u0006\u0001b\u0001\n\u0003y\u0012A\u0002;pa&\u001c'\u0007\u0003\u0004,\u0001\u0001\u0006I\u0001I\u0001\bi>\u0004\u0018n\u0019\u001a!\u0011\u0015i\u0003\u0001\"\u0011/\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#A\u0018\u0011\u0007ARTH\u0004\u00022o9\u0011!'N\u0007\u0002g)\u0011AGB\u0001\u0007yI|w\u000e\u001e \n\u0003Y\nQa]2bY\u0006L!\u0001O\u001d\u0002\u000fA\f7m[1hK*\ta'\u0003\u0002<y\t\u00191+Z9\u000b\u0005aJ\u0004C\u0001 B\u001b\u0005y$B\u0001!\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!i\u0010\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003E\u0001\u0011\u0005Q)\u0001\u0011uKN$(+Z:fi>3gm]3ug:{G/\u0012=jgRLgnZ$s_V\u0004H#\u0001$\u0011\u0005\u001dCU\"A\u001d\n\u0005%K$\u0001B+oSRD#aQ&\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015!\u00026v]&$(\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u001b\n!A+Z:u\u0011\u0015!\u0006\u0001\"\u0001F\u0003!\"Xm\u001d;SKN,Go\u00144gg\u0016$8OT3x\u0007>t7/^7fe\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dQ\t\u00196\nC\u0003X\u0001\u0011\u0005Q)A\u0010uKN$(+Z:fi>3gm]3ugR{Gj\\2bY\u0012\u000bG/\u001a+j[\u0016D#AV&\t\u000bi\u0003A\u0011A#\u0002?Q,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001cHk\u001c.p]\u0016$G)\u0019;f)&lW\r\u000b\u0002Z\u0017\")Q\f\u0001C\u0001\u000b\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]\"\u0012Al\u0013\u0005\u0006A\u0002!\t!R\u0001%i\u0016\u001cHOU3tKR|eMZ:fiN\u0014\u0015\u0010R;sCRLwN\u001c+p\u000b\u0006\u0014H.[3ti\"\u0012ql\u0013\u0005\u0006G\u0002!\t!R\u0001\u001bi\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f\u001e\u0015\u0003E.CQA\u001a\u0001\u0005\u0002\u0015\u000b\u0001\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_2\u000bG/Z:uQ\t)7\nC\u0003j\u0001\u0011\u0005Q)A\u0010uKN$(+Z:fi>3gm]3ugR{7)\u001e:sK:$xJ\u001a4tKRD#\u0001[&\t\u000b1\u0004A\u0011B7\u00023A\u0014x\u000eZ;dK\u000e{gn];nK\u0006sGm\u00155vi\u0012|wO\u001c\u000b\b\r:\\\u0018\u0011AA\n\u0011\u0015y7\u000e1\u0001q\u0003Q\u0019wN\\:v[\u0016\u0014xI]8va\u000e{W.\\1oIB\u0011\u0011\u000f\u001f\b\u0003eZt!a];\u000f\u0005I\"\u0018\"A\u0003\n\u0005\r!\u0011BA<\u0003\u0003Q\u0019uN\\:v[\u0016\u0014xI]8va\u000e{W.\\1oI&\u0011\u0011P\u001f\u0002\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u000b\u0005]\u0014\u0001\"\u0002?l\u0001\u0004i\u0018\u0001\u00048v[\u000e{gn];nKJ\u001c\bCA$\u007f\u0013\ty\u0018HA\u0002J]RDq!a\u0001l\u0001\u0004\t)!A\u0003u_BL7\r\u0005\u0003\u0002\b\u0005=a\u0002BA\u0005\u0003\u0017\u0001\"AM\u001d\n\u0007\u00055\u0011(\u0001\u0004Qe\u0016$WMZ\u0005\u0004K\u0005E!bAA\u0007s!1\u0011QC6A\u0002u\fQ\u0002^8uC2lUm]:bO\u0016\u001c\bBBA\r\u0001\u0011\u0005Q)\u0001\u0011uKN$(+Z:fi>3gm]3ugR{7\u000b]3dS\u001aL7m\u00144gg\u0016$\bfAA\f\u0017\"1\u0011q\u0004\u0001\u0005\u0002\u0015\u000b\u0011\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4G\u000f\u00157vg\"\u001a\u0011QD&\t\r\u0005\u0015\u0002\u0001\"\u0001F\u0003i!Xm\u001d;SKN,Go\u00144gg\u0016$8o\u00155jMRl\u0015N\\;tQ\r\t\u0019c\u0013\u0005\u0007\u0003W\u0001A\u0011A#\u0002QQ,7\u000f\u001e*fg\u0016$xJ\u001a4tKR\u001c8\u000b[5gi\nKHj\\<feRC\u0017M\\#be2LWm\u001d;)\u0007\u0005%2\n\u0003\u0004\u00022\u0001!\t!R\u0001(i\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u\u0005fD\u0015n\u001a5feRC\u0017M\u001c'bi\u0016\u001cH\u000fK\u0002\u00020-Ca!a\u000e\u0001\t\u0003)\u0015\u0001\n;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>,\u0015M\u001d7jKN$xJ\\(oKR{\u0007/[2)\u0007\u0005U2\n\u0003\u0004\u0002>\u0001!\t!R\u00011i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o\u001f:,Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8)\u0007\u0005m2\n\u0003\u0004\u0002D\u0001!\t!R\u0001#i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o)>\u0004\u0018nY:)\u0007\u0005\u00053\n\u0003\u0004\u0002J\u0001!\t!R\u00010i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o)>\u0004\u0018nY:B]\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004\u0003\u000fZ\u0005BBA(\u0001\u0011\u0005Q)\u0001\u0011uKN$(+Z:fi>3gm]3ug\u0016C\bo\u001c:u\u00136\u0004xN\u001d;QY\u0006t\u0007fAA'\u0017\"1\u0011Q\u000b\u0001\u0005\n\u0015\u000b!\u0003\u001d:j]R\u001cuN\\:v[\u0016\u0014xI]8va\"9\u0011Q\u000b\u0001\u0005\n\u0005eCc\u0001$\u0002\\!A\u0011QLA,\u0001\u0004\t)!A\u0003he>,\b\u000f")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        this.addConsumerGroupExecutor(1, this.topic1(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "missing.group", "--all-topics", "--to-current"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset;
            Map map = assignmentsToReset = consumerGroupCommand.resetOffsets();
            Map map2 = Predef$.MODULE$.Map().empty();
            return !(map != null ? !map.equals(map2) : map2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected to have an empty assignations map.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    @Test
    public void testResetOffsetsNewConsumerExistingTopic() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", "new.group", "--topic", this.topic1(), "--to-offset", "50", "--execute"});
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        ConsumerGroupCommand.KafkaConsumerGroupService consumerGroupCommand = new ConsumerGroupCommand.KafkaConsumerGroupService(opts);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsNewConsumerExistingTopic$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 1 (specific offset).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup("new.group");
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
        consumerGroupCommand.close();
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic1(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Some some;
            Seq assignments;
            long sumOffset;
            Option assignmentsOption;
            Option assignmentsOption2;
            Tuple2 tuple2 = consumerGroupCommand.describeGroup();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignmentsOption2 = (Option)tuple2._2();
            Option option2 = assignmentsOption = option;
            boolean bl = option2 instanceof Some ? (sumOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)(assignments = (Seq)(some = (Some)option2).value()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$3(this, x$2)))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$5(x$4)))).map((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$6(assignment)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 + x$6))) == 100L : false;
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected that consumer group has consumed all messages from topic/partition.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        String[] cgcArgs1 = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand1 = this.getConsumerGroupService(cgcArgs1);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand1.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$10(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to when offset was 50.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 50, 1, 100000);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        Date checkpoint = new Date();
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 50, 1, 100000);
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic1(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Some some;
            Seq assignments;
            long sumOffset;
            Option assignmentsOption;
            Option assignmentsOption2;
            Tuple2 tuple2 = consumerGroupCommand.describeGroup();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignmentsOption2 = (Option)tuple2._2();
            Option option2 = assignmentsOption = option;
            boolean bl = option2 instanceof Some ? (sumOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)(assignments = (Seq)(some = (Some)option2).value()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$3(this, x$7)))).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$5(x$9)))).map((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$6(assignment)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$10, x$11) -> x$10 + x$11))) == 100L : false;
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected that consumer group has consumed all messages from topic/partition.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
        String[] cgcArgs1 = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(checkpoint), "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand1 = this.getConsumerGroupService(cgcArgs1);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand1.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$10(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to when offset was 50.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT1M"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsByDuration$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest by duration).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT0.1S", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsByDurationToEarliest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 100 (latest by duration).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-latest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLatest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 200 (latest).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-current", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToCurrentOffset$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 100 (current).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    private void produceConsumeAndShutdown(ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand, int numConsumers, String topic, int totalMessages) {
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), topic, totalMessages, 1, 100000);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Some some;
            Seq assignments;
            long sumOffset;
            Option assignmentsOption;
            Option assignmentsOption2;
            Tuple2 tuple2 = consumerGroupCommand.describeGroup();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option option = assignmentsOption2 = (Option)tuple2._2();
            Option option2 = assignmentsOption = option;
            boolean bl = option2 instanceof Some ? (sumOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)(assignments = (Seq)(some = (Some)option2).value()).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$produceConsumeAndShutdown$3(topic, x$12)))).filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$produceConsumeAndShutdown$5(x$14)))).map((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToLong((long)ResetConsumerGroupOffsetTest.$anonfun$produceConsumeAndShutdown$6(assignment)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToLong((long)0), (Function2)(JFunction2.mcJJJ.sp & Serializable & scala.Serializable)(x$15, x$16) -> x$15 + x$16))) == (long)totalMessages : false;
            return bl;
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to consume all messages from topic.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        executor.shutdown();
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "1", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToSpecificOffset$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 1 (specific offset).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "50", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsShiftPlus$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 150 (current + 50).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-50", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsShiftMinus$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 50 (current - 50).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-150", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsShiftByLowerThanEarliest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest by shift).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "150", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic1(), 100, 1, 100000);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsShiftByHigherThanLatest$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 200 (latest by shift).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", this.topic1(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnOneTopic$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", String.format("%s:1", this.topic1()), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 2, this.topic1(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnOneTopicAndPartition$3(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest) in partition 1.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", this.topic1(), "--topic", this.topic2(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic2(), 1, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic1(), 100);
        this.produceConsumeAndShutdown(consumerGroupCommand, 1, this.topic2(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnTopics$3(this, assignment))) && assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnTopics$4(this, assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest).", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic2());
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", String.format("%s:1", this.topic1()), "--topic", String.format("%s:1", this.topic2()), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic2(), 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 2, this.topic1(), 100);
        this.produceConsumeAndShutdown(consumerGroupCommand, 2, this.topic2(), 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnTopicsAndPartitions$3(this, assignment)));
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToEarliestOnTopicsAndPartitions$4(this, assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 0 (earliest) in partition 1.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic2());
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        AdminUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), 2, 1, AdminUtils$.MODULE$.createTopic$default$5(), AdminUtils$.MODULE$.createTopic$default$6());
        this.produceConsumeAndShutdown(consumerGroupCommand, 2, this.topic1(), 100);
        File file = File.createTempFile("reset", ".csv");
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommand.resetOffsets();
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write(consumerGroupCommand.exportOffsetsToReset(assignmentsToReset));
            bw.close();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExportImportPlan$3(assignment))) && file.exists();
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consume all messages and save reset offsets plan to file", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        String[] cgcArgsExec = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--from-file", file.getCanonicalPath()});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Map assignmentsToReset = consumerGroupCommandExec.resetOffsets();
            return assignmentsToReset.exists((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExportImportPlan$6(assignment)));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Expected the consumer group to reset to offset 2 according to the plan in the file.", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        file.deleteOnExit();
        this.printConsumerGroup();
        AdminUtils$.MODULE$.deleteTopic(this.zkUtils(), this.topic1());
    }

    private void printConsumerGroup() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--group", this.group(), "--describe"});
        ConsumerGroupCommand$.MODULE$.main(cgcArgs);
    }

    private void printConsumerGroup(String group) {
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--group", group, "--describe"});
        ConsumerGroupCommand$.MODULE$.main(cgcArgs);
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsNewConsumerExistingTopic$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 50L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLocalDateTime$4(ResetConsumerGroupOffsetTest $this, String x$3) {
        String string = x$3;
        String string2 = $this.topic1();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLocalDateTime$3(ResetConsumerGroupOffsetTest $this, ConsumerGroupCommand.PartitionAssignmentState x$2) {
        return x$2.topic().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToLocalDateTime$4($this, x$3)));
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLocalDateTime$5(ConsumerGroupCommand.PartitionAssignmentState x$4) {
        return x$4.offset().isDefined();
    }

    public static final /* synthetic */ long $anonfun$testResetOffsetsToLocalDateTime$6(ConsumerGroupCommand.PartitionAssignmentState assignment) {
        return BoxesRunTime.unboxToLong((Object)assignment.offset().get());
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLocalDateTime$10(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToZonedDateTime$4(ResetConsumerGroupOffsetTest $this, String x$8) {
        String string = x$8;
        String string2 = $this.topic1();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToZonedDateTime$3(ResetConsumerGroupOffsetTest $this, ConsumerGroupCommand.PartitionAssignmentState x$7) {
        return x$7.topic().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsToZonedDateTime$4($this, x$8)));
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToZonedDateTime$5(ConsumerGroupCommand.PartitionAssignmentState x$9) {
        return x$9.offset().isDefined();
    }

    public static final /* synthetic */ long $anonfun$testResetOffsetsToZonedDateTime$6(ConsumerGroupCommand.PartitionAssignmentState assignment) {
        return BoxesRunTime.unboxToLong((Object)assignment.offset().get());
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToZonedDateTime$10(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 50L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsByDuration$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsByDurationToEarliest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 100L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToLatest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 200L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToCurrentOffset$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 100L;
    }

    public static final /* synthetic */ boolean $anonfun$produceConsumeAndShutdown$4(String topic$1, String x$13) {
        String string = x$13;
        String string2 = topic$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$produceConsumeAndShutdown$3(String topic$1, ConsumerGroupCommand.PartitionAssignmentState x$12) {
        return x$12.topic().exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$produceConsumeAndShutdown$4(topic$1, x$13)));
    }

    public static final /* synthetic */ boolean $anonfun$produceConsumeAndShutdown$5(ConsumerGroupCommand.PartitionAssignmentState x$14) {
        return x$14.offset().isDefined();
    }

    public static final /* synthetic */ long $anonfun$produceConsumeAndShutdown$6(ConsumerGroupCommand.PartitionAssignmentState assignment) {
        return BoxesRunTime.unboxToLong((Object)assignment.offset().get());
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToSpecificOffset$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 1L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsShiftPlus$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 150L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsShiftMinus$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 50L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsShiftByLowerThanEarliest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsShiftByHigherThanLatest$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 200L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnOneTopic$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnOneTopicAndPartition$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 0L && ((TopicPartition)assignment._1()).partition() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnTopics$3(ResetConsumerGroupOffsetTest $this, Tuple2 assignment) {
        if (((OffsetAndMetadata)assignment._2()).offset() != 0L) return false;
        String string = ((TopicPartition)assignment._1()).topic();
        String string2 = $this.topic1();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnTopics$4(ResetConsumerGroupOffsetTest $this, Tuple2 assignment) {
        if (((OffsetAndMetadata)assignment._2()).offset() != 0L) return false;
        String string = ((TopicPartition)assignment._1()).topic();
        String string2 = $this.topic2();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnTopicsAndPartitions$3(ResetConsumerGroupOffsetTest $this, Tuple2 assignment) {
        if (((OffsetAndMetadata)assignment._2()).offset() != 0L) return false;
        if (((TopicPartition)assignment._1()).partition() != 1) return false;
        String string = ((TopicPartition)assignment._1()).topic();
        String string2 = $this.topic1();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testResetOffsetsToEarliestOnTopicsAndPartitions$4(ResetConsumerGroupOffsetTest $this, Tuple2 assignment) {
        if (((OffsetAndMetadata)assignment._2()).offset() != 0L) return false;
        if (((TopicPartition)assignment._1()).partition() != 1) return false;
        String string = ((TopicPartition)assignment._1()).topic();
        String string2 = $this.topic2();
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsExportImportPlan$3(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 2L;
    }

    public static final /* synthetic */ boolean $anonfun$testResetOffsetsExportImportPlan$6(Tuple2 assignment) {
        return ((OffsetAndMetadata)assignment._2()).offset() == 2L;
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

